/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.analysis;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import org.opensearch.Version;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.env.Environment;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.analysis.AnalysisRegistry;
import org.opensearch.indices.analysis.AnalysisModule;
import org.opensearch.plugins.AnalysisPlugin;
import org.opensearch.test.IndexSettingsModule;
import org.opensearch.test.OpenSearchTestCase;

public class AnalysisTestsHelper {
    public static OpenSearchTestCase.TestAnalysis createTestAnalysisFromClassPath(Path baseDir, String resource, AnalysisPlugin ... plugins) throws IOException {
        Settings settings = Settings.builder().loadFromStream(resource, AnalysisTestsHelper.class.getResourceAsStream(resource), false).put(Environment.PATH_HOME_SETTING.getKey(), baseDir.toString()).build();
        return AnalysisTestsHelper.createTestAnalysisFromSettings(settings, plugins);
    }

    public static OpenSearchTestCase.TestAnalysis createTestAnalysisFromSettings(Settings settings, AnalysisPlugin ... plugins) throws IOException {
        return AnalysisTestsHelper.createTestAnalysisFromSettings(settings, null, plugins);
    }

    public static OpenSearchTestCase.TestAnalysis createTestAnalysisFromSettings(Settings settings, Path configPath, AnalysisPlugin ... plugins) throws IOException {
        Settings actualSettings = settings.get("index.version.created") == null ? Settings.builder().put(settings).put("index.version.created", Version.CURRENT).build() : settings;
        IndexSettings indexSettings = IndexSettingsModule.newIndexSettings("test", actualSettings, new Setting[0]);
        AnalysisRegistry analysisRegistry = new AnalysisModule(new Environment(actualSettings, configPath), Arrays.asList(plugins)).getAnalysisRegistry();
        return new OpenSearchTestCase.TestAnalysis(analysisRegistry.build(indexSettings), analysisRegistry.buildTokenFilterFactories(indexSettings), analysisRegistry.buildTokenizerFactories(indexSettings), analysisRegistry.buildCharFilterFactories(indexSettings));
    }
}

