/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.recovery;

import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.apache.lucene.util.BytesRef;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesArray;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.index.seqno.ReplicationTracker;
import org.opensearch.index.seqno.RetentionLeases;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.store.Store;
import org.opensearch.index.store.StoreFileMetadata;
import org.opensearch.index.translog.Translog;
import org.opensearch.indices.recovery.RecoveryTargetHandler;
import org.opensearch.indices.replication.SegmentReplicationTarget;

public class AsyncRecoveryTarget
implements RecoveryTargetHandler {
    private final RecoveryTargetHandler target;
    private final Executor executor;
    private final IndexShard primary;
    private final IndexShard replica;
    private final Function<List<IndexShard>, List<SegmentReplicationTarget>> replicatePrimaryFunction;

    public AsyncRecoveryTarget(RecoveryTargetHandler target, Executor executor) {
        this.executor = executor;
        this.target = target;
        this.primary = null;
        this.replica = null;
        this.replicatePrimaryFunction = a -> null;
    }

    public AsyncRecoveryTarget(RecoveryTargetHandler target, Executor executor, IndexShard primary, IndexShard replica, Function<List<IndexShard>, List<SegmentReplicationTarget>> replicatePrimaryFunction) {
        this.executor = executor;
        this.target = target;
        this.primary = primary;
        this.replica = replica;
        this.replicatePrimaryFunction = replicatePrimaryFunction;
    }

    public void prepareForTranslogOperations(int totalTranslogOps, ActionListener<Void> listener) {
        this.executor.execute(() -> this.target.prepareForTranslogOperations(totalTranslogOps, listener));
    }

    public void forceSegmentFileSync() {
        this.replicatePrimaryFunction.apply(List.of(this.primary, this.replica));
    }

    public void finalizeRecovery(long globalCheckpoint, long trimAboveSeqNo, ActionListener<Void> listener) {
        this.executor.execute(() -> this.target.finalizeRecovery(globalCheckpoint, trimAboveSeqNo, listener));
    }

    public void handoffPrimaryContext(ReplicationTracker.PrimaryContext primaryContext) {
        this.target.handoffPrimaryContext(primaryContext);
    }

    public void indexTranslogOperations(List<Translog.Operation> operations, int totalTranslogOps, long maxSeenAutoIdTimestampOnPrimary, long maxSeqNoOfDeletesOrUpdatesOnPrimary, RetentionLeases retentionLeases, long mappingVersionOnPrimary, ActionListener<Long> listener) {
        this.executor.execute(() -> this.target.indexTranslogOperations(operations, totalTranslogOps, maxSeenAutoIdTimestampOnPrimary, maxSeqNoOfDeletesOrUpdatesOnPrimary, retentionLeases, mappingVersionOnPrimary, listener));
    }

    public void receiveFileInfo(List<String> phase1FileNames, List<Long> phase1FileSizes, List<String> phase1ExistingFileNames, List<Long> phase1ExistingFileSizes, int totalTranslogOps, ActionListener<Void> listener) {
        this.executor.execute(() -> this.target.receiveFileInfo(phase1FileNames, phase1FileSizes, phase1ExistingFileNames, phase1ExistingFileSizes, totalTranslogOps, listener));
    }

    public void cleanFiles(int totalTranslogOps, long globalCheckpoint, Store.MetadataSnapshot sourceMetadata, ActionListener<Void> listener) {
        this.executor.execute(() -> this.target.cleanFiles(totalTranslogOps, globalCheckpoint, sourceMetadata, listener));
    }

    public void writeFileChunk(StoreFileMetadata fileMetadata, long position, BytesReference content, boolean lastChunk, int totalTranslogOps, ActionListener<Void> listener) {
        BytesArray copy = new BytesArray(BytesRef.deepCopyOf((BytesRef)content.toBytesRef()));
        this.executor.execute(() -> this.lambda$writeFileChunk$6(fileMetadata, position, (BytesReference)copy, lastChunk, totalTranslogOps, listener));
    }

    private /* synthetic */ void lambda$writeFileChunk$6(StoreFileMetadata fileMetadata, long position, BytesReference copy, boolean lastChunk, int totalTranslogOps, ActionListener listener) {
        this.target.writeFileChunk(fileMetadata, position, copy, lastChunk, totalTranslogOps, listener);
    }
}

