/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.remotestore;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.After;
import org.opensearch.action.admin.cluster.remotestore.restore.RestoreRemoteStoreRequest;
import org.opensearch.action.admin.cluster.repositories.get.GetRepositoriesRequest;
import org.opensearch.action.admin.cluster.repositories.get.GetRepositoriesResponse;
import org.opensearch.action.admin.indices.get.GetIndexRequest;
import org.opensearch.action.admin.indices.get.GetIndexResponse;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexRequestBuilder;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.support.PlainActionFuture;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.cluster.metadata.RepositoriesMetadata;
import org.opensearch.cluster.metadata.RepositoryMetadata;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.UUIDs;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.index.Index;
import org.opensearch.index.IndexModule;
import org.opensearch.index.IndexService;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.indices.IndicesService;
import org.opensearch.indices.replication.common.ReplicationType;
import org.opensearch.plugins.Plugin;
import org.opensearch.remotestore.mocks.MockFsMetadataSupportedRepositoryPlugin;
import org.opensearch.remotestore.multipart.mocks.MockFsRepositoryPlugin;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.repositories.blobstore.BlobStoreRepository;
import org.opensearch.repositories.fs.ReloadableFsRepository;
import org.opensearch.test.OpenSearchIntegTestCase;
import org.opensearch.test.hamcrest.OpenSearchAssertions;

public class RemoteStoreBaseIntegTestCase
extends OpenSearchIntegTestCase {
    protected static final String REPOSITORY_NAME = "test-remote-store-repo";
    protected static final String REPOSITORY_2_NAME = "test-remote-store-repo-2";
    protected static final String REPOSITORY_3_NAME = "test-remote-store-repo-3";
    protected static final String REMOTE_ROUTING_TABLE_REPO = "remote-routing-table-repo";
    protected static final int SHARD_COUNT = 1;
    protected static int REPLICA_COUNT = 1;
    protected static final String TOTAL_OPERATIONS = "total-operations";
    protected static final String REFRESHED_OR_FLUSHED_OPERATIONS = "refreshed-or-flushed-operations";
    protected static final String MAX_SEQ_NO_TOTAL = "max-seq-no-total";
    protected static final String MAX_SEQ_NO_REFRESHED_OR_FLUSHED = "max-seq-no-refreshed-or-flushed";
    protected Path segmentRepoPath;
    protected Path translogRepoPath;
    protected boolean clusterSettingsSuppliedByTest = false;
    protected boolean asyncUploadMockFsRepo = RemoteStoreBaseIntegTestCase.randomBoolean();
    private boolean metadataSupportedType = RemoteStoreBaseIntegTestCase.randomBoolean();
    private final List<String> documentKeys = List.of(RemoteStoreBaseIntegTestCase.randomAlphaOfLength(5), RemoteStoreBaseIntegTestCase.randomAlphaOfLength(5), RemoteStoreBaseIntegTestCase.randomAlphaOfLength(5), RemoteStoreBaseIntegTestCase.randomAlphaOfLength(5), RemoteStoreBaseIntegTestCase.randomAlphaOfLength(5));

    protected Map<String, Long> indexData(int numberOfIterations, boolean invokeFlush, String index) {
        return this.indexData(numberOfIterations, invokeFlush, false, index);
    }

    protected Map<String, Long> indexData(int numberOfIterations, boolean invokeFlush, boolean emptyTranslog, String index) {
        long totalOperations = 0L;
        long refreshedOrFlushedOperations = 0L;
        long maxSeqNo = -1L;
        long maxSeqNoRefreshedOrFlushed = -1L;
        int shardId = 0;
        HashMap<String, Long> indexingStats = new HashMap<String, Long>();
        for (int i = 0; i < numberOfIterations; ++i) {
            if (invokeFlush) {
                this.flushAndRefresh(index);
            } else {
                this.refresh(index);
            }
            if (emptyTranslog && i == numberOfIterations - 1) continue;
            maxSeqNoRefreshedOrFlushed = maxSeqNo;
            indexingStats.put("max-seq-no-refreshed-or-flushed-shard-" + shardId, maxSeqNoRefreshedOrFlushed);
            refreshedOrFlushedOperations = totalOperations;
            int numberOfOperations = RemoteStoreBaseIntegTestCase.randomIntBetween(20, 50);
            int numberOfBulk = RemoteStoreBaseIntegTestCase.randomIntBetween(1, 5);
            for (int j = 0; j < numberOfBulk; ++j) {
                BulkResponse res = this.indexBulk(index, numberOfOperations);
                for (BulkItemResponse singleResp : res.getItems()) {
                    indexingStats.put("max-seq-no-total-shard-" + singleResp.getResponse().getShardId().id(), singleResp.getResponse().getSeqNo());
                    maxSeqNo = singleResp.getResponse().getSeqNo();
                }
                totalOperations += (long)numberOfOperations;
            }
        }
        indexingStats.put(TOTAL_OPERATIONS, totalOperations);
        indexingStats.put(REFRESHED_OR_FLUSHED_OPERATIONS, refreshedOrFlushedOperations);
        indexingStats.put(MAX_SEQ_NO_TOTAL, maxSeqNo);
        indexingStats.put(MAX_SEQ_NO_REFRESHED_OR_FLUSHED, maxSeqNoRefreshedOrFlushed);
        return indexingStats;
    }

    @Override
    protected Collection<Class<? extends Plugin>> nodePlugins() {
        if (!this.clusterSettingsSuppliedByTest && this.asyncUploadMockFsRepo) {
            if (this.metadataSupportedType) {
                return Stream.concat(super.nodePlugins().stream(), Stream.of(MockFsMetadataSupportedRepositoryPlugin.class)).collect(Collectors.toList());
            }
            return Stream.concat(super.nodePlugins().stream(), Stream.of(MockFsRepositoryPlugin.class)).collect(Collectors.toList());
        }
        return super.nodePlugins();
    }

    @Override
    protected Settings nodeSettings(int nodeOrdinal) {
        if (this.segmentRepoPath == null || this.translogRepoPath == null) {
            this.segmentRepoPath = this.randomRepoPath().toAbsolutePath();
            this.translogRepoPath = this.randomRepoPath().toAbsolutePath();
        }
        if (this.clusterSettingsSuppliedByTest) {
            return Settings.builder().put(super.nodeSettings(nodeOrdinal)).build();
        }
        return Settings.builder().put(super.nodeSettings(nodeOrdinal)).put(this.remoteStoreRepoSettings()).build();
    }

    protected Settings remoteStoreRepoSettings() {
        Settings remoteStoreRepoSettings;
        if (this.asyncUploadMockFsRepo) {
            String repoType = this.metadataSupportedType ? "fs_metadata_supported_repository" : "fs_multipart_repository";
            remoteStoreRepoSettings = RemoteStoreBaseIntegTestCase.remoteStoreClusterSettings(REPOSITORY_NAME, this.segmentRepoPath, repoType, REPOSITORY_2_NAME, this.translogRepoPath, repoType);
        } else {
            remoteStoreRepoSettings = RemoteStoreBaseIntegTestCase.remoteStoreClusterSettings(REPOSITORY_NAME, this.segmentRepoPath, REPOSITORY_2_NAME, this.translogRepoPath);
        }
        return remoteStoreRepoSettings;
    }

    protected void setFailRate(String repoName, int value) throws ExecutionException, InterruptedException {
        GetRepositoriesRequest gr = new GetRepositoriesRequest(new String[]{repoName});
        GetRepositoriesResponse res = (GetRepositoriesResponse)RemoteStoreBaseIntegTestCase.client().admin().cluster().getRepositories(gr).get();
        RepositoryMetadata rmd = (RepositoryMetadata)res.repositories().get(0);
        Settings.Builder settings = Settings.builder().put("location", rmd.settings().get("location")).put(ReloadableFsRepository.REPOSITORIES_FAILRATE_SETTING.getKey(), value);
        this.createRepository(repoName, "reloadable-fs", settings);
    }

    @Override
    public Settings indexSettings() {
        return this.defaultIndexSettings();
    }

    protected IndexResponse indexSingleDoc(String indexName) {
        return this.indexSingleDoc(indexName, false);
    }

    protected IndexResponse indexSingleDoc(String indexName, boolean forceRefresh) {
        IndexRequestBuilder indexRequestBuilder = RemoteStoreBaseIntegTestCase.client().prepareIndex(indexName).setId(UUIDs.randomBase64UUID()).setSource(new Object[]{this.documentKeys.get(RemoteStoreBaseIntegTestCase.randomIntBetween(0, this.documentKeys.size() - 1)), RemoteStoreBaseIntegTestCase.randomAlphaOfLength(5)});
        if (forceRefresh) {
            indexRequestBuilder.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        }
        return (IndexResponse)indexRequestBuilder.get();
    }

    protected BulkResponse indexBulk(String indexName, int numDocs) {
        BulkRequest bulkRequest = new BulkRequest();
        for (int i = 0; i < numDocs; ++i) {
            IndexRequest request = (IndexRequest)RemoteStoreBaseIntegTestCase.client().prepareIndex(indexName).setId(UUIDs.randomBase64UUID()).setSource(new Object[]{this.documentKeys.get(RemoteStoreBaseIntegTestCase.randomIntBetween(0, this.documentKeys.size() - 1)), RemoteStoreBaseIntegTestCase.randomAlphaOfLength(5)}).request();
            bulkRequest.add(request);
        }
        return (BulkResponse)RemoteStoreBaseIntegTestCase.client().bulk(bulkRequest).actionGet();
    }

    Settings defaultIndexSettings() {
        return Settings.builder().put(super.indexSettings()).put(IndexModule.INDEX_QUERY_CACHE_ENABLED_SETTING.getKey(), false).put("index.number_of_shards", 1).put("index.number_of_replicas", REPLICA_COUNT).put(IndexSettings.INDEX_REFRESH_INTERVAL_SETTING.getKey(), "300s").put("index.replication.type", (Enum)ReplicationType.SEGMENT).build();
    }

    protected Settings remoteStoreIndexSettings(int numberOfReplicas, int numberOfShards) {
        return Settings.builder().put(this.defaultIndexSettings()).put("index.number_of_shards", numberOfShards).put("index.number_of_replicas", numberOfReplicas).build();
    }

    protected Settings remoteStoreIndexSettings(int numberOfReplicas) {
        return this.remoteStoreIndexSettings(numberOfReplicas, 1);
    }

    protected Settings remoteStoreIndexSettings(int numberOfReplicas, long totalFieldLimit, int refresh) {
        return Settings.builder().put(this.remoteStoreIndexSettings(numberOfReplicas)).put(MapperService.INDEX_MAPPING_TOTAL_FIELDS_LIMIT_SETTING.getKey(), totalFieldLimit).put(IndexSettings.INDEX_REFRESH_INTERVAL_SETTING.getKey(), String.valueOf(refresh)).build();
    }

    @After
    public void teardown() {
        this.clusterSettingsSuppliedByTest = false;
        this.asyncUploadMockFsRepo = RemoteStoreBaseIntegTestCase.randomBoolean();
        this.metadataSupportedType = RemoteStoreBaseIntegTestCase.randomBoolean();
        this.assertRemoteStoreRepositoryOnAllNodes(REPOSITORY_NAME);
        this.assertRemoteStoreRepositoryOnAllNodes(REPOSITORY_2_NAME);
        this.clusterAdmin().prepareCleanupRepository(REPOSITORY_NAME).get();
        this.clusterAdmin().prepareCleanupRepository(REPOSITORY_2_NAME).get();
    }

    public RepositoryMetadata buildRepositoryMetadata(DiscoveryNode node, String name) {
        Map nodeAttributes = node.getAttributes();
        String type = (String)nodeAttributes.get(String.format(Locale.getDefault(), "remote_store.repository.%s.type", name));
        String settingsAttributeKeyPrefix = String.format(Locale.getDefault(), "remote_store.repository.%s.settings.", name);
        Map<String, String> settingsMap = node.getAttributes().keySet().stream().filter(key -> key.startsWith(settingsAttributeKeyPrefix)).collect(Collectors.toMap(key -> key.replace(settingsAttributeKeyPrefix, ""), key -> (String)node.getAttributes().get(key)));
        Settings.Builder settings = Settings.builder();
        settingsMap.entrySet().forEach(entry -> settings.put((String)entry.getKey(), (String)entry.getValue()));
        settings.put(BlobStoreRepository.SYSTEM_REPOSITORY_SETTING.getKey(), true);
        return new RepositoryMetadata(name, type, settings.build());
    }

    public void assertRemoteStoreRepositoryOnAllNodes(String repositoryName) {
        RepositoriesMetadata repositories = (RepositoriesMetadata)RemoteStoreBaseIntegTestCase.internalCluster().getInstance(ClusterService.class, RemoteStoreBaseIntegTestCase.internalCluster().getNodeNames()[0]).state().metadata().custom("repositories");
        RepositoryMetadata actualRepository = repositories.repository(repositoryName);
        RepositoriesService repositoriesService = RemoteStoreBaseIntegTestCase.internalCluster().getClusterManagerNodeInstance(RepositoriesService.class);
        BlobStoreRepository repository = (BlobStoreRepository)repositoriesService.repository(repositoryName);
        for (String nodeName : RemoteStoreBaseIntegTestCase.internalCluster().getNodeNames()) {
            ClusterService clusterService = RemoteStoreBaseIntegTestCase.internalCluster().getInstance(ClusterService.class, nodeName);
            DiscoveryNode node = clusterService.localNode();
            RepositoryMetadata expectedRepository = this.buildRepositoryMetadata(node, repositoryName);
            repository.getRestrictedSystemRepositorySettings().stream().forEach(setting -> RemoteStoreBaseIntegTestCase.assertEquals((String)String.format(Locale.ROOT, "Restricted Settings mismatch [%s]", setting.getKey()), (Object)setting.get(actualRepository.settings()), (Object)setting.get(expectedRepository.settings())));
        }
    }

    public static int getFileCount(Path path) throws IOException {
        final AtomicInteger filesExisting = new AtomicInteger(0);
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException impossible) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                filesExisting.incrementAndGet();
                return FileVisitResult.CONTINUE;
            }
        });
        return filesExisting.get();
    }

    protected IndexShard getIndexShard(String dataNode, String indexName) throws ExecutionException, InterruptedException {
        String clusterManagerName = RemoteStoreBaseIntegTestCase.internalCluster().getClusterManagerName();
        IndicesService indicesService = RemoteStoreBaseIntegTestCase.internalCluster().getInstance(IndicesService.class, dataNode);
        GetIndexResponse getIndexResponse = (GetIndexResponse)RemoteStoreBaseIntegTestCase.client(clusterManagerName).admin().indices().getIndex(new GetIndexRequest()).get();
        String uuid = ((Settings)getIndexResponse.getSettings().get(indexName)).get("index.uuid");
        IndexService indexService = indicesService.indexService(new Index(indexName, uuid));
        return indexService.getShard(0);
    }

    protected void restore(boolean restoreAllShards, String ... indices) {
        if (restoreAllShards) {
            OpenSearchAssertions.assertAcked(RemoteStoreBaseIntegTestCase.client().admin().indices().prepareClose(indices));
        }
        RemoteStoreBaseIntegTestCase.client().admin().cluster().restoreRemoteStore(new RestoreRemoteStoreRequest().indices(indices).restoreAllShards(restoreAllShards), (ActionListener)PlainActionFuture.newFuture());
    }

    protected void prepareCluster(int numClusterManagerNodes, int numDataOnlyNodes, String indices, int replicaCount, int shardCount) {
        this.prepareCluster(numClusterManagerNodes, numDataOnlyNodes, indices, replicaCount, shardCount, Settings.EMPTY);
    }

    protected void prepareCluster(int numClusterManagerNodes, int numDataOnlyNodes, String indices, int replicaCount, int shardCount, Settings settings) {
        this.prepareCluster(numClusterManagerNodes, numDataOnlyNodes, settings);
        for (String index : indices.split(",")) {
            this.createIndex(index, this.remoteStoreIndexSettings(replicaCount, shardCount));
            this.ensureYellowAndNoInitializingShards(index);
            this.ensureGreen(index);
        }
    }

    protected void prepareCluster(int numClusterManagerNodes, int numDataOnlyNodes, Settings settings) {
        RemoteStoreBaseIntegTestCase.internalCluster().startClusterManagerOnlyNodes(numClusterManagerNodes, settings);
        RemoteStoreBaseIntegTestCase.internalCluster().startDataOnlyNodes(numDataOnlyNodes, settings);
    }
}

