/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.remotestore.mocks;

import org.opensearch.cluster.metadata.RepositoryMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.blobstore.BlobStore;
import org.opensearch.common.blobstore.fs.FsBlobStore;
import org.opensearch.common.settings.Setting;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.env.Environment;
import org.opensearch.indices.recovery.RecoverySettings;
import org.opensearch.remotestore.mocks.MockFsMetadataSupportedBlobStore;
import org.opensearch.repositories.fs.ReloadableFsRepository;

public class MockFsMetadataSupportedRepository
extends ReloadableFsRepository {
    public static Setting<Boolean> TRIGGER_DATA_INTEGRITY_FAILURE = Setting.boolSetting((String)"mock_fs_repository.trigger_data_integrity_failure", (boolean)false, (Setting.Property[])new Setting.Property[0]);
    private final boolean triggerDataIntegrityFailure;

    public MockFsMetadataSupportedRepository(RepositoryMetadata metadata, Environment environment, NamedXContentRegistry namedXContentRegistry, ClusterService clusterService, RecoverySettings recoverySettings) {
        super(metadata, environment, namedXContentRegistry, clusterService, recoverySettings);
        this.triggerDataIntegrityFailure = (Boolean)TRIGGER_DATA_INTEGRITY_FAILURE.get(metadata.settings());
    }

    protected BlobStore createBlobStore() throws Exception {
        FsBlobStore fsBlobStore = (FsBlobStore)super.createBlobStore();
        return new MockFsMetadataSupportedBlobStore(fsBlobStore.bufferSizeInBytes(), fsBlobStore.path(), this.isReadOnly(), this.triggerDataIntegrityFailure);
    }
}

