/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.composite;

import java.io.IOException;
import java.net.InetAddress;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.InetAddressPoint;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.search.SortedSetSortField;
import org.apache.lucene.store.Directory;
import org.apache.lucene.tests.analysis.MockAnalyzer;
import org.apache.lucene.tests.index.RandomIndexWriter;
import org.apache.lucene.tests.store.BaseDirectoryWrapper;
import org.apache.lucene.tests.util.TestUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.junit.After;
import org.junit.Before;
import org.mockito.Mockito;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.time.DateFormatter;
import org.opensearch.common.time.DateFormatters;
import org.opensearch.core.common.text.Text;
import org.opensearch.core.index.Index;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.mapper.DateFieldMapper;
import org.opensearch.index.mapper.DocumentMapper;
import org.opensearch.index.mapper.IpFieldMapper;
import org.opensearch.index.mapper.KeywordFieldMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.index.mapper.NumberFieldMapper;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregatorTestCase;
import org.opensearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.opensearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.opensearch.search.aggregations.bucket.composite.InternalComposite;
import org.opensearch.test.IndexSettingsModule;

public class BaseCompositeAggregatorTestCase
extends AggregatorTestCase {
    protected static List<MappedFieldType> FIELD_TYPES;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        FIELD_TYPES = new ArrayList<MappedFieldType>();
        FIELD_TYPES.add((MappedFieldType)new KeywordFieldMapper.KeywordFieldType("keyword"));
        FIELD_TYPES.add((MappedFieldType)new NumberFieldMapper.NumberFieldType("long", NumberFieldMapper.NumberType.LONG));
        FIELD_TYPES.add((MappedFieldType)new NumberFieldMapper.NumberFieldType("double", NumberFieldMapper.NumberType.DOUBLE));
        FIELD_TYPES.add((MappedFieldType)new DateFieldMapper.DateFieldType("date", DateFormatter.forPattern((String)"yyyy-MM-dd||epoch_millis")));
        FIELD_TYPES.add((MappedFieldType)new NumberFieldMapper.NumberFieldType("price", NumberFieldMapper.NumberType.INTEGER));
        FIELD_TYPES.add((MappedFieldType)new KeywordFieldMapper.KeywordFieldType("terms"));
        FIELD_TYPES.add((MappedFieldType)new IpFieldMapper.IpFieldType("ip"));
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        FIELD_TYPES = null;
    }

    @Override
    protected MapperService mapperServiceMock() {
        MapperService mapperService = (MapperService)Mockito.mock(MapperService.class);
        DocumentMapper mapper = (DocumentMapper)Mockito.mock(DocumentMapper.class);
        Mockito.when((Object)mapper.typeText()).thenReturn((Object)new Text("_doc"));
        Mockito.when((Object)mapper.type()).thenReturn((Object)"_doc");
        Mockito.when((Object)mapperService.documentMapper()).thenReturn((Object)mapper);
        return mapperService;
    }

    protected static Map<String, List<Object>> createDocument(Object ... fields) {
        assert (fields.length % 2 == 0);
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>();
        for (int i = 0; i < fields.length; i += 2) {
            String field = (String)fields[i];
            if (fields[i + 1] instanceof List) {
                map.put(field, (List)fields[i + 1]);
                continue;
            }
            map.put(field, Collections.singletonList(fields[i + 1]));
        }
        return map;
    }

    protected void testSearchCase(List<Query> queries, List<Map<String, List<Object>>> dataset, Supplier<CompositeAggregationBuilder> create, Consumer<InternalComposite> verify) throws IOException {
        for (Query query : queries) {
            this.executeTestCase(false, false, query, dataset, create, verify);
            this.executeTestCase(false, true, query, dataset, create, verify);
        }
    }

    protected void executeTestCase(boolean forceMerge, boolean useIndexSort, Query query, List<Map<String, List<Object>>> dataset, Supplier<? extends AggregationBuilder> create, Consumer<InternalComposite> verify) throws IOException {
        Map<String, MappedFieldType> types = FIELD_TYPES.stream().collect(Collectors.toMap(MappedFieldType::name, Function.identity()));
        AggregationBuilder aggregationBuilder = create.get();
        Sort indexSort = null;
        if (aggregationBuilder instanceof CompositeAggregationBuilder && useIndexSort) {
            CompositeAggregationBuilder cab = (CompositeAggregationBuilder)aggregationBuilder;
            indexSort = BaseCompositeAggregatorTestCase.buildIndexSort(cab.sources(), types);
        }
        IndexSettings indexSettings = BaseCompositeAggregatorTestCase.createIndexSettings(indexSort);
        try (BaseDirectoryWrapper directory = BaseCompositeAggregatorTestCase.newDirectory();){
            IndexWriterConfig config = BaseCompositeAggregatorTestCase.newIndexWriterConfig((Random)BaseCompositeAggregatorTestCase.random(), (Analyzer)new MockAnalyzer(BaseCompositeAggregatorTestCase.random()));
            if (indexSort != null) {
                config.setIndexSort(indexSort);
                config.setCodec(TestUtil.getDefaultCodec());
            }
            try (RandomIndexWriter indexWriter = new RandomIndexWriter(BaseCompositeAggregatorTestCase.random(), (Directory)directory, config);){
                Document document = new Document();
                int id = 0;
                for (Map<String, List<Object>> fields : dataset) {
                    document.clear();
                    this.addToDocument(id, document, fields);
                    indexWriter.addDocument((Iterable)document);
                    ++id;
                }
                if (forceMerge || BaseCompositeAggregatorTestCase.rarely()) {
                    indexWriter.forceMerge(1);
                } else if (dataset.size() > 0) {
                    int numDeletes = BaseCompositeAggregatorTestCase.randomIntBetween(1, 25);
                    for (int i = 0; i < numDeletes; ++i) {
                        id = BaseCompositeAggregatorTestCase.randomIntBetween(0, dataset.size() - 1);
                        indexWriter.deleteDocuments(new Term("id", Integer.toString(id)));
                        document.clear();
                        this.addToDocument(id, document, dataset.get(id));
                        indexWriter.addDocument((Iterable)document);
                    }
                }
            }
            try (DirectoryReader indexReader = DirectoryReader.open((Directory)directory);){
                IndexSearcher indexSearcher = new IndexSearcher((IndexReader)indexReader);
                Object aggregation = this.searchAndReduce(indexSettings, indexSearcher, query, aggregationBuilder, FIELD_TYPES.toArray(new MappedFieldType[0]));
                if (aggregation instanceof InternalComposite) {
                    verify.accept((InternalComposite)aggregation);
                }
            }
        }
    }

    protected void addToDocument(int id, Document doc, Map<String, List<Object>> keys) {
        doc.add((IndexableField)new StringField("id", Integer.toString(id), Field.Store.NO));
        for (Map.Entry<String, List<Object>> entry : keys.entrySet()) {
            String name = entry.getKey();
            if (name.equals("_doc_count")) {
                doc.add((IndexableField)new IntPoint(name, new int[]{(Integer)entry.getValue().get(0)}));
                doc.add((IndexableField)new NumericDocValuesField(name, (long)((Integer)entry.getValue().get(0)).intValue()));
                continue;
            }
            for (Object value : entry.getValue()) {
                if (value instanceof Integer) {
                    doc.add((IndexableField)new SortedNumericDocValuesField(name, (long)((Integer)value).intValue()));
                    doc.add((IndexableField)new IntPoint(name, new int[]{(Integer)value}));
                    continue;
                }
                if (value instanceof Long) {
                    doc.add((IndexableField)new SortedNumericDocValuesField(name, ((Long)value).longValue()));
                    doc.add((IndexableField)new LongPoint(name, new long[]{(Long)value}));
                    continue;
                }
                if (value instanceof Double) {
                    doc.add((IndexableField)new SortedNumericDocValuesField(name, NumericUtils.doubleToSortableLong((double)((Double)value))));
                    doc.add((IndexableField)new DoublePoint(name, new double[]{(Double)value}));
                    continue;
                }
                if (value instanceof String) {
                    doc.add((IndexableField)new SortedSetDocValuesField(name, new BytesRef((CharSequence)((String)value))));
                    doc.add((IndexableField)new StringField(name, new BytesRef((CharSequence)((String)value)), Field.Store.NO));
                    continue;
                }
                if (value instanceof InetAddress) {
                    doc.add((IndexableField)new SortedSetDocValuesField(name, new BytesRef(InetAddressPoint.encode((InetAddress)((InetAddress)value)))));
                    doc.add((IndexableField)new InetAddressPoint(name, (InetAddress)value));
                    continue;
                }
                if (!this.addValueToDocument(doc, name, value)) {
                    throw new AssertionError((Object)("invalid object: " + value.getClass().getSimpleName()));
                }
            }
        }
    }

    protected boolean addValueToDocument(Document doc, String name, Object value) {
        return false;
    }

    protected static Sort buildIndexSort(List<CompositeValuesSourceBuilder<?>> sources, Map<String, MappedFieldType> fieldTypes) {
        ArrayList<SortField> sortFields = new ArrayList<SortField>();
        HashMap<String, MappedFieldType> remainingFieldTypes = new HashMap<String, MappedFieldType>(fieldTypes);
        for (CompositeValuesSourceBuilder<?> source : sources) {
            MappedFieldType type = fieldTypes.remove(source.field());
            remainingFieldTypes.remove(source.field());
            SortField sortField = BaseCompositeAggregatorTestCase.sortFieldFrom(type);
            if (sortField == null) break;
            sortFields.add(sortField);
        }
        while (remainingFieldTypes.size() > 0 && BaseCompositeAggregatorTestCase.randomBoolean()) {
            ArrayList fields = new ArrayList(remainingFieldTypes.keySet());
            Collections.sort(fields);
            String field = (String)fields.get(BaseCompositeAggregatorTestCase.between(0, fields.size() - 1));
            SortField sortField = BaseCompositeAggregatorTestCase.sortFieldFrom((MappedFieldType)remainingFieldTypes.remove(field));
            if (sortField == null) continue;
            sortFields.add(sortField);
        }
        return sortFields.size() > 0 ? new Sort(sortFields.toArray(new SortField[0])) : null;
    }

    protected static SortField sortFieldFrom(MappedFieldType type) {
        if (type == null) {
            return null;
        }
        if (type.unwrap() instanceof KeywordFieldMapper.KeywordFieldType) {
            return new SortedSetSortField(type.name(), false);
        }
        if (type.unwrap() instanceof DateFieldMapper.DateFieldType) {
            return new SortedNumericSortField(type.name(), SortField.Type.LONG, false);
        }
        if (type.unwrap() instanceof NumberFieldMapper.NumberFieldType) {
            switch (type.typeName()) {
                case "byte": 
                case "short": 
                case "integer": {
                    return new SortedNumericSortField(type.name(), SortField.Type.INT, false);
                }
                case "long": {
                    return new SortedNumericSortField(type.name(), SortField.Type.LONG, false);
                }
                case "float": 
                case "double": {
                    return new SortedNumericSortField(type.name(), SortField.Type.DOUBLE, false);
                }
            }
            return null;
        }
        return null;
    }

    protected static IndexSettings createIndexSettings(Sort sort) {
        Settings.Builder builder = Settings.builder();
        if (sort != null) {
            String[] fields = (String[])Arrays.stream(sort.getSort()).map(SortField::getField).toArray(String[]::new);
            String[] orders = (String[])Arrays.stream(sort.getSort()).map(o -> o.getReverse() ? "desc" : "asc").toArray(String[]::new);
            builder.putList("index.sort.field", fields);
            builder.putList("index.sort.order", orders);
        }
        return IndexSettingsModule.newIndexSettings(new Index("_index", "0"), builder.build(), new Setting[0]);
    }

    protected static Map<String, Object> createAfterKey(Object ... fields) {
        assert (fields.length % 2 == 0);
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < fields.length; i += 2) {
            String field = (String)fields[i];
            map.put(field, fields[i + 1]);
        }
        return map;
    }

    protected static long asLong(String dateTime) {
        return DateFormatters.from((TemporalAccessor)DateFieldMapper.getDefaultDateTimeFormatter().parse(dateTime)).toInstant().toEpochMilli();
    }
}

