/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.opensearch.OpenSearchException;
import org.opensearch.action.admin.cluster.node.info.NodeInfo;
import org.opensearch.action.admin.cluster.node.info.NodesInfoRequest;
import org.opensearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.opensearch.action.admin.cluster.node.stats.NodeStats;
import org.opensearch.action.admin.cluster.node.stats.NodesStatsRequest;
import org.opensearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.common.transport.TransportAddress;
import org.opensearch.env.Environment;
import org.opensearch.http.HttpInfo;
import org.opensearch.node.MockNode;
import org.opensearch.plugins.Plugin;
import org.opensearch.test.MockHttpTransport;
import org.opensearch.test.OpenSearchTestCase;
import org.opensearch.test.TestCluster;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.nio.MockNioTransportPlugin;

public final class ExternalTestCluster
extends TestCluster {
    private static final Logger logger = LogManager.getLogger(ExternalTestCluster.class);
    private static final AtomicInteger counter = new AtomicInteger();
    public static final String EXTERNAL_CLUSTER_PREFIX = "external_";
    private final MockNode node;
    private final Client client;
    private final InetSocketAddress[] httpAddresses;
    private final String clusterName;
    private final int numDataNodes;
    private final int numClusterManagerAndDataNodes;

    public ExternalTestCluster(Path tempDir, Settings additionalSettings, Function<Client, Client> clientWrapper, String clusterName, Collection<Class<? extends Plugin>> pluginClasses, TransportAddress ... transportAddresses) {
        super(0L);
        boolean addMockTcpTransport;
        this.clusterName = clusterName;
        Settings.Builder clientSettingsBuilder = Settings.builder().put(additionalSettings).put("node.master", false).put("node.data", false).put("node.ingest", false).put("node.name", EXTERNAL_CLUSTER_PREFIX + counter.getAndIncrement()).put("cluster.name", clusterName).putList("discovery.seed_hosts", Arrays.stream(transportAddresses).map(TransportAddress::toString).collect(Collectors.toList()));
        if (!Environment.PATH_HOME_SETTING.exists(additionalSettings)) {
            clientSettingsBuilder.put(Environment.PATH_HOME_SETTING.getKey(), tempDir);
        }
        boolean bl = addMockTcpTransport = additionalSettings.get("transport.type") == null;
        if (addMockTcpTransport) {
            String transport = OpenSearchTestCase.getTestTransportType();
            clientSettingsBuilder.put("transport.type", transport);
            if (!pluginClasses.contains(MockNioTransportPlugin.class)) {
                pluginClasses = new ArrayList<Class<? extends Plugin>>(pluginClasses);
                pluginClasses.add(MockNioTransportPlugin.class);
            }
        }
        pluginClasses = new ArrayList<Class<? extends Plugin>>(pluginClasses);
        pluginClasses.add(MockHttpTransport.TestPlugin.class);
        Settings clientSettings = clientSettingsBuilder.build();
        MockNode node = new MockNode(clientSettings, pluginClasses);
        Client client = clientWrapper.apply(node.client());
        try {
            node.start();
            NodesInfoResponse nodeInfos = (NodesInfoResponse)client.admin().cluster().prepareNodesInfo(new String[0]).clear().addMetrics(new String[]{NodesInfoRequest.Metric.SETTINGS.metricName(), NodesInfoRequest.Metric.HTTP.metricName()}).get();
            this.httpAddresses = new InetSocketAddress[nodeInfos.getNodes().size()];
            int dataNodes = 0;
            int clusterManagerAndDataNodes = 0;
            for (int i = 0; i < nodeInfos.getNodes().size(); ++i) {
                NodeInfo nodeInfo = (NodeInfo)nodeInfos.getNodes().get(i);
                this.httpAddresses[i] = ((HttpInfo)nodeInfo.getInfo(HttpInfo.class)).address().publishAddress().address();
                if (DiscoveryNode.isDataNode((Settings)nodeInfo.getSettings())) {
                    ++dataNodes;
                    ++clusterManagerAndDataNodes;
                    continue;
                }
                if (!DiscoveryNode.isClusterManagerNode((Settings)nodeInfo.getSettings())) continue;
                ++clusterManagerAndDataNodes;
            }
            this.numDataNodes = dataNodes;
            this.numClusterManagerAndDataNodes = clusterManagerAndDataNodes;
            this.client = client;
            this.node = node;
            logger.info("Setup ExternalTestCluster [{}] made of [{}] nodes", (Object)nodeInfos.getClusterName().value(), (Object)this.size());
        }
        catch (Exception e) {
            try {
                client.close();
                node.close();
            }
            catch (IOException e1) {
                e.addSuppressed(e1);
            }
            throw new OpenSearchException((Throwable)e);
        }
    }

    @Override
    public void afterTest() {
    }

    @Override
    public Client client() {
        return this.client;
    }

    @Override
    public int size() {
        return this.httpAddresses.length;
    }

    @Override
    public int numDataNodes() {
        return this.numDataNodes;
    }

    @Override
    public int numDataAndClusterManagerNodes() {
        return this.numClusterManagerAndDataNodes;
    }

    @Override
    public InetSocketAddress[] httpAddresses() {
        return this.httpAddresses;
    }

    @Override
    public void close() throws IOException {
        this.client.close();
        this.node.close();
    }

    @Override
    public void ensureEstimatedStats() {
        if (this.size() > 0) {
            NodesStatsResponse nodeStats = (NodesStatsResponse)this.client().admin().cluster().prepareNodesStats(new String[0]).clear().setIndices(true).addMetric(NodesStatsRequest.Metric.BREAKER.metricName()).execute().actionGet();
            for (NodeStats stats : nodeStats.getNodes()) {
                Assert.assertThat((String)("Fielddata breaker not reset to 0 on node: " + String.valueOf(stats.getNode())), (Object)stats.getBreaker().getStats("fielddata").getEstimated(), (Matcher)Matchers.equalTo((Object)0L));
                Assert.assertThat((String)("Fielddata size must be 0 on node: " + String.valueOf(stats.getNode())), (Object)stats.getIndices().getFieldData().getMemorySizeInBytes(), (Matcher)Matchers.equalTo((Object)0L));
                Assert.assertThat((String)("Query cache size must be 0 on node: " + String.valueOf(stats.getNode())), (Object)stats.getIndices().getQueryCache().getMemorySizeInBytes(), (Matcher)Matchers.equalTo((Object)0L));
                Assert.assertThat((String)("FixedBitSet cache size must be 0 on node: " + String.valueOf(stats.getNode())), (Object)stats.getIndices().getSegments().getBitsetMemoryInBytes(), (Matcher)Matchers.equalTo((Object)0L));
            }
        }
    }

    @Override
    public Iterable<Client> getClients() {
        return Collections.singleton(this.client);
    }

    @Override
    public NamedWriteableRegistry getNamedWriteableRegistry() {
        return this.node.getNamedWriteableRegistry();
    }

    @Override
    public String getClusterName() {
        return this.clusterName;
    }
}

