/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.opensearch.search.aggregations.Aggregation;
import org.opensearch.search.aggregations.Aggregations;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.InternalAggregations;
import org.opensearch.search.aggregations.InternalMultiBucketAggregation;
import org.opensearch.search.aggregations.MultiBucketConsumerService;
import org.opensearch.search.aggregations.ParsedAggregation;
import org.opensearch.search.aggregations.ParsedMultiBucketAggregation;
import org.opensearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.opensearch.test.InternalAggregationTestCase;

public abstract class InternalMultiBucketAggregationTestCase<T extends InternalAggregation>
extends InternalAggregationTestCase<T> {
    private static final int DEFAULT_MAX_NUMBER_OF_BUCKETS = 10;
    private Supplier<InternalAggregations> subAggregationsSupplier;
    private int maxNumberOfBuckets = 10;

    protected int randomNumberOfBuckets() {
        return InternalMultiBucketAggregationTestCase.randomIntBetween(this.minNumberOfBuckets(), this.maxNumberOfBuckets());
    }

    protected int minNumberOfBuckets() {
        return 0;
    }

    protected int maxNumberOfBuckets() {
        return this.maxNumberOfBuckets;
    }

    public void setMaxNumberOfBuckets(int maxNumberOfBuckets) {
        this.maxNumberOfBuckets = maxNumberOfBuckets;
    }

    public void setSubAggregationsSupplier(Supplier<InternalAggregations> subAggregationsSupplier) {
        this.subAggregationsSupplier = subAggregationsSupplier;
    }

    public final InternalAggregations createSubAggregations() {
        return this.subAggregationsSupplier.get();
    }

    public void setUp() throws Exception {
        super.setUp();
        this.subAggregationsSupplier = InternalMultiBucketAggregationTestCase.randomBoolean() ? () -> InternalAggregations.EMPTY : () -> {
            int numAggregations = InternalMultiBucketAggregationTestCase.randomIntBetween(1, 3);
            ArrayList<T> aggs = new ArrayList<T>();
            for (int i = 0; i < numAggregations; ++i) {
                aggs.add(this.createTestInstance(InternalMultiBucketAggregationTestCase.randomAlphaOfLength(5), Collections.emptyMap(), InternalAggregations.EMPTY));
            }
            return InternalAggregations.from(aggs);
        };
    }

    @Override
    protected final T createTestInstance(String name, Map<String, Object> metadata) {
        T instance = this.createTestInstance(name, metadata, this.subAggregationsSupplier.get());
        assert (((MultiBucketsAggregation)instance).getBuckets().size() <= this.maxNumberOfBuckets()) : "Maximum number of buckets exceeded for " + instance.getClass().getSimpleName() + " aggregation";
        return instance;
    }

    protected abstract T createTestInstance(String var1, Map<String, Object> var2, InternalAggregations var3);

    protected abstract Class<? extends ParsedMultiBucketAggregation> implementationClass();

    @Override
    protected final void assertFromXContent(T aggregation, ParsedAggregation parsedAggregation) {
        this.assertMultiBucketsAggregations((Aggregation)aggregation, (Aggregation)parsedAggregation, false);
    }

    public void testIterators() throws IOException {
        Object aggregation = this.createTestInstance();
        this.assertMultiBucketsAggregations((Aggregation)aggregation, (Aggregation)this.parseAndAssert((InternalAggregation)aggregation, false, false), true);
    }

    private void assertMultiBucketsAggregations(Aggregation expected, Aggregation actual, boolean checkOrder) {
        InternalMultiBucketAggregationTestCase.assertTrue((boolean)(expected instanceof MultiBucketsAggregation));
        MultiBucketsAggregation expectedMultiBucketsAggregation = (MultiBucketsAggregation)expected;
        InternalMultiBucketAggregationTestCase.assertTrue((boolean)(actual instanceof MultiBucketsAggregation));
        MultiBucketsAggregation actualMultiBucketsAggregation = (MultiBucketsAggregation)actual;
        this.assertMultiBucketsAggregation(expectedMultiBucketsAggregation, actualMultiBucketsAggregation, checkOrder);
        List expectedBuckets = expectedMultiBucketsAggregation.getBuckets();
        List actualBuckets = actualMultiBucketsAggregation.getBuckets();
        InternalMultiBucketAggregationTestCase.assertEquals((long)expectedBuckets.size(), (long)actualBuckets.size());
        if (checkOrder) {
            Iterator expectedIt = expectedBuckets.iterator();
            Iterator actualIt = actualBuckets.iterator();
            while (expectedIt.hasNext()) {
                MultiBucketsAggregation.Bucket expectedBucket = (MultiBucketsAggregation.Bucket)expectedIt.next();
                MultiBucketsAggregation.Bucket actualBucket = (MultiBucketsAggregation.Bucket)actualIt.next();
                this.assertBucket(expectedBucket, actualBucket, true);
            }
        } else {
            for (MultiBucketsAggregation.Bucket expectedBucket : expectedBuckets) {
                Object expectedKey = expectedBucket.getKey();
                boolean found = false;
                for (MultiBucketsAggregation.Bucket actualBucket : actualBuckets) {
                    Object actualKey = actualBucket.getKey();
                    if ((actualKey == null || !actualKey.equals(expectedKey)) && (actualKey != null || expectedKey != null)) continue;
                    found = true;
                    this.assertBucket(expectedBucket, actualBucket, false);
                    break;
                }
                InternalMultiBucketAggregationTestCase.assertTrue((String)("Failed to find bucket with key [" + String.valueOf(expectedBucket.getKey()) + "]"), (boolean)found);
            }
        }
    }

    protected void assertMultiBucketsAggregation(MultiBucketsAggregation expected, MultiBucketsAggregation actual, boolean checkOrder) {
        Class<ParsedMultiBucketAggregation> parsedClass = this.implementationClass();
        InternalMultiBucketAggregationTestCase.assertNotNull((String)"Parsed aggregation class must not be null", parsedClass);
        InternalMultiBucketAggregationTestCase.assertTrue((String)("Unexpected parsed class, expected instance of: " + String.valueOf(actual) + ", but was: " + String.valueOf(parsedClass)), (boolean)parsedClass.isInstance(actual));
        InternalMultiBucketAggregationTestCase.assertTrue((boolean)(expected instanceof InternalAggregation));
        InternalMultiBucketAggregationTestCase.assertEquals((Object)expected.getName(), (Object)actual.getName());
        InternalMultiBucketAggregationTestCase.assertEquals((Object)expected.getMetadata(), (Object)actual.getMetadata());
        InternalMultiBucketAggregationTestCase.assertEquals((Object)expected.getType(), (Object)actual.getType());
    }

    protected void assertBucket(MultiBucketsAggregation.Bucket expected, MultiBucketsAggregation.Bucket actual, boolean checkOrder) {
        InternalMultiBucketAggregationTestCase.assertTrue((boolean)(expected instanceof InternalMultiBucketAggregation.InternalBucket));
        InternalMultiBucketAggregationTestCase.assertTrue((boolean)(actual instanceof ParsedMultiBucketAggregation.ParsedBucket));
        InternalMultiBucketAggregationTestCase.assertEquals((Object)expected.getKey(), (Object)actual.getKey());
        InternalMultiBucketAggregationTestCase.assertEquals((Object)expected.getKeyAsString(), (Object)actual.getKeyAsString());
        InternalMultiBucketAggregationTestCase.assertEquals((long)expected.getDocCount(), (long)actual.getDocCount());
        Aggregations expectedAggregations = expected.getAggregations();
        Aggregations actualAggregations = actual.getAggregations();
        InternalMultiBucketAggregationTestCase.assertEquals((long)expectedAggregations.asList().size(), (long)actualAggregations.asList().size());
        if (checkOrder) {
            Iterator expectedIt = expectedAggregations.iterator();
            Iterator actualIt = actualAggregations.iterator();
            while (expectedIt.hasNext()) {
                Aggregation expectedAggregation = (Aggregation)expectedIt.next();
                Aggregation actualAggregation = (Aggregation)actualIt.next();
                this.assertMultiBucketsAggregations(expectedAggregation, actualAggregation, true);
            }
        } else {
            for (Aggregation expectedAggregation : expectedAggregations) {
                Aggregation actualAggregation = actualAggregations.get(expectedAggregation.getName());
                InternalMultiBucketAggregationTestCase.assertNotNull((Object)actualAggregation);
                this.assertMultiBucketsAggregations(expectedAggregation, actualAggregation, false);
            }
        }
    }

    @Override
    public void doAssertReducedMultiBucketConsumer(Aggregation agg, MultiBucketConsumerService.MultiBucketConsumer bucketConsumer) {
    }
}

