/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test.disruption;

import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.opensearch.ExceptionsHelper;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.Priority;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.test.InternalTestCluster;
import org.opensearch.test.disruption.SingleNodeDisruption;

public class SlowClusterStateProcessing
extends SingleNodeDisruption {
    volatile boolean disrupting;
    volatile Thread worker;
    final long intervalBetweenDelaysMin;
    final long intervalBetweenDelaysMax;
    final long delayDurationMin;
    final long delayDurationMax;

    public SlowClusterStateProcessing(Random random) {
        this(null, random);
    }

    public SlowClusterStateProcessing(String disruptedNode, Random random) {
        this(disruptedNode, random, 100L, 200L, 300L, 20000L);
    }

    public SlowClusterStateProcessing(String disruptedNode, Random random, long intervalBetweenDelaysMin, long intervalBetweenDelaysMax, long delayDurationMin, long delayDurationMax) {
        this(random, intervalBetweenDelaysMin, intervalBetweenDelaysMax, delayDurationMin, delayDurationMax);
        this.disruptedNode = disruptedNode;
    }

    public SlowClusterStateProcessing(Random random, long intervalBetweenDelaysMin, long intervalBetweenDelaysMax, long delayDurationMin, long delayDurationMax) {
        super(random);
        this.intervalBetweenDelaysMin = intervalBetweenDelaysMin;
        this.intervalBetweenDelaysMax = intervalBetweenDelaysMax;
        this.delayDurationMin = delayDurationMin;
        this.delayDurationMax = delayDurationMax;
    }

    @Override
    public void startDisrupting() {
        this.disrupting = true;
        this.worker = new Thread(new BackgroundWorker());
        this.worker.setDaemon(true);
        this.worker.start();
    }

    @Override
    public void stopDisrupting() {
        if (this.worker == null) {
            return;
        }
        this.logger.info("stopping to slow down cluster state processing on [{}]", (Object)this.disruptedNode);
        this.disrupting = false;
        this.worker.interrupt();
        try {
            this.worker.join(2L * (this.intervalBetweenDelaysMax + this.delayDurationMax));
        }
        catch (InterruptedException e) {
            this.logger.info("background thread failed to stop");
        }
        this.worker = null;
    }

    private boolean interruptClusterStateProcessing(TimeValue duration) throws InterruptedException {
        String disruptionNodeCopy = this.disruptedNode;
        if (disruptionNodeCopy == null) {
            return false;
        }
        this.logger.info("delaying cluster state updates on node [{}] for [{}]", (Object)disruptionNodeCopy, (Object)duration);
        CountDownLatch countDownLatch = new CountDownLatch(1);
        ClusterService clusterService = this.cluster.getInstance(ClusterService.class, disruptionNodeCopy);
        if (clusterService == null) {
            return false;
        }
        AtomicBoolean stopped = new AtomicBoolean(false);
        clusterService.getClusterApplierService().runOnApplierThread("service_disruption_delay", currentState -> {
            try {
                for (long count = duration.millis() / 200L; count > 0L && !stopped.get(); --count) {
                    Thread.sleep(200L);
                }
                if (!stopped.get()) {
                    Thread.sleep(duration.millis() % 200L);
                }
                countDownLatch.countDown();
            }
            catch (InterruptedException e) {
                ExceptionsHelper.reThrowIfNotNull((Throwable)e);
            }
        }, (source, e) -> countDownLatch.countDown(), Priority.IMMEDIATE);
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e2) {
            stopped.set(true);
            countDownLatch.await();
        }
        return true;
    }

    @Override
    public void removeAndEnsureHealthy(InternalTestCluster cluster) {
        this.removeFromCluster(cluster);
        this.ensureNodeCount(cluster);
    }

    @Override
    public TimeValue expectedTimeToHeal() {
        return TimeValue.timeValueMillis((long)0L);
    }

    class BackgroundWorker
    implements Runnable {
        BackgroundWorker() {
        }

        @Override
        public void run() {
            while (SlowClusterStateProcessing.this.disrupting && SlowClusterStateProcessing.this.disruptedNode != null) {
                try {
                    TimeValue duration = new TimeValue(SlowClusterStateProcessing.this.delayDurationMin + (long)SlowClusterStateProcessing.this.random.nextInt((int)(SlowClusterStateProcessing.this.delayDurationMax - SlowClusterStateProcessing.this.delayDurationMin)));
                    if (!SlowClusterStateProcessing.this.interruptClusterStateProcessing(duration) || SlowClusterStateProcessing.this.intervalBetweenDelaysMax <= 0L) continue;
                    duration = new TimeValue(SlowClusterStateProcessing.this.intervalBetweenDelaysMin + (long)SlowClusterStateProcessing.this.random.nextInt((int)(SlowClusterStateProcessing.this.intervalBetweenDelaysMax - SlowClusterStateProcessing.this.intervalBetweenDelaysMin)));
                    if (!SlowClusterStateProcessing.this.disrupting || SlowClusterStateProcessing.this.disruptedNode == null) continue;
                    Thread.sleep(duration.millis());
                }
                catch (InterruptedException duration) {
                }
                catch (Exception e) {
                    SlowClusterStateProcessing.this.logger.error("error in background worker", (Throwable)e);
                }
            }
        }
    }
}

