/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test.rest.yaml.section;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.opensearch.core.common.ParsingException;
import org.opensearch.core.xcontent.XContentLocation;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.test.rest.yaml.section.ExecutableSection;
import org.opensearch.test.rest.yaml.section.ParserUtils;
import org.opensearch.test.rest.yaml.section.SkipSection;

public class ClientYamlTestSection
implements Comparable<ClientYamlTestSection> {
    private final XContentLocation location;
    private final String name;
    private final SkipSection skipSection;
    private final List<ExecutableSection> executableSections;

    public static ClientYamlTestSection parse(XContentParser parser) throws IOException {
        ParserUtils.advanceToFieldName(parser);
        XContentLocation sectionLocation = parser.getTokenLocation();
        String sectionName = parser.currentName();
        ArrayList<ExecutableSection> executableSections = new ArrayList<ExecutableSection>();
        try {
            parser.nextToken();
            SkipSection skipSection = SkipSection.parseIfNext(parser);
            while (parser.currentToken() != XContentParser.Token.END_ARRAY) {
                ParserUtils.advanceToFieldName(parser);
                executableSections.add(ExecutableSection.parse(parser));
            }
            if (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                throw new IllegalArgumentException("malformed section [" + sectionName + "] expected [" + String.valueOf(XContentParser.Token.END_OBJECT) + "] but was [" + String.valueOf(parser.currentToken()) + "]");
            }
            parser.nextToken();
            return new ClientYamlTestSection(sectionLocation, sectionName, skipSection, executableSections);
        }
        catch (Exception e) {
            throw new ParsingException(parser.getTokenLocation(), "Error parsing test named [" + sectionName + "]", (Throwable)e, new Object[0]);
        }
    }

    public ClientYamlTestSection(XContentLocation location, String name, SkipSection skipSection, List<ExecutableSection> executableSections) {
        this.location = location;
        this.name = name;
        this.skipSection = Objects.requireNonNull(skipSection, "skip section cannot be null");
        this.executableSections = Collections.unmodifiableList(executableSections);
    }

    public XContentLocation getLocation() {
        return this.location;
    }

    public String getName() {
        return this.name;
    }

    public SkipSection getSkipSection() {
        return this.skipSection;
    }

    public List<ExecutableSection> getExecutableSections() {
        return this.executableSections;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientYamlTestSection that = (ClientYamlTestSection)o;
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    @Override
    public int compareTo(ClientYamlTestSection o) {
        return this.name.compareTo(o.getName());
    }
}

