/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.upgrades;

import java.util.Map;
import org.opensearch.Version;
import org.opensearch.common.Booleans;
import org.opensearch.common.xcontent.support.XContentMapValues;
import org.opensearch.test.rest.OpenSearchRestTestCase;

public abstract class AbstractFullClusterRestartTestCase
extends OpenSearchRestTestCase {
    private static final boolean runningAgainstOldCluster = Booleans.parseBoolean((String)System.getProperty("tests.is_old_cluster"));
    private static final Version oldClusterVersion = Version.fromString((String)System.getProperty("tests.old_cluster_version"));

    public static boolean isRunningAgainstOldCluster() {
        return runningAgainstOldCluster;
    }

    protected final boolean isRunningAgainstAncientCluster() {
        return AbstractFullClusterRestartTestCase.isRunningAgainstOldCluster() && oldClusterVersion.before(Version.V_2_0_0);
    }

    public static Version getOldClusterVersion() {
        return oldClusterVersion;
    }

    @Override
    protected boolean preserveIndicesUponCompletion() {
        return true;
    }

    @Override
    protected boolean preserveSnapshotsUponCompletion() {
        return true;
    }

    @Override
    protected boolean preserveReposUponCompletion() {
        return true;
    }

    @Override
    protected boolean preserveTemplatesUponCompletion() {
        return true;
    }

    @Override
    protected boolean preserveClusterSettings() {
        return true;
    }

    @Override
    protected boolean preserveSLMPoliciesUponCompletion() {
        return true;
    }

    @Override
    protected boolean preserveDataStreamsUponCompletion() {
        return true;
    }

    protected static void assertNoFailures(Map<?, ?> response) {
        int failed = (Integer)XContentMapValues.extractValue((String)"_shards.failed", response);
        AbstractFullClusterRestartTestCase.assertEquals((long)0L, (long)failed);
    }

    protected void assertTotalHits(int expectedTotalHits, Map<?, ?> response) {
        int actualTotalHits = AbstractFullClusterRestartTestCase.extractTotalHits(response);
        AbstractFullClusterRestartTestCase.assertEquals((String)response.toString(), (long)expectedTotalHits, (long)actualTotalHits);
    }

    protected static int extractTotalHits(Map<?, ?> response) {
        return (Integer)XContentMapValues.extractValue((String)"hits.total.value", response);
    }
}

