/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import org.opensearch.Version;
import org.opensearch.cluster.ClusterInfo;
import org.opensearch.cluster.ClusterInfoService;
import org.opensearch.cluster.ClusterModule;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.EmptyClusterInfoService;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.node.DiscoveryNodeRole;
import org.opensearch.cluster.routing.RecoverySource;
import org.opensearch.cluster.routing.RoutingNode;
import org.opensearch.cluster.routing.RoutingNodes;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.routing.ShardRoutingState;
import org.opensearch.cluster.routing.UnassignedInfo;
import org.opensearch.cluster.routing.allocation.AllocationService;
import org.opensearch.cluster.routing.allocation.ExistingShardsAllocator;
import org.opensearch.cluster.routing.allocation.FailedShard;
import org.opensearch.cluster.routing.allocation.RoutingAllocation;
import org.opensearch.cluster.routing.allocation.allocator.BalancedShardsAllocator;
import org.opensearch.cluster.routing.allocation.allocator.ShardsAllocator;
import org.opensearch.cluster.routing.allocation.decider.AllocationDecider;
import org.opensearch.cluster.routing.allocation.decider.AllocationDeciders;
import org.opensearch.cluster.routing.allocation.decider.Decision;
import org.opensearch.cluster.routing.allocation.decider.FilterAllocationDecider;
import org.opensearch.cluster.routing.allocation.decider.SameShardAllocationDecider;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Settings;
import org.opensearch.gateway.GatewayAllocator;
import org.opensearch.snapshots.SnapshotShardSizeInfo;
import org.opensearch.snapshots.SnapshotsInfoService;
import org.opensearch.test.OpenSearchTestCase;
import org.opensearch.test.gateway.TestGatewayAllocator;

public abstract class OpenSearchAllocationTestCase
extends OpenSearchTestCase {
    private static final ClusterSettings EMPTY_CLUSTER_SETTINGS = new ClusterSettings(Settings.EMPTY, ClusterSettings.BUILT_IN_CLUSTER_SETTINGS);
    public static final SnapshotsInfoService SNAPSHOT_INFO_SERVICE_WITH_NO_SHARD_SIZES = () -> new SnapshotShardSizeInfo(Map.of()){

        public Long getShardSize(ShardRouting shardRouting) {
            assert (shardRouting.recoverySource().getType() == RecoverySource.Type.SNAPSHOT) : "Expecting a recovery source of type [SNAPSHOT] but got [" + String.valueOf(shardRouting.recoverySource().getType()) + "]";
            throw new UnsupportedOperationException();
        }
    };
    protected static Set<DiscoveryNodeRole> CLUSTER_MANAGER_DATA_ROLES = Collections.unmodifiableSet(new HashSet<DiscoveryNodeRole>(Arrays.asList(DiscoveryNodeRole.CLUSTER_MANAGER_ROLE, DiscoveryNodeRole.DATA_ROLE)));
    protected static Set<DiscoveryNodeRole> SEARCH_ROLE = Collections.unmodifiableSet(new HashSet<DiscoveryNodeRole>(Arrays.asList(DiscoveryNodeRole.SEARCH_ROLE, DiscoveryNodeRole.SEARCH_ROLE)));

    public static MockAllocationService createAllocationService() {
        return OpenSearchAllocationTestCase.createAllocationService(Settings.Builder.EMPTY_SETTINGS);
    }

    public static MockAllocationService createAllocationService(Settings settings) {
        return OpenSearchAllocationTestCase.createAllocationService(settings, OpenSearchAllocationTestCase.random());
    }

    public static MockAllocationService createAllocationService(Settings settings, Random random) {
        return OpenSearchAllocationTestCase.createAllocationService(settings, EMPTY_CLUSTER_SETTINGS, random);
    }

    public static MockAllocationService createAllocationService(Settings settings, ClusterSettings clusterSettings, Random random) {
        return new MockAllocationService(OpenSearchAllocationTestCase.randomAllocationDeciders(settings, clusterSettings, random), new TestGatewayAllocator(), (ShardsAllocator)new BalancedShardsAllocator(settings), (ClusterInfoService)EmptyClusterInfoService.INSTANCE, SNAPSHOT_INFO_SERVICE_WITH_NO_SHARD_SIZES);
    }

    public static MockAllocationService createAllocationService(Settings settings, ClusterInfoService clusterInfoService) {
        return new MockAllocationService(OpenSearchAllocationTestCase.randomAllocationDeciders(settings, EMPTY_CLUSTER_SETTINGS, OpenSearchAllocationTestCase.random()), new TestGatewayAllocator(), (ShardsAllocator)new BalancedShardsAllocator(settings), clusterInfoService, SNAPSHOT_INFO_SERVICE_WITH_NO_SHARD_SIZES);
    }

    public static MockAllocationService createAllocationService(Settings settings, GatewayAllocator gatewayAllocator) {
        return OpenSearchAllocationTestCase.createAllocationService(settings, gatewayAllocator, SNAPSHOT_INFO_SERVICE_WITH_NO_SHARD_SIZES);
    }

    public static MockAllocationService createAllocationService(Settings settings, SnapshotsInfoService snapshotsInfoService) {
        return OpenSearchAllocationTestCase.createAllocationService(settings, new TestGatewayAllocator(), snapshotsInfoService);
    }

    public static MockAllocationService createAllocationService(Settings settings, GatewayAllocator gatewayAllocator, SnapshotsInfoService snapshotsInfoService) {
        return new MockAllocationService(OpenSearchAllocationTestCase.randomAllocationDeciders(settings, EMPTY_CLUSTER_SETTINGS, OpenSearchAllocationTestCase.random()), gatewayAllocator, (ShardsAllocator)new BalancedShardsAllocator(settings), (ClusterInfoService)EmptyClusterInfoService.INSTANCE, snapshotsInfoService);
    }

    public static AllocationDeciders randomAllocationDeciders(Settings settings, ClusterSettings clusterSettings, Random random) {
        ArrayList deciders = new ArrayList(ClusterModule.createAllocationDeciders((Settings)settings, (ClusterSettings)clusterSettings, Collections.emptyList()));
        Collections.shuffle(deciders, random);
        return new AllocationDeciders(deciders);
    }

    protected static DiscoveryNode newNode(String nodeId) {
        return OpenSearchAllocationTestCase.newNode(nodeId, Version.CURRENT);
    }

    protected static DiscoveryNode newSearchNode(String nodeId) {
        return OpenSearchAllocationTestCase.newSearchNode(nodeId, Version.CURRENT);
    }

    protected static DiscoveryNode newSearchNode(String nodeId, Version version) {
        return new DiscoveryNode(nodeId, OpenSearchAllocationTestCase.buildNewFakeTransportAddress(), Collections.emptyMap(), SEARCH_ROLE, version);
    }

    protected static DiscoveryNode newSearchNode(String nodeId, Map<String, String> attributes) {
        return new DiscoveryNode(nodeId, OpenSearchAllocationTestCase.buildNewFakeTransportAddress(), attributes, SEARCH_ROLE, Version.CURRENT);
    }

    protected static DiscoveryNode newSearchNode(String nodeName, String nodeId, Map<String, String> attributes) {
        return new DiscoveryNode(nodeName, nodeId, OpenSearchAllocationTestCase.buildNewFakeTransportAddress(), attributes, SEARCH_ROLE, Version.CURRENT);
    }

    protected static DiscoveryNode newNode(String nodeName, String nodeId, Map<String, String> attributes) {
        return new DiscoveryNode(nodeName, nodeId, OpenSearchAllocationTestCase.buildNewFakeTransportAddress(), attributes, CLUSTER_MANAGER_DATA_ROLES, Version.CURRENT);
    }

    protected static DiscoveryNode newNode(String nodeId, Map<String, String> attributes) {
        return new DiscoveryNode(nodeId, OpenSearchAllocationTestCase.buildNewFakeTransportAddress(), attributes, CLUSTER_MANAGER_DATA_ROLES, Version.CURRENT);
    }

    protected static DiscoveryNode newNode(String nodeId, Set<DiscoveryNodeRole> roles) {
        return new DiscoveryNode(nodeId, OpenSearchAllocationTestCase.buildNewFakeTransportAddress(), Collections.emptyMap(), roles, Version.CURRENT);
    }

    protected static DiscoveryNode newNode(String nodeName, String nodeId, Set<DiscoveryNodeRole> roles) {
        return new DiscoveryNode(nodeName, nodeId, OpenSearchAllocationTestCase.buildNewFakeTransportAddress(), Collections.emptyMap(), roles, Version.CURRENT);
    }

    protected static DiscoveryNode newNode(String nodeId, Version version) {
        return new DiscoveryNode(nodeId, OpenSearchAllocationTestCase.buildNewFakeTransportAddress(), Collections.emptyMap(), CLUSTER_MANAGER_DATA_ROLES, version);
    }

    protected static ClusterState startRandomInitializingShard(ClusterState clusterState, AllocationService strategy) {
        List initializingShards = clusterState.getRoutingNodes().shardsWithState(new ShardRoutingState[]{ShardRoutingState.INITIALIZING});
        return OpenSearchAllocationTestCase.startInitialisingShardsAndReroute(strategy, clusterState, initializingShards);
    }

    protected static ClusterState startRandomInitializingShard(ClusterState clusterState, AllocationService strategy, String index) {
        List initializingShards = clusterState.getRoutingNodes().shardsWithState(index, new ShardRoutingState[]{ShardRoutingState.INITIALIZING});
        return OpenSearchAllocationTestCase.startInitialisingShardsAndReroute(strategy, clusterState, initializingShards);
    }

    private static ClusterState startInitialisingShardsAndReroute(AllocationService strategy, ClusterState clusterState, List<ShardRouting> initializingShards) {
        if (initializingShards.isEmpty()) {
            return clusterState;
        }
        return OpenSearchAllocationTestCase.startShardsAndReroute(strategy, clusterState, OpenSearchAllocationTestCase.randomFrom(initializingShards));
    }

    protected static AllocationDeciders yesAllocationDeciders() {
        return new AllocationDeciders(Arrays.asList(new AllocationDecider[]{new TestAllocateDecision(Decision.YES), new SameShardAllocationDecider(Settings.EMPTY, new ClusterSettings(Settings.EMPTY, ClusterSettings.BUILT_IN_CLUSTER_SETTINGS))}));
    }

    protected static AllocationDeciders noAllocationDeciders() {
        return new AllocationDeciders(Collections.singleton(new TestAllocateDecision(Decision.NO)));
    }

    protected static AllocationDeciders throttleAllocationDeciders() {
        return new AllocationDeciders(Arrays.asList(new AllocationDecider[]{new TestAllocateDecision(Decision.THROTTLE), new SameShardAllocationDecider(Settings.EMPTY, new ClusterSettings(Settings.EMPTY, ClusterSettings.BUILT_IN_CLUSTER_SETTINGS))}));
    }

    protected static AllocationDeciders allocationDecidersForExcludeAPI(Settings settings) {
        return new AllocationDeciders(Arrays.asList(new AllocationDecider[]{new TestAllocateDecision(Decision.YES), new SameShardAllocationDecider(settings, new ClusterSettings(settings, ClusterSettings.BUILT_IN_CLUSTER_SETTINGS)), new FilterAllocationDecider(settings, new ClusterSettings(settings, ClusterSettings.BUILT_IN_CLUSTER_SETTINGS))}));
    }

    protected ClusterState applyStartedShardsUntilNoChange(ClusterState clusterState, AllocationService service) {
        ClusterState lastClusterState;
        do {
            lastClusterState = clusterState;
            this.logger.debug("ClusterState: {}", (Object)clusterState.getRoutingNodes());
        } while (!lastClusterState.equals(clusterState = OpenSearchAllocationTestCase.startInitializingShardsAndReroute(service, clusterState)));
        return clusterState;
    }

    public static ClusterState startInitializingShardsAndReroute(AllocationService allocationService, ClusterState clusterState) {
        return OpenSearchAllocationTestCase.startShardsAndReroute(allocationService, clusterState, clusterState.routingTable().shardsWithState(ShardRoutingState.INITIALIZING));
    }

    public static ClusterState startInitializingShardsAndReroute(AllocationService allocationService, ClusterState clusterState, RoutingNode routingNode) {
        return OpenSearchAllocationTestCase.startShardsAndReroute(allocationService, clusterState, routingNode.shardsWithState(new ShardRoutingState[]{ShardRoutingState.INITIALIZING}));
    }

    public static ClusterState startInitializingShardsAndReroute(AllocationService allocationService, ClusterState clusterState, String index) {
        return OpenSearchAllocationTestCase.startShardsAndReroute(allocationService, clusterState, clusterState.routingTable().index(index).shardsWithState(ShardRoutingState.INITIALIZING));
    }

    public static ClusterState startShardsAndReroute(AllocationService allocationService, ClusterState clusterState, ShardRouting ... initializingShards) {
        return OpenSearchAllocationTestCase.startShardsAndReroute(allocationService, clusterState, Arrays.asList(initializingShards));
    }

    public static ClusterState startShardsAndReroute(AllocationService allocationService, ClusterState clusterState, List<ShardRouting> initializingShards) {
        return allocationService.reroute(allocationService.applyStartedShards(clusterState, initializingShards), "reroute after starting");
    }

    protected RoutingAllocation newRoutingAllocation(AllocationDeciders deciders, ClusterState state) {
        RoutingAllocation allocation = new RoutingAllocation(deciders, new RoutingNodes(state, false), state, ClusterInfo.EMPTY, SnapshotShardSizeInfo.EMPTY, System.nanoTime());
        allocation.debugDecision(true);
        return allocation;
    }

    protected static class MockAllocationService
    extends AllocationService {
        private volatile long nanoTimeOverride = -1L;

        public MockAllocationService(AllocationDeciders allocationDeciders, GatewayAllocator gatewayAllocator, ShardsAllocator shardsAllocator, ClusterInfoService clusterInfoService, SnapshotsInfoService snapshotsInfoService) {
            super(allocationDeciders, gatewayAllocator, shardsAllocator, clusterInfoService, snapshotsInfoService);
        }

        public void setNanoTimeOverride(long nanoTime) {
            this.nanoTimeOverride = nanoTime;
        }

        protected long currentNanoTime() {
            return this.nanoTimeOverride == -1L ? super.currentNanoTime() : this.nanoTimeOverride;
        }
    }

    public static class TestAllocateDecision
    extends AllocationDecider {
        private final Decision decision;

        public TestAllocateDecision(Decision decision) {
            this.decision = decision;
        }

        public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
            return this.decision;
        }

        public Decision canAllocate(ShardRouting shardRouting, RoutingAllocation allocation) {
            return this.decision;
        }
    }

    protected static class DelayedShardsMockGatewayAllocator
    extends GatewayAllocator {
        public void applyStartedShards(List<ShardRouting> startedShards, RoutingAllocation allocation) {
        }

        public void applyFailedShards(List<FailedShard> failedShards, RoutingAllocation allocation) {
        }

        public void beforeAllocation(RoutingAllocation allocation) {
        }

        public void afterPrimariesBeforeReplicas(RoutingAllocation allocation) {
        }

        public void allocateUnassigned(ShardRouting shardRouting, RoutingAllocation allocation, ExistingShardsAllocator.UnassignedAllocationHandler unassignedAllocationHandler) {
            if (shardRouting.primary() || shardRouting.unassignedInfo().getReason() == UnassignedInfo.Reason.INDEX_CREATED) {
                return;
            }
            if (shardRouting.unassignedInfo().isDelayed()) {
                unassignedAllocationHandler.removeAndIgnore(UnassignedInfo.AllocationStatus.DELAYED_ALLOCATION, allocation.changes());
            }
        }
    }

    public static class ShardAllocations {
        private static final String separator = "===================================================";
        private static final String ONE_LINE_RETURN = "\n";
        private static final String TWO_LINE_RETURN = "\n\n";
        static TreeMap<String, int[]> nodeToShardCountMap = new TreeMap();
        static TreeMap<String, String> nameToNodeId = new TreeMap();
        static int[] unassigned = new int[2];
        static int[] totalShards = new int[2];

        private static final String printShardAllocationWithHeader(int[] shardCount) {
            StringBuffer sb = new StringBuffer();
            Formatter formatter = new Formatter(sb, Locale.getDefault());
            formatter.format("%-20s %-20s\n", "P", shardCount[0]);
            formatter.format("%-20s %-20s\n", "R", shardCount[1]);
            return sb.toString();
        }

        private static void reset() {
            nodeToShardCountMap.clear();
            nameToNodeId.clear();
            ShardAllocations.totalShards[1] = 0;
            ShardAllocations.totalShards[0] = 0;
            ShardAllocations.unassigned[1] = 0;
            ShardAllocations.unassigned[0] = 0;
        }

        private static void buildMap(ClusterState inputState) {
            ShardAllocations.reset();
            for (RoutingNode node : inputState.getRoutingNodes()) {
                if (node.node().getName() != null && !node.node().getName().isEmpty()) {
                    nameToNodeId.putIfAbsent(node.node().getName(), node.nodeId());
                } else {
                    nameToNodeId.putIfAbsent(node.nodeId(), node.nodeId());
                }
                nodeToShardCountMap.putIfAbsent(node.nodeId(), new int[]{0, 0});
            }
            for (ShardRouting shardRouting : inputState.routingTable().allShards()) {
                ShardAllocations.updateMap(nodeToShardCountMap, shardRouting);
            }
        }

        private static void updateMap(TreeMap<String, int[]> mapToUpdate, ShardRouting shardRouting) {
            int[] shard;
            int[] nArray = shard = shardRouting.assignedToNode() ? mapToUpdate.get(shardRouting.currentNodeId()) : unassigned;
            if (shardRouting.primary()) {
                shard[0] = shard[0] + 1;
                totalShards[0] = totalShards[0] + 1;
            } else {
                shard[1] = shard[1] + 1;
                totalShards[1] = totalShards[1] + 1;
            }
            if (shardRouting.assignedToNode()) {
                mapToUpdate.put(shardRouting.currentNodeId(), shard);
            }
        }

        private static String allocation() {
            StringBuffer sb = new StringBuffer();
            sb.append("\n\n===================================================\n");
            Formatter formatter = new Formatter(sb, Locale.getDefault());
            for (Map.Entry<String, String> entry : nameToNodeId.entrySet()) {
                String nodeId = nameToNodeId.get(entry.getKey());
                formatter.format("%-20s\n", entry.getKey().toUpperCase(Locale.getDefault()));
                sb.append(ShardAllocations.printShardAllocationWithHeader(nodeToShardCountMap.get(nodeId)));
            }
            sb.append(ONE_LINE_RETURN);
            formatter.format("%-20s (P)%-5s (R)%-5s\n\n", "Unassigned ", unassigned[0], unassigned[1]);
            formatter.format("%-20s (P)%-5s (R)%-5s\n\n", "Total Shards", totalShards[0], totalShards[1]);
            return sb.toString();
        }

        public static String printShardDistribution(ClusterState state) {
            ShardAllocations.buildMap(state);
            return ShardAllocations.allocation();
        }
    }
}

