/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.shard;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.opensearch.ExceptionsHelper;
import org.opensearch.Version;
import org.opensearch.action.admin.indices.flush.FlushRequest;
import org.opensearch.action.support.PlainActionFuture;
import org.opensearch.action.support.replication.TransportReplicationAction;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.cluster.metadata.RepositoryMetadata;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.node.DiscoveryNodeRole;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.routing.IndexShardRoutingTable;
import org.opensearch.cluster.routing.RecoverySource;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.routing.ShardRoutingHelper;
import org.opensearch.cluster.routing.ShardRoutingState;
import org.opensearch.cluster.routing.TestShardRouting;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.CheckedFunction;
import org.opensearch.common.Nullable;
import org.opensearch.common.UUIDs;
import org.opensearch.common.blobstore.BlobContainer;
import org.opensearch.common.blobstore.BlobPath;
import org.opensearch.common.blobstore.BlobStore;
import org.opensearch.common.blobstore.fs.FsBlobContainer;
import org.opensearch.common.blobstore.fs.FsBlobStore;
import org.opensearch.common.concurrent.GatedCloseable;
import org.opensearch.common.io.PathUtils;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.BigArrays;
import org.opensearch.common.util.io.IOUtils;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesArray;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.core.index.Index;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.core.indices.breaker.CircuitBreakerService;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.env.Environment;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.env.ShardLock;
import org.opensearch.env.TestEnvironment;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.MapperTestUtils;
import org.opensearch.index.ReplicationStats;
import org.opensearch.index.VersionType;
import org.opensearch.index.cache.IndexCache;
import org.opensearch.index.cache.query.DisabledQueryCache;
import org.opensearch.index.cache.query.QueryCache;
import org.opensearch.index.engine.DocIdSeqNoAndSource;
import org.opensearch.index.engine.Engine;
import org.opensearch.index.engine.EngineConfigFactory;
import org.opensearch.index.engine.EngineFactory;
import org.opensearch.index.engine.EngineTestCase;
import org.opensearch.index.engine.InternalEngineFactory;
import org.opensearch.index.engine.MergedSegmentWarmerFactory;
import org.opensearch.index.engine.NRTReplicationEngineFactory;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.index.mapper.SourceToParse;
import org.opensearch.index.remote.RemoteStoreStatsTrackerFactory;
import org.opensearch.index.remote.RemoteTranslogTransferTracker;
import org.opensearch.index.replication.TestReplicationSource;
import org.opensearch.index.seqno.ReplicationTracker;
import org.opensearch.index.seqno.RetentionLeaseSyncer;
import org.opensearch.index.shard.IndexEventListener;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.shard.IndexShardState;
import org.opensearch.index.shard.IndexShardTestUtils;
import org.opensearch.index.shard.IndexingOperationListener;
import org.opensearch.index.shard.PrimaryReplicaSyncer;
import org.opensearch.index.shard.ShardPath;
import org.opensearch.index.similarity.SimilarityService;
import org.opensearch.index.snapshots.IndexShardSnapshotStatus;
import org.opensearch.index.store.RemoteBufferedOutputDirectory;
import org.opensearch.index.store.RemoteDirectory;
import org.opensearch.index.store.RemoteSegmentStoreDirectory;
import org.opensearch.index.store.Store;
import org.opensearch.index.store.StoreFileMetadata;
import org.opensearch.index.store.lockmanager.RemoteStoreLockManager;
import org.opensearch.index.store.lockmanager.RemoteStoreMetadataLockManager;
import org.opensearch.index.translog.InternalTranslogFactory;
import org.opensearch.index.translog.RemoteBlobStoreInternalTranslogFactory;
import org.opensearch.index.translog.Translog;
import org.opensearch.index.translog.TranslogFactory;
import org.opensearch.indices.DefaultRemoteStoreSettings;
import org.opensearch.indices.IndicesService;
import org.opensearch.indices.breaker.HierarchyCircuitBreakerService;
import org.opensearch.indices.recovery.AsyncRecoveryTarget;
import org.opensearch.indices.recovery.DefaultRecoverySettings;
import org.opensearch.indices.recovery.PeerRecoveryTargetService;
import org.opensearch.indices.recovery.RecoveryFailedException;
import org.opensearch.indices.recovery.RecoverySettings;
import org.opensearch.indices.recovery.RecoverySourceHandler;
import org.opensearch.indices.recovery.RecoverySourceHandlerFactory;
import org.opensearch.indices.recovery.RecoveryState;
import org.opensearch.indices.recovery.RecoveryTarget;
import org.opensearch.indices.recovery.RecoveryTargetHandler;
import org.opensearch.indices.recovery.StartRecoveryRequest;
import org.opensearch.indices.replication.AbstractSegmentReplicationTarget;
import org.opensearch.indices.replication.CheckpointInfoResponse;
import org.opensearch.indices.replication.GetSegmentFilesResponse;
import org.opensearch.indices.replication.MergedSegmentReplicationTarget;
import org.opensearch.indices.replication.SegmentReplicationSource;
import org.opensearch.indices.replication.SegmentReplicationSourceFactory;
import org.opensearch.indices.replication.SegmentReplicationState;
import org.opensearch.indices.replication.SegmentReplicationTarget;
import org.opensearch.indices.replication.SegmentReplicationTargetService;
import org.opensearch.indices.replication.checkpoint.MergedSegmentCheckpoint;
import org.opensearch.indices.replication.checkpoint.MergedSegmentPublisher;
import org.opensearch.indices.replication.checkpoint.ReferencedSegmentsPublisher;
import org.opensearch.indices.replication.checkpoint.ReplicationCheckpoint;
import org.opensearch.indices.replication.checkpoint.SegmentReplicationCheckpointPublisher;
import org.opensearch.indices.replication.common.CopyState;
import org.opensearch.indices.replication.common.ReplicationCollection;
import org.opensearch.indices.replication.common.ReplicationFailedException;
import org.opensearch.indices.replication.common.ReplicationListener;
import org.opensearch.indices.replication.common.ReplicationState;
import org.opensearch.indices.replication.common.ReplicationType;
import org.opensearch.repositories.IndexId;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.repositories.Repository;
import org.opensearch.repositories.blobstore.BlobStoreRepository;
import org.opensearch.repositories.blobstore.BlobStoreTestUtil;
import org.opensearch.repositories.blobstore.OpenSearchBlobStoreRepositoryIntegTestCase;
import org.opensearch.repositories.fs.FsRepository;
import org.opensearch.snapshots.Snapshot;
import org.opensearch.test.ClusterServiceUtils;
import org.opensearch.test.DummyShardLock;
import org.opensearch.test.OpenSearchTestCase;
import org.opensearch.threadpool.ExecutorBuilder;
import org.opensearch.threadpool.TestThreadPool;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public abstract class IndexShardTestCase
extends OpenSearchTestCase {
    public static final IndexEventListener EMPTY_EVENT_LISTENER = new IndexEventListener(){};
    private static final AtomicBoolean failOnShardFailures = new AtomicBoolean(true);
    private RecoveryTarget recoveryTarget;
    private static final Consumer<IndexShard.ShardFailure> DEFAULT_SHARD_FAILURE_HANDLER = failure -> {
        if (failOnShardFailures.get()) {
            throw new AssertionError(failure.reason, failure.cause);
        }
    };
    protected static final ReplicationListener recoveryListener = new ReplicationListener(){

        public void onDone(ReplicationState state) {
        }

        public void onFailure(ReplicationState state, ReplicationFailedException e, boolean sendShardFailure) {
            throw new AssertionError(e);
        }
    };
    protected ThreadPool threadPool;
    protected long primaryTerm;
    protected ClusterService clusterService;
    protected static AtomicLong currentClusterStateVersion = new AtomicLong();

    public void setUp() throws Exception {
        super.setUp();
        this.threadPool = this.setUpThreadPool();
        this.primaryTerm = IndexShardTestCase.randomIntBetween(1, 100);
        this.clusterService = ClusterServiceUtils.createClusterService(this.threadPool);
        this.failOnShardFailures();
    }

    protected ThreadPool setUpThreadPool() {
        return new TestThreadPool(((Object)((Object)this)).getClass().getName(), this.threadPoolSettings(), new ExecutorBuilder[0]);
    }

    @Override
    public void tearDown() throws Exception {
        try {
            this.tearDownThreadPool();
            this.clusterService.close();
        }
        finally {
            super.tearDown();
        }
    }

    protected void tearDownThreadPool() {
        ThreadPool.terminate((ThreadPool)this.threadPool, (long)30L, (TimeUnit)TimeUnit.SECONDS);
    }

    protected void allowShardFailures() {
        failOnShardFailures.set(false);
    }

    protected void failOnShardFailures() {
        failOnShardFailures.set(true);
    }

    public Settings threadPoolSettings() {
        return Settings.EMPTY;
    }

    protected Store createStore(IndexSettings indexSettings, ShardPath shardPath) throws IOException {
        return this.createStore(shardPath.getShardId(), indexSettings, (Directory)IndexShardTestCase.newFSDirectory((Path)shardPath.resolveIndex()), shardPath);
    }

    protected Store createStore(ShardId shardId, IndexSettings indexSettings, Directory directory, ShardPath shardPath) throws IOException {
        return new Store(shardId, indexSettings, directory, (ShardLock)new DummyShardLock(shardId), Store.OnClose.EMPTY, shardPath);
    }

    protected Releasable acquirePrimaryOperationPermitBlockingly(IndexShard indexShard) throws ExecutionException, InterruptedException {
        PlainActionFuture fut = new PlainActionFuture();
        indexShard.acquirePrimaryOperationPermit((ActionListener)fut, "write", (Object)"");
        return (Releasable)fut.get();
    }

    protected IndexShard newShard(boolean primary) throws IOException {
        return this.newShard(primary, Settings.EMPTY);
    }

    protected IndexShard newShard(boolean primary, Settings settings) throws IOException {
        return this.newShard(primary, settings, (EngineFactory)new InternalEngineFactory());
    }

    protected IndexShard newShard(boolean primary, Settings settings, EngineFactory engineFactory) throws IOException {
        RecoverySource.EmptyStoreRecoverySource recoverySource = primary ? RecoverySource.EmptyStoreRecoverySource.INSTANCE : RecoverySource.PeerRecoverySource.INSTANCE;
        ShardRouting shardRouting = TestShardRouting.newShardRouting(new ShardId("index", "_na_", 0), IndexShardTestCase.randomAlphaOfLength(10), primary, ShardRoutingState.INITIALIZING, (RecoverySource)recoverySource);
        return this.newShard(shardRouting, settings, engineFactory, new IndexingOperationListener[0]);
    }

    protected IndexShard newShard(ShardRouting shardRouting, IndexingOperationListener ... listeners) throws IOException {
        return this.newShard(shardRouting, Settings.EMPTY, listeners);
    }

    protected IndexShard newShard(ShardRouting shardRouting, Settings settings, IndexingOperationListener ... listeners) throws IOException {
        return this.newShard(shardRouting, settings, (EngineFactory)new InternalEngineFactory(), listeners);
    }

    protected IndexShard newShard(ShardRouting shardRouting, Settings settings, EngineFactory engineFactory, IndexingOperationListener ... listeners) throws IOException {
        assert (shardRouting.initializing()) : shardRouting;
        Settings indexSettings = Settings.builder().put("index.version.created", Version.CURRENT).put("index.number_of_replicas", 0).put("index.number_of_shards", 1).put(IndexSettings.INDEX_SOFT_DELETES_RETENTION_OPERATIONS_SETTING.getKey(), IndexShardTestCase.between(0, 1000)).put(settings).build();
        IndexMetadata.Builder metadata = IndexMetadata.builder((String)shardRouting.getIndexName()).settings(indexSettings).primaryTerm(0, this.primaryTerm).putMapping("{ \"properties\": {} }");
        return this.newShard(shardRouting, metadata.build(), null, engineFactory, () -> {}, RetentionLeaseSyncer.EMPTY, null, listeners);
    }

    protected IndexShard newShard(ShardId shardId, boolean primary, IndexingOperationListener ... listeners) throws IOException {
        ShardRouting shardRouting = TestShardRouting.newShardRouting(shardId, IndexShardTestCase.randomAlphaOfLength(5), primary, ShardRoutingState.INITIALIZING, (RecoverySource)(primary ? RecoverySource.EmptyStoreRecoverySource.INSTANCE : RecoverySource.PeerRecoverySource.INSTANCE));
        return this.newShard(shardRouting, Settings.EMPTY, (EngineFactory)new InternalEngineFactory(), listeners);
    }

    protected IndexShard newShard(ShardId shardId, boolean primary, String nodeId, IndexMetadata indexMetadata, @Nullable CheckedFunction<DirectoryReader, DirectoryReader, IOException> readerWrapper) throws IOException {
        return this.newShard(shardId, primary, nodeId, indexMetadata, readerWrapper, () -> {});
    }

    protected IndexShard newShard(ShardId shardId, boolean primary, String nodeId, IndexMetadata indexMetadata, @Nullable CheckedFunction<DirectoryReader, DirectoryReader, IOException> readerWrapper, Runnable globalCheckpointSyncer) throws IOException {
        ShardRouting shardRouting = TestShardRouting.newShardRouting(shardId, nodeId, primary, ShardRoutingState.INITIALIZING, (RecoverySource)(primary ? RecoverySource.EmptyStoreRecoverySource.INSTANCE : RecoverySource.PeerRecoverySource.INSTANCE));
        return this.newShard(shardRouting, indexMetadata, readerWrapper, (EngineFactory)new InternalEngineFactory(), globalCheckpointSyncer, RetentionLeaseSyncer.EMPTY, null, new IndexingOperationListener[0]);
    }

    protected IndexShard newShard(ShardRouting routing, IndexMetadata indexMetadata, @Nullable CheckedFunction<DirectoryReader, DirectoryReader, IOException> indexReaderWrapper, EngineFactory engineFactory, IndexingOperationListener ... listeners) throws IOException {
        return this.newShard(routing, indexMetadata, indexReaderWrapper, engineFactory, () -> {}, RetentionLeaseSyncer.EMPTY, null, listeners);
    }

    protected IndexShard newShard(ShardRouting routing, IndexMetadata indexMetadata, @Nullable CheckedFunction<DirectoryReader, DirectoryReader, IOException> indexReaderWrapper, @Nullable EngineFactory engineFactory, Runnable globalCheckpointSyncer, RetentionLeaseSyncer retentionLeaseSyncer, Path path, IndexingOperationListener ... listeners) throws IOException {
        ShardId shardId = routing.shardId();
        NodeEnvironment.NodePath nodePath = new NodeEnvironment.NodePath(IndexShardTestCase.createTempDir());
        ShardPath shardPath = new ShardPath(false, nodePath.resolve(shardId), nodePath.resolve(shardId), shardId);
        return this.newShard(routing, shardPath, indexMetadata, null, indexReaderWrapper, engineFactory, new EngineConfigFactory(new IndexSettings(indexMetadata, indexMetadata.getSettings())), globalCheckpointSyncer, retentionLeaseSyncer, EMPTY_EVENT_LISTENER, path, listeners);
    }

    protected IndexShard newShard(ShardRouting routing, ShardPath shardPath, IndexMetadata indexMetadata, @Nullable CheckedFunction<IndexSettings, Store, IOException> storeProvider, @Nullable CheckedFunction<DirectoryReader, DirectoryReader, IOException> indexReaderWrapper, @Nullable EngineFactory engineFactory, @Nullable EngineConfigFactory engineConfigFactory, Runnable globalCheckpointSyncer, RetentionLeaseSyncer retentionLeaseSyncer, IndexEventListener indexEventListener, Path remotePath, IndexingOperationListener ... listeners) throws IOException {
        return this.newShard(routing, shardPath, indexMetadata, storeProvider, indexReaderWrapper, engineFactory, engineConfigFactory, globalCheckpointSyncer, retentionLeaseSyncer, indexEventListener, SegmentReplicationCheckpointPublisher.EMPTY, remotePath, listeners);
    }

    protected IndexShard newShard(boolean primary, SegmentReplicationCheckpointPublisher checkpointPublisher) throws IOException {
        Settings settings = Settings.builder().put("index.replication.type", (Enum)ReplicationType.SEGMENT).build();
        return this.newShard(primary, checkpointPublisher, settings);
    }

    protected IndexShard newShard(boolean primary, SegmentReplicationCheckpointPublisher checkpointPublisher, Settings settings) throws IOException {
        ShardId shardId = new ShardId("index", "_na_", 0);
        ShardRouting shardRouting = TestShardRouting.newShardRouting(shardId, IndexShardTestCase.randomAlphaOfLength(10), primary, ShardRoutingState.INITIALIZING, (RecoverySource)(primary ? RecoverySource.EmptyStoreRecoverySource.INSTANCE : RecoverySource.PeerRecoverySource.INSTANCE));
        NodeEnvironment.NodePath nodePath = new NodeEnvironment.NodePath(IndexShardTestCase.createTempDir());
        ShardPath shardPath = new ShardPath(false, nodePath.resolve(shardId), nodePath.resolve(shardId), shardId);
        Settings indexSettings = Settings.builder().put(settings).put("index.version.created", Version.CURRENT).put("index.number_of_replicas", 0).put("index.number_of_shards", 1).put(IndexSettings.INDEX_SOFT_DELETES_RETENTION_OPERATIONS_SETTING.getKey(), IndexShardTestCase.between(0, 1000)).put(Settings.EMPTY).build();
        IndexMetadata metadata = IndexMetadata.builder((String)shardRouting.getIndexName()).settings(indexSettings).primaryTerm(0, this.primaryTerm).putMapping("{ \"properties\": {} }").build();
        return this.newShard(shardRouting, shardPath, metadata, null, null, (EngineFactory)new NRTReplicationEngineFactory(), new EngineConfigFactory(new IndexSettings(metadata, metadata.getSettings())), () -> {}, RetentionLeaseSyncer.EMPTY, EMPTY_EVENT_LISTENER, checkpointPublisher, null, new IndexingOperationListener[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IndexShard newShard(ShardRouting routing, ShardPath shardPath, IndexMetadata indexMetadata, @Nullable CheckedFunction<IndexSettings, Store, IOException> storeProvider, @Nullable CheckedFunction<DirectoryReader, DirectoryReader, IOException> indexReaderWrapper, @Nullable EngineFactory engineFactory, @Nullable EngineConfigFactory engineConfigFactory, Runnable globalCheckpointSyncer, RetentionLeaseSyncer retentionLeaseSyncer, IndexEventListener indexEventListener, SegmentReplicationCheckpointPublisher checkpointPublisher, @Nullable Path remotePath, IndexingOperationListener ... listeners) throws IOException {
        IndexShard indexShard;
        Settings nodeSettings = Settings.builder().put("node.name", routing.currentNodeId()).build();
        DiscoveryNodes discoveryNodes = IndexShardTestUtils.getFakeDiscoveryNodes(routing);
        if (indexMetadata.getSettings().get("index.remote_store.enabled") == "true") {
            nodeSettings = Settings.builder().put("node.name", routing.currentNodeId()).put("node.attr.remote_store.translog.repository", "seg_repo").build();
            discoveryNodes = DiscoveryNodes.builder().add(IndexShardTestUtils.getFakeRemoteEnabledNode(routing.currentNodeId())).build();
        }
        IndexSettings indexSettings = new IndexSettings(indexMetadata, nodeSettings);
        if (storeProvider == null) {
            storeProvider = is -> this.createStore((IndexSettings)is, shardPath);
        }
        Store store = (Store)storeProvider.apply((Object)indexSettings);
        boolean success = false;
        try {
            Store remoteStore;
            IndexCache indexCache = new IndexCache(indexSettings, (QueryCache)new DisabledQueryCache(indexSettings), null);
            MapperService mapperService = MapperTestUtils.newMapperService(this.xContentRegistry(), IndexShardTestCase.createTempDir(), indexSettings.getSettings(), "index");
            mapperService.merge(indexMetadata, MapperService.MergeReason.MAPPING_RECOVERY);
            SimilarityService similarityService = new SimilarityService(indexSettings, null, Collections.emptyMap());
            Engine.Warmer warmer = IndexShardTestCase.createTestWarmer(indexSettings);
            ClusterSettings clusterSettings = new ClusterSettings(nodeSettings, ClusterSettings.BUILT_IN_CLUSTER_SETTINGS);
            HierarchyCircuitBreakerService breakerService = new HierarchyCircuitBreakerService(nodeSettings, Collections.emptyList(), clusterSettings);
            RemoteStoreStatsTrackerFactory remoteStoreStatsTrackerFactory = null;
            RepositoriesService mockRepoSvc = (RepositoriesService)Mockito.mock(RepositoriesService.class);
            if (indexSettings.isRemoteStoreEnabled() || indexSettings.isAssignedOnRemoteNode()) {
                String remoteStoreRepository = indexSettings.getRemoteStoreRepository();
                if (remoteStoreRepository != null && remoteStoreRepository.endsWith("__test")) {
                    remotePath = PathUtils.get((String)remoteStoreRepository.replace("__test", ""), (String[])new String[0]);
                } else if (remotePath == null) {
                    remotePath = IndexShardTestCase.createTempDir();
                }
                remoteStore = this.createRemoteStore(remotePath, routing, indexMetadata, shardPath);
                remoteStoreStatsTrackerFactory = new RemoteStoreStatsTrackerFactory(this.clusterService, indexSettings.getSettings());
                BlobStoreRepository repo = this.createRepository(remotePath);
                Mockito.when((Object)mockRepoSvc.repository((String)ArgumentMatchers.any())).thenAnswer(invocationOnMock -> repo);
            } else {
                remoteStore = null;
            }
            BiFunction<IndexSettings, ShardRouting, TranslogFactory> translogFactorySupplier = (settings, shardRouting) -> {
                if (settings.isRemoteTranslogStoreEnabled() && shardRouting.primary()) {
                    return new RemoteBlobStoreInternalTranslogFactory(() -> mockRepoSvc, this.threadPool, settings.getRemoteStoreTranslogRepository(), new RemoteTranslogTransferTracker(shardRouting.shardId(), 20), DefaultRemoteStoreSettings.INSTANCE);
                }
                return new InternalTranslogFactory();
            };
            Function mockReplicationStatsProvider = (Function)Mockito.mock(Function.class);
            Mockito.when((Object)((ReplicationStats)mockReplicationStatsProvider.apply((ShardId)ArgumentMatchers.any()))).thenReturn((Object)new ReplicationStats(800L, 800L, 500L));
            indexShard = new IndexShard(routing, indexSettings, shardPath, store, () -> null, indexCache, mapperService, similarityService, engineFactory, engineConfigFactory, indexEventListener, indexReaderWrapper, this.threadPool, BigArrays.NON_RECYCLING_INSTANCE, warmer, Collections.emptyList(), Arrays.asList(listeners), globalCheckpointSyncer, retentionLeaseSyncer, (CircuitBreakerService)breakerService, translogFactorySupplier, checkpointPublisher, remoteStore, remoteStoreStatsTrackerFactory, "dummy-node", DefaultRecoverySettings.INSTANCE, DefaultRemoteStoreSettings.INSTANCE, false, discoveryNodes, mockReplicationStatsProvider, new MergedSegmentWarmerFactory(null, new RecoverySettings(nodeSettings, clusterSettings), null), false, () -> Boolean.FALSE, () -> ((IndexSettings)indexSettings).getRefreshInterval(), new Object(), this.clusterService.getClusterApplierService(), MergedSegmentPublisher.EMPTY, ReferencedSegmentsPublisher.EMPTY);
            indexShard.addShardFailureCallback(DEFAULT_SHARD_FAILURE_HANDLER);
            if (remoteStoreStatsTrackerFactory != null) {
                remoteStoreStatsTrackerFactory.afterIndexShardCreated(indexShard);
            }
            success = true;
        }
        finally {
            if (!success) {
                IOUtils.close((Closeable)store);
            }
        }
        return indexShard;
    }

    private BlobStoreRepository createRepository(Path path) {
        Settings settings = Settings.builder().put("location", path).build();
        RepositoryMetadata repositoryMetadata = new RepositoryMetadata(IndexShardTestCase.randomAlphaOfLength(10), "fs", settings);
        ClusterService clusterService = BlobStoreTestUtil.mockClusterService(repositoryMetadata);
        FsRepository repository = new FsRepository(this, repositoryMetadata, this.createEnvironment(path), this.xContentRegistry(), clusterService, new RecoverySettings(Settings.EMPTY, new ClusterSettings(Settings.EMPTY, ClusterSettings.BUILT_IN_CLUSTER_SETTINGS))){

            protected void assertSnapshotOrGenericThread() {
            }
        };
        clusterService.addStateApplier(event -> repository.updateState(event.state()));
        repository.updateState(clusterService.state());
        repository.start();
        return repository;
    }

    private Environment createEnvironment(Path path) {
        Path home = IndexShardTestCase.createTempDir();
        return TestEnvironment.newEnvironment(Settings.builder().put(Environment.PATH_HOME_SETTING.getKey(), home.toAbsolutePath()).put(Environment.PATH_REPO_SETTING.getKey(), path.toAbsolutePath()).build());
    }

    protected RepositoriesService createRepositoriesService() {
        RepositoriesService repositoriesService = (RepositoriesService)Mockito.mock(RepositoriesService.class);
        BlobStoreRepository repository = (BlobStoreRepository)Mockito.mock(BlobStoreRepository.class);
        Mockito.when((Object)repository.basePath()).thenReturn((Object)new BlobPath());
        BlobStore blobStore = (BlobStore)Mockito.mock(BlobStore.class);
        BlobContainer blobContainer = (BlobContainer)Mockito.mock(BlobContainer.class);
        ((BlobContainer)Mockito.doAnswer(invocation -> {
            ActionListener listener = (ActionListener)invocation.getArgument(3);
            listener.onResponse(new ArrayList());
            return null;
        }).when((Object)blobContainer)).listBlobsByPrefixInSortedOrder((String)ArgumentMatchers.any(String.class), ArgumentMatchers.anyInt(), (BlobContainer.BlobNameSortOrder)ArgumentMatchers.any(BlobContainer.BlobNameSortOrder.class), (ActionListener)ArgumentMatchers.any(ActionListener.class));
        Mockito.when((Object)blobStore.blobContainer((BlobPath)ArgumentMatchers.any())).thenReturn((Object)blobContainer);
        Mockito.when((Object)repository.blobStore()).thenReturn((Object)blobStore);
        Mockito.when((Object)repositoriesService.repository((String)ArgumentMatchers.any(String.class))).thenReturn((Object)repository);
        return repositoriesService;
    }

    protected Store createRemoteStore(Path path, ShardRouting shardRouting, IndexMetadata metadata, ShardPath shardPath) throws IOException {
        Settings nodeSettings = Settings.builder().put("node.name", shardRouting.currentNodeId()).build();
        ShardId shardId = shardRouting.shardId();
        RemoteSegmentStoreDirectory remoteSegmentStoreDirectory = this.createRemoteSegmentStoreDirectory(shardId, path);
        return this.createStore(shardId, new IndexSettings(metadata, nodeSettings), (Directory)remoteSegmentStoreDirectory, shardPath);
    }

    protected RemoteSegmentStoreDirectory createRemoteSegmentStoreDirectory(ShardId shardId, Path path) throws IOException {
        NodeEnvironment.NodePath remoteNodePath = new NodeEnvironment.NodePath(path);
        ShardPath remoteShardPath = new ShardPath(false, remoteNodePath.resolve(shardId), remoteNodePath.resolve(shardId), shardId);
        RemoteDirectory dataDirectory = this.newRemoteDirectory(remoteShardPath.resolveIndex().resolve("data"));
        RemoteDirectory metadataDirectory = this.newRemoteDirectory(remoteShardPath.resolveIndex().resolve("metadata"));
        RemoteStoreMetadataLockManager remoteStoreLockManager = new RemoteStoreMetadataLockManager(new RemoteBufferedOutputDirectory(this.getBlobContainer(remoteShardPath.resolveIndex().resolve("lock_files"))));
        return new RemoteSegmentStoreDirectory(dataDirectory, metadataDirectory, (RemoteStoreLockManager)remoteStoreLockManager, this.threadPool, shardId, new HashMap());
    }

    private RemoteDirectory newRemoteDirectory(Path f) throws IOException {
        return new RemoteDirectory(this.getBlobContainer(f));
    }

    protected BlobContainer getBlobContainer(Path f) throws IOException {
        FsBlobStore fsBlobStore = new FsBlobStore(1024, f, false);
        BlobPath blobPath = new BlobPath();
        return new FsBlobContainer(fsBlobStore, blobPath, f);
    }

    protected IndexShard reinitShard(IndexShard current, IndexingOperationListener ... listeners) throws IOException {
        return this.reinitShard(current, (Path)null, listeners);
    }

    protected IndexShard reinitShard(IndexShard current, Path remotePath, IndexingOperationListener ... listeners) throws IOException {
        ShardRouting shardRouting;
        return this.reinitShard(current, ShardRoutingHelper.initWithSameId(shardRouting, (RecoverySource)((shardRouting = current.routingEntry()).primary() ? RecoverySource.ExistingStoreRecoverySource.INSTANCE : RecoverySource.PeerRecoverySource.INSTANCE)), remotePath, listeners);
    }

    protected IndexShard reinitShard(IndexShard current, ShardRouting routing, IndexingOperationListener ... listeners) throws IOException {
        return this.reinitShard(current, routing, (Path)null, listeners);
    }

    protected IndexShard reinitShard(IndexShard current, ShardRouting routing, Path remotePath, IndexingOperationListener ... listeners) throws IOException {
        return this.reinitShard(current, routing, current.indexSettings.getIndexMetadata(), current.engineFactory, current.engineConfigFactory, remotePath, listeners);
    }

    protected IndexShard reinitShard(IndexShard current, ShardRouting routing, IndexMetadata indexMetadata, EngineFactory engineFactory, EngineConfigFactory engineConfigFactory, Path remotePath, IndexingOperationListener ... listeners) throws IOException {
        this.closeShards(current);
        return this.newShard(routing, current.shardPath(), indexMetadata, null, null, engineFactory, engineConfigFactory, current.getGlobalCheckpointSyncer(), current.getRetentionLeaseSyncer(), EMPTY_EVENT_LISTENER, remotePath, listeners);
    }

    protected IndexShard newStartedShard() throws IOException {
        return this.newStartedShard(IndexShardTestCase.randomBoolean());
    }

    protected IndexShard newStartedShard(Settings settings) throws IOException {
        return this.newStartedShard(IndexShardTestCase.randomBoolean(), settings, (EngineFactory)new InternalEngineFactory());
    }

    protected IndexShard newStartedShard(boolean primary) throws IOException {
        return this.newStartedShard(primary, Settings.EMPTY, (EngineFactory)new InternalEngineFactory());
    }

    protected IndexShard newStartedShard(boolean primary, Settings settings) throws IOException {
        return this.newStartedShard(primary, settings, (EngineFactory)new InternalEngineFactory());
    }

    protected IndexShard newStartedShard(boolean primary, Settings settings, EngineFactory engineFactory) throws IOException {
        return this.newStartedShard((CheckedFunction<Boolean, IndexShard, IOException>)((CheckedFunction)p -> this.newShard((boolean)p, settings, engineFactory)), primary);
    }

    protected IndexShard newStartedShard(CheckedFunction<Boolean, IndexShard, IOException> shardFunction, boolean primary) throws IOException {
        IndexShard shard = (IndexShard)shardFunction.apply((Object)primary);
        if (primary) {
            this.recoverShardFromStore(shard);
            IndexShardTestCase.assertThat((Object)shard.getMaxSeqNoOfUpdatesOrDeletes(), (Matcher)Matchers.equalTo((Object)shard.seqNoStats().getMaxSeqNo()));
        } else {
            this.recoveryEmptyReplica(shard, true);
        }
        return shard;
    }

    protected void closeShards(IndexShard ... shards) throws IOException {
        this.closeShards(Arrays.asList(shards));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeShard(IndexShard shard, boolean assertConsistencyBetweenTranslogAndLucene) throws IOException {
        try {
            Engine engine;
            if (assertConsistencyBetweenTranslogAndLucene) {
                IndexShardTestCase.assertConsistentHistoryBetweenTranslogAndLucene(shard);
            }
            if ((engine = shard.getEngineOrNull()) != null) {
                EngineTestCase.assertAtMostOneLuceneDocumentPerSequenceNumber(engine);
            }
        }
        catch (Throwable throwable) {
            IOUtils.close((Closeable[])new Closeable[]{() -> shard.close("test", false, false), shard.store()});
            throw throwable;
        }
        IOUtils.close((Closeable[])new Closeable[]{() -> shard.close("test", false, false), shard.store()});
    }

    protected void closeShards(Iterable<IndexShard> shards) throws IOException {
        for (IndexShard shard : shards) {
            if (shard == null) continue;
            this.closeShard(shard, true);
        }
    }

    protected void recoverShardFromStore(IndexShard primary) throws IOException {
        primary.markAsRecovering("store", new RecoveryState(primary.routingEntry(), IndexShardTestUtils.getFakeDiscoNode(primary.routingEntry().currentNodeId()), null));
        IndexShardTestCase.recoverFromStore(primary);
        IndexShardTestCase.updateRoutingEntry(primary, ShardRoutingHelper.moveToStarted(primary.routingEntry()));
    }

    public static void updateRoutingEntry(IndexShard shard, ShardRouting shardRouting) throws IOException {
        Set inSyncIds = shardRouting.active() ? Collections.singleton(shardRouting.allocationId().getId()) : Collections.emptySet();
        IndexShardRoutingTable newRoutingTable = new IndexShardRoutingTable.Builder(shardRouting.shardId()).addShard(shardRouting).build();
        shard.updateShardState(shardRouting, shard.getPendingPrimaryTerm(), null, currentClusterStateVersion.incrementAndGet(), inSyncIds, newRoutingTable, DiscoveryNodes.builder().add(new DiscoveryNode(shardRouting.currentNodeId(), shardRouting.currentNodeId(), IndexShardTestCase.buildNewFakeTransportAddress(), Collections.emptyMap(), (Set)DiscoveryNodeRole.BUILT_IN_ROLES, Version.CURRENT)).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recoveryEmptyReplica(IndexShard replica, boolean startReplica) throws IOException {
        IndexShard primary = null;
        try {
            primary = this.newStartedShard(true, replica.indexSettings.getSettings());
            this.recoverReplica(replica, primary, startReplica);
        }
        catch (Throwable throwable) {
            this.closeShards(primary);
            throw throwable;
        }
        this.closeShards(primary);
    }

    protected void recoverReplica(IndexShard replica, IndexShard primary, boolean startReplica) throws IOException {
        this.recoverReplica(replica, primary, startReplica, this.getReplicationFunc(replica));
    }

    protected void recoverReplica(IndexShard replica, IndexShard primary, boolean startReplica, Function<List<IndexShard>, List<SegmentReplicationTarget>> replicatePrimaryFunction) throws IOException {
        this.recoverReplica(replica, primary, (r, sourceNode) -> new RecoveryTarget(r, sourceNode, recoveryListener, this.threadPool), true, startReplica, replicatePrimaryFunction);
    }

    protected void recoverReplica(IndexShard replica, IndexShard primary, BiFunction<IndexShard, DiscoveryNode, RecoveryTarget> targetSupplier, boolean markAsRecovering, boolean markAsStarted) throws IOException {
        this.recoverReplica(replica, primary, targetSupplier, markAsRecovering, markAsStarted, a -> null);
    }

    public Function<List<IndexShard>, List<SegmentReplicationTarget>> getReplicationFunc(IndexShard target) {
        return target.indexSettings().isSegRepEnabledOrRemoteNode() ? shardList -> {
            try {
                assert (shardList.size() >= 2);
                IndexShard primary = (IndexShard)shardList.get(0);
                return this.replicateSegments(primary, shardList.subList(1, shardList.size()));
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException(e);
            }
        } : a -> null;
    }

    protected void recoverReplica(IndexShard replica, IndexShard primary, BiFunction<IndexShard, DiscoveryNode, RecoveryTarget> targetSupplier, boolean markAsRecovering, boolean markAsStarted, Function<List<IndexShard>, List<SegmentReplicationTarget>> replicatePrimaryFunction) throws IOException {
        IndexShardRoutingTable.Builder newRoutingTable = new IndexShardRoutingTable.Builder(replica.shardId());
        newRoutingTable.addShard(primary.routingEntry());
        if (!replica.routingEntry().isRelocationTarget()) {
            newRoutingTable.addShard(replica.routingEntry());
        }
        Set<String> inSyncIds = Collections.singleton(primary.routingEntry().allocationId().getId());
        IndexShardRoutingTable routingTable = newRoutingTable.build();
        this.recoverUnstartedReplica(replica, primary, targetSupplier, markAsRecovering, inSyncIds, routingTable, replicatePrimaryFunction);
        if (markAsStarted) {
            this.startReplicaAfterRecovery(replica, primary, inSyncIds, routingTable);
        }
    }

    public final void recoverUnstartedReplica(IndexShard replica, IndexShard primary, BiFunction<IndexShard, DiscoveryNode, RecoveryTarget> targetSupplier, boolean markAsRecovering, Set<String> inSyncIds, IndexShardRoutingTable routingTable, Function<List<IndexShard>, List<SegmentReplicationTarget>> replicatePrimaryFunction) throws IOException {
        DiscoveryNode pNode = primary.isRemoteTranslogEnabled() ? IndexShardTestUtils.getFakeRemoteEnabledNode(primary.routingEntry().currentNodeId()) : IndexShardTestUtils.getFakeDiscoNode(primary.routingEntry().currentNodeId());
        DiscoveryNode rNode = replica.isRemoteTranslogEnabled() ? IndexShardTestUtils.getFakeRemoteEnabledNode(replica.routingEntry().currentNodeId()) : IndexShardTestUtils.getFakeDiscoNode(replica.routingEntry().currentNodeId());
        if (markAsRecovering) {
            replica.markAsRecovering("remote", new RecoveryState(replica.routingEntry(), pNode, rNode));
        } else {
            IndexShardTestCase.assertEquals((Object)replica.state(), (Object)IndexShardState.RECOVERING);
        }
        replica.prepareForIndexRecovery();
        RecoveryTarget recoveryTarget = targetSupplier.apply(replica, pNode);
        IndexShard indexShard = recoveryTarget.indexShard();
        boolean remoteTranslogEnabled = !recoveryTarget.state().getPrimary() && indexShard.isRemoteTranslogEnabled();
        long startingSeqNo = indexShard.recoverLocallyAndFetchStartSeqNo(!remoteTranslogEnabled);
        StartRecoveryRequest request = PeerRecoveryTargetService.getStartRecoveryRequest((Logger)this.logger, (DiscoveryNode)rNode, (RecoveryTarget)recoveryTarget, (long)startingSeqNo);
        long fileChunkSizeInBytes = IndexShardTestCase.randomBoolean() ? ((ByteSizeValue)RecoverySettings.INDICES_RECOVERY_CHUNK_SIZE_SETTING.getDefault(Settings.EMPTY)).getBytes() : (long)IndexShardTestCase.randomIntBetween(1, 0xA00000);
        Settings settings = Settings.builder().put("indices.recovery.max_concurrent_file_chunks", Integer.toString(IndexShardTestCase.between(1, 4))).put("indices.recovery.max_concurrent_operations", Integer.toString(IndexShardTestCase.between(1, 4))).build();
        RecoverySettings recoverySettings = new RecoverySettings(settings, new ClusterSettings(Settings.EMPTY, ClusterSettings.BUILT_IN_CLUSTER_SETTINGS));
        recoverySettings.setChunkSize(new ByteSizeValue(fileChunkSizeInBytes));
        RecoverySourceHandler recovery = RecoverySourceHandlerFactory.create((IndexShard)primary, (RecoveryTargetHandler)new AsyncRecoveryTarget((RecoveryTargetHandler)recoveryTarget, this.threadPool.generic(), primary, replica, replicatePrimaryFunction), (StartRecoveryRequest)request, (RecoverySettings)recoverySettings);
        primary.updateShardState(primary.routingEntry(), primary.getPendingPrimaryTerm(), null, currentClusterStateVersion.incrementAndGet(), inSyncIds, routingTable, primary.isRemoteTranslogEnabled() ? IndexShardTestUtils.getFakeRemoteEnabledDiscoveryNodes(routingTable.getShards()) : IndexShardTestUtils.getFakeDiscoveryNodes(routingTable.getShards()));
        try {
            PlainActionFuture future = new PlainActionFuture();
            recovery.recoverToTarget((ActionListener)future);
            future.actionGet();
            recoveryTarget.markAsDone();
        }
        catch (Exception e) {
            recoveryTarget.fail((ReplicationFailedException)new RecoveryFailedException(request, (Throwable)e), false);
            throw e;
        }
    }

    protected void startReplicaAfterRecovery(IndexShard replica, IndexShard primary, Set<String> inSyncIds, IndexShardRoutingTable routingTable) throws IOException {
        ShardRouting initializingReplicaRouting = replica.routingEntry();
        IndexShardRoutingTable newRoutingTable = initializingReplicaRouting.isRelocationTarget() ? new IndexShardRoutingTable.Builder(routingTable).removeShard(primary.routingEntry()).addShard(replica.routingEntry()).build() : new IndexShardRoutingTable.Builder(routingTable).removeShard(initializingReplicaRouting).addShard(replica.routingEntry()).build();
        HashSet<String> inSyncIdsWithReplica = new HashSet<String>(inSyncIds);
        inSyncIdsWithReplica.add(replica.routingEntry().allocationId().getId());
        primary.updateShardState(primary.routingEntry(), primary.getPendingPrimaryTerm(), null, currentClusterStateVersion.incrementAndGet(), inSyncIdsWithReplica, newRoutingTable, primary.indexSettings.isRemoteTranslogStoreEnabled() ? IndexShardTestUtils.getFakeRemoteEnabledDiscoveryNodes(routingTable.shards()) : IndexShardTestUtils.getFakeDiscoveryNodes(routingTable.shards()));
        replica.updateShardState(replica.routingEntry().moveToStarted(), replica.getPendingPrimaryTerm(), null, currentClusterStateVersion.get(), inSyncIdsWithReplica, newRoutingTable, replica.indexSettings.isRemoteTranslogStoreEnabled() ? IndexShardTestUtils.getFakeRemoteEnabledDiscoveryNodes(routingTable.shards()) : IndexShardTestUtils.getFakeDiscoveryNodes(routingTable.shards()));
    }

    protected void promoteReplica(IndexShard replica, Set<String> inSyncIds, IndexShardRoutingTable routingTable) throws IOException {
        IndexShardTestCase.assertThat(inSyncIds, (Matcher)Matchers.contains((Object[])new String[]{replica.routingEntry().allocationId().getId()}));
        ShardRouting routingEntry = TestShardRouting.newShardRouting(replica.routingEntry().shardId(), replica.routingEntry().currentNodeId(), null, true, ShardRoutingState.STARTED, replica.routingEntry().allocationId());
        IndexShardRoutingTable newRoutingTable = new IndexShardRoutingTable.Builder(routingTable).removeShard(replica.routingEntry()).addShard(routingEntry).build();
        replica.updateShardState(routingEntry, replica.getPendingPrimaryTerm() + 1L, (is, listener) -> listener.onResponse((Object)new PrimaryReplicaSyncer.ResyncTask(1L, "type", "action", "desc", null, Collections.emptyMap())), currentClusterStateVersion.incrementAndGet(), inSyncIds, newRoutingTable, IndexShardTestUtils.getFakeDiscoveryNodes(routingEntry));
    }

    public static Set<String> getShardDocUIDs(IndexShard shard) throws IOException {
        return IndexShardTestCase.getDocIdAndSeqNos(shard).stream().map(DocIdSeqNoAndSource::getId).collect(Collectors.toSet());
    }

    public static List<DocIdSeqNoAndSource> getDocIdAndSeqNos(IndexShard shard) throws IOException {
        return EngineTestCase.getDocIds(shard.getEngine(), true);
    }

    protected void assertDocCount(IndexShard shard, int docDount) throws IOException {
        IndexShardTestCase.assertThat(IndexShardTestCase.getShardDocUIDs(shard), (Matcher)Matchers.hasSize((int)docDount));
    }

    protected void assertDocs(IndexShard shard, String ... ids) throws IOException {
        Set<String> shardDocUIDs = IndexShardTestCase.getShardDocUIDs(shard);
        IndexShardTestCase.assertThat(shardDocUIDs, (Matcher)Matchers.contains((Object[])ids));
        IndexShardTestCase.assertThat(shardDocUIDs, (Matcher)Matchers.hasSize((int)ids.length));
    }

    public static void assertConsistentHistoryBetweenTranslogAndLucene(IndexShard shard) throws IOException {
        if (shard.state() != IndexShardState.POST_RECOVERY && shard.state() != IndexShardState.STARTED) {
            return;
        }
        Engine engine = shard.getEngineOrNull();
        if (engine != null) {
            EngineTestCase.assertConsistentHistoryBetweenTranslogAndLuceneIndex(engine);
        }
    }

    protected Engine.IndexResult indexDoc(IndexShard shard, String type, String id) throws IOException {
        return this.indexDoc(shard, type, id, "{}");
    }

    protected Engine.IndexResult indexDoc(IndexShard shard, String type, String id, String source) throws IOException {
        return this.indexDoc(shard, id, source, MediaTypeRegistry.JSON, null);
    }

    protected Engine.IndexResult indexDoc(IndexShard shard, String id, String source, MediaType mediaType, String routing) throws IOException {
        Engine.IndexResult result;
        SourceToParse sourceToParse = new SourceToParse(shard.shardId().getIndexName(), id, (BytesReference)new BytesArray(source), mediaType, routing);
        if (shard.routingEntry().primary()) {
            result = shard.applyIndexOperationOnPrimary(-3L, VersionType.INTERNAL, sourceToParse, -2L, 0L, -1L, false);
            if (result.getResultType() == Engine.Result.Type.MAPPING_UPDATE_REQUIRED) {
                this.updateMappings(shard, IndexMetadata.builder((IndexMetadata)shard.indexSettings().getIndexMetadata()).putMapping(result.getRequiredMappingUpdate().toString()).build());
                result = shard.applyIndexOperationOnPrimary(-3L, VersionType.INTERNAL, sourceToParse, -2L, 0L, -1L, false);
            }
            shard.sync();
            shard.updateLocalCheckpointForShard(shard.routingEntry().allocationId().getId(), shard.getLocalCheckpoint());
        } else {
            long seqNo = shard.seqNoStats().getMaxSeqNo() + 1L;
            shard.advanceMaxSeqNoOfUpdatesOrDeletes(seqNo);
            result = shard.applyIndexOperationOnReplica(UUID.randomUUID().toString(), seqNo, shard.getOperationPrimaryTerm(), 0L, -1L, false, sourceToParse);
            shard.sync();
            if (result.getResultType() == Engine.Result.Type.MAPPING_UPDATE_REQUIRED) {
                throw new TransportReplicationAction.RetryOnReplicaException(shard.shardId, "Mappings are not available on the replica yet, triggered update: " + String.valueOf(result.getRequiredMappingUpdate()));
            }
        }
        return result;
    }

    protected void updateMappings(IndexShard shard, IndexMetadata indexMetadata) {
        shard.mapperService().merge(indexMetadata, MapperService.MergeReason.MAPPING_UPDATE);
        shard.indexSettings().updateIndexMetadata(IndexMetadata.builder((IndexMetadata)indexMetadata).putMapping(new MappingMetadata(shard.mapperService().documentMapper())).build());
    }

    protected Engine.DeleteResult deleteDoc(IndexShard shard, String id) throws IOException {
        Engine.DeleteResult result;
        if (shard.routingEntry().primary()) {
            result = shard.applyDeleteOperationOnPrimary(-3L, id, VersionType.INTERNAL, -2L, 0L);
            shard.sync();
            shard.updateLocalCheckpointForShard(shard.routingEntry().allocationId().getId(), shard.getLocalCheckpoint());
        } else {
            long seqNo = shard.seqNoStats().getMaxSeqNo() + 1L;
            shard.advanceMaxSeqNoOfUpdatesOrDeletes(seqNo);
            result = shard.applyDeleteOperationOnReplica(seqNo, shard.getOperationPrimaryTerm(), 0L, id);
            shard.sync();
        }
        return result;
    }

    protected void flushShard(IndexShard shard) {
        this.flushShard(shard, false);
    }

    protected void flushShard(IndexShard shard, boolean force) {
        shard.flush(new FlushRequest(new String[]{shard.shardId().getIndexName()}).force(force));
    }

    public static boolean recoverFromStore(IndexShard newShard) {
        PlainActionFuture future = PlainActionFuture.newFuture();
        newShard.recoverFromStore((ActionListener)future);
        return (Boolean)future.actionGet();
    }

    protected void recoverShardFromSnapshot(IndexShard shard, Snapshot snapshot, Repository repository) {
        Version version = Version.CURRENT;
        ShardId shardId = shard.shardId();
        IndexId indexId = new IndexId(shardId.getIndex().getName(), shardId.getIndex().getUUID());
        DiscoveryNode node = IndexShardTestUtils.getFakeDiscoNode(shard.routingEntry().currentNodeId());
        RecoverySource.SnapshotRecoverySource recoverySource = new RecoverySource.SnapshotRecoverySource(UUIDs.randomBase64UUID(), snapshot, version, indexId);
        ShardRouting shardRouting = TestShardRouting.newShardRouting(shardId, node.getId(), true, ShardRoutingState.INITIALIZING, (RecoverySource)recoverySource);
        shard.markAsRecovering("from snapshot", new RecoveryState(shardRouting, node, null));
        PlainActionFuture future = PlainActionFuture.newFuture();
        repository.restoreShard(shard.store(), snapshot.getSnapshotId(), indexId, shard.shardId(), shard.recoveryState(), (ActionListener)future);
        future.actionGet();
    }

    protected String snapshotShard(IndexShard shard, Snapshot snapshot, Repository repository) throws IOException {
        String shardGen;
        Index index = shard.shardId().getIndex();
        IndexId indexId = new IndexId(index.getName(), index.getUUID());
        IndexShardSnapshotStatus snapshotStatus = IndexShardSnapshotStatus.newInitializing((String)OpenSearchBlobStoreRepositoryIntegTestCase.getRepositoryData(repository).shardGenerations().getShardGen(indexId, shard.shardId().getId()));
        PlainActionFuture future = PlainActionFuture.newFuture();
        try (GatedCloseable wrappedIndexCommit = shard.acquireLastIndexCommit(true);){
            repository.snapshotShard(shard.store(), shard.mapperService(), snapshot.getSnapshotId(), indexId, (IndexCommit)wrappedIndexCommit.get(), null, snapshotStatus, Version.CURRENT, Collections.emptyMap(), (ActionListener)future);
            shardGen = (String)future.actionGet();
        }
        IndexShardSnapshotStatus.Copy lastSnapshotStatus = snapshotStatus.asCopy();
        IndexShardTestCase.assertEquals((Object)IndexShardSnapshotStatus.Stage.DONE, (Object)lastSnapshotStatus.getStage());
        IndexShardTestCase.assertEquals((long)shard.snapshotStoreMetadata().size(), (long)lastSnapshotStatus.getTotalFileCount());
        IndexShardTestCase.assertNull((Object)lastSnapshotStatus.getFailure());
        return shardGen;
    }

    public static Engine getEngine(IndexShard indexShard) {
        return indexShard.getEngine();
    }

    public static Translog getTranslog(IndexShard shard) {
        return EngineTestCase.getTranslog(IndexShardTestCase.getEngine(shard));
    }

    public static ReplicationTracker getReplicationTracker(IndexShard indexShard) {
        return indexShard.getReplicationTracker();
    }

    public static Engine.Warmer createTestWarmer(IndexSettings indexSettings) {
        return reader -> {
            if (IndexShardTestCase.randomBoolean()) {
                try {
                    EngineTestCase.assertAtMostOneLuceneDocumentPerSequenceNumber(indexSettings, (DirectoryReader)reader);
                }
                catch (IOException e) {
                    throw new AssertionError((Object)e);
                }
            }
        };
    }

    private SegmentReplicationTargetService getSegmentReplicationTargetService(TransportService transportService, IndicesService indicesService, ClusterService clusterService, SegmentReplicationSourceFactory sourceFactory) {
        return new SegmentReplicationTargetService(this.threadPool, new RecoverySettings(Settings.EMPTY, new ClusterSettings(Settings.EMPTY, ClusterSettings.BUILT_IN_CLUSTER_SETTINGS)), transportService, sourceFactory, indicesService, clusterService);
    }

    private SegmentReplicationTargetService prepareForReplication(IndexShard primaryShard, IndexShard target, TransportService transportService, IndicesService indicesService, ClusterService clusterService, Consumer<IndexShard> postGetFilesRunnable) {
        SegmentReplicationTargetService targetService;
        SegmentReplicationSourceFactory sourceFactory = null;
        if (primaryShard.indexSettings.isRemoteStoreEnabled() || primaryShard.indexSettings.isAssignedOnRemoteNode()) {
            RecoverySettings recoverySettings = new RecoverySettings(Settings.EMPTY, new ClusterSettings(Settings.EMPTY, ClusterSettings.BUILT_IN_CLUSTER_SETTINGS));
            sourceFactory = new SegmentReplicationSourceFactory(transportService, recoverySettings, clusterService);
            targetService = this.getSegmentReplicationTargetService(transportService, indicesService, clusterService, sourceFactory);
        } else {
            sourceFactory = (SegmentReplicationSourceFactory)Mockito.mock(SegmentReplicationSourceFactory.class);
            targetService = this.getSegmentReplicationTargetService(transportService, indicesService, clusterService, sourceFactory);
            SegmentReplicationSource replicationSource = this.getSegmentReplicationSource(primaryShard, repId -> targetService.get(repId.longValue()), repId -> targetService.getMergedSegmentReplicationRef(repId.longValue()), postGetFilesRunnable);
            Mockito.when((Object)sourceFactory.get((IndexShard)ArgumentMatchers.any())).thenReturn((Object)replicationSource);
            Mockito.when((Object)((IndexShard)indicesService.getShardOrNull((ShardId)ArgumentMatchers.any()))).thenReturn((Object)target);
        }
        return targetService;
    }

    public final SegmentReplicationTargetService prepareForReplication(IndexShard primaryShard, IndexShard target) {
        return this.prepareForReplication(primaryShard, target, (TransportService)Mockito.mock(TransportService.class), (IndicesService)Mockito.mock(IndicesService.class), (ClusterService)Mockito.mock(ClusterService.class), indexShard -> {});
    }

    public final SegmentReplicationTargetService prepareForReplication(IndexShard primaryShard, IndexShard target, TransportService transportService, IndicesService indicesService, ClusterService clusterService) {
        return this.prepareForReplication(primaryShard, target, transportService, indicesService, clusterService, indexShard -> {});
    }

    public SegmentReplicationTargetService.SegmentReplicationListener getTargetListener(final IndexShard primaryShard, final IndexShard replicaShard, final Map<String, StoreFileMetadata> primaryMetadata, final CountDownLatch latch) {
        return new SegmentReplicationTargetService.SegmentReplicationListener(){
            final /* synthetic */ IndexShardTestCase this$0;
            {
                this.this$0 = this$0;
            }

            public void onReplicationDone(SegmentReplicationState state) {
                try (GatedCloseable snapshot = replicaShard.getSegmentInfosSnapshot();){
                    SegmentInfos replicaInfos = (SegmentInfos)snapshot.get();
                    Map replicaMetadata = replicaShard.store().getSegmentMetadataMap(replicaInfos);
                    Store.RecoveryDiff recoveryDiff = Store.segmentReplicationDiff((Map)primaryMetadata, (Map)replicaMetadata);
                    Assert.assertTrue((boolean)recoveryDiff.missing.isEmpty());
                    Assert.assertTrue((boolean)recoveryDiff.different.isEmpty());
                    Assert.assertEquals((long)recoveryDiff.identical.size(), (long)primaryMetadata.size());
                    primaryShard.updateVisibleCheckpointForShard(replicaShard.routingEntry().allocationId().getId(), primaryShard.getLatestReplicationCheckpoint());
                }
                catch (Exception e) {
                    throw ExceptionsHelper.convertToRuntime((Exception)e);
                }
                finally {
                    latch.countDown();
                }
            }

            public void onReplicationFailure(SegmentReplicationState state, ReplicationFailedException e, boolean sendShardFailure) {
                this.this$0.logger.error("Unexpected replication failure in test", (Throwable)e);
                Assert.fail((String)("test replication should not fail: " + String.valueOf(e)));
            }
        };
    }

    public SegmentReplicationTargetService.SegmentReplicationListener getMergedSegmentTargetListener(IndexShard primaryShard, final IndexShard replicaShard, final Map<String, StoreFileMetadata> primaryMetadata, final CountDownLatch latch) {
        return new SegmentReplicationTargetService.SegmentReplicationListener(){
            final /* synthetic */ IndexShardTestCase this$0;
            {
                this.this$0 = this$0;
            }

            public void onReplicationDone(SegmentReplicationState state) {
                try {
                    Set replicaFiles = Arrays.stream(replicaShard.store().directory().listAll()).collect(Collectors.toSet());
                    Assert.assertTrue((boolean)replicaFiles.containsAll(primaryMetadata.keySet()));
                }
                catch (Exception e) {
                    throw ExceptionsHelper.convertToRuntime((Exception)e);
                }
                finally {
                    latch.countDown();
                }
            }

            public void onReplicationFailure(SegmentReplicationState state, ReplicationFailedException e, boolean sendShardFailure) {
                this.this$0.logger.error("Unexpected replication failure in test", (Throwable)e);
                Assert.fail((String)("test replication should not fail: " + String.valueOf(e)));
            }
        };
    }

    public SegmentReplicationSource getSegmentReplicationSource(final IndexShard primaryShard, final Function<Long, ReplicationCollection.ReplicationRef<SegmentReplicationTarget>> getTargetFunc, final Function<Long, ReplicationCollection.ReplicationRef<MergedSegmentReplicationTarget>> getMergedSegmentTargetFunc, final Consumer<IndexShard> postGetFilesRunnable) {
        return new TestReplicationSource(this){
            final /* synthetic */ IndexShardTestCase this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void getCheckpointMetadata(long replicationId, ReplicationCheckpoint checkpoint, ActionListener<CheckpointInfoResponse> listener) {
                try (CopyState copyState = new CopyState(primaryShard);){
                    listener.onResponse((Object)new CheckpointInfoResponse(copyState.getCheckpoint(), copyState.getMetadataMap(), copyState.getInfosBytes()));
                }
                catch (IOException e) {
                    this.this$0.logger.error("Unexpected error computing CopyState", (Throwable)e);
                    Assert.fail((String)"Failed to compute copyState");
                }
            }

            @Override
            public void getSegmentFiles(long replicationId, ReplicationCheckpoint checkpoint, List<StoreFileMetadata> filesToFetch, IndexShard indexShard, BiConsumer<String, Long> fileProgressTracker, ActionListener<GetSegmentFilesResponse> listener) {
                try (ReplicationCollection.ReplicationRef replicationRef = (ReplicationCollection.ReplicationRef)getTargetFunc.apply(replicationId);){
                    this.this$0.writeFileChunks((AbstractSegmentReplicationTarget)replicationRef.get(), primaryShard, filesToFetch.toArray(new StoreFileMetadata[0]));
                }
                catch (IOException e) {
                    listener.onFailure((Exception)e);
                }
                postGetFilesRunnable.accept(indexShard);
                listener.onResponse((Object)new GetSegmentFilesResponse(filesToFetch));
            }

            public void getMergedSegmentFiles(long replicationId, ReplicationCheckpoint checkpoint, List<StoreFileMetadata> filesToFetch, IndexShard indexShard, BiConsumer<String, Long> fileProgressTracker, ActionListener<GetSegmentFilesResponse> listener) {
                try (ReplicationCollection.ReplicationRef replicationRef = (ReplicationCollection.ReplicationRef)getMergedSegmentTargetFunc.apply(replicationId);){
                    this.this$0.writeFileChunks((AbstractSegmentReplicationTarget)replicationRef.get(), primaryShard, filesToFetch.toArray(new StoreFileMetadata[0]));
                }
                catch (IOException e) {
                    listener.onFailure((Exception)e);
                }
                postGetFilesRunnable.accept(indexShard);
                listener.onResponse((Object)new GetSegmentFilesResponse(filesToFetch));
            }
        };
    }

    protected final List<SegmentReplicationTarget> replicateSegments(IndexShard primaryShard, List<IndexShard> replicaShards) throws IOException, InterruptedException {
        Map primaryMetadata;
        CountDownLatch countDownLatch = new CountDownLatch(replicaShards.size());
        try (GatedCloseable segmentInfosSnapshot = primaryShard.getSegmentInfosSnapshot();){
            SegmentInfos primarySegmentInfos = (SegmentInfos)segmentInfosSnapshot.get();
            primaryMetadata = primaryShard.store().getSegmentMetadataMap(primarySegmentInfos);
        }
        ArrayList<SegmentReplicationTarget> ids = new ArrayList<SegmentReplicationTarget>();
        for (IndexShard replica : replicaShards) {
            SegmentReplicationTargetService targetService = this.prepareForReplication(primaryShard, replica);
            SegmentReplicationTarget target = targetService.startReplication(replica, primaryShard.getLatestReplicationCheckpoint(), this.getTargetListener(primaryShard, replica, primaryMetadata, countDownLatch));
            ids.add(target);
        }
        countDownLatch.await(30L, TimeUnit.SECONDS);
        IndexShardTestCase.assertEquals((String)"Replication should complete successfully", (long)0L, (long)countDownLatch.getCount());
        return ids;
    }

    protected final void replicateMergedSegments(IndexShard primaryShard, List<IndexShard> replicaShards) throws IOException, InterruptedException {
        Map primaryMetadata;
        CountDownLatch countDownLatch = new CountDownLatch(replicaShards.size());
        try (GatedCloseable segmentInfosSnapshot = primaryShard.getSegmentInfosSnapshot();){
            SegmentInfos primarySegmentInfos = (SegmentInfos)segmentInfosSnapshot.get();
            primaryMetadata = primaryShard.store().getSegmentMetadataMap(primarySegmentInfos);
        }
        ReplicationCheckpoint replicationCheckpoint = primaryShard.getLatestReplicationCheckpoint();
        for (IndexShard replica : replicaShards) {
            SegmentReplicationTargetService targetService = this.prepareForReplication(primaryShard, replica);
            targetService.startMergedSegmentReplication(replica, (ReplicationCheckpoint)new MergedSegmentCheckpoint(replicationCheckpoint.getShardId(), replicationCheckpoint.getPrimaryTerm(), replicationCheckpoint.getSegmentInfosVersion(), replicationCheckpoint.getLength(), replicationCheckpoint.getCodec(), replicationCheckpoint.getMetadataMap(), IndexFileNames.parseSegmentName((String)((String)replicationCheckpoint.getMetadataMap().keySet().stream().toList().getFirst()))), this.getMergedSegmentTargetListener(primaryShard, replica, primaryMetadata, countDownLatch));
        }
        countDownLatch.await(30L, TimeUnit.SECONDS);
        IndexShardTestCase.assertEquals((String)"Replication merged segment should complete successfully", (long)0L, (long)countDownLatch.getCount());
    }

    private void writeFileChunks(AbstractSegmentReplicationTarget target, IndexShard primary, StoreFileMetadata[] files) throws IOException {
        for (StoreFileMetadata md : files) {
            try (IndexInput in = primary.store().directory().openInput(md.name(), IOContext.READONCE);){
                int pos = 0;
                while ((long)pos < md.length()) {
                    int length = IndexShardTestCase.between(1, Math.toIntExact(md.length() - (long)pos));
                    byte[] buffer = new byte[length];
                    in.readBytes(buffer, 0, length);
                    target.writeFileChunk(md, (long)pos, (BytesReference)new BytesArray(buffer), (long)(pos + length) == md.length(), 0, (ActionListener)Mockito.mock(ActionListener.class));
                    pos += length;
                }
            }
        }
    }
}

