/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.opensearch.common.io.stream.BytesStreamOutput;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.common.io.stream.NamedWriteableAwareStreamInput;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.env.Environment;
import org.opensearch.indices.IndicesModule;
import org.opensearch.plugins.SearchPlugin;
import org.opensearch.search.SearchModule;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.PipelineAggregationBuilder;
import org.opensearch.search.aggregations.pipeline.AbstractPipelineAggregationBuilder;
import org.opensearch.test.AbstractQueryTestCase;
import org.opensearch.test.EqualsHashCodeTestUtils;
import org.opensearch.test.OpenSearchTestCase;

public abstract class BasePipelineAggregationTestCase<AF extends AbstractPipelineAggregationBuilder<AF>>
extends OpenSearchTestCase {
    protected static final String STRING_FIELD_NAME = "mapped_string";
    protected static final String INT_FIELD_NAME = "mapped_int";
    protected static final String DOUBLE_FIELD_NAME = "mapped_double";
    protected static final String BOOLEAN_FIELD_NAME = "mapped_boolean";
    protected static final String DATE_FIELD_NAME = "mapped_date";
    private String[] currentTypes;
    private NamedWriteableRegistry namedWriteableRegistry;
    private NamedXContentRegistry xContentRegistry;

    protected String[] getCurrentTypes() {
        return this.currentTypes;
    }

    protected abstract AF createTestAggregatorFactory();

    public void setUp() throws Exception {
        super.setUp();
        Settings settings = Settings.builder().put("node.name", AbstractQueryTestCase.class.toString()).put(Environment.PATH_HOME_SETTING.getKey(), BasePipelineAggregationTestCase.createTempDir()).build();
        IndicesModule indicesModule = new IndicesModule(Collections.emptyList());
        SearchModule searchModule = new SearchModule(settings, this.plugins());
        ArrayList<NamedWriteableRegistry.Entry> entries = new ArrayList<NamedWriteableRegistry.Entry>();
        entries.addAll(indicesModule.getNamedWriteables());
        entries.addAll(searchModule.getNamedWriteables());
        entries.addAll(this.additionalNamedWriteables());
        this.namedWriteableRegistry = new NamedWriteableRegistry(entries);
        List xContentEntries = searchModule.getNamedXContents();
        xContentEntries.addAll(this.additionalNamedContents());
        this.xContentRegistry = new NamedXContentRegistry(xContentEntries);
        this.currentTypes = new String[BasePipelineAggregationTestCase.randomIntBetween(0, 5)];
        for (int i = 0; i < this.currentTypes.length; ++i) {
            String type;
            this.currentTypes[i] = type = BasePipelineAggregationTestCase.randomAlphaOfLengthBetween(1, 10);
        }
    }

    protected List<SearchPlugin> plugins() {
        return Collections.emptyList();
    }

    protected List<NamedWriteableRegistry.Entry> additionalNamedWriteables() {
        return Collections.emptyList();
    }

    protected List<NamedXContentRegistry.Entry> additionalNamedContents() {
        return Collections.emptyList();
    }

    public void testFromXContent() throws IOException {
        AF testAgg = this.createTestAggregatorFactory();
        AggregatorFactories.Builder factoriesBuilder = AggregatorFactories.builder().addPipelineAggregator(testAgg);
        this.logger.info("Content string: {}", (Object)factoriesBuilder);
        XContentBuilder builder = MediaTypeRegistry.contentBuilder((MediaType)((MediaType)BasePipelineAggregationTestCase.randomFrom(XContentType.values())));
        if (BasePipelineAggregationTestCase.randomBoolean()) {
            builder.prettyPrint();
        }
        factoriesBuilder.toXContent(builder, ToXContent.EMPTY_PARAMS);
        XContentBuilder shuffled = this.shuffleXContent(builder, new String[0]);
        try (XContentParser parser = this.createParser(shuffled);){
            String contentString = factoriesBuilder.toString();
            this.logger.info("Content string: {}", (Object)contentString);
            PipelineAggregationBuilder newAgg = this.parse(parser);
            BasePipelineAggregationTestCase.assertNotSame((Object)newAgg, testAgg);
            BasePipelineAggregationTestCase.assertEquals(testAgg, (Object)newAgg);
            BasePipelineAggregationTestCase.assertEquals((long)testAgg.hashCode(), (long)newAgg.hashCode());
        }
    }

    protected PipelineAggregationBuilder parse(XContentParser parser) throws IOException {
        BasePipelineAggregationTestCase.assertSame((Object)XContentParser.Token.START_OBJECT, (Object)parser.nextToken());
        AggregatorFactories.Builder parsed = AggregatorFactories.parseAggregators((XContentParser)parser);
        BasePipelineAggregationTestCase.assertThat((Object)parsed.getAggregatorFactories(), (Matcher)Matchers.hasSize((int)0));
        BasePipelineAggregationTestCase.assertThat((Object)parsed.getPipelineAggregatorFactories(), (Matcher)Matchers.hasSize((int)1));
        PipelineAggregationBuilder newAgg = (PipelineAggregationBuilder)parsed.getPipelineAggregatorFactories().iterator().next();
        BasePipelineAggregationTestCase.assertNull((Object)parser.nextToken());
        BasePipelineAggregationTestCase.assertNotNull((Object)newAgg);
        return newAgg;
    }

    public void testSerialization() throws IOException {
        AF testAgg = this.createTestAggregatorFactory();
        try (BytesStreamOutput output = new BytesStreamOutput();){
            output.writeNamedWriteable(testAgg);
            try (NamedWriteableAwareStreamInput in = new NamedWriteableAwareStreamInput(output.bytes().streamInput(), this.namedWriteableRegistry);){
                PipelineAggregationBuilder deserializedQuery = (PipelineAggregationBuilder)in.readNamedWriteable(PipelineAggregationBuilder.class);
                BasePipelineAggregationTestCase.assertEquals((Object)deserializedQuery, testAgg);
                BasePipelineAggregationTestCase.assertEquals((long)deserializedQuery.hashCode(), (long)testAgg.hashCode());
                BasePipelineAggregationTestCase.assertNotSame((Object)deserializedQuery, testAgg);
            }
        }
    }

    public void testEqualsAndHashcode() throws IOException {
        EqualsHashCodeTestUtils.checkEqualsAndHashCode(this.createTestAggregatorFactory(), this::copyAggregation);
    }

    private AF copyAggregation(AF agg) throws IOException {
        try (BytesStreamOutput output = new BytesStreamOutput();){
            AbstractPipelineAggregationBuilder abstractPipelineAggregationBuilder;
            output.writeNamedWriteable(agg);
            try (NamedWriteableAwareStreamInput in = new NamedWriteableAwareStreamInput(output.bytes().streamInput(), this.namedWriteableRegistry);){
                AbstractPipelineAggregationBuilder secondAgg;
                abstractPipelineAggregationBuilder = secondAgg = (AbstractPipelineAggregationBuilder)in.readNamedWriteable(PipelineAggregationBuilder.class);
            }
            return (AF)abstractPipelineAggregationBuilder;
        }
    }

    protected String[] getRandomTypes() {
        String[] types;
        if (this.currentTypes.length > 0 && BasePipelineAggregationTestCase.randomBoolean()) {
            int numberOfQueryTypes = BasePipelineAggregationTestCase.randomIntBetween(1, this.currentTypes.length);
            types = new String[numberOfQueryTypes];
            for (int i = 0; i < numberOfQueryTypes; ++i) {
                types[i] = BasePipelineAggregationTestCase.randomFrom(this.currentTypes);
            }
        } else {
            types = BasePipelineAggregationTestCase.randomBoolean() ? new String[]{"_all"} : new String[]{};
        }
        return types;
    }

    public String randomNumericField() {
        int randomInt = BasePipelineAggregationTestCase.randomInt(3);
        switch (randomInt) {
            case 0: {
                return DATE_FIELD_NAME;
            }
            case 1: {
                return DOUBLE_FIELD_NAME;
            }
        }
        return INT_FIELD_NAME;
    }

    @Override
    protected NamedXContentRegistry xContentRegistry() {
        return this.xContentRegistry;
    }

    protected String validate(AggregationBuilder parent, AF builder) {
        return this.validate(PipelineAggregationBuilder.ValidationContext.forInsideTree((AggregationBuilder)parent, null), builder);
    }

    protected String validate(Collection<AggregationBuilder> siblingAggregations, AF builder) {
        return this.validate(siblingAggregations, Collections.emptyList(), builder);
    }

    protected String validate(Collection<AggregationBuilder> siblingAggregations, Collection<PipelineAggregationBuilder> siblingPipelineAggregations, AF builder) {
        return this.validate(PipelineAggregationBuilder.ValidationContext.forTreeRoot(siblingAggregations, siblingPipelineAggregations, null), builder);
    }

    protected String validate(PipelineAggregationBuilder.ValidationContext context, AF builder) {
        builder.validate(context);
        return context.getValidationException() == null ? null : context.getValidationException().getMessage();
    }
}

