/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test;

import com.carrotsearch.randomizedtesting.annotations.TestGroup;
import com.carrotsearch.randomizedtesting.generators.RandomNumbers;
import com.carrotsearch.randomizedtesting.generators.RandomPicks;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.constant.Constable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchException;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.admin.cluster.health.ClusterHealthRequest;
import org.opensearch.action.admin.cluster.health.ClusterHealthRequestBuilder;
import org.opensearch.action.admin.cluster.health.ClusterHealthResponse;
import org.opensearch.action.admin.cluster.node.hotthreads.NodeHotThreads;
import org.opensearch.action.admin.cluster.node.hotthreads.NodesHotThreadsResponse;
import org.opensearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.opensearch.action.admin.cluster.repositories.put.PutRepositoryRequestBuilder;
import org.opensearch.action.admin.cluster.settings.ClusterUpdateSettingsRequest;
import org.opensearch.action.admin.cluster.state.ClusterStateRequestBuilder;
import org.opensearch.action.admin.cluster.state.ClusterStateResponse;
import org.opensearch.action.admin.cluster.tasks.PendingClusterTasksRequestBuilder;
import org.opensearch.action.admin.cluster.tasks.PendingClusterTasksResponse;
import org.opensearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.opensearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.opensearch.action.admin.indices.flush.FlushRequestBuilder;
import org.opensearch.action.admin.indices.flush.FlushResponse;
import org.opensearch.action.admin.indices.forcemerge.ForceMergeRequestBuilder;
import org.opensearch.action.admin.indices.forcemerge.ForceMergeResponse;
import org.opensearch.action.admin.indices.get.GetIndexRequestBuilder;
import org.opensearch.action.admin.indices.get.GetIndexResponse;
import org.opensearch.action.admin.indices.refresh.RefreshRequestBuilder;
import org.opensearch.action.admin.indices.refresh.RefreshResponse;
import org.opensearch.action.admin.indices.segments.IndexSegments;
import org.opensearch.action.admin.indices.segments.IndexShardSegments;
import org.opensearch.action.admin.indices.segments.IndicesSegmentResponse;
import org.opensearch.action.admin.indices.segments.ShardSegments;
import org.opensearch.action.admin.indices.template.put.PutIndexTemplateRequestBuilder;
import org.opensearch.action.bulk.BulkRequestBuilder;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexRequestBuilder;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.ClearScrollResponse;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.action.support.broadcast.BroadcastResponse;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.client.RestClient;
import org.opensearch.cluster.ClusterModule;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.coordination.OpenSearchNodeCommand;
import org.opensearch.cluster.health.ClusterHealthStatus;
import org.opensearch.cluster.metadata.Context;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.routing.IndexRoutingTable;
import org.opensearch.cluster.routing.IndexShardRoutingTable;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.routing.UnassignedInfo;
import org.opensearch.cluster.routing.allocation.AwarenessReplicaBalance;
import org.opensearch.cluster.routing.allocation.DiskThresholdSettings;
import org.opensearch.cluster.routing.allocation.decider.AwarenessAllocationDecider;
import org.opensearch.cluster.routing.allocation.decider.EnableAllocationDecider;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.cluster.service.applicationtemplates.TestSystemTemplatesRepositoryPlugin;
import org.opensearch.common.CheckedRunnable;
import org.opensearch.common.Nullable;
import org.opensearch.common.Priority;
import org.opensearch.common.blobstore.BlobPath;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.concurrent.GatedCloseable;
import org.opensearch.common.regex.Regex;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.FeatureFlagSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.FeatureFlags;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.common.xcontent.smile.SmileXContent;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.action.support.DefaultShardOperationFailedException;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.common.transport.TransportAddress;
import org.opensearch.core.common.unit.ByteSizeUnit;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.core.common.util.CollectionUtils;
import org.opensearch.core.concurrency.OpenSearchRejectedExecutionException;
import org.opensearch.core.index.Index;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.discovery.DiscoveryModule;
import org.opensearch.discovery.SettingsBasedSeedHostsProvider;
import org.opensearch.env.Environment;
import org.opensearch.env.TestEnvironment;
import org.opensearch.index.IndexModule;
import org.opensearch.index.IndexService;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.MergeSchedulerConfig;
import org.opensearch.index.MockEngineFactoryPlugin;
import org.opensearch.index.TieredMergePolicyProvider;
import org.opensearch.index.engine.Segment;
import org.opensearch.index.mapper.MockFieldFilterPlugin;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.remote.RemoteStoreEnums;
import org.opensearch.index.remote.RemoteStorePathStrategy;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.store.Store;
import org.opensearch.index.translog.Translog;
import org.opensearch.indices.IndicesQueryCache;
import org.opensearch.indices.IndicesRequestCache;
import org.opensearch.indices.IndicesService;
import org.opensearch.indices.RemoteStoreSettings;
import org.opensearch.indices.replication.common.ReplicationType;
import org.opensearch.indices.store.IndicesStore;
import org.opensearch.monitor.os.OsInfo;
import org.opensearch.node.NodeMocksPlugin;
import org.opensearch.node.remotestore.RemoteStoreNodeService;
import org.opensearch.plugins.NetworkPlugin;
import org.opensearch.plugins.Plugin;
import org.opensearch.plugins.PluginInfo;
import org.opensearch.repositories.IndexId;
import org.opensearch.repositories.blobstore.BlobStoreRepository;
import org.opensearch.script.MockScriptService;
import org.opensearch.search.MockSearchService;
import org.opensearch.search.SearchHit;
import org.opensearch.search.SearchService;
import org.opensearch.telemetry.TelemetrySettings;
import org.opensearch.test.BackgroundIndexer;
import org.opensearch.test.ExternalTestCluster;
import org.opensearch.test.InternalTestCluster;
import org.opensearch.test.MockHttpTransport;
import org.opensearch.test.NodeConfigurationSource;
import org.opensearch.test.OpenSearchTestCase;
import org.opensearch.test.OpenSearchTestClusterRule;
import org.opensearch.test.TestCluster;
import org.opensearch.test.TestGeoShapeFieldMapperPlugin;
import org.opensearch.test.XContentTestUtils;
import org.opensearch.test.client.RandomizingClient;
import org.opensearch.test.disruption.NetworkDisruption;
import org.opensearch.test.disruption.ServiceDisruptionScheme;
import org.opensearch.test.hamcrest.OpenSearchAssertions;
import org.opensearch.test.store.MockFSIndexStore;
import org.opensearch.test.telemetry.MockTelemetryPlugin;
import org.opensearch.test.transport.MockTransportService;
import org.opensearch.transport.TransportInterceptor;
import org.opensearch.transport.TransportRequest;
import org.opensearch.transport.TransportRequestHandler;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.AdminClient;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.ClusterAdminClient;
import org.opensearch.transport.client.Requests;
import reactor.util.annotation.NonNull;

@LuceneTestCase.SuppressFileSystems(value={"ExtrasFS"})
public abstract class OpenSearchIntegTestCase
extends OpenSearchTestCase {
    public static final String SYSPROP_THIRDPARTY = "tests.thirdparty";
    public static final List<String> CODECS = List.of("default", "lz4", "best_compression", "zlib");
    public static final String SUITE_CLUSTER_NODE_PREFIX = "node_s";
    public static final String TEST_CLUSTER_NODE_PREFIX = "node_t";
    public static final String TESTS_CLUSTER = "tests.cluster";
    public static final Setting<Long> INDEX_TEST_SEED_SETTING = Setting.longSetting((String)"index.tests.seed", (long)0L, (long)Long.MIN_VALUE, (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope});
    public static final String TESTS_ENABLE_MOCK_MODULES = "tests.enable_mock_modules";
    private static final boolean MOCK_MODULES_ENABLED = "true".equals(System.getProperty("tests.enable_mock_modules", "true"));
    @Rule
    public static OpenSearchTestClusterRule testClusterRule = new OpenSearchTestClusterRule();
    private static final int FREQUENT_BULK_THRESHOLD = 300;
    private static final int ALWAYS_BULK_THRESHOLD = 3000;
    private static final int MAX_IN_FLIGHT_ASYNC_INDEXES = 150;
    private static final int MAX_BULK_INDEX_REQUEST_SIZE = 1000;
    protected static final int DEFAULT_MIN_NUM_SHARDS = 1;
    protected static final int DEFAULT_MAX_NUM_SHARDS = 10;
    public static final String TESTS_CLUSTER_NAME = "tests.clustername";
    protected static final String REMOTE_BACKED_STORAGE_REPOSITORY_NAME = "test-remote-store-repo";
    protected static Boolean prefixModeVerificationEnable;
    protected static Boolean translogPathFixedPrefix;
    protected static Boolean segmentsPathFixedPrefix;
    protected static Boolean snapshotShardPathFixedPrefix;
    private Path remoteStoreRepositoryPath;
    private ReplicationType randomReplicationType;
    private String randomStorageType;
    private final AtomicInteger dummmyDocIdGenerator = new AtomicInteger();

    @BeforeClass
    public static void beforeClass() throws Exception {
        prefixModeVerificationEnable = OpenSearchIntegTestCase.randomBoolean();
        translogPathFixedPrefix = OpenSearchIntegTestCase.randomBoolean();
        segmentsPathFixedPrefix = OpenSearchIntegTestCase.randomBoolean();
        snapshotShardPathFixedPrefix = OpenSearchIntegTestCase.randomBoolean();
        testClusterRule.beforeClass();
    }

    @Override
    protected final boolean enableWarningsCheck() {
        return false;
    }

    protected void randomIndexTemplate() {
        if (OpenSearchIntegTestCase.cluster().size() > 0) {
            Settings.Builder randomSettingsBuilder = this.setRandomIndexSettings(OpenSearchIntegTestCase.random(), Settings.builder());
            if (OpenSearchIntegTestCase.isInternalCluster()) {
                randomSettingsBuilder.put(INDEX_TEST_SEED_SETTING.getKey(), OpenSearchIntegTestCase.random().nextLong());
            }
            randomSettingsBuilder.put("index.number_of_shards", this.numberOfShards()).put("index.number_of_replicas", this.numberOfReplicas());
            LuceneTestCase.SuppressCodecs annotation = ((Object)((Object)this)).getClass().getAnnotation(LuceneTestCase.SuppressCodecs.class);
            if (annotation != null && annotation.value().length == 1 && "*".equals(annotation.value()[0])) {
                randomSettingsBuilder.put("index.codec", OpenSearchIntegTestCase.randomFrom(CODECS));
            } else {
                randomSettingsBuilder.put("index.codec", "lucene_default");
            }
            for (String setting : randomSettingsBuilder.keys()) {
                OpenSearchIntegTestCase.assertThat((String)"non index. prefix setting set on index template, its a node setting...", (Object)setting, (Matcher)Matchers.startsWith((String)"index."));
            }
            randomSettingsBuilder.put(UnassignedInfo.INDEX_DELAYED_NODE_LEFT_TIMEOUT_SETTING.getKey(), 0);
            if (OpenSearchIntegTestCase.randomBoolean()) {
                randomSettingsBuilder.put(IndexModule.INDEX_QUERY_CACHE_ENABLED_SETTING.getKey(), OpenSearchIntegTestCase.randomBoolean());
            }
            PutIndexTemplateRequestBuilder putTemplate = OpenSearchIntegTestCase.client().admin().indices().preparePutTemplate("random_index_template").setPatterns(Collections.singletonList("*")).setOrder(0).setSettings(randomSettingsBuilder);
            OpenSearchAssertions.assertAcked((AcknowledgedResponse)putTemplate.execute().actionGet());
        }
    }

    protected Settings.Builder setRandomIndexSettings(Random random, Settings.Builder builder) {
        OpenSearchIntegTestCase.setRandomIndexMergeSettings(random, builder);
        OpenSearchIntegTestCase.setRandomIndexTranslogSettings(random, builder);
        if (random.nextBoolean()) {
            builder.put(MergeSchedulerConfig.AUTO_THROTTLE_SETTING.getKey(), false);
        }
        if (random.nextBoolean()) {
            builder.put(IndicesRequestCache.INDEX_CACHE_REQUEST_ENABLED_SETTING.getKey(), random.nextBoolean());
        }
        if (random.nextBoolean()) {
            builder.put(IndexSettings.INDEX_CHECK_ON_STARTUP.getKey(), OpenSearchIntegTestCase.randomFrom(random, new String[]{"false", "checksum", "true"}));
        }
        if (random.nextBoolean()) {
            builder.put(UnassignedInfo.INDEX_DELAYED_NODE_LEFT_TIMEOUT_SETTING.getKey(), RandomNumbers.randomIntBetween((Random)random, (int)1, (int)15) + "ms");
        }
        if (random.nextBoolean()) {
            builder.put(Store.FORCE_RAM_TERM_DICT.getKey(), true);
        }
        return builder;
    }

    private static Settings.Builder setRandomIndexMergeSettings(Random random, Settings.Builder builder) {
        if (random.nextBoolean()) {
            builder.put(TieredMergePolicyProvider.INDEX_COMPOUND_FORMAT_SETTING.getKey(), (random.nextBoolean() ? (Constable)Double.valueOf(random.nextDouble()) : (Constable)Boolean.valueOf(random.nextBoolean())).toString());
        }
        switch (random.nextInt(4)) {
            case 3: {
                int maxThreadCount = RandomNumbers.randomIntBetween((Random)random, (int)1, (int)4);
                int maxMergeCount = RandomNumbers.randomIntBetween((Random)random, (int)maxThreadCount, (int)(maxThreadCount + 4));
                builder.put(MergeSchedulerConfig.MAX_MERGE_COUNT_SETTING.getKey(), maxMergeCount);
                builder.put(MergeSchedulerConfig.MAX_THREAD_COUNT_SETTING.getKey(), maxThreadCount);
            }
        }
        return builder;
    }

    private static Settings.Builder setRandomIndexTranslogSettings(Random random, Settings.Builder builder) {
        if (random.nextBoolean()) {
            builder.put(IndexSettings.INDEX_TRANSLOG_FLUSH_THRESHOLD_SIZE_SETTING.getKey(), new ByteSizeValue((long)RandomNumbers.randomIntBetween((Random)random, (int)1, (int)300), ByteSizeUnit.MB));
        }
        if (random.nextBoolean()) {
            builder.put(IndexSettings.INDEX_TRANSLOG_FLUSH_THRESHOLD_SIZE_SETTING.getKey(), new ByteSizeValue(1L, ByteSizeUnit.PB));
        }
        if (random.nextBoolean()) {
            builder.put(IndexSettings.INDEX_TRANSLOG_DURABILITY_SETTING.getKey(), (Enum)RandomPicks.randomFrom((Random)random, (Object[])Translog.Durability.values()));
        }
        if (random.nextBoolean()) {
            builder.put(IndexSettings.INDEX_TRANSLOG_SYNC_INTERVAL_SETTING.getKey(), (long)RandomNumbers.randomIntBetween((Random)random, (int)100, (int)5000), TimeUnit.MILLISECONDS);
        }
        return builder;
    }

    protected Set<String> excludeTemplates() {
        return Collections.emptySet();
    }

    protected void beforeIndexDeletion() throws Exception {
        OpenSearchIntegTestCase.cluster().beforeIndexDeletion();
    }

    public static TestCluster cluster() {
        return testClusterRule.cluster();
    }

    public static boolean isInternalCluster() {
        return testClusterRule.isInternalCluster();
    }

    public static InternalTestCluster internalCluster() {
        return testClusterRule.internalCluster().orElseThrow(() -> new UnsupportedOperationException("current test cluster is immutable"));
    }

    public ClusterService clusterService() {
        return OpenSearchIntegTestCase.internalCluster().clusterService();
    }

    public static Client client() {
        return OpenSearchIntegTestCase.client(null);
    }

    public static Client client(@Nullable String node) {
        return testClusterRule.clientForNode(node);
    }

    public static Client dataNodeClient() {
        Object client = OpenSearchIntegTestCase.internalCluster().dataNodeClient();
        if (OpenSearchIntegTestCase.frequently()) {
            client = new RandomizingClient((Client)client, OpenSearchIntegTestCase.random());
        }
        return client;
    }

    public static Iterable<Client> clients() {
        return OpenSearchIntegTestCase.cluster().getClients();
    }

    protected int minimumNumberOfShards() {
        return 1;
    }

    protected int maximumNumberOfShards() {
        return 10;
    }

    protected int numberOfShards() {
        return OpenSearchIntegTestCase.between(this.minimumNumberOfShards(), this.maximumNumberOfShards());
    }

    protected int minimumNumberOfReplicas() {
        return 0;
    }

    protected int maximumNumberOfReplicas() {
        int maxNumReplicas = Math.max(0, OpenSearchIntegTestCase.cluster().numDataNodes() - 1);
        return OpenSearchIntegTestCase.frequently() ? Math.min(1, maxNumReplicas) : maxNumReplicas;
    }

    protected int numberOfReplicas() {
        return OpenSearchIntegTestCase.between(this.minimumNumberOfReplicas(), this.maximumNumberOfReplicas());
    }

    public void setDisruptionScheme(ServiceDisruptionScheme scheme) {
        OpenSearchIntegTestCase.internalCluster().setDisruptionScheme(scheme);
    }

    protected static NetworkDisruption isolateClusterManagerDisruption(NetworkDisruption.NetworkLinkDisruptionType disruptionType) {
        String clusterManagerNode = OpenSearchIntegTestCase.internalCluster().getClusterManagerName();
        return new NetworkDisruption(new NetworkDisruption.TwoPartitions(Collections.singleton(clusterManagerNode), Arrays.stream(OpenSearchIntegTestCase.internalCluster().getNodeNames()).filter(name -> !name.equals(clusterManagerNode)).collect(Collectors.toSet())), disruptionType);
    }

    public Settings indexSettings() {
        int numberOfReplicas;
        Settings.Builder builder = Settings.builder();
        int numberOfShards = this.numberOfShards();
        if (numberOfShards > 0) {
            builder.put("index.number_of_shards", numberOfShards).build();
        }
        if ((numberOfReplicas = this.numberOfReplicas()) >= 0) {
            builder.put("index.number_of_replicas", numberOfReplicas).build();
        }
        if (OpenSearchIntegTestCase.randomInt(9) < 3) {
            String dataPath = OpenSearchIntegTestCase.randomAlphaOfLength(10);
            this.logger.info("using custom data_path for index: [{}]", (Object)dataPath);
            builder.put("index.data_path", dataPath);
        }
        builder.put(UnassignedInfo.INDEX_DELAYED_NODE_LEFT_TIMEOUT_SETTING.getKey(), 0);
        if (OpenSearchIntegTestCase.randomBoolean()) {
            builder.put(IndexSettings.INDEX_SOFT_DELETES_RETENTION_OPERATIONS_SETTING.getKey(), OpenSearchIntegTestCase.between(0, 1000));
        }
        if (OpenSearchIntegTestCase.randomBoolean()) {
            builder.put(IndexSettings.INDEX_SOFT_DELETES_RETENTION_LEASE_PERIOD_SETTING.getKey(), TimeValue.timeValueMillis((long)OpenSearchIntegTestCase.randomLongBetween(0L, OpenSearchIntegTestCase.randomBoolean() ? 1000L : ((TimeValue)IndexSettings.INDEX_SOFT_DELETES_RETENTION_LEASE_PERIOD_SETTING.get(Settings.EMPTY)).millis())).getStringRep());
        }
        if (OpenSearchIntegTestCase.randomBoolean()) {
            builder.put(IndexSettings.INDEX_DOC_ID_FUZZY_SET_ENABLED_SETTING.getKey(), true);
            builder.put(IndexSettings.INDEX_DOC_ID_FUZZY_SET_FALSE_POSITIVE_PROBABILITY_SETTING.getKey(), OpenSearchIntegTestCase.randomDoubleBetween(0.01, 0.5, true));
        }
        return builder.build();
    }

    protected Settings featureFlagSettings() {
        Settings.Builder featureSettings = Settings.builder();
        for (Setting builtInFlag : FeatureFlagSettings.BUILT_IN_FEATURE_FLAGS) {
            featureSettings.put(builtInFlag.getKey(), builtInFlag.getDefaultRaw(Settings.EMPTY));
        }
        featureSettings.put(FeatureFlags.TELEMETRY_SETTING.getKey(), true);
        featureSettings.put(FeatureFlags.APPLICATION_BASED_CONFIGURATION_TEMPLATES_SETTING.getKey(), true);
        return featureSettings.build();
    }

    protected boolean triggerRemoteStateRestore() {
        return false;
    }

    protected void performRemoteStoreTestAction() {
        if (this.triggerRemoteStateRestore()) {
            String clusterUUIDBefore = this.clusterService().state().metadata().clusterUUID();
            OpenSearchIntegTestCase.internalCluster().resetCluster();
            String clusterUUIDAfter = this.clusterService().state().metadata().clusterUUID();
            OpenSearchIntegTestCase.assertFalse((boolean)clusterUUIDBefore.equals(clusterUUIDAfter));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void createIndex(String ... names) {
        ArrayList<String> created = new ArrayList<String>();
        for (String name : names) {
            boolean success = false;
            try {
                OpenSearchAssertions.assertAcked(this.prepareCreate(name));
                created.add(name);
                success = true;
            }
            finally {
                if (!success && !created.isEmpty()) {
                    OpenSearchIntegTestCase.cluster().wipeIndices(created.toArray(new String[0]));
                }
            }
        }
    }

    public final void createIndex(String name, Settings indexSettings) {
        OpenSearchAssertions.assertAcked(this.prepareCreate(name).setSettings(indexSettings));
    }

    public final void createIndex(String name, Settings indexSettings, String mapping) {
        OpenSearchAssertions.assertAcked(this.prepareCreate(name).setSettings(indexSettings).setMapping(mapping));
    }

    public final void createIndex(String name, Context context) {
        OpenSearchAssertions.assertAcked(this.prepareCreate(name).setContext(context));
    }

    public final CreateIndexRequestBuilder prepareCreate(String index) {
        return this.prepareCreate(index, -1);
    }

    public final CreateIndexRequestBuilder prepareCreate(String index, int numNodes) {
        return this.prepareCreate(index, numNodes, Settings.builder());
    }

    public CreateIndexRequestBuilder prepareCreate(String index, Settings.Builder settingsBuilder) {
        return this.prepareCreate(index, -1, settingsBuilder);
    }

    public CreateIndexRequestBuilder prepareCreate(String index, int numNodes, Settings.Builder settingsBuilder) {
        Settings.Builder builder = Settings.builder().put(this.indexSettings()).put(settingsBuilder.build());
        if (numNodes > 0) {
            OpenSearchIntegTestCase.internalCluster().ensureAtLeastNumDataNodes(numNodes);
            this.getExcludeSettings(numNodes, builder);
        }
        return OpenSearchIntegTestCase.client().admin().indices().prepareCreate(index).setSettings(builder.build());
    }

    private Settings.Builder getExcludeSettings(int num, Settings.Builder builder) {
        String exclude = String.join((CharSequence)",", OpenSearchIntegTestCase.internalCluster().allDataNodesButN(num));
        builder.put("index.routing.allocation.exclude._name", exclude);
        return builder;
    }

    public void waitNoPendingTasksOnAll() throws Exception {
        OpenSearchAssertions.assertNoTimeout((ClusterHealthResponse)OpenSearchIntegTestCase.client().admin().cluster().prepareHealth(new String[0]).setWaitForEvents(Priority.LANGUID).get());
        OpenSearchIntegTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            for (Client client : OpenSearchIntegTestCase.clients()) {
                ClusterHealthResponse clusterHealth = (ClusterHealthResponse)((ClusterHealthRequestBuilder)client.admin().cluster().prepareHealth(new String[0]).setLocal(true)).get();
                OpenSearchIntegTestCase.assertThat((String)("client " + String.valueOf(client) + " still has in flight fetch"), (Object)clusterHealth.getNumberOfInFlightFetch(), (Matcher)Matchers.equalTo((Object)0));
                PendingClusterTasksResponse pendingTasks = (PendingClusterTasksResponse)((PendingClusterTasksRequestBuilder)client.admin().cluster().preparePendingClusterTasks().setLocal(true)).get();
                OpenSearchIntegTestCase.assertThat((String)("client " + String.valueOf(client) + " still has pending tasks " + String.valueOf(pendingTasks)), (Object)pendingTasks, (Matcher)Matchers.emptyIterable());
                clusterHealth = (ClusterHealthResponse)((ClusterHealthRequestBuilder)client.admin().cluster().prepareHealth(new String[0]).setLocal(true)).get();
                OpenSearchIntegTestCase.assertThat((String)("client " + String.valueOf(client) + " still has in flight fetch"), (Object)clusterHealth.getNumberOfInFlightFetch(), (Matcher)Matchers.equalTo((Object)0));
            }
        }));
        OpenSearchAssertions.assertNoTimeout((ClusterHealthResponse)OpenSearchIntegTestCase.client().admin().cluster().prepareHealth(new String[0]).setWaitForEvents(Priority.LANGUID).get());
    }

    public void assertResultsAndLogOnFailure(long expectedResults, SearchResponse searchResponse) {
        TotalHits totalHits = searchResponse.getHits().getTotalHits();
        if (totalHits.value() != expectedResults || totalHits.relation() != TotalHits.Relation.EQUAL_TO) {
            StringBuilder sb = new StringBuilder("search result contains [");
            String value = Long.toString(totalHits.value()) + (totalHits.relation() == TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO ? "+" : "");
            sb.append(value).append("] results. expected [").append(expectedResults).append("]");
            String failMsg = sb.toString();
            for (SearchHit hit : searchResponse.getHits().getHits()) {
                sb.append("\n-> _index: [").append(hit.getIndex()).append("] id [").append(hit.getId()).append("]");
            }
            this.logger.warn("{}", (Object)sb);
            OpenSearchIntegTestCase.fail((String)failMsg);
        }
    }

    public void allowNodes(String index, int n) {
        Settings build;
        assert (index != null);
        OpenSearchIntegTestCase.internalCluster().ensureAtLeastNumDataNodes(n);
        Settings.Builder builder = Settings.builder();
        if (n > 0) {
            this.getExcludeSettings(n, builder);
        }
        if (!(build = builder.build()).isEmpty()) {
            this.logger.debug("allowNodes: updating [{}]'s setting to [{}]", (Object)index, (Object)build.toDelimitedString(';'));
            OpenSearchIntegTestCase.client().admin().indices().prepareUpdateSettings(new String[]{index}).setSettings(build).execute().actionGet();
        }
    }

    public ClusterHealthStatus ensureGreen(String ... indices) {
        return this.ensureGreen(TimeValue.timeValueSeconds((long)30L), indices);
    }

    public ClusterHealthStatus ensureGreen(TimeValue timeout, String ... indices) {
        return this.ensureColor(ClusterHealthStatus.GREEN, timeout, false, indices);
    }

    public ClusterHealthStatus ensureGreen(TimeValue timeout, boolean waitForNoRelocatingShards, String ... indices) {
        return this.ensureColor(ClusterHealthStatus.GREEN, timeout, waitForNoRelocatingShards, false, indices);
    }

    public ClusterHealthStatus ensureYellow(String ... indices) {
        return this.ensureColor(ClusterHealthStatus.YELLOW, TimeValue.timeValueSeconds((long)30L), false, indices);
    }

    public ClusterHealthStatus ensureRed(String ... indices) {
        return this.ensureColor(ClusterHealthStatus.RED, TimeValue.timeValueSeconds((long)30L), false, indices);
    }

    public ClusterHealthStatus ensureYellowAndNoInitializingShards(String ... indices) {
        return this.ensureColor(ClusterHealthStatus.YELLOW, TimeValue.timeValueSeconds((long)30L), true, indices);
    }

    private ClusterHealthStatus ensureColor(ClusterHealthStatus clusterHealthStatus, TimeValue timeout, boolean waitForNoInitializingShards, String ... indices) {
        return this.ensureColor(clusterHealthStatus, timeout, true, waitForNoInitializingShards, indices);
    }

    private ClusterHealthStatus ensureColor(ClusterHealthStatus clusterHealthStatus, TimeValue timeout, boolean waitForNoRelocatingShards, boolean waitForNoInitializingShards, String ... indices) {
        String color = clusterHealthStatus.name().toLowerCase(Locale.ROOT);
        String method = "ensure" + Strings.capitalize((String)color);
        ClusterHealthRequest healthRequest = Requests.clusterHealthRequest((String[])indices).timeout(timeout).waitForStatus(clusterHealthStatus).waitForEvents(Priority.LANGUID).waitForNoRelocatingShards(waitForNoRelocatingShards).waitForNoInitializingShards(waitForNoInitializingShards).waitForNodes(Integer.toString(OpenSearchIntegTestCase.cluster().size()));
        ClusterHealthResponse actionGet = (ClusterHealthResponse)OpenSearchIntegTestCase.client().admin().cluster().health(healthRequest).actionGet();
        if (actionGet.isTimedOut()) {
            String hotThreads = ((NodesHotThreadsResponse)OpenSearchIntegTestCase.client().admin().cluster().prepareNodesHotThreads(new String[0]).setThreads(99999).setIgnoreIdleThreads(false).get()).getNodes().stream().map(NodeHotThreads::getHotThreads).collect(Collectors.joining("\n"));
            this.logger.info("{} timed out, cluster state:\n{}\npending tasks:\n{}\nhot threads:\n{}\n", (Object)method, (Object)((ClusterStateResponse)OpenSearchIntegTestCase.client().admin().cluster().prepareState().get()).getState(), (Object)OpenSearchIntegTestCase.client().admin().cluster().preparePendingClusterTasks().get(), (Object)hotThreads);
            OpenSearchIntegTestCase.fail((String)("timed out waiting for " + color + " state"));
        }
        OpenSearchIntegTestCase.assertThat((String)("Expected at least " + String.valueOf(clusterHealthStatus) + " but got " + String.valueOf(actionGet.getStatus())), (Object)actionGet.getStatus().value(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Byte.valueOf(clusterHealthStatus.value())));
        this.logger.debug("indices {} are {}", (Object)(indices.length == 0 ? "[_all]" : indices), (Object)color);
        return actionGet.getStatus();
    }

    public ClusterHealthStatus waitForRelocation() {
        return this.waitForRelocation(null);
    }

    public ClusterHealthStatus waitForRelocation(ClusterHealthStatus status) {
        ClusterHealthResponse actionGet;
        ClusterHealthRequest request = Requests.clusterHealthRequest((String[])new String[0]).waitForNoRelocatingShards(true).waitForEvents(Priority.LANGUID);
        if (status != null) {
            request.waitForStatus(status);
        }
        if ((actionGet = (ClusterHealthResponse)OpenSearchIntegTestCase.client().admin().cluster().health(request).actionGet()).isTimedOut()) {
            this.logger.info("waitForRelocation timed out (status={}), cluster state:\n{}\n{}", (Object)status, (Object)((ClusterStateResponse)OpenSearchIntegTestCase.client().admin().cluster().prepareState().get()).getState(), (Object)OpenSearchIntegTestCase.client().admin().cluster().preparePendingClusterTasks().get());
            OpenSearchIntegTestCase.assertThat((String)"timed out waiting for relocation", (Object)actionGet.isTimedOut(), (Matcher)Matchers.equalTo((Object)false));
        }
        if (status != null) {
            OpenSearchIntegTestCase.assertThat((Object)actionGet.getStatus(), (Matcher)Matchers.equalTo((Object)status));
        }
        return actionGet.getStatus();
    }

    public void waitForDocs(long numDocs, BackgroundIndexer indexer) throws Exception {
        long maxWaitTimeMs = Math.max(90000L, 200L * numDocs);
        OpenSearchIntegTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            long lastKnownCount = indexer.totalIndexedDocs();
            if (lastKnownCount >= numDocs) {
                try {
                    long count = ((SearchResponse)OpenSearchIntegTestCase.client().prepareSearch(new String[0]).setTrackTotalHits(true).setSize(0).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).get()).getHits().getTotalHits().value();
                    if (count == lastKnownCount) {
                        OpenSearchIntegTestCase.client().admin().indices().prepareRefresh(new String[0]).get();
                    }
                    lastKnownCount = count;
                }
                catch (Exception e) {
                    this.logger.debug("failed to executed count", (Throwable)e);
                    throw e;
                }
            }
            if (this.logger.isDebugEnabled()) {
                if (lastKnownCount < numDocs) {
                    this.logger.debug("[{}] docs indexed. waiting for [{}]", (Object)lastKnownCount, (Object)numDocs);
                } else {
                    this.logger.debug("[{}] docs visible for search (needed [{}])", (Object)lastKnownCount, (Object)numDocs);
                }
            }
            OpenSearchIntegTestCase.assertThat((Object)lastKnownCount, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(numDocs)));
        }), maxWaitTimeMs, TimeUnit.MILLISECONDS);
    }

    public void waitForIndexed(long numDocs, BackgroundIndexer indexer) throws Exception {
        long maxWaitTimeMs = Math.max(90000L, 200L * numDocs);
        OpenSearchIntegTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            long lastKnownCount = indexer.totalIndexedDocs();
            OpenSearchIntegTestCase.assertThat((Object)lastKnownCount, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(numDocs)));
        }), maxWaitTimeMs, TimeUnit.MILLISECONDS);
    }

    public void logClusterState() {
        this.logger.debug("cluster state:\n{}\n{}", (Object)((ClusterStateResponse)OpenSearchIntegTestCase.client().admin().cluster().prepareState().get()).getState(), (Object)OpenSearchIntegTestCase.client().admin().cluster().preparePendingClusterTasks().get());
    }

    protected void ensureClusterSizeConsistency() {
        if (OpenSearchIntegTestCase.cluster() != null && OpenSearchIntegTestCase.cluster().size() > 0) {
            this.logger.trace("Check consistency for [{}] nodes", (Object)OpenSearchIntegTestCase.cluster().size());
            OpenSearchAssertions.assertNoTimeout((ClusterHealthResponse)OpenSearchIntegTestCase.client().admin().cluster().prepareHealth(new String[0]).setWaitForNodes(Integer.toString(OpenSearchIntegTestCase.cluster().size())).get());
        }
    }

    protected void ensureClusterStateConsistency() throws IOException {
        if (OpenSearchIntegTestCase.cluster() != null && OpenSearchIntegTestCase.cluster().size() > 0) {
            NamedWriteableRegistry namedWriteableRegistry = OpenSearchIntegTestCase.cluster().getNamedWriteableRegistry();
            Client clusterManagerClient = OpenSearchIntegTestCase.client();
            ClusterState clusterManagerClusterState = ((ClusterStateResponse)clusterManagerClient.admin().cluster().prepareState().all().get()).getState();
            byte[] masterClusterStateBytes = ClusterState.Builder.toBytes((ClusterState)clusterManagerClusterState);
            clusterManagerClusterState = ClusterState.Builder.fromBytes((byte[])masterClusterStateBytes, null, (NamedWriteableRegistry)namedWriteableRegistry);
            Map<String, Object> clusterManagerStateMap = XContentTestUtils.convertToMap((ToXContent)clusterManagerClusterState);
            int clusterManagerClusterStateSize = clusterManagerClusterState.toString().length();
            String clusterManagerId = clusterManagerClusterState.nodes().getClusterManagerNodeId();
            for (Client client : OpenSearchIntegTestCase.cluster().getClients()) {
                ClusterState localClusterState = ((ClusterStateResponse)((ClusterStateRequestBuilder)client.admin().cluster().prepareState().all().setLocal(true)).get()).getState();
                byte[] localClusterStateBytes = ClusterState.Builder.toBytes((ClusterState)localClusterState);
                localClusterState = ClusterState.Builder.fromBytes((byte[])localClusterStateBytes, null, (NamedWriteableRegistry)namedWriteableRegistry);
                Map<String, Object> localStateMap = XContentTestUtils.convertToMap((ToXContent)localClusterState);
                int localClusterStateSize = localClusterState.toString().length();
                if (clusterManagerClusterState.version() != localClusterState.version() || !clusterManagerId.equals(localClusterState.nodes().getClusterManagerNodeId())) continue;
                try {
                    OpenSearchIntegTestCase.assertEquals((String)"cluster state UUID does not match", (Object)clusterManagerClusterState.stateUUID(), (Object)localClusterState.stateUUID());
                    OpenSearchIntegTestCase.assertEquals((String)"cluster state size does not match", (long)clusterManagerClusterStateSize, (long)localClusterStateSize);
                    OpenSearchIntegTestCase.assertNull((String)"cluster state JSON serialization does not match", (Object)XContentTestUtils.differenceBetweenMapsIgnoringArrayOrder(clusterManagerStateMap, localStateMap));
                }
                catch (AssertionError error) {
                    this.logger.error("Cluster state from cluster-manager:\n{}\nLocal cluster state:\n{}", (Object)clusterManagerClusterState.toString(), (Object)localClusterState.toString());
                    throw error;
                }
            }
        }
    }

    protected void ensureClusterStateCanBeReadByNodeTool() throws IOException {
        if (OpenSearchIntegTestCase.cluster() != null && OpenSearchIntegTestCase.cluster().size() > 0) {
            Metadata loadedMetadata;
            Client clusterManagerClient = OpenSearchIntegTestCase.client();
            Metadata metadata = ((ClusterStateResponse)clusterManagerClient.admin().cluster().prepareState().all().get()).getState().metadata();
            HashMap<String, String> serializationParams = new HashMap<String, String>(2);
            serializationParams.put("binary", "true");
            serializationParams.put("context_mode", Metadata.CONTEXT_MODE_GATEWAY);
            ToXContent.MapParams serializationFormatParams = new ToXContent.MapParams(serializationParams);
            HashMap<String, String> compareParams = new HashMap<String, String>(2);
            compareParams.put("context_mode", Metadata.CONTEXT_MODE_GATEWAY);
            ToXContent.MapParams compareFormatParams = new ToXContent.MapParams(compareParams);
            Metadata metadataWithoutIndices = Metadata.builder((Metadata)metadata).removeAllIndices().build();
            XContentBuilder builder = SmileXContent.contentBuilder();
            builder.startObject();
            metadataWithoutIndices.toXContent(builder, (ToXContent.Params)serializationFormatParams);
            builder.endObject();
            BytesReference originalBytes = BytesReference.bytes((XContentBuilder)builder);
            XContentBuilder compareBuilder = SmileXContent.contentBuilder();
            compareBuilder.startObject();
            metadataWithoutIndices.toXContent(compareBuilder, (ToXContent.Params)compareFormatParams);
            compareBuilder.endObject();
            BytesReference compareOriginalBytes = BytesReference.bytes((XContentBuilder)compareBuilder);
            try (XContentParser parser = this.createParser(OpenSearchNodeCommand.namedXContentRegistry, (XContent)SmileXContent.smileXContent, originalBytes);){
                loadedMetadata = Metadata.fromXContent((XContentParser)parser);
            }
            builder = SmileXContent.contentBuilder();
            builder.startObject();
            loadedMetadata.toXContent(builder, (ToXContent.Params)compareFormatParams);
            builder.endObject();
            BytesReference parsedBytes = BytesReference.bytes((XContentBuilder)builder);
            OpenSearchIntegTestCase.assertNull((String)("cluster state XContent serialization does not match, expected " + String.valueOf(XContentHelper.convertToMap((BytesReference)compareOriginalBytes, (boolean)false, (XContentType)XContentType.SMILE)) + " but got " + String.valueOf(XContentHelper.convertToMap((BytesReference)parsedBytes, (boolean)false, (XContentType)XContentType.SMILE))), (Object)XContentTestUtils.differenceBetweenMapsIgnoringArrayOrder((Map)XContentHelper.convertToMap((BytesReference)compareOriginalBytes, (boolean)false, (XContentType)XContentType.SMILE).v2(), (Map)XContentHelper.convertToMap((BytesReference)parsedBytes, (boolean)false, (XContentType)XContentType.SMILE).v2()));
            for (IndexMetadata indexMetadata : metadata) {
                IndexMetadata loadedIndexMetadata;
                XContentBuilder builder2 = SmileXContent.contentBuilder();
                builder2.startObject();
                indexMetadata.toXContent(builder2, (ToXContent.Params)serializationFormatParams);
                builder2.endObject();
                BytesReference originalBytes2 = BytesReference.bytes((XContentBuilder)builder2);
                XContentBuilder compareBuilder2 = SmileXContent.contentBuilder();
                compareBuilder2.startObject();
                indexMetadata.toXContent(compareBuilder2, (ToXContent.Params)compareFormatParams);
                compareBuilder2.endObject();
                BytesReference compareOriginalBytes2 = BytesReference.bytes((XContentBuilder)compareBuilder2);
                try (XContentParser parser = this.createParser(OpenSearchNodeCommand.namedXContentRegistry, (XContent)SmileXContent.smileXContent, originalBytes2);){
                    loadedIndexMetadata = IndexMetadata.fromXContent((XContentParser)parser);
                }
                builder2 = SmileXContent.contentBuilder();
                builder2.startObject();
                loadedIndexMetadata.toXContent(builder2, (ToXContent.Params)compareFormatParams);
                builder2.endObject();
                BytesReference parsedBytes2 = BytesReference.bytes((XContentBuilder)builder2);
                OpenSearchIntegTestCase.assertNull((String)("cluster state XContent serialization does not match, expected " + String.valueOf(XContentHelper.convertToMap((BytesReference)compareOriginalBytes2, (boolean)false, (XContentType)XContentType.SMILE)) + " but got " + String.valueOf(XContentHelper.convertToMap((BytesReference)parsedBytes2, (boolean)false, (XContentType)XContentType.SMILE))), (Object)XContentTestUtils.differenceBetweenMapsIgnoringArrayOrder((Map)XContentHelper.convertToMap((BytesReference)compareOriginalBytes2, (boolean)false, (XContentType)XContentType.SMILE).v2(), (Map)XContentHelper.convertToMap((BytesReference)parsedBytes2, (boolean)false, (XContentType)XContentType.SMILE).v2()));
            }
        }
    }

    protected ClusterHealthStatus ensureSearchable(String ... indices) {
        return this.ensureGreen(indices);
    }

    protected void ensureStableCluster(int nodeCount) {
        this.ensureStableCluster(nodeCount, TimeValue.timeValueSeconds((long)30L));
    }

    protected void ensureStableCluster(int nodeCount, TimeValue timeValue) {
        this.ensureStableCluster(nodeCount, timeValue, false, null);
    }

    protected void ensureStableCluster(int nodeCount, @Nullable String viaNode) {
        this.ensureStableCluster(nodeCount, TimeValue.timeValueSeconds((long)30L), false, viaNode);
    }

    protected void ensureStableCluster(int nodeCount, TimeValue timeValue, boolean local, @Nullable String viaNode) {
        if (viaNode == null) {
            viaNode = OpenSearchIntegTestCase.randomFrom(OpenSearchIntegTestCase.internalCluster().getNodeNames());
        }
        this.logger.debug("ensuring cluster is stable with [{}] nodes. access node: [{}]. timeout: [{}]", (Object)nodeCount, (Object)viaNode, (Object)timeValue);
        ClusterHealthResponse clusterHealthResponse = (ClusterHealthResponse)((ClusterHealthRequestBuilder)OpenSearchIntegTestCase.client(viaNode).admin().cluster().prepareHealth(new String[0]).setWaitForEvents(Priority.LANGUID).setWaitForNodes(Integer.toString(nodeCount)).setTimeout(timeValue).setLocal(local)).setWaitForNoRelocatingShards(true).get();
        if (clusterHealthResponse.isTimedOut()) {
            ClusterStateResponse stateResponse = (ClusterStateResponse)OpenSearchIntegTestCase.client(viaNode).admin().cluster().prepareState().get();
            OpenSearchIntegTestCase.fail((String)("failed to reach a stable cluster of [" + nodeCount + "] nodes. Tried via [" + viaNode + "]. last cluster state:\n" + String.valueOf(stateResponse.getState())));
        }
        OpenSearchIntegTestCase.assertThat((Object)clusterHealthResponse.isTimedOut(), (Matcher)Matchers.is((Object)false));
        this.ensureFullyConnectedCluster();
    }

    protected void ensureFullyConnectedCluster() {
        NetworkDisruption.ensureFullyConnectedCluster(OpenSearchIntegTestCase.internalCluster());
    }

    @Deprecated
    protected final IndexResponse index(String index, String type, XContentBuilder source) {
        return (IndexResponse)OpenSearchIntegTestCase.client().prepareIndex(index).setSource(source).execute().actionGet();
    }

    protected final IndexResponse index(String index, String type, String id, Map<String, Object> source) {
        return (IndexResponse)OpenSearchIntegTestCase.client().prepareIndex(index).setId(id).setSource(source).execute().actionGet();
    }

    @Deprecated
    protected final IndexResponse index(String index, String type, String id, XContentBuilder source) {
        return (IndexResponse)OpenSearchIntegTestCase.client().prepareIndex(index).setId(id).setSource(source).execute().actionGet();
    }

    @Deprecated
    protected final IndexResponse index(String index, String type, String id, Object ... source) {
        return (IndexResponse)OpenSearchIntegTestCase.client().prepareIndex(index).setId(id).setSource(source).execute().actionGet();
    }

    @Deprecated
    protected final IndexResponse index(String index, String type, String id, String source) {
        return (IndexResponse)OpenSearchIntegTestCase.client().prepareIndex(index).setId(id).setSource(source, MediaTypeRegistry.JSON).execute().actionGet();
    }

    protected final RefreshResponse refresh(String ... indices) {
        this.waitForRelocation();
        RefreshResponse actionGet = (RefreshResponse)((RefreshRequestBuilder)OpenSearchIntegTestCase.client().admin().indices().prepareRefresh(indices).setIndicesOptions(IndicesOptions.STRICT_EXPAND_OPEN_HIDDEN_FORBID_CLOSED)).execute().actionGet();
        OpenSearchAssertions.assertNoFailures((BroadcastResponse)actionGet);
        return actionGet;
    }

    protected final void flushAndRefresh(String ... indices) {
        this.flush(indices);
        this.refresh(indices);
    }

    protected final FlushResponse flush(String ... indices) {
        this.waitForRelocation();
        FlushResponse actionGet = (FlushResponse)OpenSearchIntegTestCase.client().admin().indices().prepareFlush(indices).execute().actionGet();
        for (DefaultShardOperationFailedException failure : actionGet.getShardFailures()) {
            OpenSearchIntegTestCase.assertThat((String)("unexpected flush failure " + failure.reason()), (Object)failure.status(), (Matcher)Matchers.equalTo((Object)RestStatus.SERVICE_UNAVAILABLE));
        }
        return actionGet;
    }

    protected ForceMergeResponse forceMerge() {
        this.waitForRelocation();
        ForceMergeResponse actionGet = (ForceMergeResponse)OpenSearchIntegTestCase.client().admin().indices().prepareForceMerge(new String[0]).setMaxNumSegments(1).execute().actionGet();
        OpenSearchAssertions.assertNoFailures((BroadcastResponse)actionGet);
        return actionGet;
    }

    protected ForceMergeResponse forceMerge(int maxNumSegments) {
        this.waitForRelocation();
        ForceMergeResponse actionGet = (ForceMergeResponse)OpenSearchIntegTestCase.client().admin().indices().prepareForceMerge(new String[0]).setMaxNumSegments(maxNumSegments).execute().actionGet();
        OpenSearchAssertions.assertNoFailures((BroadcastResponse)actionGet);
        return actionGet;
    }

    protected static boolean indexExists(String index) {
        IndicesExistsResponse actionGet = (IndicesExistsResponse)OpenSearchIntegTestCase.client().admin().indices().prepareExists(new String[]{index}).execute().actionGet();
        return actionGet.isExists();
    }

    protected final void enableAllocation(String ... indices) {
        OpenSearchIntegTestCase.client().admin().indices().prepareUpdateSettings(indices).setSettings(Settings.builder().put(EnableAllocationDecider.INDEX_ROUTING_ALLOCATION_ENABLE_SETTING.getKey(), "all")).get();
    }

    protected final void disableAllocation(String ... indices) {
        OpenSearchIntegTestCase.client().admin().indices().prepareUpdateSettings(indices).setSettings(Settings.builder().put(EnableAllocationDecider.INDEX_ROUTING_ALLOCATION_ENABLE_SETTING.getKey(), "none")).get();
    }

    protected AdminClient admin() {
        return OpenSearchIntegTestCase.client().admin();
    }

    protected ClusterAdminClient clusterAdmin() {
        return this.admin().cluster();
    }

    public void indexRandom(boolean forceRefresh, IndexRequestBuilder ... builders) throws InterruptedException {
        this.indexRandom(forceRefresh, Arrays.asList(builders));
    }

    public void indexRandom(boolean forceRefresh, boolean dummyDocuments, IndexRequestBuilder ... builders) throws InterruptedException {
        this.indexRandom(forceRefresh, dummyDocuments, Arrays.asList(builders));
    }

    public void indexRandom(boolean forceRefresh, List<IndexRequestBuilder> builders) throws InterruptedException {
        this.indexRandom(forceRefresh, forceRefresh, builders);
    }

    public void indexRandom(boolean forceRefresh, boolean dummyDocuments, List<IndexRequestBuilder> builders) throws InterruptedException {
        this.indexRandom(forceRefresh, dummyDocuments, true, builders);
    }

    public void indexRandom(boolean forceRefresh, boolean dummyDocuments, boolean maybeFlush, List<IndexRequestBuilder> builders) throws InterruptedException {
        Random random = OpenSearchIntegTestCase.random();
        HashSet<String> indices = new HashSet<String>();
        for (IndexRequestBuilder builder : builders) {
            indices.add(((IndexRequest)builder.request()).index());
        }
        HashSet<List<String>> bogusIds = new HashSet<List<String>>();
        if (random.nextBoolean() && !builders.isEmpty() && dummyDocuments) {
            builders = new ArrayList<IndexRequestBuilder>(builders);
            int numBogusDocs = OpenSearchIntegTestCase.scaledRandomIntBetween(1, builders.size() * 2);
            int unicodeLen = OpenSearchIntegTestCase.between(1, 10);
            for (int i = 0; i < numBogusDocs; ++i) {
                Iterator<IndexRequestBuilder> id = "bogus_doc_" + OpenSearchIntegTestCase.randomRealisticUnicodeOfLength(unicodeLen) + this.dummmyDocIdGenerator.incrementAndGet();
                String string = (String)RandomPicks.randomFrom((Random)random, indices);
                bogusIds.add(Arrays.asList(string, id));
                builders.add(((IndexRequestBuilder)OpenSearchIntegTestCase.client().prepareIndex().setIndex(string)).setId(id).setSource("{}", MediaTypeRegistry.JSON).setRouting(id));
            }
        }
        Collections.shuffle(builders, OpenSearchIntegTestCase.random());
        CopyOnWriteArrayList errors = new CopyOnWriteArrayList();
        ArrayList<CountDownLatch> inFlightAsyncOperations = new ArrayList<CountDownLatch>();
        String[] indicesArray = indices.toArray(new String[0]);
        if (builders.size() < 300 ? OpenSearchIntegTestCase.frequently() : builders.size() < 3000 && OpenSearchIntegTestCase.rarely()) {
            if (OpenSearchIntegTestCase.frequently()) {
                this.logger.info("Index [{}] docs async: [{}] bulk: [{}]", (Object)builders.size(), (Object)true, (Object)false);
                for (IndexRequestBuilder indexRequestBuilder : builders) {
                    indexRequestBuilder.execute(new PayloadLatchedActionListener(this, indexRequestBuilder, OpenSearchIntegTestCase.newLatch(inFlightAsyncOperations), errors));
                    this.postIndexAsyncActions(indicesArray, inFlightAsyncOperations, maybeFlush);
                }
            } else {
                this.logger.info("Index [{}] docs async: [{}] bulk: [{}]", (Object)builders.size(), (Object)false, (Object)false);
                for (IndexRequestBuilder indexRequestBuilder : builders) {
                    indexRequestBuilder.execute().actionGet();
                    this.postIndexAsyncActions(indicesArray, inFlightAsyncOperations, maybeFlush);
                }
            }
        } else {
            List partition = CollectionUtils.eagerPartition(builders, (int)Math.min(1000, Math.max(1, (int)((double)builders.size() * OpenSearchIntegTestCase.randomDouble()))));
            this.logger.info("Index [{}] docs async: [{}] bulk: [{}] partitions [{}]", (Object)builders.size(), (Object)false, (Object)true, (Object)partition.size());
            Iterator iterator = partition.iterator();
            while (iterator.hasNext()) {
                List list = (List)iterator.next();
                BulkRequestBuilder bulkBuilder = OpenSearchIntegTestCase.client().prepareBulk();
                for (IndexRequestBuilder indexRequestBuilder2 : list) {
                    indexRequestBuilder2.setRefreshPolicy(WriteRequest.RefreshPolicy.NONE);
                    bulkBuilder.add(indexRequestBuilder2);
                }
                BulkResponse actionGet = (BulkResponse)bulkBuilder.execute().actionGet();
                OpenSearchIntegTestCase.assertThat((String)(actionGet.hasFailures() ? actionGet.buildFailureMessage() : ""), (Object)actionGet.hasFailures(), (Matcher)Matchers.equalTo((Object)false));
            }
        }
        for (CountDownLatch countDownLatch : inFlightAsyncOperations) {
            countDownLatch.await();
        }
        ArrayList<Exception> actualErrors = new ArrayList<Exception>();
        for (Tuple tuple : errors) {
            Throwable t = ExceptionsHelper.unwrapCause((Throwable)((Throwable)tuple.v2()));
            if (t instanceof OpenSearchRejectedExecutionException) {
                this.logger.debug("Error indexing doc: " + t.getMessage() + ", reindexing.");
                ((IndexRequestBuilder)tuple.v1()).execute().actionGet();
                continue;
            }
            actualErrors.add((Exception)tuple.v2());
        }
        OpenSearchIntegTestCase.assertThat(actualErrors, (Matcher)Matchers.emptyIterable());
        if (!bogusIds.isEmpty()) {
            for (List list : bogusIds) {
                OpenSearchIntegTestCase.assertEquals((String)("failed to delete a dummy doc [" + (String)list.get(0) + "][" + (String)list.get(1) + "]"), (Object)DocWriteResponse.Result.DELETED, (Object)((DeleteResponse)OpenSearchIntegTestCase.client().prepareDelete((String)list.get(0), (String)list.get(1)).setRouting((String)list.get(1)).get()).getResult());
            }
        }
        if (forceRefresh) {
            OpenSearchAssertions.assertNoFailures((BroadcastResponse)((RefreshRequestBuilder)OpenSearchIntegTestCase.client().admin().indices().prepareRefresh(indicesArray).setIndicesOptions(IndicesOptions.lenientExpandOpen())).get());
        }
        if (dummyDocuments) {
            this.indexRandomForMultipleSlices(indicesArray);
        }
        if (forceRefresh) {
            this.waitForReplication(new String[0]);
        }
    }

    protected void indexRandomForMultipleSlices(String ... indices) throws InterruptedException {
        HashSet<List<String>> bogusIds = new HashSet<List<String>>();
        int refreshCount = OpenSearchIntegTestCase.randomIntBetween(2, 3);
        for (String index : indices) {
            int numDocs = this.getNumShards((String)index).totalNumShards * OpenSearchIntegTestCase.randomIntBetween(2, 10);
            while (refreshCount-- > 0) {
                CopyOnWriteArrayList errors = new CopyOnWriteArrayList();
                ArrayList<CountDownLatch> inFlightAsyncOperations = new ArrayList<CountDownLatch>();
                for (int i = 0; i < numDocs; ++i) {
                    String id = "bogus_doc_" + OpenSearchIntegTestCase.randomRealisticUnicodeOfLength(OpenSearchIntegTestCase.between(1, 10)) + this.dummmyDocIdGenerator.incrementAndGet();
                    IndexRequestBuilder indexRequestBuilder = ((IndexRequestBuilder)OpenSearchIntegTestCase.client().prepareIndex().setIndex(index)).setId(id).setSource("{}", MediaTypeRegistry.JSON).setRouting(id);
                    indexRequestBuilder.execute(new PayloadLatchedActionListener(this, indexRequestBuilder, OpenSearchIntegTestCase.newLatch(inFlightAsyncOperations), errors));
                    bogusIds.add(Arrays.asList(index, id));
                }
                for (CountDownLatch operation : inFlightAsyncOperations) {
                    operation.await();
                }
                ArrayList<Exception> actualErrors = new ArrayList<Exception>();
                for (Tuple tuple : errors) {
                    Throwable t = ExceptionsHelper.unwrapCause((Throwable)((Throwable)tuple.v2()));
                    if (t instanceof OpenSearchRejectedExecutionException) {
                        this.logger.debug("Error indexing doc: " + t.getMessage() + ", reindexing.");
                        ((IndexRequestBuilder)tuple.v1()).execute().actionGet();
                        continue;
                    }
                    actualErrors.add((Exception)tuple.v2());
                }
                OpenSearchIntegTestCase.assertThat(actualErrors, (Matcher)Matchers.emptyIterable());
                this.refresh(index);
            }
        }
        for (List list : bogusIds) {
            OpenSearchIntegTestCase.assertEquals((String)("failed to delete a dummy doc [" + (String)list.get(0) + "][" + (String)list.get(1) + "]"), (Object)DocWriteResponse.Result.DELETED, (Object)((DeleteResponse)OpenSearchIntegTestCase.client().prepareDelete((String)list.get(0), (String)list.get(1)).setRouting((String)list.get(1)).get()).getResult());
        }
        this.refresh(new String[0]);
    }

    public static void disableIndexBlock(String index, String block) {
        Settings settings = Settings.builder().put(block, false).build();
        OpenSearchIntegTestCase.client().admin().indices().prepareUpdateSettings(new String[]{index}).setSettings(settings).get();
    }

    public static void enableIndexBlock(String index, String block) {
        if (IndexMetadata.APIBlock.fromSetting((String)block) == IndexMetadata.APIBlock.READ_ONLY_ALLOW_DELETE || OpenSearchIntegTestCase.randomBoolean()) {
            Settings settings = Settings.builder().put(block, true).build();
            OpenSearchIntegTestCase.client().admin().indices().prepareUpdateSettings(new String[]{index}).setSettings(settings).get();
        } else {
            OpenSearchIntegTestCase.client().admin().indices().prepareAddBlock(IndexMetadata.APIBlock.fromSetting((String)block), new String[]{index}).get();
        }
    }

    public static void setClusterReadOnly(boolean value) {
        Settings settings = value ? Settings.builder().put(Metadata.SETTING_READ_ONLY_SETTING.getKey(), value).build() : Settings.builder().putNull(Metadata.SETTING_READ_ONLY_SETTING.getKey()).build();
        OpenSearchAssertions.assertAcked((AcknowledgedResponse)OpenSearchIntegTestCase.client().admin().cluster().prepareUpdateSettings().setTransientSettings(settings).get());
    }

    private static CountDownLatch newLatch(List<CountDownLatch> latches) {
        CountDownLatch l = new CountDownLatch(1);
        latches.add(l);
        return l;
    }

    private void postIndexAsyncActions(String[] indices, List<CountDownLatch> inFlightAsyncOperations, boolean maybeFlush) throws InterruptedException {
        if (OpenSearchIntegTestCase.rarely()) {
            if (OpenSearchIntegTestCase.rarely()) {
                ((RefreshRequestBuilder)OpenSearchIntegTestCase.client().admin().indices().prepareRefresh(indices).setIndicesOptions(IndicesOptions.lenientExpandOpen())).execute(new LatchedActionListener(OpenSearchIntegTestCase.newLatch(inFlightAsyncOperations)));
            } else if (maybeFlush && OpenSearchIntegTestCase.rarely()) {
                ((FlushRequestBuilder)OpenSearchIntegTestCase.client().admin().indices().prepareFlush(indices).setIndicesOptions(IndicesOptions.lenientExpandOpen())).execute(new LatchedActionListener(OpenSearchIntegTestCase.newLatch(inFlightAsyncOperations)));
            } else if (OpenSearchIntegTestCase.rarely()) {
                ((ForceMergeRequestBuilder)OpenSearchIntegTestCase.client().admin().indices().prepareForceMerge(indices).setIndicesOptions(IndicesOptions.lenientExpandOpen())).setMaxNumSegments(OpenSearchIntegTestCase.between(1, 10)).setFlush(maybeFlush && OpenSearchIntegTestCase.randomBoolean()).execute(new LatchedActionListener(OpenSearchIntegTestCase.newLatch(inFlightAsyncOperations)));
            }
        }
        while (inFlightAsyncOperations.size() > 150) {
            int waitFor = OpenSearchIntegTestCase.between(0, inFlightAsyncOperations.size() - 1);
            inFlightAsyncOperations.remove(waitFor).await();
        }
    }

    public void clearScroll(String ... scrollIds) {
        ClearScrollResponse clearResponse = (ClearScrollResponse)OpenSearchIntegTestCase.client().prepareClearScroll().setScrollIds(Arrays.asList(scrollIds)).get();
        OpenSearchIntegTestCase.assertThat((Object)clearResponse.isSucceeded(), (Matcher)Matchers.equalTo((Object)true));
    }

    static <A extends Annotation> A getAnnotation(Class<?> clazz, Class<A> annotationClass) {
        if (clazz == Object.class || clazz == OpenSearchIntegTestCase.class) {
            return null;
        }
        A annotation = clazz.getAnnotation(annotationClass);
        if (annotation != null) {
            return annotation;
        }
        return OpenSearchIntegTestCase.getAnnotation(clazz.getSuperclass(), annotationClass);
    }

    private boolean getSupportsDedicatedClusterManagers() {
        ClusterScope annotation = OpenSearchIntegTestCase.getAnnotation(((Object)((Object)this)).getClass(), ClusterScope.class);
        return annotation == null ? true : annotation.supportsDedicatedMasters();
    }

    private boolean getAutoManageClusterManagerNodes() {
        ClusterScope annotation = OpenSearchIntegTestCase.getAnnotation(((Object)((Object)this)).getClass(), ClusterScope.class);
        return annotation == null ? true : annotation.autoManageMasterNodes();
    }

    private int getNumDataNodes() {
        ClusterScope annotation = OpenSearchIntegTestCase.getAnnotation(((Object)((Object)this)).getClass(), ClusterScope.class);
        return annotation == null ? -1 : annotation.numDataNodes();
    }

    private int getMinNumDataNodes() {
        ClusterScope annotation = OpenSearchIntegTestCase.getAnnotation(((Object)((Object)this)).getClass(), ClusterScope.class);
        return annotation == null || annotation.minNumDataNodes() == -1 ? 1 : annotation.minNumDataNodes();
    }

    private int getMaxNumDataNodes() {
        ClusterScope annotation = OpenSearchIntegTestCase.getAnnotation(((Object)((Object)this)).getClass(), ClusterScope.class);
        return annotation == null || annotation.maxNumDataNodes() == -1 ? InternalTestCluster.DEFAULT_MAX_NUM_DATA_NODES : annotation.maxNumDataNodes();
    }

    private int getNumClientNodes() {
        ClusterScope annotation = OpenSearchIntegTestCase.getAnnotation(((Object)((Object)this)).getClass(), ClusterScope.class);
        return annotation == null ? -1 : annotation.numClientNodes();
    }

    protected Settings nodeSettings(int nodeOrdinal) {
        Settings featureFlagSettings = this.featureFlagSettings();
        Settings.Builder builder = Settings.builder().put(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_LOW_DISK_WATERMARK_SETTING.getKey(), "1b").put(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_WATERMARK_SETTING.getKey(), "1b").put(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_WATERMARK_SETTING.getKey(), "1b").put(IndicesQueryCache.INDICES_QUERIES_CACHE_ALL_SEGMENTS_SETTING.getKey(), nodeOrdinal % 2 == 0).put(IndicesStore.INDICES_STORE_DELETE_SHARD_TIMEOUT.getKey(), new TimeValue(1L, TimeUnit.SECONDS)).put(SearchService.LOW_LEVEL_CANCELLATION_SETTING.getKey(), OpenSearchIntegTestCase.randomBoolean()).putList(SettingsBasedSeedHostsProvider.DISCOVERY_SEED_HOSTS_SETTING.getKey(), new String[0]).putList(DiscoveryModule.DISCOVERY_SEED_PROVIDERS_SETTING.getKey(), new String[]{"file"}).put("search.concurrent.max_slice_count", 2).put(this.featureFlagSettings());
        if (this.featureFlagSettings().getAsBoolean(FeatureFlags.TELEMETRY_SETTING.getKey(), Boolean.valueOf(false)).booleanValue()) {
            builder.put(TelemetrySettings.TRACER_FEATURE_ENABLED_SETTING.getKey(), true);
            builder.put(TelemetrySettings.TRACER_ENABLED_SETTING.getKey(), true);
        }
        if (this.useRandomReplicationStrategy()) {
            if (this.randomReplicationType.equals((Object)ReplicationType.SEGMENT) && this.randomStorageType.equals("REMOTE_STORE")) {
                this.logger.info("Randomly using Replication Strategy as {} and Storage Type as {}.", (Object)this.randomReplicationType, (Object)this.randomStorageType);
                if (this.remoteStoreRepositoryPath == null) {
                    this.remoteStoreRepositoryPath = this.randomRepoPath().toAbsolutePath();
                }
                builder.put(OpenSearchIntegTestCase.remoteStoreClusterSettings(REMOTE_BACKED_STORAGE_REPOSITORY_NAME, this.remoteStoreRepositoryPath));
            } else {
                this.logger.info("Randomly using Replication Strategy as {} and Storage Type as {}.", (Object)this.randomReplicationType, (Object)this.randomStorageType);
                builder.put(IndicesService.CLUSTER_REPLICATION_TYPE_SETTING.getKey(), (Enum)this.randomReplicationType);
            }
        }
        return builder.build();
    }

    protected boolean useRandomReplicationStrategy() {
        return false;
    }

    protected Path nodeConfigPath(int nodeOrdinal) {
        return null;
    }

    protected Collection<Class<? extends Plugin>> nodePlugins() {
        return Collections.emptyList();
    }

    protected Collection<PluginInfo> additionalNodePlugins() {
        return Collections.emptyList();
    }

    private ExternalTestCluster buildExternalCluster(String clusterAddresses, String clusterName) throws IOException {
        String[] stringAddresses = clusterAddresses.split(",");
        TransportAddress[] transportAddresses = new TransportAddress[stringAddresses.length];
        int i = 0;
        for (String stringAddress : stringAddresses) {
            URL url = new URL("http://" + stringAddress);
            InetAddress inetAddress = InetAddress.getByName(url.getHost());
            transportAddresses[i++] = new TransportAddress(new InetSocketAddress(inetAddress, url.getPort()));
        }
        return new ExternalTestCluster(OpenSearchIntegTestCase.createTempDir(), this.externalClusterClientSettings(), this.getClientWrapper(), clusterName, this.nodePlugins(), transportAddresses);
    }

    protected Settings externalClusterClientSettings() {
        return Settings.EMPTY;
    }

    protected boolean ignoreExternalCluster() {
        return false;
    }

    protected TestCluster buildTestCluster(Scope scope, long seed) throws IOException {
        int minNumDataNodes;
        int maxNumDataNodes;
        String clusterAddresses;
        if (this.useRandomReplicationStrategy()) {
            ReplicationType replicationType = this.randomReplicationType = OpenSearchIntegTestCase.randomBoolean() ? ReplicationType.DOCUMENT : ReplicationType.SEGMENT;
            this.randomStorageType = this.randomReplicationType.equals((Object)ReplicationType.SEGMENT) ? (OpenSearchIntegTestCase.randomBoolean() ? "REMOTE_STORE" : "LOCAL") : "LOCAL";
        }
        if (Strings.hasLength((String)(clusterAddresses = System.getProperty(TESTS_CLUSTER))) && !this.ignoreExternalCluster()) {
            if (scope == Scope.TEST) {
                throw new IllegalArgumentException("Cannot run TEST scope test with tests.cluster");
            }
            String clusterName = System.getProperty(TESTS_CLUSTER_NAME);
            if (Strings.isNullOrEmpty((String)clusterName)) {
                throw new IllegalArgumentException("Missing tests.clustername system property");
            }
            return this.buildExternalCluster(clusterAddresses, clusterName);
        }
        String nodePrefix = switch (scope.ordinal()) {
            case 1 -> TEST_CLUSTER_NODE_PREFIX;
            case 0 -> SUITE_CLUSTER_NODE_PREFIX;
            default -> throw new OpenSearchException("Scope not supported: " + String.valueOf((Object)scope), new Object[0]);
        };
        boolean supportsDedicatedClusterManagers = this.getSupportsDedicatedClusterManagers();
        int numDataNodes = this.getNumDataNodes();
        if (numDataNodes >= 0) {
            minNumDataNodes = maxNumDataNodes = numDataNodes;
        } else {
            minNumDataNodes = this.getMinNumDataNodes();
            maxNumDataNodes = this.getMaxNumDataNodes();
        }
        Collection<Class<? extends Plugin>> mockPlugins = this.getMockPlugins();
        NodeConfigurationSource nodeConfigurationSource = this.getNodeConfigSource();
        if (this.addMockTransportService()) {
            ArrayList<Class<? extends Plugin>> mocks = new ArrayList<Class<? extends Plugin>>(mockPlugins);
            if (!mockPlugins.contains(OpenSearchIntegTestCase.getTestTransportPlugin())) {
                mocks.add(OpenSearchIntegTestCase.getTestTransportPlugin());
            }
            mockPlugins = mocks;
        }
        return new InternalTestCluster(seed, OpenSearchIntegTestCase.createTempDir(), supportsDedicatedClusterManagers, this.getAutoManageClusterManagerNodes(), minNumDataNodes, maxNumDataNodes, InternalTestCluster.clusterName(scope.name(), seed) + "-cluster", nodeConfigurationSource, this.getNumClientNodes(), nodePrefix, mockPlugins, this.getClientWrapper(), this.forbidPrivateIndexSettings());
    }

    private NodeConfigurationSource getNodeConfigSource() {
        final Settings.Builder initialNodeSettings = Settings.builder();
        if (this.addMockTransportService()) {
            initialNodeSettings.put("transport.type", OpenSearchIntegTestCase.getTestTransportType());
        }
        return new NodeConfigurationSource(this){
            final /* synthetic */ OpenSearchIntegTestCase this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Settings nodeSettings(int nodeOrdinal) {
                return Settings.builder().put(initialNodeSettings.build()).put(this.this$0.nodeSettings(nodeOrdinal)).build();
            }

            @Override
            public Path nodeConfigPath(int nodeOrdinal) {
                return this.this$0.nodeConfigPath(nodeOrdinal);
            }

            @Override
            public Collection<Class<? extends Plugin>> nodePlugins() {
                return this.this$0.nodePlugins();
            }

            @Override
            public Collection<PluginInfo> additionalNodePlugins() {
                return this.this$0.additionalNodePlugins();
            }
        };
    }

    protected boolean addMockTransportService() {
        return true;
    }

    protected boolean addMockIndexStorePlugin() {
        return true;
    }

    protected boolean addMockHttpTransport() {
        return true;
    }

    protected boolean addMockInternalEngine() {
        return true;
    }

    protected boolean addMockGeoShapeFieldMapper() {
        return true;
    }

    protected boolean addMockTelemetryPlugin() {
        return true;
    }

    protected Function<Client, Client> getClientWrapper() {
        return Function.identity();
    }

    protected Collection<Class<? extends Plugin>> getMockPlugins() {
        ArrayList<Class<Object>> mocks = new ArrayList<Class<Object>>();
        if (MOCK_MODULES_ENABLED && OpenSearchIntegTestCase.randomBoolean()) {
            if (OpenSearchIntegTestCase.randomBoolean() && this.addMockTransportService()) {
                mocks.add(MockTransportService.TestPlugin.class);
            }
            if (OpenSearchIntegTestCase.randomBoolean() && this.addMockIndexStorePlugin()) {
                mocks.add(MockFSIndexStore.TestPlugin.class);
            }
            if (OpenSearchIntegTestCase.randomBoolean()) {
                mocks.add(NodeMocksPlugin.class);
            }
            if (this.addMockInternalEngine() && OpenSearchIntegTestCase.randomBoolean()) {
                mocks.add(MockEngineFactoryPlugin.class);
            }
            if (OpenSearchIntegTestCase.randomBoolean()) {
                mocks.add(MockSearchService.TestPlugin.class);
            }
            if (OpenSearchIntegTestCase.randomBoolean()) {
                mocks.add(MockFieldFilterPlugin.class);
            }
        }
        if (this.addMockTransportService()) {
            mocks.add(OpenSearchIntegTestCase.getTestTransportPlugin());
        }
        if (this.addMockHttpTransport()) {
            mocks.add(MockHttpTransport.TestPlugin.class);
        }
        mocks.add(TestSeedPlugin.class);
        mocks.add(AssertActionNamePlugin.class);
        mocks.add(MockScriptService.TestPlugin.class);
        if (this.addMockGeoShapeFieldMapper()) {
            mocks.add(TestGeoShapeFieldMapperPlugin.class);
        }
        if (this.addMockTelemetryPlugin()) {
            mocks.add(MockTelemetryPlugin.class);
        }
        mocks.add(TestSystemTemplatesRepositoryPlugin.class);
        return Collections.unmodifiableList(mocks);
    }

    public Path randomRepoPath() {
        return testClusterRule.internalCluster().map(c -> OpenSearchIntegTestCase.randomRepoPath(c.getDefaultSettings())).orElseThrow(() -> new UnsupportedOperationException("unsupported cluster type"));
    }

    public static Path randomRepoPath(Settings settings) {
        Path path;
        Environment environment = TestEnvironment.newEnvironment(settings);
        Path[] repoFiles = environment.repoFiles();
        assert (repoFiles.length > 0);
        while (Files.exists(path = repoFiles[0].resolve(OpenSearchIntegTestCase.randomAlphaOfLength(10)), new LinkOption[0])) {
        }
        return path;
    }

    protected NumShards getNumShards(String index) {
        Metadata metadata = ((ClusterStateResponse)OpenSearchIntegTestCase.client().admin().cluster().prepareState().get()).getState().metadata();
        OpenSearchIntegTestCase.assertThat((Object)metadata.hasIndex(index), (Matcher)Matchers.equalTo((Object)true));
        int numShards = Integer.valueOf(metadata.index(index).getSettings().get("index.number_of_shards"));
        int numReplicas = Integer.valueOf(metadata.index(index).getSettings().get("index.number_of_replicas"));
        String numSearchReplicasValue = metadata.index(index).getSettings().get("index.number_of_search_replicas");
        int numSearchReplicas = numSearchReplicasValue != null ? Integer.parseInt(numSearchReplicasValue) : 0;
        return new NumShards(numShards, numReplicas, numSearchReplicas);
    }

    public Set<String> assertAllShardsOnNodes(String index, String ... pattern) {
        HashSet<String> nodes = new HashSet<String>();
        ClusterState clusterState = ((ClusterStateResponse)OpenSearchIntegTestCase.client().admin().cluster().prepareState().execute().actionGet()).getState();
        for (IndexRoutingTable indexRoutingTable : clusterState.routingTable()) {
            for (IndexShardRoutingTable indexShardRoutingTable : indexRoutingTable) {
                for (ShardRouting shardRouting : indexShardRoutingTable) {
                    if (shardRouting.currentNodeId() == null || !index.equals(shardRouting.getIndexName())) continue;
                    String name = clusterState.nodes().get(shardRouting.currentNodeId()).getName();
                    nodes.add(name);
                    OpenSearchIntegTestCase.assertThat((String)("Allocated on new node: " + name), (Object)Regex.simpleMatch((String[])pattern, (String)name), (Matcher)Matchers.is((Object)true));
                }
            }
        }
        return nodes;
    }

    public void assertSortedSegments(String indexName, Sort expectedIndexSort) {
        IndicesSegmentResponse segmentResponse = (IndicesSegmentResponse)OpenSearchIntegTestCase.client().admin().indices().prepareSegments(new String[]{indexName}).execute().actionGet();
        IndexSegments indexSegments = (IndexSegments)segmentResponse.getIndices().get(indexName);
        for (IndexShardSegments indexShardSegments : indexSegments.getShards().values()) {
            for (ShardSegments shardSegments : indexShardSegments.getShards()) {
                for (Segment segment : shardSegments) {
                    OpenSearchIntegTestCase.assertThat((Object)expectedIndexSort, (Matcher)Matchers.equalTo((Object)segment.getSegmentSort()));
                }
            }
        }
    }

    @AfterClass
    public static void afterClass() throws Exception {
        testClusterRule.afterClass();
    }

    protected String routingKeyForShard(String index, int shard) {
        return OpenSearchIntegTestCase.internalCluster().routingKeyForShard(OpenSearchIntegTestCase.resolveIndex(index), shard, OpenSearchIntegTestCase.random());
    }

    @Override
    protected NamedXContentRegistry xContentRegistry() {
        if (OpenSearchIntegTestCase.isInternalCluster() && OpenSearchIntegTestCase.cluster().size() > 0) {
            return OpenSearchIntegTestCase.internalCluster().getInstance(NamedXContentRegistry.class);
        }
        return new NamedXContentRegistry(ClusterModule.getNamedXWriteables());
    }

    protected boolean forbidPrivateIndexSettings() {
        return true;
    }

    protected static RestClient getRestClient() {
        return testClusterRule.getRestClient();
    }

    protected void setupSuiteScopeCluster() throws Exception {
    }

    public static Index resolveIndex(String index) {
        GetIndexResponse getIndexResponse = (GetIndexResponse)((GetIndexRequestBuilder)OpenSearchIntegTestCase.client().admin().indices().prepareGetIndex().setIndices(new String[]{index})).get();
        OpenSearchIntegTestCase.assertTrue((String)("index " + index + " not found"), (boolean)getIndexResponse.getSettings().containsKey(index));
        String uuid = ((Settings)getIndexResponse.getSettings().get(index)).get("index.uuid");
        return new Index(index, uuid);
    }

    public static String resolveCustomDataPath(String index) {
        GetIndexResponse getIndexResponse = (GetIndexResponse)((GetIndexRequestBuilder)OpenSearchIntegTestCase.client().admin().indices().prepareGetIndex().setIndices(new String[]{index})).get();
        OpenSearchIntegTestCase.assertTrue((String)("index " + index + " not found"), (boolean)getIndexResponse.getSettings().containsKey(index));
        return ((Settings)getIndexResponse.getSettings().get(index)).get("index.data_path");
    }

    protected boolean willSufferDebian8MemoryProblem() {
        NodesInfoResponse response = (NodesInfoResponse)OpenSearchIntegTestCase.client().admin().cluster().prepareNodesInfo(new String[0]).execute().actionGet();
        boolean anyDebian8Nodes = response.getNodes().stream().anyMatch(ni -> ((OsInfo)ni.getInfo(OsInfo.class)).getPrettyName().equals("Debian GNU/Linux 8 (jessie)"));
        boolean java15Plus = Runtime.version().compareTo(Runtime.Version.parse("15")) >= 0;
        return anyDebian8Nodes && !java15Plus;
    }

    public void manageReplicaBalanceSetting(boolean apply) {
        Settings settings = apply ? Settings.builder().put(AwarenessAllocationDecider.CLUSTER_ROUTING_ALLOCATION_AWARENESS_ATTRIBUTE_SETTING.getKey(), "zone").put(AwarenessAllocationDecider.CLUSTER_ROUTING_ALLOCATION_AWARENESS_FORCE_GROUP_SETTING.getKey() + "zone.values", "a, b").put(AwarenessReplicaBalance.CLUSTER_ROUTING_ALLOCATION_AWARENESS_BALANCE_SETTING.getKey(), true).build() : Settings.builder().putNull(AwarenessAllocationDecider.CLUSTER_ROUTING_ALLOCATION_AWARENESS_ATTRIBUTE_SETTING.getKey()).putNull(AwarenessAllocationDecider.CLUSTER_ROUTING_ALLOCATION_AWARENESS_FORCE_GROUP_SETTING.getKey() + "zone.values").putNull(AwarenessReplicaBalance.CLUSTER_ROUTING_ALLOCATION_AWARENESS_BALANCE_SETTING.getKey()).build();
        ClusterUpdateSettingsRequest updateSettingsRequest = new ClusterUpdateSettingsRequest();
        updateSettingsRequest.persistentSettings(settings);
        OpenSearchAssertions.assertAcked((AcknowledgedResponse)OpenSearchIntegTestCase.client().admin().cluster().updateSettings(updateSettingsRequest).actionGet());
    }

    public void manageReplicaSettingForDefaultReplica(boolean apply) {
        Settings settings = apply ? Settings.builder().put(AwarenessAllocationDecider.CLUSTER_ROUTING_ALLOCATION_AWARENESS_ATTRIBUTE_SETTING.getKey(), "zone").put(AwarenessAllocationDecider.CLUSTER_ROUTING_ALLOCATION_AWARENESS_FORCE_GROUP_SETTING.getKey() + "zone.values", "a, b, c").put(AwarenessReplicaBalance.CLUSTER_ROUTING_ALLOCATION_AWARENESS_BALANCE_SETTING.getKey(), true).put(Metadata.DEFAULT_REPLICA_COUNT_SETTING.getKey(), 2).build() : Settings.builder().putNull(AwarenessAllocationDecider.CLUSTER_ROUTING_ALLOCATION_AWARENESS_ATTRIBUTE_SETTING.getKey()).putNull(AwarenessAllocationDecider.CLUSTER_ROUTING_ALLOCATION_AWARENESS_FORCE_GROUP_SETTING.getKey() + "zone.values").putNull(AwarenessReplicaBalance.CLUSTER_ROUTING_ALLOCATION_AWARENESS_BALANCE_SETTING.getKey()).putNull(Metadata.DEFAULT_REPLICA_COUNT_SETTING.getKey()).build();
        ClusterUpdateSettingsRequest updateSettingsRequest = new ClusterUpdateSettingsRequest();
        updateSettingsRequest.persistentSettings(settings);
        OpenSearchAssertions.assertAcked((AcknowledgedResponse)OpenSearchIntegTestCase.client().admin().cluster().updateSettings(updateSettingsRequest).actionGet());
    }

    protected String primaryNodeName(String indexName) {
        ClusterState clusterState = ((ClusterStateResponse)OpenSearchIntegTestCase.client().admin().cluster().prepareState().get()).getState();
        String nodeId = clusterState.getRoutingTable().index(indexName).shard(0).primaryShard().currentNodeId();
        return clusterState.getRoutingNodes().node(nodeId).node().getName();
    }

    protected String primaryNodeName(String indexName, int shardId) {
        ClusterState clusterState = ((ClusterStateResponse)OpenSearchIntegTestCase.client().admin().cluster().prepareState().get()).getState();
        String nodeId = clusterState.getRoutingTable().index(indexName).shard(shardId).primaryShard().currentNodeId();
        return clusterState.getRoutingNodes().node(nodeId).node().getName();
    }

    protected String replicaNodeName(String indexName) {
        ClusterState clusterState = ((ClusterStateResponse)OpenSearchIntegTestCase.client().admin().cluster().prepareState().get()).getState();
        String nodeId = ((ShardRouting)clusterState.getRoutingTable().index(indexName).shard(0).replicaShards().get(0)).currentNodeId();
        return clusterState.getRoutingNodes().node(nodeId).node().getName();
    }

    protected ClusterState getClusterState() {
        return ((ClusterStateResponse)OpenSearchIntegTestCase.client(OpenSearchIntegTestCase.internalCluster().getClusterManagerName()).admin().cluster().prepareState().get()).getState();
    }

    protected RefreshResponse refreshAndWaitForReplication(String ... indices) {
        RefreshResponse refreshResponse = this.refresh(indices);
        this.waitForReplication(new String[0]);
        return refreshResponse;
    }

    public boolean isMigratingToRemoteStore() {
        ClusterSettings clusterSettings = this.clusterService().getClusterSettings();
        boolean isMixedMode = ((RemoteStoreNodeService.CompatibilityMode)clusterSettings.get(RemoteStoreNodeService.REMOTE_STORE_COMPATIBILITY_MODE_SETTING)).equals((Object)RemoteStoreNodeService.CompatibilityMode.MIXED);
        boolean isRemoteStoreMigrationDirection = ((RemoteStoreNodeService.Direction)clusterSettings.get(RemoteStoreNodeService.MIGRATION_DIRECTION_SETTING)).equals((Object)RemoteStoreNodeService.Direction.REMOTE_STORE);
        return isMixedMode && isRemoteStoreMigrationDirection;
    }

    protected void waitForReplication(String ... indices) {
        if (indices.length == 0) {
            indices = (String[])this.getClusterState().routingTable().indicesRouting().keySet().toArray(String[]::new);
        }
        try {
            for (String index : indices) {
                if (!this.isSegmentReplicationEnabledForIndex(index)) continue;
                if (OpenSearchIntegTestCase.isInternalCluster()) {
                    IndexRoutingTable indexRoutingTable = this.getClusterState().routingTable().index(index);
                    if (indexRoutingTable == null) continue;
                    OpenSearchIntegTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
                        for (IndexShardRoutingTable shardRoutingTable : indexRoutingTable) {
                            ShardRouting primaryRouting = shardRoutingTable.primaryShard();
                            if (!primaryRouting.state().toString().equals("STARTED") || !this.isSegmentReplicationEnabledForIndex(index)) continue;
                            List replicaRouting = shardRoutingTable.replicaShards();
                            IndexShard primaryShard = this.getIndexShard(primaryRouting, index);
                            for (ShardRouting replica : replicaRouting) {
                                IndexShard replicaShard;
                                if (!replica.state().toString().equals("STARTED") || !(replicaShard = this.getIndexShard(replica, index)).indexSettings().isSegRepEnabledOrRemoteNode()) continue;
                                OpenSearchIntegTestCase.assertEquals((String)"replica shards haven't caught up with primary", (long)this.getLatestSegmentInfoVersion(primaryShard), (long)this.getLatestSegmentInfoVersion(replicaShard));
                            }
                        }
                    }), 30L, TimeUnit.SECONDS);
                    continue;
                }
                throw new IllegalStateException("Segment Replication is not supported for testing tests using External Test Cluster");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean isSegmentReplicationEnabledForIndex(String index) {
        return this.clusterService().state().getMetadata().isSegmentReplicationEnabled(index) || this.isMigratingToRemoteStore();
    }

    protected IndexShard getIndexShard(ShardRouting routing, String indexName) {
        return this.getIndexShard(this.getClusterState().nodes().get(routing.currentNodeId()).getName(), routing.shardId(), indexName);
    }

    protected IndexShard getIndexShard(String node, ShardId shardId, String indexName) {
        Index index = OpenSearchIntegTestCase.resolveIndex(indexName);
        IndicesService indicesService = OpenSearchIntegTestCase.internalCluster().getInstance(IndicesService.class, node);
        IndexService indexService = indicesService.indexServiceSafe(index);
        Optional<Integer> id = indexService.shardIds().stream().filter(sid -> sid.equals(shardId.id())).findFirst();
        return indexService.getShard(id.get().intValue());
    }

    protected long getLatestSegmentInfoVersion(IndexShard shard) {
        long l;
        block8: {
            GatedCloseable snapshot = shard.getSegmentInfosSnapshot();
            try {
                l = ((SegmentInfos)snapshot.get()).version;
                if (snapshot == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (snapshot != null) {
                        try {
                            snapshot.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            snapshot.close();
        }
        return l;
    }

    protected void createRepository(String repoName, String type, Settings.Builder settings, String timeout) {
        this.logger.info("--> creating repository [{}] [{}]", (Object)repoName, (Object)type);
        OpenSearchIntegTestCase.putRepository(this.clusterAdmin(), repoName, type, timeout, settings);
    }

    protected void createRepository(String repoName, String type, Settings.Builder settings) {
        this.logger.info("--> creating repository [{}] [{}]", (Object)repoName, (Object)type);
        OpenSearchIntegTestCase.putRepository(this.clusterAdmin(), repoName, type, null, settings);
    }

    protected void updateRepository(String repoName, String type, Settings.Builder settings) {
        this.logger.info("--> updating repository [{}] [{}]", (Object)repoName, (Object)type);
        OpenSearchIntegTestCase.putRepository(this.clusterAdmin(), repoName, type, null, settings);
    }

    public Settings getNodeSettings() {
        InternalTestCluster internalTestCluster = OpenSearchIntegTestCase.internalCluster();
        ClusterService clusterService = internalTestCluster.getInstance(ClusterService.class, internalTestCluster.getClusterManagerName());
        return clusterService.getSettings();
    }

    public static void putRepository(ClusterAdminClient adminClient, String repoName, String type, Settings.Builder settings) {
        OpenSearchAssertions.assertAcked(OpenSearchIntegTestCase.putRepositoryRequestBuilder(adminClient, repoName, type, true, settings, null, false));
    }

    public static void putRepository(ClusterAdminClient adminClient, String repoName, String type, String timeout, Settings.Builder settings) {
        OpenSearchAssertions.assertAcked(OpenSearchIntegTestCase.putRepositoryRequestBuilder(adminClient, repoName, type, true, settings, timeout, false));
    }

    public static void putRepository(ClusterAdminClient adminClient, String repoName, String type, boolean verify, Settings.Builder settings) {
        OpenSearchAssertions.assertAcked(OpenSearchIntegTestCase.putRepositoryRequestBuilder(adminClient, repoName, type, verify, settings, null, false));
    }

    public static void putRepositoryWithNoSettingOverrides(ClusterAdminClient adminClient, String repoName, String type, boolean verify, Settings.Builder settings) {
        OpenSearchAssertions.assertAcked(OpenSearchIntegTestCase.putRepositoryRequestBuilder(adminClient, repoName, type, verify, settings, null, true));
    }

    public static void putRepository(ClusterAdminClient adminClient, String repoName, String type, Settings.Builder settings, ActionListener<AcknowledgedResponse> listener) {
        OpenSearchIntegTestCase.putRepositoryRequestBuilder(adminClient, repoName, type, true, settings, null, false).execute(listener);
    }

    public static PutRepositoryRequestBuilder putRepositoryRequestBuilder(ClusterAdminClient adminClient, String repoName, String type, boolean verify, Settings.Builder settings, String timeout, boolean finalSettings) {
        PutRepositoryRequestBuilder builder = adminClient.preparePutRepository(repoName).setType(type).setVerify(verify);
        if (timeout != null) {
            builder.setTimeout(timeout);
        }
        if (!finalSettings && !settings.keys().contains(BlobStoreRepository.SHARD_PATH_TYPE.getKey())) {
            settings.put(BlobStoreRepository.SHARD_PATH_TYPE.getKey(), (Enum)OpenSearchIntegTestCase.randomFrom(RemoteStoreEnums.PathType.values()));
        }
        builder.setSettings(settings);
        return builder;
    }

    public static Settings remoteStoreClusterSettings(String name, Path path) {
        return OpenSearchIntegTestCase.remoteStoreClusterSettings(name, path, name, path);
    }

    public static Settings remoteStoreClusterSettings(String segmentRepoName, Path segmentRepoPath, String segmentRepoType, String translogRepoName, Path translogRepoPath, String translogRepoType) {
        Settings.Builder settingsBuilder = Settings.builder();
        settingsBuilder.put(OpenSearchIntegTestCase.buildRemoteStoreNodeAttributes(segmentRepoName, segmentRepoPath, segmentRepoType, translogRepoName, translogRepoPath, translogRepoType, false));
        return settingsBuilder.build();
    }

    public static Settings remoteStoreClusterSettings(String segmentRepoName, Path segmentRepoPath, String segmentRepoType, String translogRepoName, Path translogRepoPath, String translogRepoType, String routingTableRepoName, Path routingTableRepoPath, String routingTableRepoType) {
        Settings.Builder settingsBuilder = Settings.builder();
        settingsBuilder.put(OpenSearchIntegTestCase.buildRemoteStoreNodeAttributes(segmentRepoName, segmentRepoPath, segmentRepoType, translogRepoName, translogRepoPath, translogRepoType, routingTableRepoName, routingTableRepoPath, routingTableRepoType, false));
        return settingsBuilder.build();
    }

    public static Settings remoteStoreClusterSettings(String segmentRepoName, Path segmentRepoPath, String translogRepoName, Path translogRepoPath) {
        Settings.Builder settingsBuilder = Settings.builder();
        settingsBuilder.put(OpenSearchIntegTestCase.buildRemoteStoreNodeAttributes(segmentRepoName, segmentRepoPath, translogRepoName, translogRepoPath, false));
        return settingsBuilder.build();
    }

    public static Settings remoteStoreClusterSettings(String segmentRepoName, Path segmentRepoPath, String translogRepoName, Path translogRepoPath, String remoteRoutingTableRepoName, Path remoteRoutingTableRepoPath) {
        Settings.Builder settingsBuilder = Settings.builder();
        settingsBuilder.put(OpenSearchIntegTestCase.buildRemoteStoreNodeAttributes(segmentRepoName, segmentRepoPath, translogRepoName, translogRepoPath, remoteRoutingTableRepoName, remoteRoutingTableRepoPath, false));
        return settingsBuilder.build();
    }

    public static Settings buildRemoteStoreNodeAttributes(String segmentRepoName, Path segmentRepoPath, String translogRepoName, Path translogRepoPath, boolean withRateLimiterAttributes) {
        return OpenSearchIntegTestCase.buildRemoteStoreNodeAttributes(segmentRepoName, segmentRepoPath, "reloadable-fs", translogRepoName, translogRepoPath, "reloadable-fs", withRateLimiterAttributes);
    }

    public static Settings buildRemoteStoreNodeAttributes(String segmentRepoName, Path segmentRepoPath, String translogRepoName, Path translogRepoPath, String remoteRoutingTableRepoName, Path remoteRoutingTableRepoPath, boolean withRateLimiterAttributes) {
        return OpenSearchIntegTestCase.buildRemoteStoreNodeAttributes(segmentRepoName, segmentRepoPath, "reloadable-fs", translogRepoName, translogRepoPath, "reloadable-fs", remoteRoutingTableRepoName, remoteRoutingTableRepoPath, "fs", withRateLimiterAttributes);
    }

    public static Settings buildRemoteStateNodeAttributes(String stateRepoName, Path stateRepoPath, String stateRepoType) {
        String stateRepoTypeAttributeKey = String.format(Locale.getDefault(), "node.attr.remote_store.repository.%s.type", stateRepoName);
        String stateRepoSettingsAttributeKeyPrefix = String.format(Locale.getDefault(), "node.attr.remote_store.repository.%s.settings.", stateRepoName);
        String prefixModeVerificationSuffix = BlobStoreRepository.PREFIX_MODE_VERIFICATION_SETTING.getKey();
        Settings.Builder settings = Settings.builder().put("node.attr.remote_store.state.repository", stateRepoName).put(stateRepoTypeAttributeKey, stateRepoType).put(stateRepoSettingsAttributeKeyPrefix + "location", stateRepoPath).put(stateRepoSettingsAttributeKeyPrefix + prefixModeVerificationSuffix, prefixModeVerificationEnable.booleanValue());
        return settings.build();
    }

    private static Settings buildRemoteStoreNodeAttributes(String segmentRepoName, Path segmentRepoPath, String segmentRepoType, String translogRepoName, Path translogRepoPath, String translogRepoType, boolean withRateLimiterAttributes) {
        return OpenSearchIntegTestCase.buildRemoteStoreNodeAttributes(segmentRepoName, segmentRepoPath, segmentRepoType, translogRepoName, translogRepoPath, translogRepoType, null, null, null, withRateLimiterAttributes);
    }

    protected static Settings buildRemoteStoreNodeAttributes(String segmentRepoName, Path segmentRepoPath, String segmentRepoType, String translogRepoName, Path translogRepoPath, String translogRepoType, String routingTableRepoName, Path routingTableRepoPath, String routingTableRepoType, boolean withRateLimiterAttributes) {
        String segmentRepoTypeAttributeKey = String.format(Locale.getDefault(), "node.attr.remote_store.repository.%s.type", segmentRepoName);
        String segmentRepoSettingsAttributeKeyPrefix = String.format(Locale.getDefault(), "node.attr.remote_store.repository.%s.settings.", segmentRepoName);
        String translogRepoTypeAttributeKey = String.format(Locale.getDefault(), "node.attr.remote_store.repository.%s.type", translogRepoName);
        String translogRepoSettingsAttributeKeyPrefix = String.format(Locale.getDefault(), "node.attr.remote_store.repository.%s.settings.", translogRepoName);
        String routingTableRepoAttributeKey = null;
        String routingTableRepoSettingsAttributeKeyPrefix = null;
        if (routingTableRepoName != null) {
            routingTableRepoAttributeKey = String.format(Locale.getDefault(), "node.attr.remote_store.repository.%s.type", routingTableRepoName);
            routingTableRepoSettingsAttributeKeyPrefix = String.format(Locale.getDefault(), "node.attr.remote_store.repository.%s.settings.", routingTableRepoName);
        }
        String prefixModeVerificationSuffix = BlobStoreRepository.PREFIX_MODE_VERIFICATION_SETTING.getKey();
        Settings.Builder settings = Settings.builder().put("node.attr.remote_store.segment.repository", segmentRepoName).put(segmentRepoTypeAttributeKey, segmentRepoType).put(segmentRepoSettingsAttributeKeyPrefix + "location", segmentRepoPath).put(segmentRepoSettingsAttributeKeyPrefix + prefixModeVerificationSuffix, prefixModeVerificationEnable.booleanValue()).put("node.attr.remote_store.translog.repository", translogRepoName).put(translogRepoTypeAttributeKey, translogRepoType).put(translogRepoSettingsAttributeKeyPrefix + "location", translogRepoPath).put(translogRepoSettingsAttributeKeyPrefix + prefixModeVerificationSuffix, prefixModeVerificationEnable.booleanValue()).put(OpenSearchIntegTestCase.buildRemoteStateNodeAttributes(segmentRepoName, segmentRepoPath, segmentRepoType));
        if (routingTableRepoName != null) {
            settings.put("node.attr.remote_store.routing_table.repository", routingTableRepoName).put(routingTableRepoAttributeKey, routingTableRepoType).put(routingTableRepoSettingsAttributeKeyPrefix + "location", routingTableRepoPath);
        }
        if (withRateLimiterAttributes) {
            settings.put(segmentRepoSettingsAttributeKeyPrefix + "compress", OpenSearchIntegTestCase.randomBoolean()).put(segmentRepoSettingsAttributeKeyPrefix + "chunk_size", 200L, ByteSizeUnit.BYTES);
        }
        settings.put(RemoteStoreSettings.CLUSTER_REMOTE_STORE_PATH_TYPE_SETTING.getKey(), (Enum)OpenSearchIntegTestCase.randomFrom(RemoteStoreEnums.PathType.values()));
        settings.put(RemoteStoreSettings.CLUSTER_REMOTE_STORE_TRANSLOG_METADATA.getKey(), OpenSearchIntegTestCase.randomBoolean());
        settings.put(RemoteStoreSettings.CLUSTER_REMOTE_STORE_PINNED_TIMESTAMP_ENABLED.getKey(), OpenSearchIntegTestCase.randomBoolean());
        settings.put(RemoteStoreSettings.CLUSTER_REMOTE_STORE_SEGMENTS_PATH_PREFIX.getKey(), translogPathFixedPrefix != false ? "a" : "");
        settings.put(RemoteStoreSettings.CLUSTER_REMOTE_STORE_TRANSLOG_PATH_PREFIX.getKey(), segmentsPathFixedPrefix != false ? "b" : "");
        settings.put(BlobStoreRepository.SNAPSHOT_SHARD_PATH_PREFIX_SETTING.getKey(), snapshotShardPathFixedPrefix != false ? "c" : "");
        return settings.build();
    }

    protected Settings buildRemotePublicationNodeAttributes(@NonNull String remoteStateRepoName, @NonNull String remoteStateRepoType, @NonNull String routingTableRepoName, @NonNull String routingTableRepoType) {
        String remoteStateRepositoryTypeAttributeKey = String.format(Locale.getDefault(), "node.attr.remote_store.repository.%s.type", remoteStateRepoName);
        String routingTableRepositoryTypeAttributeKey = String.format(Locale.getDefault(), "node.attr.remote_store.repository.%s.type", routingTableRepoName);
        String remoteStateRepositorySettingsAttributeKeyPrefix = String.format(Locale.getDefault(), "node.attr.remote_store.repository.%s.settings.", remoteStateRepoName);
        String routingTableRepositorySettingsAttributeKeyPrefix = String.format(Locale.getDefault(), "node.attr.remote_store.repository.%s.settings.", routingTableRepoName);
        return Settings.builder().put("node.attr.remote_store.state.repository", remoteStateRepoName).put("node.attr.remote_store.routing_table.repository", routingTableRepoName).put(remoteStateRepositoryTypeAttributeKey, remoteStateRepoType).put(routingTableRepositoryTypeAttributeKey, routingTableRepoType).put(remoteStateRepositorySettingsAttributeKeyPrefix + "location", this.randomRepoPath().toAbsolutePath()).put(routingTableRepositorySettingsAttributeKeyPrefix + "location", this.randomRepoPath().toAbsolutePath()).build();
    }

    public static String resolvePath(IndexId indexId, String shardId) {
        RemoteStoreEnums.PathType pathType = RemoteStoreEnums.PathType.fromCode((int)indexId.getShardPathType());
        RemoteStorePathStrategy.SnapshotShardPathInput shardPathInput = ((RemoteStorePathStrategy.SnapshotShardPathInput.Builder)((RemoteStorePathStrategy.SnapshotShardPathInput.Builder)new RemoteStorePathStrategy.SnapshotShardPathInput.Builder().basePath(BlobPath.cleanPath())).indexUUID(indexId.getId())).shardId(shardId).build();
        RemoteStoreEnums.PathHashAlgorithm pathHashAlgorithm = pathType != RemoteStoreEnums.PathType.FIXED ? RemoteStoreEnums.PathHashAlgorithm.FNV_1A_COMPOSITE_1 : null;
        BlobPath blobPath = pathType.path((RemoteStorePathStrategy.PathInput)shardPathInput, pathHashAlgorithm);
        return blobPath.buildAsString();
    }

    private class PayloadLatchedActionListener<Response, T>
    extends LatchedActionListener<Response> {
        private final CopyOnWriteArrayList<Tuple<T, Exception>> errors;
        private final T builder;

        PayloadLatchedActionListener(OpenSearchIntegTestCase openSearchIntegTestCase, T builder, CountDownLatch latch, CopyOnWriteArrayList<Tuple<T, Exception>> errors) {
            super(latch);
            this.errors = errors;
            this.builder = builder;
        }

        @Override
        protected void addError(Exception e) {
            this.errors.add(new Tuple(this.builder, (Object)e));
        }
    }

    protected static class NumShards {
        public final int numPrimaries;
        public final int numReplicas;
        public final int numSearchReplicas;
        public final int totalNumShards;
        public final int dataCopies;

        private NumShards(int numPrimaries, int numReplicas, int numSearchReplicas) {
            this.numPrimaries = numPrimaries;
            this.numReplicas = numReplicas;
            this.numSearchReplicas = numSearchReplicas;
            this.dataCopies = numReplicas + numSearchReplicas + 1;
            this.totalNumShards = numPrimaries * this.dataCopies;
        }
    }

    private class LatchedActionListener<Response>
    implements ActionListener<Response> {
        private final CountDownLatch latch;

        LatchedActionListener(CountDownLatch latch) {
            this.latch = latch;
        }

        public final void onResponse(Response response) {
            this.latch.countDown();
        }

        public final void onFailure(Exception t) {
            try {
                OpenSearchIntegTestCase.this.logger.info("Action Failed", (Throwable)t);
                this.addError(t);
            }
            finally {
                this.latch.countDown();
            }
        }

        protected void addError(Exception e) {
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface ClusterScope {
        public Scope scope() default Scope.SUITE;

        public int numDataNodes() default -1;

        public int minNumDataNodes() default -1;

        public int maxNumDataNodes() default -1;

        public boolean supportsDedicatedMasters() default true;

        public boolean autoManageMasterNodes() default true;

        public int numClientNodes() default -1;
    }

    public static enum Scope {
        SUITE,
        TEST;

    }

    public static final class TestSeedPlugin
    extends Plugin {
        public List<Setting<?>> getSettings() {
            return Collections.singletonList(INDEX_TEST_SEED_SETTING);
        }
    }

    public static final class AssertActionNamePlugin
    extends Plugin
    implements NetworkPlugin {
        public List<TransportInterceptor> getTransportInterceptors(NamedWriteableRegistry namedWriteableRegistry, ThreadContext threadContext) {
            return Arrays.asList(new TransportInterceptor(this){

                public <T extends TransportRequest> TransportRequestHandler<T> interceptHandler(String action, String executor, boolean forceExecution, TransportRequestHandler<T> actualHandler) {
                    if (!TransportService.isValidActionName((String)action)) {
                        throw new IllegalArgumentException("invalid action name [" + action + "] must start with one of: " + String.valueOf(TransportService.VALID_ACTION_PREFIXES));
                    }
                    return actualHandler;
                }
            });
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    @Target(value={ElementType.TYPE})
    public static @interface SuiteScopeTestCase {
    }

    @Inherited
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @TestGroup(enabled=false, sysProperty="tests.thirdparty")
    public static @interface ThirdParty {
    }
}

