/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.opensearch.common.settings.Settings;
import org.opensearch.gateway.remote.RemoteClusterStateService;
import org.opensearch.indices.IndicesService;
import org.opensearch.indices.replication.common.ReplicationType;
import org.opensearch.test.ParameterizedOpenSearchIntegTestCase;

public abstract class ParameterizedStaticSettingsOpenSearchIntegTestCase
extends ParameterizedOpenSearchIntegTestCase {
    protected static final String REMOTE_STORE_REPOSITORY_NAME = "test-remote-store-repo";
    private Path remoteStoreRepositoryPath;
    public static final List<Object[]> replicationSettings = Arrays.asList({Settings.builder().put(IndicesService.CLUSTER_REPLICATION_TYPE_SETTING.getKey(), (Enum)ReplicationType.DOCUMENT).build()}, {Settings.builder().put(IndicesService.CLUSTER_REPLICATION_TYPE_SETTING.getKey(), (Enum)ReplicationType.SEGMENT).build()});
    public static final List<Object[]> remoteStoreSettings = Arrays.asList({Settings.builder().put(RemoteClusterStateService.REMOTE_CLUSTER_STATE_ENABLED_SETTING.getKey(), true).build()}, {Settings.builder().put(RemoteClusterStateService.REMOTE_CLUSTER_STATE_ENABLED_SETTING.getKey(), false).build()});

    public ParameterizedStaticSettingsOpenSearchIntegTestCase(Settings nodeSettings) {
        super(nodeSettings);
    }

    @Override
    protected Settings nodeSettings(int nodeOrdinal) {
        Settings.Builder builder = Settings.builder();
        if (((Boolean)RemoteClusterStateService.REMOTE_CLUSTER_STATE_ENABLED_SETTING.get(this.settings)).booleanValue()) {
            if (this.remoteStoreRepositoryPath == null) {
                this.remoteStoreRepositoryPath = this.randomRepoPath().toAbsolutePath();
            }
            builder.put(ParameterizedStaticSettingsOpenSearchIntegTestCase.remoteStoreClusterSettings(REMOTE_STORE_REPOSITORY_NAME, this.remoteStoreRepositoryPath));
        }
        return builder.put(super.nodeSettings(nodeOrdinal)).put(this.settings).build();
    }

    @Override
    boolean hasSameParametersAs(ParameterizedOpenSearchIntegTestCase obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != ((Object)((Object)obj)).getClass()) {
            return false;
        }
        ParameterizedStaticSettingsOpenSearchIntegTestCase other = (ParameterizedStaticSettingsOpenSearchIntegTestCase)obj;
        return Objects.equals(this.settings, other.settings);
    }
}

