/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class TestLogsAppender
extends AbstractAppender {
    private final List<String> capturedLogs = new ArrayList<String>();
    private final List<String> messagesToCapture;

    public TestLogsAppender(List<String> messagesToCapture) {
        super("TestAppender", null, (Layout)PatternLayout.createDefaultLayout(), false, Property.EMPTY_ARRAY);
        this.messagesToCapture = messagesToCapture;
        this.start();
    }

    public void append(LogEvent event) {
        if (this.shouldCaptureMessage(event.getMessage().getFormattedMessage())) {
            this.capturedLogs.add(event.getMessage().getFormattedMessage());
        }
        if (event.getThrown() != null) {
            if (this.shouldCaptureMessage(event.getThrown().toString())) {
                this.capturedLogs.add(event.getThrown().toString());
            }
            for (StackTraceElement element : event.getThrown().getStackTrace()) {
                if (!this.shouldCaptureMessage(element.toString())) continue;
                this.capturedLogs.add(element.toString());
            }
        }
    }

    public boolean shouldCaptureMessage(String log) {
        return this.messagesToCapture.stream().anyMatch(log::contains);
    }

    public List<String> getCapturedLogs() {
        return new ArrayList<String>(this.capturedLogs);
    }

    public boolean waitForLog(String expectedLog, long timeout, TimeUnit unit) {
        long startTime = System.currentTimeMillis();
        long timeoutInMillis = unit.toMillis(timeout);
        while (System.currentTimeMillis() - startTime < timeoutInMillis) {
            if (this.capturedLogs.stream().anyMatch(log -> log.contains(expectedLog))) {
                return true;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return false;
    }

    public void clearCapturedLogs() {
        this.capturedLogs.clear();
    }
}

