/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test.transport;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.Version;
import org.opensearch.cluster.ClusterModule;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.Nullable;
import org.opensearch.common.UUIDs;
import org.opensearch.common.io.stream.BytesStreamOutput;
import org.opensearch.common.network.NetworkService;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.MockPageCacheRecycler;
import org.opensearch.common.util.concurrent.AbstractRunnable;
import org.opensearch.common.util.concurrent.RunOnce;
import org.opensearch.common.util.io.IOUtils;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.transport.BoundTransportAddress;
import org.opensearch.core.common.transport.TransportAddress;
import org.opensearch.core.indices.breaker.CircuitBreakerService;
import org.opensearch.core.indices.breaker.NoneCircuitBreakerService;
import org.opensearch.node.Node;
import org.opensearch.plugins.Plugin;
import org.opensearch.tasks.TaskManager;
import org.opensearch.telemetry.tracing.Tracer;
import org.opensearch.telemetry.tracing.noop.NoopTracer;
import org.opensearch.test.OpenSearchTestCase;
import org.opensearch.test.tasks.MockTaskManager;
import org.opensearch.test.transport.StubbableConnectionManager;
import org.opensearch.test.transport.StubbableTransport;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.ClusterConnectionManager;
import org.opensearch.transport.ConnectTransportException;
import org.opensearch.transport.ConnectionManager;
import org.opensearch.transport.ConnectionProfile;
import org.opensearch.transport.RequestHandlerRegistry;
import org.opensearch.transport.Transport;
import org.opensearch.transport.TransportInterceptor;
import org.opensearch.transport.TransportRequest;
import org.opensearch.transport.TransportRequestOptions;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.TransportSettings;
import org.opensearch.transport.nio.MockNioTransport;

public final class MockTransportService
extends TransportService {
    private static final Logger logger = LogManager.getLogger(MockTransportService.class);
    private final Map<DiscoveryNode, List<Transport.Connection>> openConnections = new HashMap<DiscoveryNode, List<Transport.Connection>>();
    private final List<Runnable> onStopListeners = new CopyOnWriteArrayList<Runnable>();
    private final Transport original;

    public static MockTransportService createNewService(Settings settings, Version version, ThreadPool threadPool, Tracer tracer) {
        return MockTransportService.createNewService(settings, version, threadPool, null, tracer);
    }

    public static MockTransportService createNewService(Settings settings, Version version, ThreadPool threadPool, @Nullable ClusterSettings clusterSettings, Tracer tracer) {
        MockNioTransport mockTransport = MockTransportService.newMockTransport(settings, version, threadPool);
        return MockTransportService.createNewService(settings, (Transport)mockTransport, version, threadPool, clusterSettings, Collections.emptySet(), tracer);
    }

    public static MockNioTransport newMockTransport(Settings settings, Version version, ThreadPool threadPool) {
        settings = Settings.builder().put(TransportSettings.PORT.getKey(), OpenSearchTestCase.getPortRange()).put(settings).build();
        NamedWriteableRegistry namedWriteableRegistry = new NamedWriteableRegistry(ClusterModule.getNamedWriteables());
        return new MockNioTransport(settings, version, threadPool, new NetworkService(Collections.emptyList()), new MockPageCacheRecycler(settings), namedWriteableRegistry, (CircuitBreakerService)new NoneCircuitBreakerService(), NoopTracer.INSTANCE);
    }

    public static MockTransportService createNewService(Settings settings, Transport transport, Version version, ThreadPool threadPool, @Nullable ClusterSettings clusterSettings, Set<String> taskHeaders, Tracer tracer) {
        return MockTransportService.createNewService(settings, transport, version, threadPool, clusterSettings, taskHeaders, NOOP_TRANSPORT_INTERCEPTOR, tracer);
    }

    public static MockTransportService createNewService(Settings settings, Transport transport, Version version, ThreadPool threadPool, @Nullable ClusterSettings clusterSettings, Set<String> taskHeaders, TransportInterceptor interceptor, Tracer tracer) {
        return new MockTransportService(settings, transport, threadPool, interceptor, boundAddress -> new DiscoveryNode((String)Node.NODE_NAME_SETTING.get(settings), UUIDs.randomBase64UUID(), boundAddress.publishAddress(), Node.NODE_ATTRIBUTES.getAsMap(settings), DiscoveryNode.getRolesFromSettings((Settings)settings), version), clusterSettings, taskHeaders, tracer);
    }

    public MockTransportService(Settings settings, Transport transport, ThreadPool threadPool, TransportInterceptor interceptor, @Nullable ClusterSettings clusterSettings, Tracer tracer) {
        this(settings, transport, threadPool, interceptor, boundAddress -> DiscoveryNode.createLocal((Settings)settings, (TransportAddress)boundAddress.publishAddress(), (String)settings.get(Node.NODE_NAME_SETTING.getKey(), UUIDs.randomBase64UUID())), clusterSettings, Collections.emptySet(), tracer);
    }

    public MockTransportService(Settings settings, Transport transport, ThreadPool threadPool, TransportInterceptor interceptor, Function<BoundTransportAddress, DiscoveryNode> localNodeFactory, @Nullable ClusterSettings clusterSettings, Set<String> taskHeaders, Tracer tracer) {
        this(settings, new StubbableTransport(transport), (StubbableTransport)null, threadPool, interceptor, localNodeFactory, clusterSettings, taskHeaders, tracer);
    }

    public MockTransportService(Settings settings, Transport transport, @Nullable Transport streamTransport, ThreadPool threadPool, TransportInterceptor interceptor, Function<BoundTransportAddress, DiscoveryNode> localNodeFactory, @Nullable ClusterSettings clusterSettings, Set<String> taskHeaders, Tracer tracer) {
        this(settings, new StubbableTransport(transport), streamTransport != null ? new StubbableTransport(streamTransport) : null, threadPool, interceptor, localNodeFactory, clusterSettings, taskHeaders, tracer);
    }

    private MockTransportService(Settings settings, StubbableTransport transport, @Nullable StubbableTransport streamTransport, ThreadPool threadPool, TransportInterceptor interceptor, Function<BoundTransportAddress, DiscoveryNode> localNodeFactory, @Nullable ClusterSettings clusterSettings, Set<String> taskHeaders, Tracer tracer) {
        super(settings, (Transport)transport, (Transport)streamTransport, threadPool, interceptor, localNodeFactory, clusterSettings, taskHeaders, (ConnectionManager)new StubbableConnectionManager((ConnectionManager)new ClusterConnectionManager(settings, (Transport)transport)), tracer);
        this.original = transport.getDelegate();
    }

    private static TransportAddress[] extractTransportAddresses(TransportService transportService) {
        HashSet<TransportAddress> transportAddresses = new HashSet<TransportAddress>();
        BoundTransportAddress boundTransportAddress = transportService.boundAddress();
        transportAddresses.addAll(Arrays.asList(boundTransportAddress.boundAddresses()));
        transportAddresses.add(boundTransportAddress.publishAddress());
        return transportAddresses.toArray(new TransportAddress[0]);
    }

    protected TaskManager createTaskManager(Settings settings, ClusterSettings clusterSettings, ThreadPool threadPool, Set<String> taskHeaders) {
        if (((Boolean)MockTaskManager.USE_MOCK_TASK_MANAGER_SETTING.get(settings)).booleanValue()) {
            return new MockTaskManager(settings, threadPool, taskHeaders);
        }
        return super.createTaskManager(settings, clusterSettings, threadPool, taskHeaders);
    }

    public void clearAllRules() {
        this.transport().clearBehaviors();
        this.connectionManager().clearBehaviors();
    }

    public void clearInboundRules() {
        this.transport().clearInboundBehaviors();
    }

    public void clearOutboundRules(TransportService transportService) {
        for (TransportAddress transportAddress : MockTransportService.extractTransportAddresses(transportService)) {
            this.clearOutboundRules(transportAddress);
        }
    }

    public void clearOutboundRules(TransportAddress transportAddress) {
        this.transport().clearOutboundBehaviors(transportAddress);
        this.connectionManager().clearBehavior(transportAddress);
    }

    public void addFailToSendNoConnectRule(TransportService transportService) {
        for (TransportAddress transportAddress : MockTransportService.extractTransportAddresses(transportService)) {
            this.addFailToSendNoConnectRule(transportAddress);
        }
    }

    public void addFailToSendNoConnectRule(TransportAddress transportAddress) {
        this.transport().addConnectBehavior(transportAddress, (Transport transport, DiscoveryNode discoveryNode, ConnectionProfile profile, ActionListener<Transport.Connection> listener) -> listener.onFailure((Exception)new ConnectTransportException(discoveryNode, "DISCONNECT: simulated")));
        this.transport().addSendBehavior(transportAddress, (Transport.Connection connection, long requestId, String action, TransportRequest request, TransportRequestOptions options) -> {
            connection.close();
            connection.sendRequest(requestId, action, request, options);
        });
    }

    public void addFailToSendNoConnectRule(TransportService transportService, String ... blockedActions) {
        this.addFailToSendNoConnectRule(transportService, new HashSet<String>(Arrays.asList(blockedActions)));
    }

    public void addFailToSendNoConnectRule(TransportService transportService, Set<String> blockedActions) {
        for (TransportAddress transportAddress : MockTransportService.extractTransportAddresses(transportService)) {
            this.addFailToSendNoConnectRule(transportAddress, blockedActions);
        }
    }

    public void addFailToSendNoConnectRule(TransportAddress transportAddress, Set<String> blockedActions) {
        this.transport().addSendBehavior(transportAddress, (Transport.Connection connection, long requestId, String action, TransportRequest request, TransportRequestOptions options) -> {
            if (blockedActions.contains(action)) {
                logger.info("--> preventing {} request", (Object)action);
                connection.close();
            }
            connection.sendRequest(requestId, action, request, options);
        });
    }

    public void addUnresponsiveRule(TransportService transportService) {
        for (TransportAddress transportAddress : MockTransportService.extractTransportAddresses(transportService)) {
            this.addUnresponsiveRule(transportAddress);
        }
    }

    public void addUnresponsiveRule(TransportAddress transportAddress) {
        this.transport().addConnectBehavior(transportAddress, (Transport transport, DiscoveryNode discoveryNode, ConnectionProfile profile, ActionListener<Transport.Connection> listener) -> listener.onFailure((Exception)new ConnectTransportException(discoveryNode, "UNRESPONSIVE: simulated")));
        this.transport().addSendBehavior(transportAddress, new StubbableTransport.SendRequestBehavior(this){
            private Set<Transport.Connection> toClose = ConcurrentHashMap.newKeySet();

            @Override
            public void sendRequest(Transport.Connection connection, long requestId, String action, TransportRequest request, TransportRequestOptions options) {
                this.toClose.add(connection);
            }

            @Override
            public void clearCallback() {
                try {
                    IOUtils.close(this.toClose);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public void addUnresponsiveRule(TransportService transportService, TimeValue duration) {
        for (TransportAddress transportAddress : MockTransportService.extractTransportAddresses(transportService)) {
            this.addUnresponsiveRule(transportAddress, duration);
        }
    }

    public void addUnresponsiveRule(TransportAddress transportAddress, TimeValue duration) {
        long startTime = System.currentTimeMillis();
        final Supplier<TimeValue> delaySupplier = () -> new TimeValue(duration.millis() - (System.currentTimeMillis() - startTime));
        this.transport().addConnectBehavior(transportAddress, new StubbableTransport.OpenConnectionBehavior(){
            private CountDownLatch stopLatch = new CountDownLatch(1);
            final /* synthetic */ MockTransportService this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void openConnection(Transport transport, DiscoveryNode discoveryNode, ConnectionProfile profile, ActionListener<Transport.Connection> listener) {
                TimeValue delay = (TimeValue)delaySupplier.get();
                if (delay.millis() <= 0L) {
                    this.this$0.original.openConnection(discoveryNode, profile, listener);
                    return;
                }
                TimeValue connectingTimeout = (TimeValue)TransportSettings.CONNECT_TIMEOUT.getDefault(Settings.EMPTY);
                try {
                    if (delay.millis() < connectingTimeout.millis()) {
                        this.stopLatch.await(delay.millis(), TimeUnit.MILLISECONDS);
                        this.this$0.original.openConnection(discoveryNode, profile, listener);
                    } else {
                        this.stopLatch.await(connectingTimeout.millis(), TimeUnit.MILLISECONDS);
                        listener.onFailure((Exception)new ConnectTransportException(discoveryNode, "UNRESPONSIVE: simulated"));
                    }
                }
                catch (InterruptedException e) {
                    listener.onFailure((Exception)new ConnectTransportException(discoveryNode, "UNRESPONSIVE: simulated"));
                }
            }

            @Override
            public void clearCallback() {
                this.stopLatch.countDown();
            }
        });
        this.transport().addSendBehavior(transportAddress, new StubbableTransport.SendRequestBehavior(){
            private final Queue<Runnable> requestsToSendWhenCleared = new LinkedBlockingDeque<Runnable>();
            private boolean cleared = false;
            final /* synthetic */ MockTransportService this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendRequest(final Transport.Connection connection, final long requestId, final String action, TransportRequest request, final TransportRequestOptions options) throws IOException {
                TimeValue delay = (TimeValue)delaySupplier.get();
                if (delay.millis() <= 0L) {
                    connection.sendRequest(requestId, action, request, options);
                    return;
                }
                RequestHandlerRegistry reg = this.this$0.getRequestHandler(action);
                BytesStreamOutput bStream = new BytesStreamOutput();
                request.writeTo((StreamOutput)bStream);
                final TransportRequest clonedRequest = reg.newRequest(bStream.bytes().streamInput());
                RunOnce runnable = new RunOnce((Runnable)new AbstractRunnable(this){

                    public void onFailure(Exception e) {
                        logger.debug("failed to send delayed request", (Throwable)e);
                    }

                    protected void doRun() throws IOException {
                        connection.sendRequest(requestId, action, clonedRequest, options);
                    }
                });
                3 var12_11 = this;
                synchronized (var12_11) {
                    if (this.cleared) {
                        runnable.run();
                    } else {
                        this.requestsToSendWhenCleared.add((Runnable)runnable);
                        this.this$0.threadPool.schedule((Runnable)runnable, delay, "generic");
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearCallback() {
                3 var1_1 = this;
                synchronized (var1_1) {
                    assert (!this.cleared);
                    this.cleared = true;
                    this.requestsToSendWhenCleared.forEach(Runnable::run);
                }
            }
        });
    }

    public <R extends TransportRequest> void addRequestHandlingBehavior(String actionName, StubbableTransport.RequestHandlingBehavior<R> handlingBehavior) {
        this.transport().addRequestHandlingBehavior(actionName, handlingBehavior);
    }

    public boolean addSendBehavior(TransportService transportService, StubbableTransport.SendRequestBehavior sendBehavior) {
        boolean noRegistered = true;
        for (TransportAddress transportAddress : MockTransportService.extractTransportAddresses(transportService)) {
            noRegistered &= this.addSendBehavior(transportAddress, sendBehavior);
        }
        return noRegistered;
    }

    public boolean addSendBehavior(TransportAddress transportAddress, StubbableTransport.SendRequestBehavior sendBehavior) {
        return this.transport().addSendBehavior(transportAddress, sendBehavior);
    }

    public boolean addSendBehavior(StubbableTransport.SendRequestBehavior behavior) {
        return this.transport().setDefaultSendBehavior(behavior);
    }

    public boolean addConnectBehavior(TransportService transportService, StubbableTransport.OpenConnectionBehavior connectBehavior) {
        boolean noRegistered = true;
        for (TransportAddress transportAddress : MockTransportService.extractTransportAddresses(transportService)) {
            noRegistered &= this.addConnectBehavior(transportAddress, connectBehavior);
        }
        return noRegistered;
    }

    public boolean addConnectBehavior(TransportAddress transportAddress, StubbableTransport.OpenConnectionBehavior connectBehavior) {
        return this.transport().addConnectBehavior(transportAddress, connectBehavior);
    }

    public boolean addGetConnectionBehavior(TransportAddress transportAddress, StubbableConnectionManager.GetConnectionBehavior behavior) {
        return this.connectionManager().addGetConnectionBehavior(transportAddress, behavior);
    }

    public boolean addGetConnectionBehavior(StubbableConnectionManager.GetConnectionBehavior behavior) {
        return this.connectionManager().setDefaultGetConnectionBehavior(behavior);
    }

    public boolean addNodeConnectedBehavior(StubbableConnectionManager.NodeConnectedBehavior behavior) {
        return this.connectionManager().setDefaultNodeConnectedBehavior(behavior);
    }

    public StubbableTransport transport() {
        return (StubbableTransport)this.transport;
    }

    public StubbableConnectionManager connectionManager() {
        return (StubbableConnectionManager)this.connectionManager;
    }

    public Transport getOriginalTransport() {
        StubbableTransport transport = this.transport();
        while (transport instanceof StubbableTransport) {
            transport = transport.getDelegate();
        }
        return transport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transport.Connection openConnection(DiscoveryNode node, ConnectionProfile profile) {
        Transport.Connection connection = super.openConnection(node, profile);
        Map<DiscoveryNode, List<Transport.Connection>> map = this.openConnections;
        synchronized (map) {
            this.openConnections.computeIfAbsent(node, n -> new CopyOnWriteArrayList()).add(connection);
            connection.addCloseListener(ActionListener.wrap(() -> {
                Map<DiscoveryNode, List<Transport.Connection>> map = this.openConnections;
                synchronized (map) {
                    List<Transport.Connection> connections = this.openConnections.get(node);
                    boolean remove = connections.remove(connection);
                    assert (remove) : "Should have removed connection";
                    if (connections.isEmpty()) {
                        this.openConnections.remove(node);
                    }
                    if (this.openConnections.isEmpty()) {
                        this.openConnections.notifyAll();
                    }
                }
            }));
        }
        return connection;
    }

    public void addOnStopListener(Runnable listener) {
        this.onStopListeners.add(listener);
    }

    protected void doStop() {
        this.onStopListeners.forEach(Runnable::run);
        super.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doClose() throws IOException {
        super.doClose();
        try {
            Map<DiscoveryNode, List<Transport.Connection>> map = this.openConnections;
            synchronized (map) {
                if (!this.openConnections.isEmpty()) {
                    this.openConnections.wait(TimeUnit.SECONDS.toMillis(30L));
                }
                assert (this.openConnections.size() == 0) : "still open connections: " + String.valueOf(this.openConnections);
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    public DiscoveryNode getLocalDiscoNode() {
        return this.getLocalNode();
    }

    public static class TestPlugin
    extends Plugin {
        public List<Setting<?>> getSettings() {
            return Arrays.asList(MockTaskManager.USE_MOCK_TASK_MANAGER_SETTING);
        }
    }
}

