/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.threadpool;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicReference;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.OpenSearchExecutors;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.node.Node;
import org.opensearch.threadpool.ExecutorBuilder;
import org.opensearch.threadpool.RunnableTaskExecutionListener;
import org.opensearch.threadpool.ThreadPool;

public class TestThreadPool
extends ThreadPool {
    private final CountDownLatch blockingLatch = new CountDownLatch(1);
    private volatile boolean returnRejectingExecutor = false;
    private volatile ThreadPoolExecutor rejectingExecutor;

    public TestThreadPool(String name, AtomicReference<RunnableTaskExecutionListener> runnableTaskListener, ExecutorBuilder<?> ... customBuilders) {
        this(name, Settings.EMPTY, runnableTaskListener, customBuilders);
    }

    public TestThreadPool(String name, ExecutorBuilder<?> ... customBuilders) {
        this(name, Settings.EMPTY, customBuilders);
    }

    public TestThreadPool(String name, Settings settings, ExecutorBuilder<?> ... customBuilders) {
        this(name, settings, (AtomicReference<RunnableTaskExecutionListener>)null, customBuilders);
    }

    public TestThreadPool(String name, Settings settings, AtomicReference<RunnableTaskExecutionListener> runnableTaskListener, ExecutorBuilder<?> ... customBuilders) {
        super(Settings.builder().put(Node.NODE_NAME_SETTING.getKey(), name).put(settings).build(), runnableTaskListener, customBuilders);
    }

    public ExecutorService executor(String name) {
        if (this.returnRejectingExecutor) {
            return this.rejectingExecutor;
        }
        return super.executor(name);
    }

    public void startForcingRejections() {
        if (this.rejectingExecutor == null) {
            this.createRejectingExecutor();
        }
        this.returnRejectingExecutor = true;
    }

    public void stopForcingRejections() {
        this.returnRejectingExecutor = false;
    }

    public void shutdown() {
        this.blockingLatch.countDown();
        if (this.rejectingExecutor != null) {
            this.rejectingExecutor.shutdown();
        }
        super.shutdown();
    }

    public void shutdownNow() {
        this.blockingLatch.countDown();
        if (this.rejectingExecutor != null) {
            this.rejectingExecutor.shutdownNow();
        }
        super.shutdownNow();
    }

    private synchronized void createRejectingExecutor() {
        if (this.rejectingExecutor != null) {
            return;
        }
        ThreadFactory factory = OpenSearchExecutors.daemonThreadFactory((String)"reject_thread");
        this.rejectingExecutor = OpenSearchExecutors.newFixed((String)"rejecting", (int)1, (int)0, (ThreadFactory)factory, (ThreadContext)this.getThreadContext());
        CountDownLatch startedLatch = new CountDownLatch(1);
        this.rejectingExecutor.execute(() -> {
            try {
                startedLatch.countDown();
                this.blockingLatch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        });
        try {
            startedLatch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

