/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.remotestore.mocks;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Base64;
import java.util.HashMap;
import org.opensearch.common.blobstore.BlobPath;
import org.opensearch.common.blobstore.InputStreamWithMetadata;
import org.opensearch.common.blobstore.fs.FsBlobStore;
import org.opensearch.common.blobstore.stream.write.WriteContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.remotestore.multipart.mocks.MockFsAsyncBlobContainer;

public class MockFsMetadataSupportedBlobContainer
extends MockFsAsyncBlobContainer {
    private static String CHECKPOINT_FILE_DATA_KEY = "ckp-data";

    public MockFsMetadataSupportedBlobContainer(FsBlobStore blobStore, BlobPath blobPath, Path path, boolean triggerDataIntegrityFailure) {
        super(blobStore, blobPath, path, triggerDataIntegrityFailure);
    }

    @Override
    public void asyncBlobUpload(WriteContext writeContext, ActionListener<Void> completionListener) throws IOException {
        if (writeContext.getMetadata() != null) {
            String base64String = (String)writeContext.getMetadata().get(CHECKPOINT_FILE_DATA_KEY);
            byte[] decodedBytes = Base64.getDecoder().decode(base64String);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(decodedBytes);
            int length = decodedBytes.length;
            String ckpFileName = this.getCheckpointFileName(writeContext.getFileName());
            this.writeBlob(ckpFileName, inputStream, length, true);
        }
        super.asyncBlobUpload(writeContext, completionListener);
    }

    private String getCheckpointFileName(String translogFileName) {
        if (!translogFileName.endsWith(".tlog")) {
            throw new IllegalArgumentException("Invalid translog file name format: " + translogFileName);
        }
        int dotIndex = translogFileName.lastIndexOf(46);
        String baseName = translogFileName.substring(0, dotIndex);
        return baseName + ".ckp";
    }

    public static String convertToBase64(InputStream inputStream) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            int bytesRead;
            byte[] buffer = new byte[128];
            int totalBytesRead = 0;
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                byteArrayOutputStream.write(buffer, 0, bytesRead);
                if ((totalBytesRead += bytesRead) > 1024) {
                    throw new AssertionError((Object)"Input stream exceeds 1KB limit");
                }
            }
            byte[] bytes = byteArrayOutputStream.toByteArray();
            String string = Base64.getEncoder().encodeToString(bytes);
            return string;
        }
    }

    public InputStreamWithMetadata readBlobWithMetadata(String blobName) throws IOException {
        String ckpFileName = this.getCheckpointFileName(blobName);
        InputStream inputStream = this.readBlob(blobName);
        try (InputStream ckpInputStream = this.readBlob(ckpFileName);){
            String ckpString = MockFsMetadataSupportedBlobContainer.convertToBase64(ckpInputStream);
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put(CHECKPOINT_FILE_DATA_KEY, ckpString);
            InputStreamWithMetadata inputStreamWithMetadata = new InputStreamWithMetadata(inputStream, metadata);
            return inputStreamWithMetadata;
        }
    }
}

