/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.repositories.blobstore;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.NoSuchFileException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.opensearch.action.ActionRunnable;
import org.opensearch.action.admin.cluster.snapshots.create.CreateSnapshotRequestBuilder;
import org.opensearch.action.admin.cluster.snapshots.create.CreateSnapshotResponse;
import org.opensearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequestBuilder;
import org.opensearch.action.admin.cluster.snapshots.restore.RestoreSnapshotResponse;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.index.IndexRequestBuilder;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.PlainActionFuture;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.common.SetOnce;
import org.opensearch.common.blobstore.BlobContainer;
import org.opensearch.common.blobstore.BlobMetadata;
import org.opensearch.common.blobstore.BlobPath;
import org.opensearch.common.blobstore.BlobStore;
import org.opensearch.common.io.Streams;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesArray;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.compress.CompressorRegistry;
import org.opensearch.repositories.IndexId;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.repositories.Repository;
import org.opensearch.repositories.RepositoryData;
import org.opensearch.repositories.blobstore.BlobStoreRepository;
import org.opensearch.snapshots.SnapshotMissingException;
import org.opensearch.snapshots.SnapshotRestoreException;
import org.opensearch.test.OpenSearchIntegTestCase;
import org.opensearch.test.hamcrest.OpenSearchAssertions;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.Client;

public abstract class OpenSearchBlobStoreRepositoryIntegTestCase
extends OpenSearchIntegTestCase {
    public static RepositoryData getRepositoryData(Repository repository) {
        return (RepositoryData)PlainActionFuture.get(arg_0 -> ((Repository)repository).getRepositoryData(arg_0));
    }

    protected abstract String repositoryType();

    protected Settings repositorySettings() {
        boolean compress = OpenSearchBlobStoreRepositoryIntegTestCase.randomBoolean();
        Settings.Builder builder = Settings.builder();
        builder.put("compress", compress);
        if (compress) {
            builder.put("compression_type", (String)OpenSearchBlobStoreRepositoryIntegTestCase.randomFrom(CompressorRegistry.registeredCompressors().keySet()));
        }
        return builder.build();
    }

    protected final String createRepository(String name) {
        return this.createRepository(name, this.repositorySettings());
    }

    protected final String createRepository(String name, Settings settings) {
        boolean verify = OpenSearchBlobStoreRepositoryIntegTestCase.randomBoolean();
        this.logger.debug("-->  creating repository [name: {}, verify: {}, settings: {}]", (Object)name, (Object)verify, (Object)settings);
        OpenSearchIntegTestCase.putRepository(OpenSearchBlobStoreRepositoryIntegTestCase.client().admin().cluster(), name, this.repositoryType(), verify, Settings.builder().put(settings));
        OpenSearchBlobStoreRepositoryIntegTestCase.internalCluster().getDataOrClusterManagerNodeInstances(RepositoriesService.class).forEach(repositories -> {
            OpenSearchBlobStoreRepositoryIntegTestCase.assertThat((Object)repositories.repository(name), (Matcher)Matchers.notNullValue());
            OpenSearchBlobStoreRepositoryIntegTestCase.assertThat((Object)repositories.repository(name), (Matcher)Matchers.instanceOf(BlobStoreRepository.class));
            OpenSearchBlobStoreRepositoryIntegTestCase.assertThat((Object)repositories.repository(name).isReadOnly(), (Matcher)Matchers.is((Object)false));
            BlobStore blobStore = ((BlobStoreRepository)repositories.repository(name)).getBlobStore();
            OpenSearchBlobStoreRepositoryIntegTestCase.assertThat((String)"blob store has to be lazy initialized", (Object)blobStore, (Matcher)(verify ? Matchers.is((Matcher)Matchers.notNullValue()) : Matchers.is((Matcher)Matchers.nullValue())));
        });
        return name;
    }

    public void testReadNonExistingPath() throws IOException {
        try (BlobStore store = this.newBlobStore();){
            BlobContainer container = store.blobContainer(new BlobPath());
            OpenSearchBlobStoreRepositoryIntegTestCase.expectThrows(NoSuchFileException.class, () -> {
                try (InputStream is = container.readBlob("non-existing");){
                    is.read();
                }
            });
        }
    }

    public void testWriteRead() throws IOException {
        try (BlobStore store = this.newBlobStore();){
            BlobContainer container = store.blobContainer(new BlobPath());
            byte[] data = OpenSearchBlobStoreRepositoryIntegTestCase.randomBytes(OpenSearchBlobStoreRepositoryIntegTestCase.randomIntBetween(10, OpenSearchBlobStoreRepositoryIntegTestCase.scaledRandomIntBetween(1024, 65536)));
            OpenSearchBlobStoreRepositoryIntegTestCase.writeBlob(container, "foobar", new BytesArray(data), OpenSearchBlobStoreRepositoryIntegTestCase.randomBoolean());
            if (OpenSearchBlobStoreRepositoryIntegTestCase.randomBoolean()) {
                data = OpenSearchBlobStoreRepositoryIntegTestCase.randomBytes(OpenSearchBlobStoreRepositoryIntegTestCase.randomIntBetween(10, OpenSearchBlobStoreRepositoryIntegTestCase.scaledRandomIntBetween(1024, 65536)));
                OpenSearchBlobStoreRepositoryIntegTestCase.writeBlob(container, "foobar", new BytesArray(data), false);
            }
            try (InputStream stream = container.readBlob("foobar");){
                BytesRefBuilder target = new BytesRefBuilder();
                while (target.length() < data.length) {
                    int offset;
                    byte[] buffer = new byte[OpenSearchBlobStoreRepositoryIntegTestCase.scaledRandomIntBetween(1, data.length - target.length())];
                    int read = stream.read(buffer, offset = OpenSearchBlobStoreRepositoryIntegTestCase.scaledRandomIntBetween(0, buffer.length - 1), buffer.length - offset);
                    if (read >= 0) {
                        target.append(new BytesRef(buffer, offset, read));
                        continue;
                    }
                    OpenSearchBlobStoreRepositoryIntegTestCase.fail((String)("Expected [" + (data.length - target.length()) + "] more bytes to be readable but reached EOF"));
                }
                OpenSearchBlobStoreRepositoryIntegTestCase.assertEquals((long)data.length, (long)target.length());
                OpenSearchBlobStoreRepositoryIntegTestCase.assertArrayEquals((byte[])data, (byte[])Arrays.copyOfRange(target.bytes(), 0, target.length()));
            }
            container.delete();
        }
    }

    public void testReadRange() throws IOException {
        try (BlobStore store = this.newBlobStore();){
            BlobContainer container = store.blobContainer(new BlobPath());
            byte[] data = OpenSearchBlobStoreRepositoryIntegTestCase.randomBytes(4096);
            int startOffset = OpenSearchBlobStoreRepositoryIntegTestCase.randomIntBetween(100, 1000);
            int endOffset = OpenSearchBlobStoreRepositoryIntegTestCase.randomIntBetween(startOffset + 100, data.length - 100);
            byte[] subrangeData = Arrays.copyOfRange(data, startOffset, endOffset);
            OpenSearchBlobStoreRepositoryIntegTestCase.writeBlob(container, "foobar", new BytesArray(data), OpenSearchBlobStoreRepositoryIntegTestCase.randomBoolean());
            try (InputStream stream = container.readBlob("foobar", (long)startOffset, (long)subrangeData.length);){
                byte[] actual = stream.readAllBytes();
                OpenSearchBlobStoreRepositoryIntegTestCase.assertArrayEquals((byte[])subrangeData, (byte[])actual);
            }
            container.delete();
        }
    }

    public void testList() throws IOException {
        try (BlobStore store = this.newBlobStore();){
            String name;
            int length;
            int i;
            BlobContainer container = store.blobContainer(new BlobPath());
            OpenSearchBlobStoreRepositoryIntegTestCase.assertThat((Object)container.listBlobs().size(), (Matcher)CoreMatchers.equalTo((Object)0));
            int numberOfFooBlobs = OpenSearchBlobStoreRepositoryIntegTestCase.randomIntBetween(0, 10);
            int numberOfBarBlobs = OpenSearchBlobStoreRepositoryIntegTestCase.randomIntBetween(3, 20);
            HashMap<Object, Long> generatedBlobs = new HashMap<Object, Long>();
            for (i = 0; i < numberOfFooBlobs; ++i) {
                length = OpenSearchBlobStoreRepositoryIntegTestCase.randomIntBetween(10, 100);
                name = "foo-" + i + "-";
                generatedBlobs.put(name, Long.valueOf(length));
                OpenSearchBlobStoreRepositoryIntegTestCase.writeRandomBlob(container, name, length);
            }
            for (i = 1; i < numberOfBarBlobs; ++i) {
                length = OpenSearchBlobStoreRepositoryIntegTestCase.randomIntBetween(10, 100);
                name = "bar-" + i + "-";
                generatedBlobs.put(name, Long.valueOf(length));
                OpenSearchBlobStoreRepositoryIntegTestCase.writeRandomBlob(container, name, length);
            }
            int length2 = OpenSearchBlobStoreRepositoryIntegTestCase.randomIntBetween(10, 100);
            String name2 = "bar-0-";
            generatedBlobs.put(name2, Long.valueOf(length2));
            OpenSearchBlobStoreRepositoryIntegTestCase.writeRandomBlob(container, name2, length2);
            Map blobs = container.listBlobs();
            OpenSearchBlobStoreRepositoryIntegTestCase.assertThat((Object)blobs.size(), (Matcher)CoreMatchers.equalTo((Object)(numberOfFooBlobs + numberOfBarBlobs)));
            for (Map.Entry generated : generatedBlobs.entrySet()) {
                BlobMetadata blobMetadata = (BlobMetadata)blobs.get(generated.getKey());
                OpenSearchBlobStoreRepositoryIntegTestCase.assertThat((String)((String)generated.getKey()), (Object)blobMetadata, (Matcher)CoreMatchers.notNullValue());
                OpenSearchBlobStoreRepositoryIntegTestCase.assertThat((Object)blobMetadata.name(), (Matcher)CoreMatchers.equalTo((Object)((String)generated.getKey())));
                OpenSearchBlobStoreRepositoryIntegTestCase.assertThat((Object)blobMetadata.length(), (Matcher)CoreMatchers.equalTo((Object)((Long)generated.getValue())));
            }
            OpenSearchBlobStoreRepositoryIntegTestCase.assertThat((Object)container.listBlobsByPrefix("foo-").size(), (Matcher)CoreMatchers.equalTo((Object)numberOfFooBlobs));
            OpenSearchBlobStoreRepositoryIntegTestCase.assertThat((Object)container.listBlobsByPrefix("bar-").size(), (Matcher)CoreMatchers.equalTo((Object)numberOfBarBlobs));
            OpenSearchBlobStoreRepositoryIntegTestCase.assertThat((Object)container.listBlobsByPrefix("baz-").size(), (Matcher)CoreMatchers.equalTo((Object)0));
            container.delete();
        }
    }

    public void testDeleteBlobs() throws IOException {
        try (BlobStore store = this.newBlobStore();){
            List<String> blobNames = Arrays.asList("foobar", "barfoo");
            BlobContainer container = store.blobContainer(new BlobPath());
            container.deleteBlobsIgnoringIfNotExists(blobNames);
            byte[] data = OpenSearchBlobStoreRepositoryIntegTestCase.randomBytes(OpenSearchBlobStoreRepositoryIntegTestCase.randomIntBetween(10, OpenSearchBlobStoreRepositoryIntegTestCase.scaledRandomIntBetween(1024, 65536)));
            BytesArray bytesArray = new BytesArray(data);
            for (String blobName : blobNames) {
                OpenSearchBlobStoreRepositoryIntegTestCase.writeBlob(container, blobName, bytesArray, OpenSearchBlobStoreRepositoryIntegTestCase.randomBoolean());
            }
            OpenSearchBlobStoreRepositoryIntegTestCase.assertEquals((long)container.listBlobs().size(), (long)2L);
            container.deleteBlobsIgnoringIfNotExists(blobNames);
            OpenSearchBlobStoreRepositoryIntegTestCase.assertTrue((boolean)container.listBlobs().isEmpty());
            container.deleteBlobsIgnoringIfNotExists(blobNames);
        }
    }

    public static void writeBlob(BlobContainer container, String blobName, BytesArray bytesArray, boolean failIfAlreadyExists) throws IOException {
        try (StreamInput stream = bytesArray.streamInput();){
            if (OpenSearchBlobStoreRepositoryIntegTestCase.randomBoolean()) {
                container.writeBlob(blobName, (InputStream)stream, (long)bytesArray.length(), failIfAlreadyExists);
            } else {
                container.writeBlobAtomic(blobName, (InputStream)stream, (long)bytesArray.length(), failIfAlreadyExists);
            }
        }
    }

    public void testContainerCreationAndDeletion() throws IOException {
        try (BlobStore store = this.newBlobStore();){
            BlobContainer containerFoo = store.blobContainer(new BlobPath().add("foo"));
            BlobContainer containerBar = store.blobContainer(new BlobPath().add("bar"));
            byte[] data1 = OpenSearchBlobStoreRepositoryIntegTestCase.randomBytes(OpenSearchBlobStoreRepositoryIntegTestCase.randomIntBetween(10, OpenSearchBlobStoreRepositoryIntegTestCase.scaledRandomIntBetween(1024, 65536)));
            byte[] data2 = OpenSearchBlobStoreRepositoryIntegTestCase.randomBytes(OpenSearchBlobStoreRepositoryIntegTestCase.randomIntBetween(10, OpenSearchBlobStoreRepositoryIntegTestCase.scaledRandomIntBetween(1024, 65536)));
            OpenSearchBlobStoreRepositoryIntegTestCase.writeBlob(containerFoo, "test", new BytesArray(data1));
            OpenSearchBlobStoreRepositoryIntegTestCase.writeBlob(containerBar, "test", new BytesArray(data2));
            OpenSearchBlobStoreRepositoryIntegTestCase.assertArrayEquals((byte[])OpenSearchBlobStoreRepositoryIntegTestCase.readBlobFully(containerFoo, "test", data1.length), (byte[])data1);
            OpenSearchBlobStoreRepositoryIntegTestCase.assertArrayEquals((byte[])OpenSearchBlobStoreRepositoryIntegTestCase.readBlobFully(containerBar, "test", data2.length), (byte[])data2);
            OpenSearchBlobStoreRepositoryIntegTestCase.assertTrue((boolean)containerFoo.blobExists("test"));
            OpenSearchBlobStoreRepositoryIntegTestCase.assertTrue((boolean)containerBar.blobExists("test"));
            containerBar.delete();
            containerFoo.delete();
        }
    }

    public static byte[] writeRandomBlob(BlobContainer container, String name, int length) throws IOException {
        byte[] data = OpenSearchBlobStoreRepositoryIntegTestCase.randomBytes(length);
        OpenSearchBlobStoreRepositoryIntegTestCase.writeBlob(container, name, new BytesArray(data));
        return data;
    }

    public static byte[] readBlobFully(BlobContainer container, String name, int length) throws IOException {
        byte[] data = new byte[length];
        try (InputStream inputStream = container.readBlob(name);){
            OpenSearchBlobStoreRepositoryIntegTestCase.assertThat((Object)Streams.readFully((InputStream)inputStream, (byte[])data), (Matcher)CoreMatchers.equalTo((Object)length));
            OpenSearchBlobStoreRepositoryIntegTestCase.assertThat((Object)inputStream.read(), (Matcher)CoreMatchers.equalTo((Object)-1));
        }
        return data;
    }

    public static byte[] randomBytes(int length) {
        byte[] data = new byte[length];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)OpenSearchBlobStoreRepositoryIntegTestCase.randomInt();
        }
        return data;
    }

    protected static void writeBlob(BlobContainer container, String blobName, BytesArray bytesArray) throws IOException {
        try (StreamInput stream = bytesArray.streamInput();){
            container.writeBlob(blobName, (InputStream)stream, (long)bytesArray.length(), true);
        }
    }

    protected BlobStore newBlobStore() {
        String repository = this.createRepository(OpenSearchBlobStoreRepositoryIntegTestCase.randomName());
        BlobStoreRepository blobStoreRepository = (BlobStoreRepository)OpenSearchBlobStoreRepositoryIntegTestCase.internalCluster().getClusterManagerNodeInstance(RepositoriesService.class).repository(repository);
        return (BlobStore)PlainActionFuture.get(f -> blobStoreRepository.threadPool().generic().execute((Runnable)ActionRunnable.supply((ActionListener)f, () -> ((BlobStoreRepository)blobStoreRepository).blobStore())));
    }

    public void testSnapshotAndRestore() throws Exception {
        String repoName = this.createRepository(OpenSearchBlobStoreRepositoryIntegTestCase.randomName());
        int indexCount = OpenSearchBlobStoreRepositoryIntegTestCase.randomIntBetween(1, 5);
        int[] docCounts = new int[indexCount];
        String[] indexNames = this.generateRandomNames(indexCount);
        for (int i = 0; i < indexCount; ++i) {
            docCounts[i] = OpenSearchBlobStoreRepositoryIntegTestCase.iterations(10, 1000);
            this.logger.info("-->  create random index {} with {} records", (Object)indexNames[i], (Object)docCounts[i]);
            this.addRandomDocuments(indexNames[i], docCounts[i]);
            OpenSearchAssertions.assertHitCount((SearchResponse)OpenSearchBlobStoreRepositoryIntegTestCase.client().prepareSearch(new String[]{indexNames[i]}).setSize(0).get(), docCounts[i]);
        }
        String snapshotName = OpenSearchBlobStoreRepositoryIntegTestCase.randomName();
        this.logger.info("-->  create snapshot {}:{}", (Object)repoName, (Object)snapshotName);
        OpenSearchBlobStoreRepositoryIntegTestCase.assertSuccessfulSnapshot(OpenSearchBlobStoreRepositoryIntegTestCase.client().admin().cluster().prepareCreateSnapshot(repoName, snapshotName).setWaitForCompletion(true).setIndices(indexNames));
        List<String> deleteIndices = OpenSearchBlobStoreRepositoryIntegTestCase.randomSubsetOf(OpenSearchBlobStoreRepositoryIntegTestCase.randomIntBetween(0, indexCount), indexNames);
        if (deleteIndices.size() > 0) {
            this.logger.info("-->  delete indices {}", deleteIndices);
            OpenSearchAssertions.assertAcked(OpenSearchBlobStoreRepositoryIntegTestCase.client().admin().indices().prepareDelete(deleteIndices.toArray(new String[0])));
        }
        HashSet<String> closeIndices = new HashSet<String>(Arrays.asList(indexNames));
        closeIndices.removeAll(deleteIndices);
        if (closeIndices.size() > 0) {
            for (String index : closeIndices) {
                if (OpenSearchBlobStoreRepositoryIntegTestCase.randomBoolean()) {
                    this.logger.info("--> add random documents to {}", (Object)index);
                    this.addRandomDocuments(index, OpenSearchBlobStoreRepositoryIntegTestCase.randomIntBetween(10, 1000));
                    continue;
                }
                int docCount = (int)((SearchResponse)OpenSearchBlobStoreRepositoryIntegTestCase.client().prepareSearch(new String[]{index}).setSize(0).get()).getHits().getTotalHits().value();
                int deleteCount = OpenSearchBlobStoreRepositoryIntegTestCase.randomIntBetween(1, docCount);
                this.logger.info("--> delete {} random documents from {}", (Object)deleteCount, (Object)index);
                for (int i = 0; i < deleteCount; ++i) {
                    int doc = OpenSearchBlobStoreRepositoryIntegTestCase.randomIntBetween(0, docCount - 1);
                    OpenSearchBlobStoreRepositoryIntegTestCase.client().prepareDelete(index, Integer.toString(doc)).get();
                }
                OpenSearchBlobStoreRepositoryIntegTestCase.client().admin().indices().prepareRefresh(new String[]{index}).get();
            }
            this.ensureGreen(new String[0]);
            this.logger.info("-->  close indices {}", closeIndices);
            OpenSearchAssertions.assertAcked(OpenSearchBlobStoreRepositoryIntegTestCase.client().admin().indices().prepareClose(closeIndices.toArray(new String[0])));
        }
        this.logger.info("--> restore all indices from the snapshot");
        OpenSearchBlobStoreRepositoryIntegTestCase.assertSuccessfulRestore(OpenSearchBlobStoreRepositoryIntegTestCase.client().admin().cluster().prepareRestoreSnapshot(repoName, snapshotName).setWaitForCompletion(true));
        this.ensureGreen(TimeValue.timeValueSeconds((long)120L), new String[0]);
        for (int i = 0; i < indexCount; ++i) {
            OpenSearchAssertions.assertHitCount((SearchResponse)OpenSearchBlobStoreRepositoryIntegTestCase.client().prepareSearch(new String[]{indexNames[i]}).setSize(0).get(), docCounts[i]);
        }
        this.logger.info("-->  delete snapshot {}:{}", (Object)repoName, (Object)snapshotName);
        OpenSearchAssertions.assertAcked((AcknowledgedResponse)OpenSearchBlobStoreRepositoryIntegTestCase.client().admin().cluster().prepareDeleteSnapshot(repoName, new String[]{snapshotName}).get());
        OpenSearchBlobStoreRepositoryIntegTestCase.expectThrows(SnapshotMissingException.class, () -> OpenSearchBlobStoreRepositoryIntegTestCase.client().admin().cluster().prepareGetSnapshots(repoName).setSnapshots(new String[]{snapshotName}).get());
        OpenSearchBlobStoreRepositoryIntegTestCase.expectThrows(SnapshotMissingException.class, () -> OpenSearchBlobStoreRepositoryIntegTestCase.client().admin().cluster().prepareDeleteSnapshot(repoName, new String[]{snapshotName}).get());
        OpenSearchBlobStoreRepositoryIntegTestCase.expectThrows(SnapshotRestoreException.class, () -> OpenSearchBlobStoreRepositoryIntegTestCase.client().admin().cluster().prepareRestoreSnapshot(repoName, snapshotName).setWaitForCompletion(OpenSearchBlobStoreRepositoryIntegTestCase.randomBoolean()).get());
    }

    public void testMultipleSnapshotAndRollback() throws Exception {
        int i;
        String repoName = this.createRepository(OpenSearchBlobStoreRepositoryIntegTestCase.randomName());
        int iterationCount = OpenSearchBlobStoreRepositoryIntegTestCase.randomIntBetween(2, 5);
        int[] docCounts = new int[iterationCount];
        String indexName = OpenSearchBlobStoreRepositoryIntegTestCase.randomName();
        String snapshotName = OpenSearchBlobStoreRepositoryIntegTestCase.randomName();
        OpenSearchAssertions.assertAcked((CreateIndexResponse)OpenSearchBlobStoreRepositoryIntegTestCase.client().admin().indices().prepareCreate(indexName).get());
        for (int i2 = 0; i2 < iterationCount; ++i2) {
            if (OpenSearchBlobStoreRepositoryIntegTestCase.randomBoolean() && i2 > 0) {
                docCount = docCounts[i2 - 1];
                if (docCount > 0) {
                    int deleteCount = OpenSearchBlobStoreRepositoryIntegTestCase.randomIntBetween(1, docCount);
                    this.logger.info("--> delete {} random documents from {}", (Object)deleteCount, (Object)indexName);
                    for (int j = 0; j < deleteCount; ++j) {
                        int doc = OpenSearchBlobStoreRepositoryIntegTestCase.randomIntBetween(0, docCount - 1);
                        OpenSearchBlobStoreRepositoryIntegTestCase.client().prepareDelete(indexName, Integer.toString(doc)).get();
                    }
                    OpenSearchBlobStoreRepositoryIntegTestCase.client().admin().indices().prepareRefresh(new String[]{indexName}).get();
                }
            } else {
                docCount = OpenSearchBlobStoreRepositoryIntegTestCase.randomIntBetween(10, 1000);
                this.logger.info("--> add {} random documents to {}", (Object)docCount, (Object)indexName);
                this.addRandomDocuments(indexName, docCount);
            }
            docCounts[i2] = (int)((SearchResponse)OpenSearchBlobStoreRepositoryIntegTestCase.client().prepareSearch(new String[]{indexName}).setSize(0).get()).getHits().getTotalHits().value();
            this.logger.info("-->  create snapshot {}:{} with {} documents", (Object)repoName, (Object)(snapshotName + "-" + i2), (Object)docCounts[i2]);
            OpenSearchBlobStoreRepositoryIntegTestCase.assertSuccessfulSnapshot(OpenSearchBlobStoreRepositoryIntegTestCase.client().admin().cluster().prepareCreateSnapshot(repoName, snapshotName + "-" + i2).setWaitForCompletion(true).setIndices(new String[]{indexName}));
        }
        int restoreOperations = OpenSearchBlobStoreRepositoryIntegTestCase.randomIntBetween(1, 3);
        for (i = 0; i < restoreOperations; ++i) {
            int iterationToRestore = OpenSearchBlobStoreRepositoryIntegTestCase.randomIntBetween(0, iterationCount - 1);
            this.logger.info("-->  performing restore of the iteration {}", (Object)iterationToRestore);
            this.ensureGreen(new String[0]);
            this.logger.info("-->  close index");
            OpenSearchAssertions.assertAcked(OpenSearchBlobStoreRepositoryIntegTestCase.client().admin().indices().prepareClose(new String[]{indexName}));
            this.logger.info("--> restore index from the snapshot");
            OpenSearchBlobStoreRepositoryIntegTestCase.assertSuccessfulRestore(OpenSearchBlobStoreRepositoryIntegTestCase.client().admin().cluster().prepareRestoreSnapshot(repoName, snapshotName + "-" + iterationToRestore).setWaitForCompletion(true));
            this.ensureGreen(new String[0]);
            OpenSearchAssertions.assertHitCount((SearchResponse)OpenSearchBlobStoreRepositoryIntegTestCase.client().prepareSearch(new String[]{indexName}).setSize(0).get(), docCounts[iterationToRestore]);
        }
        for (i = 0; i < iterationCount; ++i) {
            this.logger.info("-->  delete snapshot {}:{}", (Object)repoName, (Object)(snapshotName + "-" + i));
            OpenSearchAssertions.assertAcked((AcknowledgedResponse)OpenSearchBlobStoreRepositoryIntegTestCase.client().admin().cluster().prepareDeleteSnapshot(repoName, new String[]{snapshotName + "-" + i}).get());
        }
    }

    public void testIndicesDeletedFromRepository() throws Exception {
        String repoName = this.createRepository("test-repo-" + OpenSearchBlobStoreRepositoryIntegTestCase.randomAlphaOfLength(8));
        Client client = OpenSearchBlobStoreRepositoryIntegTestCase.client();
        this.createIndex("test-idx-1", "test-idx-2", "test-idx-3");
        this.ensureGreen(new String[0]);
        this.logger.info("--> indexing some data");
        for (int i = 0; i < 20; ++i) {
            this.index("test-idx-1", "doc", Integer.toString(i), "foo", "bar" + i);
            this.index("test-idx-2", "doc", Integer.toString(i), "foo", "baz" + i);
            this.index("test-idx-3", "doc", Integer.toString(i), "foo", "baz" + i);
        }
        this.refresh(new String[0]);
        this.logger.info("--> take a snapshot");
        CreateSnapshotResponse createSnapshotResponse = (CreateSnapshotResponse)client.admin().cluster().prepareCreateSnapshot(repoName, "test-snap").setWaitForCompletion(true).get();
        OpenSearchBlobStoreRepositoryIntegTestCase.assertEquals((long)createSnapshotResponse.getSnapshotInfo().successfulShards(), (long)createSnapshotResponse.getSnapshotInfo().totalShards());
        this.logger.info("--> indexing more data");
        for (int i = 20; i < 40; ++i) {
            this.index("test-idx-1", "doc", Integer.toString(i), "foo", "bar" + i);
            this.index("test-idx-2", "doc", Integer.toString(i), "foo", "baz" + i);
            this.index("test-idx-3", "doc", Integer.toString(i), "foo", "baz" + i);
        }
        this.logger.info("--> take another snapshot with only 2 of the 3 indices");
        createSnapshotResponse = (CreateSnapshotResponse)client.admin().cluster().prepareCreateSnapshot(repoName, "test-snap2").setWaitForCompletion(true).setIndices(new String[]{"test-idx-1", "test-idx-2"}).get();
        OpenSearchBlobStoreRepositoryIntegTestCase.assertEquals((long)createSnapshotResponse.getSnapshotInfo().successfulShards(), (long)createSnapshotResponse.getSnapshotInfo().totalShards());
        this.logger.info("--> delete a snapshot");
        OpenSearchAssertions.assertAcked((AcknowledgedResponse)OpenSearchBlobStoreRepositoryIntegTestCase.client().admin().cluster().prepareDeleteSnapshot(repoName, new String[]{"test-snap"}).get());
        this.logger.info("--> verify index folder deleted from blob container");
        RepositoriesService repositoriesSvc = OpenSearchBlobStoreRepositoryIntegTestCase.internalCluster().getInstance(RepositoriesService.class, OpenSearchBlobStoreRepositoryIntegTestCase.internalCluster().getClusterManagerName());
        ThreadPool threadPool = OpenSearchBlobStoreRepositoryIntegTestCase.internalCluster().getInstance(ThreadPool.class, OpenSearchBlobStoreRepositoryIntegTestCase.internalCluster().getClusterManagerName());
        BlobStoreRepository repository = (BlobStoreRepository)repositoriesSvc.repository(repoName);
        SetOnce indicesBlobContainer = new SetOnce();
        PlainActionFuture repositoryData = PlainActionFuture.newFuture();
        threadPool.executor("snapshot").execute(() -> {
            indicesBlobContainer.set((Object)repository.blobStore().blobContainer(repository.basePath().add("indices")));
            repository.getRepositoryData((ActionListener)repositoryData);
        });
        for (IndexId indexId : ((RepositoryData)repositoryData.actionGet()).getIndices().values()) {
            if (!indexId.getName().equals("test-idx-3")) continue;
            OpenSearchBlobStoreRepositoryIntegTestCase.assertFalse((boolean)((BlobContainer)indicesBlobContainer.get()).blobExists(indexId.getId()));
        }
        OpenSearchAssertions.assertAcked((AcknowledgedResponse)OpenSearchBlobStoreRepositoryIntegTestCase.client().admin().cluster().prepareDeleteSnapshot(repoName, new String[]{"test-snap2"}).get());
    }

    protected void addRandomDocuments(String name, int numDocs) throws InterruptedException {
        IndexRequestBuilder[] indexRequestBuilders = new IndexRequestBuilder[numDocs];
        for (int i = 0; i < numDocs; ++i) {
            indexRequestBuilders[i] = OpenSearchBlobStoreRepositoryIntegTestCase.client().prepareIndex(name).setId(Integer.toString(i)).setRouting(OpenSearchBlobStoreRepositoryIntegTestCase.randomAlphaOfLength(OpenSearchBlobStoreRepositoryIntegTestCase.randomIntBetween(1, 10))).setSource(new Object[]{"field", "value"});
        }
        this.indexRandom(true, indexRequestBuilders);
    }

    private String[] generateRandomNames(int num) {
        HashSet<String> names = new HashSet<String>();
        for (int i = 0; i < num; ++i) {
            String name;
            while (names.contains(name = OpenSearchBlobStoreRepositoryIntegTestCase.randomName())) {
            }
            names.add(name);
        }
        return names.toArray(new String[num]);
    }

    protected static void assertSuccessfulSnapshot(CreateSnapshotRequestBuilder requestBuilder) {
        CreateSnapshotResponse response = (CreateSnapshotResponse)requestBuilder.get();
        OpenSearchBlobStoreRepositoryIntegTestCase.assertSuccessfulSnapshot(response);
    }

    private static void assertSuccessfulSnapshot(CreateSnapshotResponse response) {
        OpenSearchBlobStoreRepositoryIntegTestCase.assertThat((Object)response.getSnapshotInfo().successfulShards(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        OpenSearchBlobStoreRepositoryIntegTestCase.assertThat((Object)response.getSnapshotInfo().successfulShards(), (Matcher)Matchers.equalTo((Object)response.getSnapshotInfo().totalShards()));
    }

    protected static void assertSuccessfulRestore(RestoreSnapshotRequestBuilder requestBuilder) {
        RestoreSnapshotResponse response = (RestoreSnapshotResponse)requestBuilder.get();
        OpenSearchBlobStoreRepositoryIntegTestCase.assertSuccessfulRestore(response);
    }

    private static void assertSuccessfulRestore(RestoreSnapshotResponse response) {
        OpenSearchBlobStoreRepositoryIntegTestCase.assertThat((Object)response.getRestoreInfo().successfulShards(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        OpenSearchBlobStoreRepositoryIntegTestCase.assertThat((Object)response.getRestoreInfo().successfulShards(), (Matcher)Matchers.equalTo((Object)response.getRestoreInfo().totalShards()));
    }

    protected static String randomName() {
        return OpenSearchBlobStoreRepositoryIntegTestCase.randomAlphaOfLength(OpenSearchBlobStoreRepositoryIntegTestCase.randomIntBetween(5, 10)).toLowerCase(Locale.ROOT);
    }
}

