/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.repositories.blobstore;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class ZeroInputStream
extends InputStream {
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final long length;
    private final AtomicLong reads;
    private volatile long mark;

    public ZeroInputStream(long length) {
        this.length = length;
        this.reads = new AtomicLong(0L);
        this.mark = -1L;
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        return this.reads.incrementAndGet() <= this.length ? 0 : -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        if (len == 0) {
            return 0;
        }
        int available = this.available();
        if (available == 0) {
            return -1;
        }
        int toCopy = Math.min(len, available);
        Arrays.fill(b, off, off + toCopy, (byte)0);
        this.reads.addAndGet(toCopy);
        return toCopy;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.mark = this.reads.get();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.ensureOpen();
        this.reads.set(this.mark);
    }

    @Override
    public int available() throws IOException {
        this.ensureOpen();
        if (this.reads.get() >= this.length) {
            return 0;
        }
        try {
            return Math.toIntExact(this.length - this.reads.get());
        }
        catch (ArithmeticException e) {
            return Integer.MAX_VALUE;
        }
    }

    @Override
    public void close() {
        this.closed.set(true);
    }

    private void ensureOpen() throws IOException {
        if (this.closed.get()) {
            throw new IOException("Stream closed");
        }
    }
}

