/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.script;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Scorable;
import org.opensearch.common.collect.Tuple;
import org.opensearch.index.query.IntervalFilterScript;
import org.opensearch.index.similarity.ScriptedSimilarity;
import org.opensearch.script.AggregationScript;
import org.opensearch.script.BucketAggregationScript;
import org.opensearch.script.BucketAggregationSelectorScript;
import org.opensearch.script.DerivedFieldScript;
import org.opensearch.script.FieldScript;
import org.opensearch.script.FilterScript;
import org.opensearch.script.IngestConditionalScript;
import org.opensearch.script.IngestScript;
import org.opensearch.script.MockDeterministicScript;
import org.opensearch.script.NumberSortScript;
import org.opensearch.script.ScoreAccessor;
import org.opensearch.script.ScoreScript;
import org.opensearch.script.Script;
import org.opensearch.script.ScriptContext;
import org.opensearch.script.ScriptEngine;
import org.opensearch.script.ScriptType;
import org.opensearch.script.ScriptedMetricAggContexts;
import org.opensearch.script.SearchScript;
import org.opensearch.script.SignificantTermsHeuristicScoreScript;
import org.opensearch.script.SimilarityScript;
import org.opensearch.script.SimilarityWeightScript;
import org.opensearch.script.StringSortScript;
import org.opensearch.script.TemplateScript;
import org.opensearch.script.TermsSetQueryScript;
import org.opensearch.script.UpdateScript;
import org.opensearch.search.aggregations.pipeline.MovingFunctionScript;
import org.opensearch.search.lookup.LeafSearchLookup;
import org.opensearch.search.lookup.SearchLookup;
import org.opensearch.search.lookup.SourceLookup;

public class MockScriptEngine
implements ScriptEngine {
    public static final String NAME = "mockscript";
    private final String type;
    private final Map<String, MockDeterministicScript> scripts;
    private final Map<ScriptContext<?>, ContextCompiler> contexts;

    public MockScriptEngine(String type, Map<String, Function<Map<String, Object>, Object>> scripts, Map<ScriptContext<?>, ContextCompiler> contexts) {
        this(type, scripts, Collections.emptyMap(), contexts);
    }

    public MockScriptEngine(String type, Map<String, Function<Map<String, Object>, Object>> deterministicScripts, Map<String, Function<Map<String, Object>, Object>> nonDeterministicScripts, Map<ScriptContext<?>, ContextCompiler> contexts) {
        HashMap scripts = new HashMap(deterministicScripts.size() + nonDeterministicScripts.size());
        deterministicScripts.forEach((key, value) -> scripts.put(key, MockDeterministicScript.asDeterministic(value)));
        nonDeterministicScripts.forEach((key, value) -> scripts.put(key, MockDeterministicScript.asNonDeterministic(value)));
        this.type = type;
        this.scripts = Collections.unmodifiableMap(scripts);
        this.contexts = Collections.unmodifiableMap(contexts);
    }

    public MockScriptEngine() {
        this(NAME, Collections.emptyMap(), Collections.emptyMap());
    }

    public String getType() {
        return this.type;
    }

    public <T> T compile(String name, String source, ScriptContext<T> context, Map<String, String> params) {
        final MockDeterministicScript script = this.scripts.get(source);
        if (script == null) {
            throw new IllegalArgumentException("No pre defined script matching [" + source + "] for script with name [" + name + "], did you declare the mocked script?");
        }
        MockCompiledScript mockCompiled = new MockCompiledScript(name, params, source, script);
        if (context.instanceClazz.equals(FieldScript.class)) {
            return context.factoryClazz.cast(new MockFieldScriptFactory(script));
        }
        if (context.instanceClazz.equals(TermsSetQueryScript.class)) {
            TermsSetQueryScript.Factory factory = (parameters, lookup) -> ctx -> new TermsSetQueryScript(this, parameters, lookup, ctx){

                public Number execute() {
                    HashMap<String, Object> vars = new HashMap<String, Object>(parameters);
                    vars.put("params", parameters);
                    vars.put("doc", this.getDoc());
                    return (Number)script.apply((Map<String, Object>)vars);
                }
            };
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(NumberSortScript.class)) {
            NumberSortScript.Factory factory = (parameters, lookup) -> new NumberSortScript.LeafFactory(){

                public NumberSortScript newInstance(LeafReaderContext ctx) {
                    return new NumberSortScript(this, parameters, lookup, ctx){

                        public double execute() {
                            HashMap<String, Object> vars = new HashMap<String, Object>(parameters);
                            vars.put("params", parameters);
                            vars.put("doc", this.getDoc());
                            return ((Number)script.apply((Map<String, Object>)vars)).doubleValue();
                        }
                    };
                }

                public boolean needs_score() {
                    return false;
                }
            };
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(StringSortScript.class)) {
            return context.factoryClazz.cast(new MockStringSortScriptFactory(this, script));
        }
        if (context.instanceClazz.equals(IngestScript.class)) {
            IngestScript.Factory factory = vars -> new IngestScript(this, vars){

                public void execute(Map<String, Object> ctx) {
                    script.apply(ctx);
                }
            };
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(SearchScript.class)) {
            SearchScript.Factory factory = parameters -> new SearchScript(this, parameters){

                public void execute(Map<String, Object> ctx) {
                    script.apply(ctx);
                }
            };
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(AggregationScript.class)) {
            return context.factoryClazz.cast(new MockAggregationScript(this, script));
        }
        if (context.instanceClazz.equals(IngestConditionalScript.class)) {
            IngestConditionalScript.Factory factory = parameters -> new IngestConditionalScript(this, parameters){

                public boolean execute(Map<String, Object> ctx) {
                    return (Boolean)script.apply(ctx);
                }
            };
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(UpdateScript.class)) {
            UpdateScript.Factory factory = (parameters, ctx) -> new UpdateScript(this, parameters, ctx){

                public void execute() {
                    HashMap<String, Object> vars = new HashMap<String, Object>();
                    vars.put("ctx", ctx);
                    vars.put("params", parameters);
                    vars.putAll(parameters);
                    script.apply((Map<String, Object>)vars);
                }
            };
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(BucketAggregationScript.class)) {
            BucketAggregationScript.Factory factory = parameters -> new BucketAggregationScript(this, parameters){

                public Double execute() {
                    Object ret = script.apply(this.getParams());
                    if (ret == null) {
                        return null;
                    }
                    return ((Number)ret).doubleValue();
                }
            };
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(BucketAggregationSelectorScript.class)) {
            BucketAggregationSelectorScript.Factory factory = parameters -> new BucketAggregationSelectorScript(this, parameters){

                public boolean execute() {
                    return (Boolean)script.apply(this.getParams());
                }
            };
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(SignificantTermsHeuristicScoreScript.class)) {
            return context.factoryClazz.cast(new MockSignificantTermsHeuristicScoreScript(this, script));
        }
        if (context.instanceClazz.equals(TemplateScript.class)) {
            TemplateScript.Factory factory = vars -> {
                final HashMap<String, Map> varsWithParams = new HashMap<String, Map>();
                if (vars != null) {
                    varsWithParams.put("params", vars);
                }
                return new TemplateScript(this, vars){

                    public String execute() {
                        return (String)script.apply(varsWithParams);
                    }
                };
            };
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(FilterScript.class)) {
            FilterScript.Factory factory = mockCompiled::createFilterScript;
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(SimilarityScript.class)) {
            SimilarityScript.Factory factory = mockCompiled::createSimilarityScript;
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(SimilarityWeightScript.class)) {
            SimilarityWeightScript.Factory factory = mockCompiled::createSimilarityWeightScript;
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(MovingFunctionScript.class)) {
            MovingFunctionScript.Factory factory = () -> new MovingFunctionScript(this){

                public double execute(Map<String, Object> params1, double[] values) {
                    params1.put("_values", values);
                    return (Double)script.apply(params1);
                }
            };
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(ScoreScript.class)) {
            MockScoreScript factory = new MockScoreScript(this, script);
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(ScriptedMetricAggContexts.InitScript.class)) {
            MockMetricAggInitScriptFactory factory = new MockMetricAggInitScriptFactory(script);
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(ScriptedMetricAggContexts.MapScript.class)) {
            MockMetricAggMapScriptFactory factory = new MockMetricAggMapScriptFactory(script);
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(ScriptedMetricAggContexts.CombineScript.class)) {
            MockMetricAggCombineScriptFactory factory = new MockMetricAggCombineScriptFactory(script);
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(ScriptedMetricAggContexts.ReduceScript.class)) {
            MockMetricAggReduceScriptFactory factory = new MockMetricAggReduceScriptFactory(script);
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(IntervalFilterScript.class)) {
            IntervalFilterScript.Factory factory = mockCompiled::createIntervalFilterScript;
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(DerivedFieldScript.class)) {
            DerivedFieldScript.Factory factory = new DerivedFieldScript.Factory(){

                public boolean isResultDeterministic() {
                    return true;
                }

                public DerivedFieldScript.LeafFactory newFactory(final Map<String, Object> derivedFieldParams, final SearchLookup lookup) {
                    return ctx -> new DerivedFieldScript(this, derivedFieldParams, lookup, ctx){

                        public void execute() {
                            HashMap<String, Object> vars = new HashMap<String, Object>(derivedFieldParams);
                            SourceLookup sourceLookup = lookup.source();
                            vars.put("params", derivedFieldParams);
                            vars.put("_source", sourceLookup.loadSourceIfNeeded());
                            Object result = script.apply((Map<String, Object>)vars);
                            if (result instanceof ArrayList) {
                                for (Object v : (ArrayList)result) {
                                    if (v instanceof HashMap) {
                                        this.addEmittedValue(new Tuple(((HashMap)v).get("lat"), ((HashMap)v).get("lon")));
                                        continue;
                                    }
                                    this.addEmittedValue(v);
                                }
                            } else if (result instanceof HashMap) {
                                this.addEmittedValue(new Tuple(((HashMap)result).get("lat"), ((HashMap)result).get("lon")));
                            } else {
                                this.addEmittedValue(result);
                            }
                        }
                    };
                }
            };
            return context.factoryClazz.cast(factory);
        }
        ContextCompiler compiler = this.contexts.get(context);
        if (compiler != null) {
            return context.factoryClazz.cast(compiler.compile(script::apply, params));
        }
        throw new IllegalArgumentException("mock script engine does not know how to handle context [" + context.name + "]");
    }

    public Set<ScriptContext<?>> getSupportedContexts() {
        return Stream.of(FieldScript.CONTEXT, TermsSetQueryScript.CONTEXT, NumberSortScript.CONTEXT, StringSortScript.CONTEXT, IngestScript.CONTEXT, AggregationScript.CONTEXT, IngestConditionalScript.CONTEXT, UpdateScript.CONTEXT, BucketAggregationScript.CONTEXT, BucketAggregationSelectorScript.CONTEXT, SignificantTermsHeuristicScoreScript.CONTEXT, TemplateScript.CONTEXT, FilterScript.CONTEXT, SimilarityScript.CONTEXT, SimilarityWeightScript.CONTEXT, MovingFunctionScript.CONTEXT, ScoreScript.CONTEXT, ScriptedMetricAggContexts.InitScript.CONTEXT, ScriptedMetricAggContexts.MapScript.CONTEXT, ScriptedMetricAggContexts.CombineScript.CONTEXT, ScriptedMetricAggContexts.ReduceScript.CONTEXT, IntervalFilterScript.CONTEXT).collect(Collectors.toSet());
    }

    private Map<String, Object> createVars(Map<String, Object> params) {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("params", params);
        return vars;
    }

    public static Script mockInlineScript(String script) {
        return new Script(ScriptType.INLINE, "mock", script, Collections.emptyMap());
    }

    public class MockCompiledScript {
        private final String name;
        private final String source;
        private final Map<String, String> options;
        private final Function<Map<String, Object>, Object> script;

        public MockCompiledScript(String name, Map<String, String> options, String source, Function<Map<String, Object>, Object> script) {
            this.name = name;
            this.source = source;
            this.options = options;
            this.script = script;
        }

        public String getName() {
            return this.name;
        }

        public FilterScript.LeafFactory createFilterScript(Map<String, Object> params, SearchLookup lookup) {
            return new MockFilterScript(lookup, params, this.script);
        }

        public SimilarityScript createSimilarityScript() {
            return new MockSimilarityScript(MockScriptEngine.this, this.script != null ? this.script : ctx -> 42.0);
        }

        public SimilarityWeightScript createSimilarityWeightScript() {
            return new MockSimilarityWeightScript(MockScriptEngine.this, this.script != null ? this.script : ctx -> 42.0);
        }

        public IntervalFilterScript createIntervalFilterScript() {
            return new IntervalFilterScript(this){

                public boolean execute(IntervalFilterScript.Interval interval) {
                    return false;
                }
            };
        }
    }

    class MockFieldScriptFactory
    implements FieldScript.Factory {
        private final MockDeterministicScript script;

        MockFieldScriptFactory(MockDeterministicScript script) {
            this.script = script;
        }

        public boolean isResultDeterministic() {
            return this.script.isResultDeterministic();
        }

        public FieldScript.LeafFactory newFactory(final Map<String, Object> parameters, SearchLookup lookup) {
            return ctx -> new FieldScript(this, parameters, lookup, ctx){
                final /* synthetic */ MockFieldScriptFactory this$1;
                {
                    this.this$1 = this$1;
                    super(params, lookup, leafContext);
                }

                public Object execute() {
                    Map<String, Object> vars = this.this$1.MockScriptEngine.this.createVars(parameters);
                    vars.putAll(this.getLeafLookup().asMap());
                    return this.this$1.script.apply(vars);
                }
            };
        }
    }

    class MockStringSortScriptFactory
    implements StringSortScript.Factory {
        private final MockDeterministicScript script;

        MockStringSortScriptFactory(MockScriptEngine this$0, MockDeterministicScript script) {
            this.script = script;
        }

        public boolean isResultDeterministic() {
            return this.script.isResultDeterministic();
        }

        public StringSortScript.LeafFactory newFactory(final Map<String, Object> parameters, SearchLookup lookup) {
            return ctx -> new StringSortScript(this, parameters, lookup, ctx){
                final /* synthetic */ MockStringSortScriptFactory this$1;
                {
                    this.this$1 = this$1;
                    super(params, lookup, leafContext);
                }

                public String execute() {
                    HashMap<String, Object> vars = new HashMap<String, Object>(parameters);
                    vars.put("params", parameters);
                    vars.put("doc", this.getDoc());
                    return String.valueOf(this.this$1.script.apply((Map<String, Object>)vars));
                }
            };
        }
    }

    class MockAggregationScript
    implements AggregationScript.Factory {
        private final MockDeterministicScript script;

        MockAggregationScript(MockScriptEngine this$0, MockDeterministicScript script) {
            this.script = script;
        }

        public boolean isResultDeterministic() {
            return this.script.isResultDeterministic();
        }

        public AggregationScript.LeafFactory newFactory(final Map<String, Object> params, final SearchLookup lookup) {
            return new AggregationScript.LeafFactory(){
                final /* synthetic */ MockAggregationScript this$1;
                {
                    this.this$1 = this$1;
                }

                public AggregationScript newInstance(LeafReaderContext ctx) {
                    return new AggregationScript(this, params, lookup, ctx){
                        final /* synthetic */ 1 this$2;
                        {
                            this.this$2 = this$2;
                            super(params2, lookup, leafContext);
                        }

                        public Object execute() {
                            HashMap<String, Object> vars = new HashMap<String, Object>(params);
                            vars.put("params", params);
                            vars.put("doc", this.getDoc());
                            vars.put("_score", this.get_score());
                            vars.put("_value", this.get_value());
                            return this.this$2.this$1.script.apply((Map<String, Object>)vars);
                        }
                    };
                }

                public boolean needs_score() {
                    return true;
                }
            };
        }
    }

    class MockSignificantTermsHeuristicScoreScript
    implements SignificantTermsHeuristicScoreScript.Factory {
        private final MockDeterministicScript script;

        MockSignificantTermsHeuristicScoreScript(MockScriptEngine this$0, MockDeterministicScript script) {
            this.script = script;
        }

        public boolean isResultDeterministic() {
            return this.script.isResultDeterministic();
        }

        public SignificantTermsHeuristicScoreScript newInstance() {
            return new SignificantTermsHeuristicScoreScript(){

                public double execute(Map<String, Object> vars) {
                    return ((Number)MockSignificantTermsHeuristicScoreScript.this.script.apply(vars)).doubleValue();
                }
            };
        }
    }

    public class MockScoreScript
    implements ScoreScript.Factory {
        private final MockDeterministicScript script;

        public MockScoreScript(MockScriptEngine this$0, MockDeterministicScript script) {
            this.script = script;
        }

        public ScoreScript.LeafFactory newFactory(final Map<String, Object> params, final SearchLookup lookup, final IndexSearcher indexSearcher) {
            return new ScoreScript.LeafFactory(){
                final /* synthetic */ MockScoreScript this$1;
                {
                    this.this$1 = this$1;
                }

                public boolean needs_score() {
                    return true;
                }

                public ScoreScript newInstance(LeafReaderContext ctx) throws IOException {
                    final Scorable[] scorerHolder = new Scorable[1];
                    return new ScoreScript(this, params, lookup, indexSearcher, ctx){
                        final /* synthetic */ 1 this$2;
                        {
                            this.this$2 = this$2;
                            super(params, lookup, indexSearcher, leafContext);
                        }

                        public double execute(ScoreScript.ExplanationHolder explanation) {
                            HashMap<String, Object> vars = new HashMap<String, Object>(this.getParams());
                            vars.put("doc", this.getDoc());
                            if (scorerHolder[0] != null) {
                                vars.put("_score", new ScoreAccessor(scorerHolder[0]));
                            }
                            return ((Number)this.this$2.this$1.script.apply((Map<String, Object>)vars)).doubleValue();
                        }

                        public void setScorer(Scorable scorer) {
                            scorerHolder[0] = scorer;
                        }
                    };
                }
            };
        }

        public boolean isResultDeterministic() {
            return this.script.isResultDeterministic();
        }
    }

    public static class MockMetricAggInitScriptFactory
    implements ScriptedMetricAggContexts.InitScript.Factory {
        private final MockDeterministicScript script;

        MockMetricAggInitScriptFactory(MockDeterministicScript script) {
            this.script = script;
        }

        public boolean isResultDeterministic() {
            return this.script.isResultDeterministic();
        }

        public ScriptedMetricAggContexts.InitScript newInstance(Map<String, Object> params, Map<String, Object> state) {
            return new MockMetricAggInitScript(params, state, this.script);
        }
    }

    public static class MockMetricAggMapScriptFactory
    implements ScriptedMetricAggContexts.MapScript.Factory {
        private final MockDeterministicScript script;

        MockMetricAggMapScriptFactory(MockDeterministicScript script) {
            this.script = script;
        }

        public boolean isResultDeterministic() {
            return this.script.isResultDeterministic();
        }

        public ScriptedMetricAggContexts.MapScript.LeafFactory newFactory(Map<String, Object> params, Map<String, Object> state, SearchLookup lookup) {
            return new MockMetricAggMapScript(params, state, lookup, this.script);
        }
    }

    public static class MockMetricAggCombineScriptFactory
    implements ScriptedMetricAggContexts.CombineScript.Factory {
        private final MockDeterministicScript script;

        MockMetricAggCombineScriptFactory(MockDeterministicScript script) {
            this.script = script;
        }

        public boolean isResultDeterministic() {
            return this.script.isResultDeterministic();
        }

        public ScriptedMetricAggContexts.CombineScript newInstance(Map<String, Object> params, Map<String, Object> state) {
            return new MockMetricAggCombineScript(params, state, this.script);
        }
    }

    public static class MockMetricAggReduceScriptFactory
    implements ScriptedMetricAggContexts.ReduceScript.Factory {
        private final MockDeterministicScript script;

        MockMetricAggReduceScriptFactory(MockDeterministicScript script) {
            this.script = script;
        }

        public boolean isResultDeterministic() {
            return this.script.isResultDeterministic();
        }

        public ScriptedMetricAggContexts.ReduceScript newInstance(Map<String, Object> params, List<Object> states) {
            return new MockMetricAggReduceScript(params, states, this.script);
        }
    }

    public static interface ContextCompiler {
        public Object compile(Function<Map<String, Object>, Object> var1, Map<String, String> var2);
    }

    public static class MockMetricAggReduceScript
    extends ScriptedMetricAggContexts.ReduceScript {
        private final Function<Map<String, Object>, Object> script;

        MockMetricAggReduceScript(Map<String, Object> params, List<Object> states, Function<Map<String, Object>, Object> script) {
            super(params, states);
            this.script = script;
        }

        public Object execute() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (this.getParams() != null) {
                map.putAll(this.getParams());
                map.put("params", this.getParams());
            }
            map.put("states", this.getStates());
            return this.script.apply(map);
        }
    }

    public static class MockMetricAggCombineScript
    extends ScriptedMetricAggContexts.CombineScript {
        private final Function<Map<String, Object>, Object> script;

        MockMetricAggCombineScript(Map<String, Object> params, Map<String, Object> state, Function<Map<String, Object>, Object> script) {
            super(params, state);
            this.script = script;
        }

        public Object execute() {
            HashMap<String, Map> map = new HashMap<String, Map>();
            if (this.getParams() != null) {
                map.putAll(this.getParams());
                map.put("params", this.getParams());
            }
            map.put("state", this.getState());
            return this.script.apply(map);
        }
    }

    public static class MockMetricAggMapScript
    implements ScriptedMetricAggContexts.MapScript.LeafFactory {
        private final Map<String, Object> params;
        private final Map<String, Object> state;
        private final SearchLookup lookup;
        private final Function<Map<String, Object>, Object> script;

        MockMetricAggMapScript(Map<String, Object> params, Map<String, Object> state, SearchLookup lookup, Function<Map<String, Object>, Object> script) {
            this.params = params;
            this.state = state;
            this.lookup = lookup;
            this.script = script;
        }

        public ScriptedMetricAggContexts.MapScript newInstance(LeafReaderContext context) {
            return new ScriptedMetricAggContexts.MapScript(this.params, this.state, this.lookup, context){

                public void execute() {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    if (this.getParams() != null) {
                        map.putAll(this.getParams());
                        map.put("params", this.getParams());
                    }
                    map.put("state", this.getState());
                    map.put("doc", this.getDoc());
                    map.put("_score", this.get_score());
                    script.apply(map);
                }
            };
        }
    }

    public static class MockMetricAggInitScript
    extends ScriptedMetricAggContexts.InitScript {
        private final Function<Map<String, Object>, Object> script;

        MockMetricAggInitScript(Map<String, Object> params, Map<String, Object> state, Function<Map<String, Object>, Object> script) {
            super(params, state);
            this.script = script;
        }

        public void execute() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (this.getParams() != null) {
                map.putAll(this.getParams());
                map.put("params", this.getParams());
            }
            map.put("state", this.getState());
            this.script.apply(map);
        }
    }

    public class MockSimilarityWeightScript
    extends SimilarityWeightScript {
        private final Function<Map<String, Object>, Object> script;

        MockSimilarityWeightScript(MockScriptEngine this$0, Function<Map<String, Object>, Object> script) {
            this.script = script;
        }

        public double execute(ScriptedSimilarity.Query query, ScriptedSimilarity.Field field, ScriptedSimilarity.Term term) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("query", query);
            map.put("field", field);
            map.put("term", term);
            return ((Number)this.script.apply(map)).doubleValue();
        }
    }

    public class MockSimilarityScript
    extends SimilarityScript {
        private final Function<Map<String, Object>, Object> script;

        MockSimilarityScript(MockScriptEngine this$0, Function<Map<String, Object>, Object> script) {
            this.script = script;
        }

        public double execute(double weight, ScriptedSimilarity.Query query, ScriptedSimilarity.Field field, ScriptedSimilarity.Term term, ScriptedSimilarity.Doc doc) {
            HashMap<String, Double> map = new HashMap<String, Double>();
            map.put("weight", weight);
            map.put("query", (Double)query);
            map.put("field", (Double)field);
            map.put("term", (Double)term);
            map.put("doc", (Double)doc);
            return ((Number)this.script.apply(map)).doubleValue();
        }
    }

    public static class MockFilterScript
    implements FilterScript.LeafFactory {
        private final Function<Map<String, Object>, Object> script;
        private final Map<String, Object> vars;
        private final SearchLookup lookup;

        public MockFilterScript(SearchLookup lookup, Map<String, Object> vars, Function<Map<String, Object>, Object> script) {
            this.lookup = lookup;
            this.vars = vars;
            this.script = script;
        }

        public FilterScript newInstance(LeafReaderContext context) throws IOException {
            final LeafSearchLookup leafLookup = this.lookup.getLeafSearchLookup(context);
            final HashMap<String, Object> ctx = new HashMap<String, Object>(leafLookup.asMap());
            if (this.vars != null) {
                ctx.putAll(this.vars);
            }
            return new FilterScript(this, ctx, this.lookup, context){
                final /* synthetic */ MockFilterScript this$0;
                {
                    this.this$0 = this$0;
                    super(params, lookup, leafContext);
                }

                public boolean execute() {
                    return (Boolean)this.this$0.script.apply(ctx);
                }

                public void setDocument(int doc) {
                    leafLookup.setDocument(doc);
                }
            };
        }
    }
}

