/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test.rest.yaml.section;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.opensearch.core.xcontent.XContentLocation;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.test.rest.yaml.section.Assertion;
import org.opensearch.test.rest.yaml.section.ParserUtils;

public class IsFalseAssertion
extends Assertion {
    private static final Logger logger = LogManager.getLogger(IsFalseAssertion.class);

    public static IsFalseAssertion parse(XContentParser parser) throws IOException {
        return new IsFalseAssertion(parser.getTokenLocation(), ParserUtils.parseField(parser));
    }

    public IsFalseAssertion(XContentLocation location, String field) {
        super(location, field, false);
    }

    @Override
    protected void doAssert(Object actualValue, Object expectedValue) {
        logger.trace("assert that [{}] doesn't have a true value (field: [{}])", actualValue, (Object)this.getField());
        if (actualValue == null) {
            return;
        }
        String actualString = actualValue.toString();
        Assert.assertThat((String)this.errorMessage(), (Object)actualString, (Matcher)Matchers.anyOf((Matcher)Matchers.equalTo((Object)""), (Matcher)Matchers.equalToIgnoringCase((String)Boolean.FALSE.toString()), (Matcher)Matchers.equalTo((Object)"0")));
    }

    private String errorMessage() {
        return "field [" + this.getField() + "] has a true value but it shouldn't";
    }
}

