/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.nio;

import java.util.Set;
import org.opensearch.Version;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.util.BigArrays;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.telemetry.tracing.Tracer;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.Header;
import org.opensearch.transport.NativeMessageHandler;
import org.opensearch.transport.OutboundHandler;
import org.opensearch.transport.ProtocolOutboundHandler;
import org.opensearch.transport.StatsTracker;
import org.opensearch.transport.TcpChannel;
import org.opensearch.transport.TcpTransportChannel;
import org.opensearch.transport.Transport;
import org.opensearch.transport.TransportHandshaker;
import org.opensearch.transport.TransportKeepAlive;
import org.opensearch.transport.TransportMessageListener;
import org.opensearch.transport.nio.MockStreamingTransportChannel;

class MockNativeMessageHandler
extends NativeMessageHandler {
    private static final Set<String> STREAMING_ACTIONS = Set.of("indices:data/read/search[phase/query]", "indices:data/read/search[phase/fetch/id]", "indices:data/read/search[free_context]", "indices:data/read/search/stream");
    private final ThreadPool threadPool;
    private final Transport.ResponseHandlers responseHandlers;
    private final TransportMessageListener messageListener;

    public MockNativeMessageHandler(String nodeName, Version version, String[] features, StatsTracker statsTracker, ThreadPool threadPool, BigArrays bigArrays, OutboundHandler outboundHandler, NamedWriteableRegistry namedWriteableRegistry, TransportHandshaker handshaker, Transport.RequestHandlers requestHandlers, Transport.ResponseHandlers responseHandlers, Tracer tracer, TransportKeepAlive keepAlive, TransportMessageListener messageListener) {
        super(nodeName, version, features, statsTracker, threadPool, bigArrays, outboundHandler, namedWriteableRegistry, handshaker, requestHandlers, responseHandlers, tracer, keepAlive);
        this.threadPool = threadPool;
        this.responseHandlers = responseHandlers;
        this.messageListener = messageListener;
    }

    protected TcpTransportChannel createTcpTransportChannel(ProtocolOutboundHandler outboundHandler, TcpChannel channel, String action, long requestId, Version version, Header header, Releasable breakerRelease) {
        if (this.requiresStreaming(action)) {
            return new MockStreamingTransportChannel(outboundHandler, channel, action, requestId, version, header.getFeatures(), header.isCompressed(), header.isHandshake(), breakerRelease, this.responseHandlers, this.messageListener);
        }
        return super.createTcpTransportChannel(outboundHandler, channel, action, requestId, version, header, breakerRelease);
    }

    private boolean requiresStreaming(String action) {
        return STREAMING_ACTIONS.contains(action) || action.contains("stream");
    }
}

