/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.nio;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.core.transport.TransportResponse;
import org.opensearch.transport.stream.StreamTransportResponse;

class MockStreamTransportResponse<T extends TransportResponse>
implements StreamTransportResponse<T> {
    private static final Logger logger = LogManager.getLogger(MockStreamTransportResponse.class);
    private final List<T> responses;
    private final AtomicInteger currentIndex = new AtomicInteger(0);
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private volatile boolean cancelled = false;

    public MockStreamTransportResponse(List<T> responses) {
        this.responses = responses != null ? responses : List.of();
    }

    public T nextResponse() {
        if (this.cancelled) {
            throw new IllegalStateException("Stream has been cancelled");
        }
        if (this.closed.get()) {
            throw new IllegalStateException("Stream has been closed");
        }
        int index = this.currentIndex.getAndIncrement();
        if (index < this.responses.size()) {
            TransportResponse response = (TransportResponse)this.responses.get(index);
            logger.debug("Returning mock streaming response {}/{}: {}", (Object)(index + 1), (Object)this.responses.size(), (Object)response.getClass().getSimpleName());
            return (T)response;
        }
        logger.debug("Mock stream exhausted, returning null (requested index {}, total responses: {})", (Object)index, (Object)this.responses.size());
        return null;
    }

    public void cancel(String reason, Throwable cause) {
        if (this.cancelled) {
            logger.warn("Stream already cancelled, ignoring cancel request: {}", (Object)reason);
            return;
        }
        this.cancelled = true;
        logger.debug("Mock stream cancelled: {} - {}", (Object)reason, (Object)(cause != null ? cause.getMessage() : "no cause"));
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            logger.debug("Mock stream closed");
        } else {
            logger.warn("Stream already closed, ignoring close request");
        }
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }
}

