/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test.telemetry.tracing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opensearch.telemetry.tracing.Span;
import org.opensearch.test.telemetry.tracing.MockSpan;
import org.opensearch.test.telemetry.tracing.MockSpanData;
import org.opensearch.test.telemetry.tracing.SpanProcessor;
import org.opensearch.test.telemetry.tracing.TelemetryValidators;
import org.opensearch.test.telemetry.tracing.validators.AllSpansAreEndedProperly;
import org.opensearch.test.telemetry.tracing.validators.AllSpansHaveUniqueId;

public class StrictCheckSpanProcessor
implements SpanProcessor {
    private static Map<String, MockSpanData> spanMap = new ConcurrentHashMap<String, MockSpanData>();

    @Override
    public void onStart(Span span) {
        spanMap.put(span.getSpanId(), this.toMockSpanData(span));
    }

    @Override
    public void onEnd(Span span) {
        MockSpanData spanData = spanMap.get(span.getSpanId());
        if (spanData != null) {
            spanData.setEndEpochNanos(System.nanoTime());
            spanData.setHasEnded(true);
        }
    }

    public List<MockSpanData> getFinishedSpanItems() {
        return new ArrayList<MockSpanData>(spanMap.values());
    }

    private MockSpanData toMockSpanData(Span span) {
        String parentSpanId = span.getParentSpan() != null ? span.getParentSpan().getSpanId() : "";
        MockSpanData spanData = new MockSpanData(span.getSpanId(), parentSpanId, span.getTraceId(), System.nanoTime(), false, span.getSpanName(), Thread.currentThread().getStackTrace(), span instanceof MockSpan ? ((MockSpan)span).getAttributes() : Map.of());
        return spanData;
    }

    public static void validateTracingStateOnShutdown() {
        ArrayList<MockSpanData> spanData = new ArrayList<MockSpanData>(spanMap.values());
        if (spanData.size() != 0) {
            TelemetryValidators validators = new TelemetryValidators(Arrays.asList(new AllSpansAreEndedProperly(), new AllSpansHaveUniqueId()));
            try {
                validators.validate(spanData, 1);
            }
            catch (Error e) {
                spanMap.clear();
                throw e;
            }
        }
    }
}

