/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test.telemetry.tracing;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.test.telemetry.tracing.MockSpanData;
import org.opensearch.test.telemetry.tracing.TracingValidator;

public class TelemetryValidators {
    private List<TracingValidator> validators;

    public TelemetryValidators(List<TracingValidator> validators) {
        this.validators = validators;
    }

    public void validate(List<MockSpanData> spans, int requests) {
        HashMap<String, List<MockSpanData>> problematicSpansMap = new HashMap<String, List<MockSpanData>>();
        for (TracingValidator validator : this.validators) {
            List<MockSpanData> problematicSpans = validator.validate(spans, requests);
            if (problematicSpans.isEmpty()) continue;
            problematicSpansMap.put(validator.getClass().getName(), problematicSpans);
        }
        if (!problematicSpansMap.isEmpty()) {
            AssertionError error = new AssertionError((Object)this.printProblematicSpansMap(problematicSpansMap));
            throw error;
        }
    }

    private String printProblematicSpansMap(Map<String, List<MockSpanData>> spanMap) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, List<MockSpanData>> entry : spanMap.entrySet()) {
            sb.append("SpanData validation failed for validator " + entry.getKey());
            sb.append("/n");
            for (MockSpanData span : entry.getValue()) {
                sb.append(span.toString());
            }
        }
        return sb.toString();
    }
}

