/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test.telemetry;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.opensearch.telemetry.metrics.Counter;
import org.opensearch.telemetry.metrics.Histogram;
import org.opensearch.telemetry.metrics.MetricsRegistry;
import org.opensearch.telemetry.metrics.TaggedMeasurement;
import org.opensearch.telemetry.metrics.tags.Tags;
import org.opensearch.test.telemetry.TestInMemoryCounter;
import org.opensearch.test.telemetry.TestInMemoryHistogram;

public class TestInMemoryMetricsRegistry
implements MetricsRegistry {
    private ConcurrentHashMap<String, TestInMemoryCounter> counterStore = new ConcurrentHashMap();
    private ConcurrentHashMap<String, TestInMemoryHistogram> histogramStore = new ConcurrentHashMap();

    public ConcurrentHashMap<String, TestInMemoryCounter> getCounterStore() {
        return this.counterStore;
    }

    public ConcurrentHashMap<String, TestInMemoryHistogram> getHistogramStore() {
        return this.histogramStore;
    }

    public Counter createCounter(String name, String description, String unit) {
        TestInMemoryCounter counter = new TestInMemoryCounter();
        this.counterStore.putIfAbsent(name, counter);
        return counter;
    }

    public Counter createUpDownCounter(String name, String description, String unit) {
        return null;
    }

    public Histogram createHistogram(String name, String description, String unit) {
        TestInMemoryHistogram histogram = new TestInMemoryHistogram();
        this.histogramStore.putIfAbsent(name, histogram);
        return histogram;
    }

    public Closeable createGauge(String name, String description, String unit, Supplier<Double> valueProvider, Tags tags) {
        return null;
    }

    public Closeable createGauge(String name, String description, String unit, Supplier<TaggedMeasurement> value) {
        return null;
    }

    public void close() throws IOException {
    }
}

