/*
 * Decompiled with CFR 0.152.
 */
package org.smpp;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.smpp.Connection;
import org.smpp.OutbindEvent;
import org.smpp.OutbindEventListener;
import org.smpp.ReceiverBase;
import org.smpp.TimeoutException;
import org.smpp.pdu.InvalidPDUException;
import org.smpp.pdu.Outbind;
import org.smpp.pdu.PDU;
import org.smpp.pdu.PDUException;
import org.smpp.pdu.UnknownCommandIdException;
import org.smpp.pdu.tlv.TLVException;
import org.smpp.util.Unprocessed;

public class OutbindReceiver
extends ReceiverBase {
    private static final String OUTBIND_RECEIVER_THREAD_NAME = "OutbindRcv";
    private Connection serverConnection = null;
    private long acceptTimeout = 60000L;
    private OutbindEventListener listener = null;
    private Unprocessed unprocessed = new Unprocessed();

    private OutbindReceiver() {
    }

    public OutbindReceiver(Connection serverConnection) {
        this.serverConnection = serverConnection;
    }

    protected PDU tryReceivePDU(Connection connection, PDU expectedPDU) throws UnknownCommandIdException, TimeoutException, PDUException, IOException {
        PDU pdu = null;
        pdu = this.receivePDUFromConnection(connection, this.unprocessed);
        if (pdu != null && !pdu.equals(expectedPDU)) {
            pdu = null;
        }
        return pdu;
    }

    protected void receiveAsync() {
        Connection connection = null;
        Outbind outbind = new Outbind();
        try {
            this.serverConnection.setReceiveTimeout(this.getAcceptTimeout());
            connection = this.serverConnection.accept();
        }
        catch (InterruptedIOException interruptedIOException) {
        }
        catch (IOException e) {
            this.stopProcessing(e);
        }
        if (connection != null) {
            this.unprocessed.reset();
            PDU pdu = null;
            try {
                pdu = this.tryReceivePDUWithTimeout(connection, outbind);
            }
            catch (InvalidPDUException e) {
                event.write(e, "Buffer didn't contain enough data, continuing.");
            }
            catch (UnknownCommandIdException e) {
                event.write(e, "Unknown command id, continuing.");
            }
            catch (TimeoutException e) {
                debug.write("Timeout expired, message not received completly in time.");
            }
            catch (TLVException e) {
                event.write(e, "Wrong TLV");
            }
            catch (PDUException e) {
                event.write(e, "Wrong PDU");
            }
            catch (Exception e) {
                event.write(e, "Unspecified exception");
                this.stopProcessing(e);
            }
            if (pdu != null) {
                if (pdu.getCommandId() == 11) {
                    debug.write("Got outbind PDU, sending event info. " + pdu.debugString());
                    this.sendOutbindEvent(new OutbindEvent(this, connection, (Outbind)pdu));
                } else {
                    debug.write("PDU isn't outbind, throwing away. " + pdu.debugString());
                }
            }
        }
    }

    private void sendOutbindEvent(OutbindEvent event) {
        if (this.listener != null) {
            this.listener.handleOutbind(event);
        }
    }

    public synchronized void setAcceptTimeout(long acceptTimeout) {
        this.acceptTimeout = acceptTimeout;
    }

    public void setOutbindListener(OutbindEventListener listener) {
        this.listener = listener;
    }

    public synchronized long getAcceptTimeout() {
        return this.acceptTimeout;
    }

    public OutbindEventListener getOutbindListener() {
        return this.listener;
    }

    public String getThreadName() {
        return OUTBIND_RECEIVER_THREAD_NAME;
    }
}

