/*
 * Decompiled with CFR 0.152.
 */
package org.smpp;

import java.io.IOException;
import org.smpp.Connection;
import org.smpp.NotSynchronousException;
import org.smpp.ReceiverBase;
import org.smpp.ServerPDUEvent;
import org.smpp.ServerPDUEventListener;
import org.smpp.TimeoutException;
import org.smpp.Transmitter;
import org.smpp.pdu.GenericNack;
import org.smpp.pdu.InvalidPDUException;
import org.smpp.pdu.PDU;
import org.smpp.pdu.PDUException;
import org.smpp.pdu.UnknownCommandIdException;
import org.smpp.util.Queue;
import org.smpp.util.Unprocessed;

public class Receiver
extends ReceiverBase {
    private static final String RECEIVER_THREAD_NAME = "Receiver";
    private Transmitter transmitter = null;
    private Connection connection = null;
    private Queue pduQueue = new Queue();
    private long queueWaitTimeout = 2000L;
    private boolean receiver = false;
    private Unprocessed unprocessed = new Unprocessed();
    private ServerPDUEventListener pduListener = null;
    private boolean asynchronous = false;
    private boolean automaticNack = true;

    public Receiver(Connection connection) {
        this.connection = connection;
    }

    public Receiver(Transmitter transmitter, Connection connection) {
        this.transmitter = transmitter;
        this.connection = connection;
    }

    public boolean isReceiver() {
        return this.receiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setServerPDUEventListener(ServerPDUEventListener pduListener) {
        this.pduListener = pduListener;
        boolean bl = this.asynchronous = pduListener != null;
        if (this.asynchronous) {
            Queue queue = this.pduQueue;
            synchronized (queue) {
                int queueSize = this.pduQueue.size();
                for (int i = 0; i < queueSize; ++i) {
                    PDU pdu = (PDU)this.pduQueue.dequeue();
                    this.process(pdu);
                }
            }
        }
    }

    public void start() {
        debug.write(1, "Receiver starting");
        this.receiver = true;
        this.unprocessed.reset();
        super.start();
        debug.write(1, "Receiver started");
    }

    public void stop() {
        debug.write(1, "Receiver stoping");
        if (this.isReceiver()) {
            super.stop();
            this.receiver = false;
        }
        debug.write(1, "Receiver stoped");
    }

    public synchronized PDU receive(long timeout) throws UnknownCommandIdException, TimeoutException, NotSynchronousException, PDUException, IOException {
        PDU pdu = null;
        if (!this.asynchronous) {
            pdu = this.tryReceivePDUWithTimeout(this.connection, null, timeout);
        }
        return pdu;
    }

    public synchronized PDU receive(PDU expectedPDU) throws UnknownCommandIdException, TimeoutException, NotSynchronousException, PDUException, IOException {
        PDU pdu = null;
        if (!this.asynchronous) {
            pdu = this.tryReceivePDUWithTimeout(this.connection, expectedPDU);
        }
        return pdu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PDU tryReceivePDU(Connection connection, PDU expectedPDU) throws UnknownCommandIdException, TimeoutException, PDUException, IOException {
        PDU pdu = null;
        if (this.receiver) {
            debug.write(3, "Is receiver/transciever => trying to get from queue.");
            Queue queue = this.pduQueue;
            synchronized (queue) {
                if (expectedPDU == null) {
                    if (!this.pduQueue.isEmpty()) {
                        pdu = (PDU)this.pduQueue.dequeue();
                    }
                } else {
                    pdu = (PDU)this.pduQueue.dequeue(expectedPDU);
                }
                if (pdu == null) {
                    try {
                        this.pduQueue.wait(this.getQueueWaitTimeout());
                    }
                    catch (InterruptedException e) {
                        debug.write(1, "tryReceivePDU got interrupt waiting for queue");
                    }
                }
            }
        }
        debug.write(1, "Is transmitter only => trying to receive from connection.");
        pdu = this.receivePDUFromConnection(connection, this.unprocessed);
        if (!(pdu == null || expectedPDU != null && pdu.equals(expectedPDU))) {
            debug.write(1, "This is not the pdu we expect, processing" + pdu.debugString());
            this.enqueue(pdu);
            pdu = null;
        }
        return pdu;
    }

    protected void receiveAsync() {
        PDU pdu = null;
        try {
            debug.write(3, "Receiver.receiveAsync() going to receive pdu.");
            pdu = this.receivePDUFromConnection(this.connection, this.unprocessed);
        }
        catch (InvalidPDUException e) {
            int seqNr;
            event.write(e, "Receiver.receiveAsync(): received PDU is invalid.");
            PDU expdu = e.getPDU();
            int n = seqNr = expdu == null ? 0 : expdu.getSequenceNumber();
            if (this.automaticNack) {
                this.sendGenericNack(1, seqNr);
            } else {
                pdu = new GenericNack(1, seqNr);
            }
        }
        catch (UnknownCommandIdException e) {
            event.write(e, "Receiver.receiveAsync(): Unknown command id.");
            if (this.automaticNack) {
                this.sendGenericNack(3, e.getSequenceNumber());
            } else {
                pdu = new GenericNack(3, e.getSequenceNumber());
            }
        }
        catch (TimeoutException e) {
            debug.write(1, "Receiver.receiveAsync() too long had an uncomplete message.");
        }
        catch (PDUException e) {
            int seqNr;
            event.write(e, "Receiver.receiveAsync()");
            PDU expdu = e.getPDU();
            int n = seqNr = expdu == null ? 0 : expdu.getSequenceNumber();
            if (this.automaticNack) {
                this.sendGenericNack(e.getErrorCode(), seqNr);
            } else {
                pdu = new GenericNack(e.getErrorCode(), seqNr);
            }
        }
        catch (Exception e) {
            event.write(e, "Receiver.receiveAsync()");
            this.stopProcessing(e);
        }
        if (pdu != null) {
            debug.write(1, "Receiver.receiveAsync(): PDU received, processing " + pdu.debugString());
            if (this.asynchronous) {
                this.process(pdu);
            } else {
                this.enqueue(pdu);
            }
        }
    }

    private void process(PDU pdu) {
        debug.write(1, "receiver passing pdu to ServerPDUEventListener");
        if (this.pduListener != null) {
            ServerPDUEvent pduReceived = new ServerPDUEvent(this, this.connection, pdu);
            this.pduListener.handleEvent(pduReceived);
            debug.write(1, "ServerPDUEventListener received pdu");
        } else {
            debug.write(1, "async receiver doesn't have ServerPDUEventListener, discarding " + pdu.debugString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueue(PDU pdu) {
        debug.write(1, "receiver enqueuing pdu.");
        Queue queue = this.pduQueue;
        synchronized (queue) {
            this.pduQueue.enqueue(pdu);
            this.pduQueue.notifyAll();
        }
        if (-2147483642 == pdu.getCommandId()) {
            this.stopProcessing(null);
        }
    }

    private void sendGenericNack(int commandStatus, int sequenceNumber) {
        if (this.transmitter != null) {
            try {
                GenericNack gnack = new GenericNack(commandStatus, sequenceNumber);
                this.transmitter.send(gnack);
            }
            catch (IOException gnacke) {
                event.write(gnacke, "Receiver.run(): IOException sending generic_nack.");
            }
            catch (Exception gnacke) {
                event.write(gnacke, "Receiver.run(): an exception sending generic_nack.");
                this.stopProcessing(gnacke);
            }
        }
    }

    public void setQueueWaitTimeout(long timeout) {
        this.queueWaitTimeout = timeout;
    }

    public long getQueueWaitTimeout() {
        return this.queueWaitTimeout;
    }

    public String getThreadName() {
        return RECEIVER_THREAD_NAME;
    }

    public void setAutomaticNack(boolean automaticNack) {
        this.automaticNack = automaticNack;
    }

    public boolean isAutomaticNack() {
        return this.automaticNack;
    }
}

