/*
 * Decompiled with CFR 0.152.
 */
package org.smpp;

import java.io.IOException;
import java.util.Hashtable;
import org.smpp.Connection;
import org.smpp.NotSynchronousException;
import org.smpp.Receiver;
import org.smpp.ServerPDUEvent;
import org.smpp.ServerPDUEventListener;
import org.smpp.SmppException;
import org.smpp.SmppObject;
import org.smpp.TimeoutException;
import org.smpp.Transmitter;
import org.smpp.WrongSessionStateException;
import org.smpp.pdu.AlertNotification;
import org.smpp.pdu.BindRequest;
import org.smpp.pdu.BindResponse;
import org.smpp.pdu.CancelSM;
import org.smpp.pdu.CancelSMResp;
import org.smpp.pdu.DataSM;
import org.smpp.pdu.DataSMResp;
import org.smpp.pdu.DeliverSM;
import org.smpp.pdu.DeliverSMResp;
import org.smpp.pdu.EnquireLink;
import org.smpp.pdu.EnquireLinkResp;
import org.smpp.pdu.GenericNack;
import org.smpp.pdu.InvalidPDUException;
import org.smpp.pdu.Outbind;
import org.smpp.pdu.PDU;
import org.smpp.pdu.PDUException;
import org.smpp.pdu.QuerySM;
import org.smpp.pdu.QuerySMResp;
import org.smpp.pdu.ReplaceSM;
import org.smpp.pdu.ReplaceSMResp;
import org.smpp.pdu.Request;
import org.smpp.pdu.Response;
import org.smpp.pdu.SubmitMultiSM;
import org.smpp.pdu.SubmitMultiSMResp;
import org.smpp.pdu.SubmitSM;
import org.smpp.pdu.SubmitSMResp;
import org.smpp.pdu.Unbind;
import org.smpp.pdu.UnbindResp;
import org.smpp.pdu.UnknownCommandIdException;
import org.smpp.pdu.ValueNotSetException;
import org.smpp.util.NotEnoughDataInByteBufferException;
import org.smpp.util.TerminatingZeroNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Session
extends SmppObject {
    private boolean opened = false;
    private boolean bound = false;
    public static final int STATE_NOT_ALLOWED = 0;
    public static final int STATE_CLOSED = 1;
    public static final int STATE_OPENED = 2;
    public static final int STATE_TRANSMITTER = 4;
    public static final int STATE_RECEIVER = 8;
    public static final int STATE_TRANSCEIVER = 16;
    public static final int STATE_ALWAYS = 30;
    private static Hashtable<Integer, Integer> esmeStateMatrix;
    private static Hashtable<Integer, Integer> mcStateMatrix;
    private boolean disallowUnknownPDU = false;
    private int state = 1;
    private boolean stateChecking = false;
    public static final int TYPE_ESME = 1;
    public static final int TYPE_MC = 2;
    private int type = 1;
    private Connection connection;
    private Transmitter transmitter;
    private Receiver receiver;
    private ServerPDUEventListener pduListener = null;
    private boolean asynchronous = false;

    protected Session() {
    }

    public Session(Connection connection) {
        this.connection = connection;
    }

    public void open() throws IOException, WrongSessionStateException {
        this.checkState(1);
        if (!this.opened) {
            this.connection.open();
            this.opened = true;
            this.setState(2);
        }
    }

    public void close() throws IOException, WrongSessionStateException {
        this.checkState(2);
        if (this.connection.isOpened()) {
            this.connection.close();
            this.opened = false;
            this.setState(1);
        }
    }

    public boolean isOpened() {
        return this.opened && this.connection.isOpened();
    }

    public boolean isBound() {
        return this.bound;
    }

    private void setServerPDUEventListener(ServerPDUEventListener pduListener) {
        this.pduListener = pduListener;
        this.receiver.setServerPDUEventListener(pduListener);
        this.asynchronous = pduListener != null;
    }

    private ServerPDUEventListener getServerPDUEventListener() {
        return this.pduListener;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public final BindResponse bind(BindRequest bindReq) throws ValueNotSetException, TimeoutException, PDUException, IOException, WrongSessionStateException {
        this.checkState(bindReq);
        return this.bind(bindReq, null);
    }

    public final BindResponse bind(BindRequest bindReq, ServerPDUEventListener pduListener) throws ValueNotSetException, TimeoutException, PDUException, IOException, WrongSessionStateException {
        this.checkState(bindReq);
        if (this.bound) {
            return null;
        }
        this.open();
        this.transmitter = new Transmitter(this.connection);
        this.receiver = new Receiver(this.transmitter, this.connection);
        BindResponse bindResp = (BindResponse)this.send(bindReq, false);
        boolean bl = this.bound = bindResp != null && bindResp.getCommandStatus() == 0;
        if (!this.bound) {
            this.close();
        } else {
            this.receiver.start();
            if (bindReq.isTransmitter()) {
                if (bindReq.isReceiver()) {
                    this.setState(16);
                } else {
                    this.setState(4);
                }
            } else {
                this.setState(8);
            }
            this.setServerPDUEventListener(pduListener);
        }
        return bindResp;
    }

    public final void outbind(Outbind request) throws ValueNotSetException, TimeoutException, PDUException, IOException, WrongSessionStateException {
        this.checkState(request);
        this.send(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final UnbindResp unbind() throws ValueNotSetException, TimeoutException, PDUException, IOException, WrongSessionStateException {
        UnbindResp unbindResp = null;
        if (this.bound) {
            Unbind unbindReq = new Unbind();
            this.checkState(unbindReq);
            ServerPDUEventListener origListener = null;
            if (this.asynchronous) {
                unbindReq.assignSequenceNumber();
                origListener = this.getServerPDUEventListener();
                UnbindServerPDUEventListener unbindListener = new UnbindServerPDUEventListener(this, origListener, unbindReq);
                this.setServerPDUEventListener(unbindListener);
                UnbindServerPDUEventListener unbindServerPDUEventListener = unbindListener;
                synchronized (unbindServerPDUEventListener) {
                    event.write("sending unbindReq");
                    this.send(unbindReq);
                    try {
                        debug.write("unbindListener.wait()");
                        unbindListener.wait(this.receiver.getReceiveTimeout());
                        debug.write("unbindListener.getUnbindResp()");
                        unbindResp = unbindListener.getUnbindResp();
                        event.write("got unbindResp");
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            debug.write(4, "going to unbind sync session");
            unbindResp = (UnbindResp)this.send(unbindReq);
            boolean bl = this.bound = unbindResp == null;
            if (!this.bound) {
                this.setState(2);
                event.write("stopping receiver");
                this.receiver.stop();
                event.write("receiver stopped");
                this.receiver = null;
                this.transmitter = null;
                this.close();
            } else {
                event.write("Unbind unsuccessful, restoring listener");
                this.setServerPDUEventListener(origListener);
            }
        }
        return unbindResp;
    }

    public final void genericNack(GenericNack response) throws ValueNotSetException, TimeoutException, IOException, WrongSessionStateException {
        this.checkState(response);
        try {
            this.respond(response);
        }
        catch (WrongSessionStateException e) {
            debug.write("strange, generic nack thrown " + e);
            debug.write("this shouldn't happend");
            event.write(e, "Unexpected exeption caught");
        }
    }

    public final void genericNack(int commandStatus, int sequenceNumber) throws ValueNotSetException, TimeoutException, IOException, WrongSessionStateException {
        GenericNack gnack = new GenericNack(commandStatus, sequenceNumber);
        this.checkState(gnack);
        this.genericNack(gnack);
    }

    public final SubmitSMResp submit(SubmitSM request) throws ValueNotSetException, TimeoutException, PDUException, IOException, WrongSessionStateException {
        this.checkState(request);
        return (SubmitSMResp)this.send(request);
    }

    public final SubmitMultiSMResp submitMulti(SubmitMultiSM request) throws ValueNotSetException, TimeoutException, PDUException, IOException, WrongSessionStateException {
        this.checkState(request);
        return (SubmitMultiSMResp)this.send(request);
    }

    public final DeliverSMResp deliver(DeliverSM request) throws ValueNotSetException, TimeoutException, PDUException, IOException, WrongSessionStateException {
        this.checkState(request);
        return (DeliverSMResp)this.send(request);
    }

    public final DataSMResp data(DataSM request) throws ValueNotSetException, TimeoutException, PDUException, IOException, WrongSessionStateException {
        this.checkState(request);
        return (DataSMResp)this.send(request);
    }

    public final QuerySMResp query(QuerySM request) throws ValueNotSetException, TimeoutException, PDUException, IOException, WrongSessionStateException {
        this.checkState(request);
        return (QuerySMResp)this.send(request);
    }

    public final CancelSMResp cancel(CancelSM request) throws ValueNotSetException, TimeoutException, PDUException, IOException, WrongSessionStateException {
        this.checkState(request);
        return (CancelSMResp)this.send(request);
    }

    public final ReplaceSMResp replace(ReplaceSM request) throws ValueNotSetException, TimeoutException, PDUException, IOException, WrongSessionStateException {
        this.checkState(request);
        return (ReplaceSMResp)this.send(request);
    }

    public final EnquireLinkResp enquireLink(EnquireLink request) throws ValueNotSetException, TimeoutException, PDUException, IOException, WrongSessionStateException {
        this.checkState(request);
        return (EnquireLinkResp)this.send(request);
    }

    public final EnquireLinkResp enquireLink() throws ValueNotSetException, TimeoutException, PDUException, IOException, WrongSessionStateException {
        EnquireLink request = new EnquireLink();
        this.checkState(request);
        return this.enquireLink(request);
    }

    public final void alertNotification(AlertNotification request) throws ValueNotSetException, TimeoutException, PDUException, IOException, WrongSessionStateException {
        this.checkState(request);
        this.send(request);
    }

    public final PDU receive() throws UnknownCommandIdException, TimeoutException, NotSynchronousException, PDUException, IOException {
        if (!this.asynchronous) {
            return this.receive(-1L);
        }
        throw new NotSynchronousException(this);
    }

    public final PDU receive(long timeout) throws UnknownCommandIdException, TimeoutException, NotSynchronousException, PDUException, IOException {
        PDU pdu = null;
        if (this.receiver.isReceiver()) {
            if (!this.asynchronous) {
                pdu = this.receiver.receive(timeout);
            } else {
                throw new NotSynchronousException(this);
            }
        }
        return pdu;
    }

    public final void respond(Response response) throws ValueNotSetException, IOException, WrongSessionStateException {
        this.checkState(response);
        debug.enter(4, this, "respond(Response)");
        debug.write(4, "Sending response " + response.debugString());
        try {
            this.transmitter.send(response);
        }
        catch (ValueNotSetException e) {
            event.write(e, "Sending a response.");
            debug.exit(4, this);
            throw e;
        }
        debug.exit(4, this);
    }

    public Transmitter getTransmitter() {
        return this.transmitter;
    }

    public Receiver getReceiver() {
        return this.receiver;
    }

    public Connection getConnection() {
        return this.connection;
    }

    private final Response send(Request request, boolean asynchronous) throws ValueNotSetException, TimeoutException, PDUException, IOException {
        debug.enter(4, this, "send(Request)");
        Response response = null;
        debug.write(4, "Sending request " + request.debugString());
        try {
            this.transmitter.send(request);
        }
        catch (ValueNotSetException e) {
            event.write(e, "Sending the request.");
            debug.exit(4, this);
            throw e;
        }
        if (!asynchronous && request.canResponse()) {
            PDU pdu = null;
            Response expResponse = null;
            expResponse = request.getResponse();
            try {
                debug.write(4, "Going to receive response. Expecting " + expResponse.debugString());
                try {
                    pdu = this.receiver.receive(expResponse);
                }
                catch (NotSynchronousException e) {
                    debug.write("Unexpected NotSynchronousException caught, ignoring :-)");
                }
            }
            catch (UnknownCommandIdException e) {
                this.safeGenericNack(3, e.getSequenceNumber());
            }
            catch (InvalidPDUException e) {
                if (e.getException() instanceof NotEnoughDataInByteBufferException || e.getException() instanceof TerminatingZeroNotFoundException) {
                    debug.write(4, "wrong length " + e);
                    debug.write(4, " => sending gnack.");
                    this.safeGenericNack(1, e.getPDU().getSequenceNumber());
                }
                debug.write(4, "InvalidPDUException - rethrowing " + e);
                debug.exit(4, this);
                throw e;
            }
            catch (TimeoutException e) {
                debug.write(4, "TimeoutException - rethrowing " + e);
                debug.exit(4, this);
                throw e;
            }
            if (pdu != null) {
                debug.write(4, "Got response(?) pdu " + pdu.debugString());
                response = this.checkResponse(pdu, expResponse);
            } else {
                debug.write(4, "No response received.");
            }
        }
        debug.exit(4, this);
        return response;
    }

    private final Response send(Request request) throws ValueNotSetException, TimeoutException, PDUException, IOException {
        return this.send(request, this.asynchronous);
    }

    private Response checkResponse(PDU pdu, Response expResponse) throws ValueNotSetException, TimeoutException, IOException {
        Response response = null;
        debug.write(4, "checking response if it's what we expected.");
        if (pdu.getCommandId() != expResponse.getCommandId()) {
            debug.write(4, "Got different response than expected " + expResponse.debugString());
            if (pdu.getCommandId() == Integer.MIN_VALUE) {
                debug.write(4, "Got generic nack. What could we do wrong?");
                expResponse.setCommandId(Integer.MIN_VALUE);
                expResponse.setCommandLength(pdu.getCommandLength());
                expResponse.setCommandStatus(pdu.getCommandStatus());
                expResponse.setSequenceNumber(pdu.getSequenceNumber());
                response = expResponse;
            } else {
                debug.write(4, "invalid command id - sending gnack");
                this.safeGenericNack(3, pdu.getSequenceNumber());
                response = null;
            }
        } else {
            response = (Response)pdu;
        }
        return response;
    }

    private void safeGenericNack(int commandStatus, int sequenceNumber) throws IOException {
        try {
            this.genericNack(commandStatus, sequenceNumber);
        }
        catch (SmppException e) {
            debug.write("Ignoring unexpected SmppException caught sending generic nack.");
            event.write(e, "Ignoring unexpected exception caught sending generic nack.");
        }
    }

    private void setState(int state) {
        this.state = state;
    }

    public int getState() {
        return this.state;
    }

    public void enableStateChecking() {
        this.stateChecking = true;
    }

    public void disableStateChecking() {
        this.stateChecking = false;
    }

    public void checkState(int requestedState) throws WrongSessionStateException {
        if (this.stateChecking) {
            debug.write(4, "checking state current=0x" + Integer.toHexString(this.state) + " requested esme=0x" + Integer.toHexString(requestedState));
            if ((this.state & requestedState) == 0) {
                throw new WrongSessionStateException(this.type, requestedState, this.state);
            }
        }
    }

    public void checkState(PDU pdu) throws WrongSessionStateException {
        if (this.stateChecking) {
            Integer requestedStateInteger;
            Hashtable<Integer, Integer> pduMatrix = Session.getStateMatrix(this.type);
            Integer commandIdInteger = new Integer(pdu.getCommandId());
            Integer n = requestedStateInteger = pduMatrix == null ? null : pduMatrix.get(commandIdInteger);
            if (requestedStateInteger != null) {
                this.checkState(requestedStateInteger);
            } else if (this.disallowUnknownPDU) {
                throw new WrongSessionStateException();
            }
        }
    }

    public boolean isStateAllowed(int requestedState) {
        boolean stateAllowed = true;
        try {
            this.checkState(requestedState);
        }
        catch (WrongSessionStateException e) {
            stateAllowed = false;
        }
        return stateAllowed;
    }

    public boolean isPDUAllowed(PDU pdu) {
        boolean pduAllowed = true;
        try {
            this.checkState(pdu);
        }
        catch (WrongSessionStateException e) {
            pduAllowed = false;
        }
        return pduAllowed;
    }

    private static void initialiseStateMatrix() {
        esmeStateMatrix = new Hashtable();
        Session.addValidState(esmeStateMatrix, 2, 1);
        Session.addValidState(esmeStateMatrix, -2147483646, 0);
        Session.addValidState(esmeStateMatrix, 1, 1);
        Session.addValidState(esmeStateMatrix, -2147483647, 0);
        Session.addValidState(esmeStateMatrix, 9, 1);
        Session.addValidState(esmeStateMatrix, -2147483639, 0);
        Session.addValidState(esmeStateMatrix, 11, 0);
        Session.addValidState(esmeStateMatrix, 6, 28);
        Session.addValidState(esmeStateMatrix, -2147483642, 28);
        Session.addValidState(esmeStateMatrix, 4, 20);
        Session.addValidState(esmeStateMatrix, -2147483644, 0);
        Session.addValidState(esmeStateMatrix, 33, 20);
        Session.addValidState(esmeStateMatrix, -2147483615, 0);
        Session.addValidState(esmeStateMatrix, 259, 20);
        Session.addValidState(esmeStateMatrix, -2147483389, 24);
        Session.addValidState(esmeStateMatrix, 5, 0);
        Session.addValidState(esmeStateMatrix, -2147483643, 24);
        Session.addValidState(esmeStateMatrix, 3, 20);
        Session.addValidState(esmeStateMatrix, -2147483645, 0);
        Session.addValidState(esmeStateMatrix, 8, 20);
        Session.addValidState(esmeStateMatrix, -2147483640, 0);
        Session.addValidState(esmeStateMatrix, 7, 20);
        Session.addValidState(esmeStateMatrix, -2147483641, 0);
        Session.addValidState(esmeStateMatrix, 21, 28);
        Session.addValidState(esmeStateMatrix, -2147483627, 28);
        Session.addValidState(esmeStateMatrix, 258, 0);
        Session.addValidState(esmeStateMatrix, Integer.MIN_VALUE, 28);
        mcStateMatrix = new Hashtable();
        Session.addValidState(mcStateMatrix, 2, 0);
        Session.addValidState(mcStateMatrix, -2147483646, 28);
        Session.addValidState(mcStateMatrix, 1, 0);
        Session.addValidState(mcStateMatrix, -2147483647, 28);
        Session.addValidState(mcStateMatrix, 9, 0);
        Session.addValidState(mcStateMatrix, -2147483639, 28);
        Session.addValidState(mcStateMatrix, 11, 28);
        Session.addValidState(mcStateMatrix, 6, 28);
        Session.addValidState(mcStateMatrix, -2147483642, 28);
        Session.addValidState(mcStateMatrix, 4, 0);
        Session.addValidState(mcStateMatrix, -2147483644, 20);
        Session.addValidState(mcStateMatrix, 33, 0);
        Session.addValidState(mcStateMatrix, -2147483615, 20);
        Session.addValidState(mcStateMatrix, 259, 24);
        Session.addValidState(mcStateMatrix, -2147483389, 20);
        Session.addValidState(mcStateMatrix, 5, 24);
        Session.addValidState(mcStateMatrix, -2147483643, 0);
        Session.addValidState(mcStateMatrix, 3, 0);
        Session.addValidState(mcStateMatrix, -2147483645, 20);
        Session.addValidState(mcStateMatrix, 8, 0);
        Session.addValidState(mcStateMatrix, -2147483640, 20);
        Session.addValidState(mcStateMatrix, 7, 0);
        Session.addValidState(mcStateMatrix, -2147483641, 20);
        Session.addValidState(mcStateMatrix, 21, 28);
        Session.addValidState(mcStateMatrix, -2147483627, 28);
        Session.addValidState(mcStateMatrix, 258, 24);
        Session.addValidState(mcStateMatrix, Integer.MIN_VALUE, 28);
    }

    private static void addValidState(Hashtable<Integer, Integer> matrix, int commandId, int state) {
        matrix.put(new Integer(commandId), new Integer(state));
    }

    private static Hashtable<Integer, Integer> getStateMatrix(int type) {
        switch (type) {
            case 1: {
                return esmeStateMatrix;
            }
            case 2: {
                return mcStateMatrix;
            }
        }
        return null;
    }

    static {
        Session.initialiseStateMatrix();
    }

    private class UnbindServerPDUEventListener
    extends SmppObject
    implements ServerPDUEventListener {
        Session session;
        ServerPDUEventListener origListener;
        Unbind unbindReq;
        UnbindResp expectedResp;
        UnbindResp unbindResp = null;

        public UnbindServerPDUEventListener(Session session2, ServerPDUEventListener origListener, Unbind unbindReq) {
            this.session = session2;
            this.origListener = origListener;
            this.unbindReq = unbindReq;
            this.expectedResp = (UnbindResp)unbindReq.getResponse();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleEvent(ServerPDUEvent event) {
            PDU pdu = event.getPDU();
            if (pdu.getSequenceNumber() == this.unbindReq.getSequenceNumber()) {
                UnbindServerPDUEventListener unbindServerPDUEventListener = this;
                synchronized (unbindServerPDUEventListener) {
                    try {
                        this.unbindResp = (UnbindResp)this.session.checkResponse(pdu, this.expectedResp);
                    }
                    catch (Exception e) {
                        debug.write(4, "exception handling unbind " + e);
                        SmppObject.event.write(e, "exception handling unbind");
                    }
                    this.notify();
                }
            }
            if (this.origListener != null) {
                this.origListener.handleEvent(event);
            }
        }

        public UnbindResp getUnbindResp() {
            return this.unbindResp;
        }
    }
}

