/*
 * Decompiled with CFR 0.152.
 */
package org.smpp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import org.smpp.Connection;
import org.smpp.Data;
import org.smpp.util.ByteBuffer;

public class TCPIPConnection
extends Connection {
    private int requestedPort = 0;
    private int port = 0;
    private Socket socket = null;
    private BufferedInputStream inputStream = null;
    private BufferedOutputStream outputStream = null;
    private boolean opened = false;
    private ServerSocket receiverSocket = null;
    private byte connType = 0;
    private static final byte CONN_NONE = 0;
    private static final byte CONN_CLIENT = 1;
    private static final byte CONN_SERVER = 2;
    private static final int DFLT_IO_BUF_SIZE = 2048;
    private static final int DFLT_RECEIVE_BUFFER_SIZE = 4096;
    private static final int DFLT_MAX_RECEIVE_SIZE = 131072;
    private int ioBufferSize = 2048;
    private int receiveBufferSize;
    private byte[] receiveBuffer;
    private int maxReceiveSize = 131072;
    protected SocketFactory socketFactory = SocketFactory.getDefault();
    protected ServerSocketFactory serverSocketFactory = ServerSocketFactory.getDefault();

    public TCPIPConnection(int port) {
        if (port == 0 || port >= 100 && port <= 65535) {
            this.requestedPort = port;
        } else {
            debug.write("Invalid port.");
        }
        this.connType = (byte)2;
    }

    public TCPIPConnection(String address, int port) {
        if (address.length() >= 7) {
            this.address = address;
        } else {
            debug.write("Invalid address.");
        }
        if (port >= 100 && port <= 65535) {
            this.port = port;
        } else {
            debug.write("Invalid port.");
        }
        this.connType = 1;
        this.setReceiveBufferSize(4096);
    }

    public TCPIPConnection(Socket socket) throws IOException {
        this.connType = 1;
        this.socket = socket;
        this.address = socket.getInetAddress().getHostAddress();
        this.port = socket.getPort();
        this.initialiseIOStreams(socket);
        this.opened = true;
        this.setReceiveBufferSize(4096);
    }

    public void open() throws IOException {
        debug.enter(7, this, "open");
        IOException exception = null;
        if (!this.opened) {
            if (this.connType == 1) {
                try {
                    this.socket = this.socketFactory.createSocket();
                    this.socket.connect(new InetSocketAddress(this.address, this.port), this.getConnectionTimeout());
                    this.initialiseIOStreams(this.socket);
                    this.opened = true;
                    debug.write(7, "opened client tcp/ip connection to " + this.address + " on port " + this.port);
                }
                catch (IOException e) {
                    debug.write("IOException opening TCPIPConnection " + e);
                    event.write(e, "IOException opening TCPIPConnection");
                    exception = e;
                }
            } else if (this.connType == 2) {
                try {
                    this.receiverSocket = this.serverSocketFactory.createServerSocket(this.requestedPort);
                    this.opened = true;
                    this.port = this.receiverSocket.getLocalPort();
                    debug.write(7, "listening tcp/ip on port " + this.port);
                }
                catch (IOException e) {
                    debug.write("IOException creating listener socket " + e);
                    exception = e;
                }
            } else {
                debug.write("Unknown connection type = " + this.connType);
            }
        } else {
            debug.write("attempted to open already opened connection ");
        }
        debug.exit(7, this);
        if (exception != null) {
            throw exception;
        }
    }

    public void close() throws IOException {
        debug.enter(7, this, "close");
        IOException exception = null;
        if (this.connType == 1) {
            try {
                if (this.inputStream != null) {
                    this.inputStream.close();
                }
                if (this.outputStream != null) {
                    this.outputStream.close();
                }
                if (this.socket != null) {
                    this.socket.close();
                }
                this.inputStream = null;
                this.outputStream = null;
                this.socket = null;
                this.opened = false;
                debug.write(7, "closed client tcp/ip connection to " + this.address + " on port " + this.port);
            }
            catch (IOException e) {
                debug.write("IOException closing socket " + e);
                event.write(e, "IOException closing socket");
                exception = e;
            }
        } else if (this.connType == 2) {
            try {
                if (this.receiverSocket != null) {
                    this.receiverSocket.close();
                }
                this.receiverSocket = null;
                this.opened = false;
                debug.write(7, "stopped listening tcp/ip on port " + this.port);
            }
            catch (IOException e) {
                debug.write("IOException closing listener socket " + e);
                event.write(e, "IOException closing listener socket");
                exception = e;
            }
        } else {
            debug.write("Unknown connection type = " + this.connType);
        }
        debug.exit(7, this);
        if (exception != null) {
            throw exception;
        }
    }

    public void send(ByteBuffer data) throws IOException {
        IOException exception;
        block10: {
            debug.enter(7, this, "send");
            exception = null;
            if (this.outputStream == null) {
                debug.exit(7, this);
                throw new IOException("Not connected");
            }
            if (this.connType == 1) {
                try {
                    try {
                        this.outputStream.write(data.getBuffer(), 0, data.length());
                        debug.write(7, "sent " + data.length() + " bytes to " + this.address + " on port " + this.port);
                    }
                    catch (IOException e) {
                        debug.write("IOException sending data " + e);
                        exception = e;
                    }
                    this.outputStream.flush();
                }
                catch (IOException e) {
                    debug.write("IOException flushing data " + e);
                    if (exception == null) {
                        exception = e;
                    }
                    break block10;
                }
            }
            if (this.connType == 2) {
                debug.write("Attempt to send data over server type connection.");
            } else {
                debug.write("Unknown connection type = " + this.connType);
            }
        }
        debug.exit(7, this);
        if (exception != null) {
            throw exception;
        }
    }

    public ByteBuffer receive() throws IOException {
        debug.enter(8, this, "receive");
        IOException exception = null;
        ByteBuffer data = null;
        if (this.connType == 1) {
            data = new ByteBuffer();
            long endTime = Data.getCurrentTime() + this.getReceiveTimeout();
            int bytesToRead = 0;
            int bytesRead = 0;
            int totalBytesRead = 0;
            try {
                this.socket.setSoTimeout((int)this.getCommsTimeout());
                bytesToRead = this.receiveBufferSize;
                debug.write(8, "going to read from socket");
                debug.write(8, "comms timeout=" + this.getCommsTimeout() + " receive timeout=" + this.getReceiveTimeout() + " receive buffer size=" + this.receiveBufferSize);
                do {
                    bytesRead = 0;
                    try {
                        bytesRead = this.inputStream.read(this.receiveBuffer, 0, bytesToRead);
                    }
                    catch (InterruptedIOException e) {
                        debug.write(8, "timeout reading from socket");
                    }
                    if (bytesRead > 0) {
                        debug.write(8, "read " + bytesRead + " bytes from socket");
                        data.appendBytes(this.receiveBuffer, bytesRead);
                        totalBytesRead += bytesRead;
                    }
                    if (bytesRead == -1) {
                        debug.write(8, "reached end of stream");
                        this.close();
                        throw new EOFException("Reached end of stream");
                    }
                    bytesToRead = this.inputStream.available();
                    if (bytesToRead > 0) {
                        debug.write(8, "more data (" + bytesToRead + " bytes) remains in the socket");
                    } else {
                        debug.write(8, "no more data remains in the socket");
                    }
                    if (bytesToRead > this.receiveBufferSize) {
                        bytesToRead = this.receiveBufferSize;
                    }
                    if (totalBytesRead + bytesToRead <= this.maxReceiveSize) continue;
                    bytesToRead = this.maxReceiveSize - totalBytesRead;
                } while (bytesToRead != 0 && Data.getCurrentTime() <= endTime && totalBytesRead < this.maxReceiveSize);
                debug.write(7, "totally read " + data.length() + " bytes from socket");
            }
            catch (IOException e) {
                debug.write("IOException: " + e.getMessage());
                event.write(e, "IOException receive via TCPIPConnection");
                exception = e;
                this.close();
            }
        } else if (this.connType == 2) {
            debug.write("Attempt to receive data from server type connection.");
        } else {
            debug.write("Unknown connection type = " + this.connType);
        }
        debug.exit(8, this);
        if (exception != null) {
            throw exception;
        }
        return data;
    }

    public Connection accept() throws IOException {
        debug.enter(8, this, "receive");
        IOException exception = null;
        TCPIPConnection newConn = null;
        if (this.connType == 2) {
            try {
                this.receiverSocket.setSoTimeout((int)this.getReceiveTimeout());
            }
            catch (SocketException socketException) {
                // empty catch block
            }
            Socket acceptedSocket = null;
            try {
                acceptedSocket = this.receiverSocket.accept();
            }
            catch (IOException e) {
                debug.write(8, "Exception accepting socket (timeout?)" + e);
            }
            if (acceptedSocket != null) {
                try {
                    newConn = new TCPIPConnection(acceptedSocket);
                }
                catch (IOException e) {
                    debug.write("IOException creating new client connection " + e);
                    event.write(e, "IOException creating new client connection");
                    exception = e;
                }
            }
        } else if (this.connType == 1) {
            debug.write("Attempt to receive data from client type connection.");
        } else {
            debug.write("Unknown connection type = " + this.connType);
        }
        debug.exit(8, this);
        if (exception != null) {
            throw exception;
        }
        return newConn;
    }

    private void initialiseIOStreams(Socket socket) throws IOException {
        if (this.connType == 1) {
            this.inputStream = new BufferedInputStream(socket.getInputStream(), this.ioBufferSize);
            this.outputStream = new BufferedOutputStream(socket.getOutputStream(), this.ioBufferSize);
        } else if (this.connType == 2) {
            debug.write("Attempt to initialise i/o streams for server type connection.");
        } else {
            debug.write("Unknown connection type = " + this.connType);
        }
    }

    public void setIOBufferSize(int ioBufferSize) {
        if (!this.opened) {
            this.ioBufferSize = ioBufferSize;
        }
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
        this.receiveBuffer = new byte[receiveBufferSize];
    }

    public void setMaxReceiveSize(int maxReceiveSize) {
        this.maxReceiveSize = maxReceiveSize;
    }

    public boolean isOpened() {
        return this.opened;
    }

    public int getPort() {
        return this.port;
    }
}

