/*
 * Decompiled with CFR 0.152.
 */
package org.smpp.client;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import org.smpp.Session;
import org.smpp.TCPIPConnection;
import org.smpp.pdu.Address;
import org.smpp.pdu.AddressRange;
import org.smpp.pdu.BindResponse;
import org.smpp.pdu.BindTransmitter;
import org.smpp.pdu.EnquireLink;
import org.smpp.pdu.EnquireLinkResp;
import org.smpp.pdu.SubmitSM;
import org.smpp.pdu.SubmitSMResp;
import org.smpp.pdu.UnbindResp;
import org.smpp.pdu.WrongLengthOfStringException;
import org.smpp.util.DataCodingCharsetHandler;

public class SMPPSender {
    static String propsFilePath = "./smppsender.cfg";
    static Session session = null;
    Properties properties = new Properties();
    boolean bound = false;
    String ipAddress = null;
    int port = 0;
    String systemId = null;
    String password = null;
    String bindOption = "t";
    AddressRange addressRange = new AddressRange();
    String systemType = "";
    String serviceType = "";
    Address sourceAddress = new Address();
    Address destAddress = new Address();
    String scheduleDeliveryTime = "";
    String validityPeriod = "";
    String shortMessage = "";
    int numberOfDestination = 1;
    String messageId = "";
    byte esmClass = 0;
    byte protocolId = 0;
    byte priorityFlag = 0;
    byte registeredDelivery = 0;
    byte replaceIfPresentFlag = 0;
    byte dataCoding = 0;
    byte smDefaultMsgId = 0;
    long receiveTimeout = -1L;

    public SMPPSender() throws IOException {
        this.loadProperties(propsFilePath);
    }

    public static void main(String[] args) {
        String sender = null;
        byte senderTon = 0;
        byte senderNpi = 0;
        String dest = null;
        String message = null;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].startsWith("-")) continue;
            String opt = args[i].substring(1);
            if (opt.compareToIgnoreCase("sender") == 0) {
                sender = args[++i];
                continue;
            }
            if (opt.compareToIgnoreCase("senderTon") == 0) {
                senderTon = Byte.parseByte(args[++i]);
                continue;
            }
            if (opt.compareToIgnoreCase("senderNpi") == 0) {
                senderNpi = Byte.parseByte(args[++i]);
                continue;
            }
            if (opt.compareToIgnoreCase("dest") == 0) {
                dest = args[++i];
                continue;
            }
            if (opt.compareToIgnoreCase("destination") == 0) {
                dest = args[++i];
                continue;
            }
            if (opt.compareToIgnoreCase("message") == 0) {
                message = args[++i];
                continue;
            }
            if (opt.compareToIgnoreCase("file") != 0) continue;
            propsFilePath = args[++i];
        }
        if (dest == null || message == null) {
            System.out.println("Usage: SMPPSender -dest <dest number on international format> -message <the message, within qoutes if contains whitespaces> [-sender <sender id> [-senderTon <sender ton>] [-senderNpi <sender npi>]]");
            System.exit(0);
        }
        ArrayList<String> destinations = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(dest, ",");
        while (st.hasMoreTokens()) {
            String d = st.nextToken();
            destinations.add(d);
        }
        System.out.println("Initialising...");
        SMPPSender smppSender = null;
        try {
            smppSender = new SMPPSender();
        }
        catch (IOException e) {
            System.out.println("Exception initialising SMPPSender " + e);
        }
        System.out.println("Sending: \"" + message + "\" to " + dest);
        if (smppSender != null) {
            smppSender.bind();
            if (smppSender.bound) {
                for (String d : destinations) {
                    smppSender.submit(d, message, sender, senderTon, senderNpi);
                }
                smppSender.unbind();
            }
        }
    }

    private void bind() {
        try {
            if (this.bound) {
                System.out.println("Already bound, unbind first.");
                return;
            }
            BindTransmitter request = null;
            BindResponse response = null;
            request = new BindTransmitter();
            TCPIPConnection connection = new TCPIPConnection(this.ipAddress, this.port);
            connection.setReceiveTimeout(20000L);
            session = new Session(connection);
            request.setSystemId(this.systemId);
            request.setPassword(this.password);
            request.setSystemType(this.systemType);
            request.setInterfaceVersion((byte)52);
            request.setAddressRange(this.addressRange);
            System.out.println("Bind request " + request.debugString());
            response = session.bind(request);
            System.out.println("Bind response " + response.debugString());
            if (response.getCommandStatus() == 0) {
                this.bound = true;
            } else {
                System.out.println("Bind failed, code " + response.getCommandStatus());
            }
        }
        catch (Exception e) {
            System.out.println("Bind operation failed. " + e);
        }
    }

    private void unbind() {
        try {
            if (!this.bound) {
                System.out.println("Not bound, cannot unbind.");
                return;
            }
            System.out.println("Going to unbind.");
            if (session.getReceiver().isReceiver()) {
                System.out.println("It can take a while to stop the receiver.");
            }
            UnbindResp response = session.unbind();
            System.out.println("Unbind response " + response.debugString());
            this.bound = false;
        }
        catch (Exception e) {
            System.out.println("Unbind operation failed. " + e);
        }
    }

    private void submit(String destAddress, String shortMessage, String sender, byte senderTon, byte senderNpi) {
        try {
            SubmitSM request = new SubmitSM();
            request.setServiceType(this.serviceType);
            if (sender != null) {
                if (sender.startsWith("+")) {
                    sender = sender.substring(1);
                    senderTon = 1;
                    senderNpi = 1;
                }
                if (!sender.matches("\\d+")) {
                    senderTon = (byte)5;
                    senderNpi = 0;
                }
                if (senderTon == 5) {
                    request.setSourceAddr(new Address(senderTon, senderNpi, sender, 11));
                } else {
                    request.setSourceAddr(new Address(senderTon, senderNpi, sender));
                }
            } else {
                request.setSourceAddr(this.sourceAddress);
            }
            if (destAddress.startsWith("+")) {
                destAddress = destAddress.substring(1);
            }
            request.setDestAddr(new Address(1, 1, destAddress));
            request.setReplaceIfPresentFlag(this.replaceIfPresentFlag);
            String encoding = DataCodingCharsetHandler.getCharsetName(this.dataCoding);
            request.setShortMessage(shortMessage, encoding);
            request.setScheduleDeliveryTime(this.scheduleDeliveryTime);
            request.setValidityPeriod(this.validityPeriod);
            request.setEsmClass(this.esmClass);
            request.setProtocolId(this.protocolId);
            request.setPriorityFlag(this.priorityFlag);
            request.setRegisteredDelivery(this.registeredDelivery);
            request.setDataCoding(this.dataCoding);
            request.setSmDefaultMsgId(this.smDefaultMsgId);
            request.assignSequenceNumber(true);
            System.out.println("Submit request " + request.debugString());
            SubmitSMResp response = session.submit(request);
            System.out.println("Submit response " + response.debugString());
            this.messageId = response.getMessageId();
            this.enquireLink();
        }
        catch (Exception e) {
            System.out.println("Submit operation failed. " + e);
        }
    }

    private void enquireLink() {
        try {
            EnquireLink request = new EnquireLink();
            System.out.println("Enquire Link request " + request.debugString());
            EnquireLinkResp response = session.enquireLink(request);
            System.out.println("Enquire Link response " + response.debugString());
        }
        catch (Exception e) {
            System.out.println("Enquire Link operation failed. " + e);
        }
    }

    private void loadProperties(String fileName) throws IOException {
        System.out.println("Reading configuration file " + fileName + "...");
        FileInputStream propsFile = new FileInputStream(fileName);
        this.properties.load(propsFile);
        propsFile.close();
        System.out.println("Setting default parameters...");
        this.ipAddress = this.properties.getProperty("ip-address");
        this.port = this.getIntProperty("port", this.port);
        this.systemId = this.properties.getProperty("system-id");
        this.password = this.properties.getProperty("password");
        byte ton = this.getByteProperty("addr-ton", this.addressRange.getTon());
        byte npi = this.getByteProperty("addr-npi", this.addressRange.getNpi());
        String addr = this.properties.getProperty("address-range", this.addressRange.getAddressRange());
        this.addressRange.setTon(ton);
        this.addressRange.setNpi(npi);
        try {
            this.addressRange.setAddressRange(addr);
        }
        catch (WrongLengthOfStringException e) {
            System.out.println("The length of address-range parameter is wrong.");
        }
        ton = this.getByteProperty("source-ton", this.sourceAddress.getTon());
        npi = this.getByteProperty("source-npi", this.sourceAddress.getNpi());
        addr = this.properties.getProperty("source-address", this.sourceAddress.getAddress());
        this.setAddressParameter("source-address", this.sourceAddress, ton, npi, addr);
        ton = this.getByteProperty("destination-ton", this.destAddress.getTon());
        npi = this.getByteProperty("destination-npi", this.destAddress.getNpi());
        addr = this.properties.getProperty("destination-address", this.destAddress.getAddress());
        this.setAddressParameter("destination-address", this.destAddress, ton, npi, addr);
        this.serviceType = this.properties.getProperty("service-type", this.serviceType);
        this.systemType = this.properties.getProperty("system-type", this.systemType);
        String bindMode = this.properties.getProperty("bind-mode", this.bindOption);
        if (bindMode.equalsIgnoreCase("transmitter")) {
            bindMode = "t";
        } else if (bindMode.equalsIgnoreCase("receiver")) {
            bindMode = "r";
        } else if (bindMode.equalsIgnoreCase("transciever")) {
            bindMode = "tr";
        } else if (!(bindMode.equalsIgnoreCase("t") || bindMode.equalsIgnoreCase("r") || bindMode.equalsIgnoreCase("tr"))) {
            System.out.println("The value of bind-mode parameter in the configuration file " + fileName + " is wrong. " + "Setting the default");
            bindMode = "t";
        }
        this.bindOption = bindMode;
        int rcvTimeout = this.receiveTimeout == -1L ? -1 : (int)this.receiveTimeout / 1000;
        rcvTimeout = this.getIntProperty("receive-timeout", rcvTimeout);
        this.receiveTimeout = rcvTimeout == -1 ? -1L : (long)(rcvTimeout * 1000);
    }

    private byte getByteProperty(String propName, byte defaultValue) {
        return Byte.parseByte(this.properties.getProperty(propName, Byte.toString(defaultValue)));
    }

    private int getIntProperty(String propName, int defaultValue) {
        return Integer.parseInt(this.properties.getProperty(propName, Integer.toString(defaultValue)));
    }

    private void setAddressParameter(String descr, Address address, byte ton, byte npi, String addr) {
        address.setTon(ton);
        address.setNpi(npi);
        try {
            address.setAddress(addr);
        }
        catch (WrongLengthOfStringException e) {
            System.out.println("The length of " + descr + " parameter is wrong.");
        }
    }
}

