/*
 * Decompiled with CFR 0.152.
 */
package org.smpp.debug;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.smpp.debug.Debug;

public class LoggerDebug
implements Debug {
    private Logger logger;
    private boolean active = false;
    private int indent = 0;

    public LoggerDebug(String category) {
        this.logger = Logger.getLogger(category);
    }

    public LoggerDebug(Logger logger) {
        this.logger = logger;
    }

    public void enter(int group, Object from, String name) {
        this.enter(from, name);
    }

    public void enter(Object from, String name) {
        if (this.active && this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(this.getDelimiter(true, from, name));
            ++this.indent;
        }
    }

    public void write(int group, String msg) {
        this.write(msg);
    }

    public void write(String msg) {
        if (this.active && this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(this.getIndent() + " " + msg);
        }
    }

    public void exit(int group, Object from) {
        this.exit(from);
    }

    public void exit(Object from) {
        if (this.active) {
            --this.indent;
            if (this.indent < 0) {
                this.indent = 0;
            }
            this.logger.fine(this.getDelimiter(false, from, ""));
        }
    }

    public void activate() {
        this.active = true;
    }

    public void activate(int group) {
    }

    public void deactivate() {
        this.active = false;
    }

    public void deactivate(int group) {
    }

    public boolean active(int group) {
        return true;
    }

    private String getDelimiter(boolean start, Object from, String name) {
        String indentStr = this.getIndent();
        indentStr = start ? indentStr + "-> " : indentStr + "<- ";
        return indentStr + from.toString() + (name == "" ? "" : " " + name);
    }

    private String getIndent() {
        String result = new String("");
        for (int i = 0; i < this.indent; ++i) {
            result = result + "  ";
        }
        return result;
    }
}

