/*
 * Decompiled with CFR 0.152.
 */
package org.smpp.pdu;

import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.smpp.SmppObject;
import org.smpp.pdu.IntegerOutOfRangeException;
import org.smpp.pdu.PDUException;
import org.smpp.pdu.ValueNotSetException;
import org.smpp.pdu.WrongDateFormatException;
import org.smpp.pdu.WrongLengthOfStringException;
import org.smpp.util.ByteBuffer;
import org.smpp.util.NotEnoughDataInByteBufferException;
import org.smpp.util.TerminatingZeroNotFoundException;

public abstract class ByteData
extends SmppObject {
    private static final String SMPP_TIME_DATE_FORMAT = "yyMMddHHmmss";
    private static SimpleDateFormat dateFormatter;
    private static boolean libraryCheckDateFormat;

    public abstract void setData(ByteBuffer var1) throws PDUException, NotEnoughDataInByteBufferException, TerminatingZeroNotFoundException;

    public abstract ByteBuffer getData() throws ValueNotSetException;

    protected static void checkString(String string, int max) throws WrongLengthOfStringException {
        ByteData.checkString(string, 0, max);
    }

    protected static void checkString(String string, int max, String encoding) throws WrongLengthOfStringException, UnsupportedEncodingException {
        ByteData.checkString(string, 0, max, encoding);
    }

    protected static void checkString(String string, int min, int max) throws WrongLengthOfStringException {
        int length = string == null ? 0 : string.length();
        ByteData.checkString(min, length, max);
    }

    protected static void checkString(String string, int min, int max, String encoding) throws WrongLengthOfStringException, UnsupportedEncodingException {
        byte[] stringBytes = string.getBytes(encoding);
        int length = stringBytes == null ? 0 : stringBytes.length;
        ByteData.checkString(min, length, max);
    }

    protected static void checkString(int min, int length, int max) throws WrongLengthOfStringException {
        if (length < min || length > max) {
            throw new WrongLengthOfStringException(min, max, length);
        }
    }

    protected static void checkCString(String string, int max) throws WrongLengthOfStringException {
        ByteData.checkCString(string, 1, max);
    }

    protected static void checkCString(String string, int min, int max) throws WrongLengthOfStringException {
        int count;
        int n = count = string == null ? 1 : string.length() + 1;
        if (count < min || count > max) {
            throw new WrongLengthOfStringException(min, max, count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void checkDate(String dateStr) throws WrongDateFormatException {
        int count;
        int n = count = dateStr == null ? 1 : dateStr.length() + 1;
        if (count != 1 && count != 17) {
            throw new WrongDateFormatException(dateStr);
        }
        if (count == 1 || !libraryCheckDateFormat) {
            return;
        }
        char locTime = dateStr.charAt(dateStr.length() - 1);
        if ("+-R".lastIndexOf(locTime) == -1) {
            throw new WrongDateFormatException(dateStr, "time difference relation indicator incorrect; should be +, - or R and is " + locTime);
        }
        int formatLen = SMPP_TIME_DATE_FORMAT.length();
        String dateJavaStr = dateStr.substring(0, formatLen);
        SimpleDateFormat simpleDateFormat = dateFormatter;
        synchronized (simpleDateFormat) {
            try {
                if (locTime == 'R') {
                    Long.parseLong(dateJavaStr);
                } else {
                    dateFormatter.parse(dateJavaStr);
                }
            }
            catch (ParseException e) {
                debug.write("Exception parsing absolute date " + dateStr + " " + e);
                throw new WrongDateFormatException(dateStr, "format of absolute date-time incorrect");
            }
            catch (NumberFormatException e) {
                debug.write("Exception parsing relative date " + dateStr + " " + e);
                throw new WrongDateFormatException(dateStr, "format of relative date-time incorrect");
            }
        }
        String tenthsOfSecStr = dateStr.substring(formatLen, formatLen + 1);
        try {
            Integer.parseInt(tenthsOfSecStr);
        }
        catch (NumberFormatException e) {
            throw new WrongDateFormatException(dateStr, "non-numeric tenths of seconds " + tenthsOfSecStr);
        }
        String timeDiffStr = dateStr.substring(formatLen + 1, formatLen + 3);
        int timeDiff = 0;
        try {
            timeDiff = Integer.parseInt(timeDiffStr);
        }
        catch (NumberFormatException e) {
            throw new WrongDateFormatException(dateStr, "non-numeric time difference " + timeDiffStr);
        }
        if (timeDiff < 0 || timeDiff > 48) {
            throw new WrongDateFormatException(dateStr, "time difference is incorrect; should be between 00-48 and is " + timeDiffStr);
        }
    }

    protected static void checkRange(int min, int val, int max) throws IntegerOutOfRangeException {
        if (val < min || val > max) {
            throw new IntegerOutOfRangeException(min, max, val);
        }
    }

    protected static short decodeUnsigned(byte signed) {
        if (signed >= 0) {
            return signed;
        }
        return (short)(256 + (short)signed);
    }

    protected static int decodeUnsigned(short signed) {
        if (signed >= 0) {
            return signed;
        }
        return 65536 + signed;
    }

    protected static byte encodeUnsigned(short positive) {
        if (positive < 128) {
            return (byte)positive;
        }
        return (byte)(-(256 - positive));
    }

    protected static short encodeUnsigned(int positive) {
        if (positive < 32768) {
            return (short)positive;
        }
        return (short)(-(65536 - positive));
    }

    public String debugString() {
        return new String("");
    }

    static {
        libraryCheckDateFormat = true;
        dateFormatter = new SimpleDateFormat(SMPP_TIME_DATE_FORMAT);
        dateFormatter.setLenient(false);
    }
}

