/*
 * Decompiled with CFR 0.152.
 */
package org.smpp.pdu;

import java.util.Vector;
import org.smpp.pdu.ByteData;
import org.smpp.pdu.PDUException;
import org.smpp.pdu.TooManyValuesException;
import org.smpp.pdu.ValueNotSetException;
import org.smpp.util.ByteBuffer;
import org.smpp.util.NotEnoughDataInByteBufferException;
import org.smpp.util.TerminatingZeroNotFoundException;

public abstract class ByteDataList
extends ByteData {
    public static final byte BYTE_SIZE = 1;
    public static final byte SHORT_SIZE = 2;
    public static final byte INT_SIZE = 4;
    private Vector<ByteData> values = new Vector();
    private int maxSize = 0;
    private int lengthOfSize = 4;

    public abstract ByteData createValue();

    public ByteDataList() {
    }

    public ByteDataList(int max, int lengthOfSize) {
        this.maxSize = max;
        if (lengthOfSize != 1 && lengthOfSize != 2 && lengthOfSize != 4) {
            throw new Error("Length of the size field is invalid. Expected 1, 2 or 4 and got " + lengthOfSize);
        }
        this.lengthOfSize = lengthOfSize;
    }

    private void resetValues() {
        this.values.removeAllElements();
    }

    public void setData(ByteBuffer buffer) throws PDUException, NotEnoughDataInByteBufferException, TerminatingZeroNotFoundException, TooManyValuesException {
        this.resetValues();
        int nrValues = 0;
        switch (this.lengthOfSize) {
            case 1: {
                nrValues = ByteDataList.decodeUnsigned(buffer.removeByte());
                break;
            }
            case 2: {
                nrValues = ByteDataList.decodeUnsigned(buffer.removeShort());
                break;
            }
            case 4: {
                nrValues = buffer.removeInt();
            }
        }
        for (int i = 0; i < nrValues; ++i) {
            ByteData value = this.createValue();
            value.setData(buffer);
            this.addValue(value);
        }
    }

    public ByteBuffer getData() throws ValueNotSetException {
        ByteBuffer buffer = new ByteBuffer();
        int nrValues = this.getCount();
        switch (this.lengthOfSize) {
            case 1: {
                buffer.appendByte(ByteDataList.encodeUnsigned((short)nrValues));
                break;
            }
            case 2: {
                buffer.appendShort(ByteDataList.encodeUnsigned(nrValues));
                break;
            }
            case 4: {
                buffer.appendInt(nrValues);
            }
        }
        for (int i = 0; i < nrValues; ++i) {
            ByteData value = this.getValue(i);
            buffer.appendBuffer(value.getData());
        }
        return buffer;
    }

    public int getCount() {
        return this.values.size();
    }

    public void addValue(ByteData value) throws TooManyValuesException {
        if (this.getCount() >= this.maxSize) {
            throw new TooManyValuesException();
        }
        this.values.add(value);
    }

    public ByteData getValue(int i) {
        if (i < this.getCount()) {
            return this.values.get(i);
        }
        return null;
    }

    public String debugString() {
        String dbgs = "(bdlist: ";
        dbgs = dbgs + super.debugString();
        int count = this.getCount();
        dbgs = dbgs + "(count: " + count + ") ";
        for (int i = 0; i < count; ++i) {
            ByteData value = this.getValue(i);
            dbgs = dbgs + (i + 1) + ": " + value.debugString();
            dbgs = dbgs + " ";
        }
        dbgs = dbgs + ") ";
        return dbgs;
    }
}

