/*
 * Decompiled with CFR 0.152.
 */
package org.smpp.pdu;

import org.smpp.pdu.PDUException;
import org.smpp.pdu.Response;
import org.smpp.pdu.ValueNotSetException;
import org.smpp.pdu.WrongLengthOfStringException;
import org.smpp.pdu.tlv.TLVByte;
import org.smpp.pdu.tlv.TLVOctets;
import org.smpp.pdu.tlv.TLVString;
import org.smpp.pdu.tlv.WrongLengthException;
import org.smpp.util.ByteBuffer;
import org.smpp.util.NotEnoughDataInByteBufferException;
import org.smpp.util.TerminatingZeroNotFoundException;

public class DataSMResp
extends Response {
    private String messageId = "";
    private TLVByte deliveryFailureReason = new TLVByte(1061);
    private TLVOctets networkErrorCode = new TLVOctets(1059, 3, 3);
    private TLVString additionalStatusInfoText = new TLVString(29, 1, 256);
    private TLVByte dpfResult = new TLVByte(1056);

    public DataSMResp() {
        super(-2147483389);
        this.registerOptional(this.deliveryFailureReason);
        this.registerOptional(this.networkErrorCode);
        this.registerOptional(this.additionalStatusInfoText);
        this.registerOptional(this.dpfResult);
    }

    public void setBody(ByteBuffer buffer) throws NotEnoughDataInByteBufferException, TerminatingZeroNotFoundException, PDUException {
        this.setMessageId(buffer.removeCString());
    }

    public ByteBuffer getBody() {
        ByteBuffer buffer = new ByteBuffer();
        buffer.appendCString(this.messageId);
        return buffer;
    }

    public void setMessageId(String value) throws WrongLengthOfStringException {
        DataSMResp.checkString(value, 64);
        this.messageId = value;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public boolean hasDeliveryFailureReason() {
        return this.deliveryFailureReason.hasValue();
    }

    public boolean hasNetworkErrorCode() {
        return this.networkErrorCode.hasValue();
    }

    public boolean hasAdditionalStatusInfoText() {
        return this.additionalStatusInfoText.hasValue();
    }

    public boolean hasDpfResult() {
        return this.dpfResult.hasValue();
    }

    public void setDeliveryFailureReason(byte value) {
        this.deliveryFailureReason.setValue(value);
    }

    public void setNetworkErrorCode(ByteBuffer value) {
        this.networkErrorCode.setValue(value);
    }

    public void setAdditionalStatusInfoText(String value) throws WrongLengthException {
        this.additionalStatusInfoText.setValue(value);
    }

    public void setDpfResult(byte value) {
        this.dpfResult.setValue(value);
    }

    public byte getDeliveryFailureReason() throws ValueNotSetException {
        return this.deliveryFailureReason.getValue();
    }

    public ByteBuffer getNetworkErrorCode() throws ValueNotSetException {
        return this.networkErrorCode.getValue();
    }

    public String getAdditionalStatusInfoText() throws ValueNotSetException {
        return this.additionalStatusInfoText.getValue();
    }

    public byte getDpfResult() throws ValueNotSetException {
        return this.dpfResult.getValue();
    }

    public String debugString() {
        String dbgs = "(data_resp: ";
        dbgs = dbgs + super.debugString();
        dbgs = dbgs + this.getMessageId();
        dbgs = dbgs + " ";
        dbgs = dbgs + this.debugStringOptional();
        dbgs = dbgs + ") ";
        return dbgs;
    }
}

