/*
 * Decompiled with CFR 0.152.
 */
package org.smpp.pdu;

import java.io.UnsupportedEncodingException;
import org.smpp.pdu.Address;
import org.smpp.pdu.DeliverSMResp;
import org.smpp.pdu.IntegerOutOfRangeException;
import org.smpp.pdu.PDUException;
import org.smpp.pdu.Request;
import org.smpp.pdu.Response;
import org.smpp.pdu.ShortMessage;
import org.smpp.pdu.ValueNotSetException;
import org.smpp.pdu.WrongLengthOfStringException;
import org.smpp.pdu.tlv.TLVByte;
import org.smpp.pdu.tlv.TLVOctets;
import org.smpp.pdu.tlv.TLVShort;
import org.smpp.pdu.tlv.TLVString;
import org.smpp.pdu.tlv.TLVUByte;
import org.smpp.pdu.tlv.WrongLengthException;
import org.smpp.util.ByteBuffer;
import org.smpp.util.NotEnoughDataInByteBufferException;
import org.smpp.util.TerminatingZeroNotFoundException;

public class DeliverSM
extends Request {
    private String serviceType = "";
    private Address sourceAddr = new Address();
    private Address destAddr = new Address();
    private byte esmClass = 0;
    private byte protocolId = 0;
    private byte priorityFlag = 0;
    private String scheduleDeliveryTime = "";
    private String validityPeriod = "";
    private byte registeredDelivery = 0;
    private byte replaceIfPresentFlag = 0;
    private byte dataCoding = 0;
    private byte smDefaultMsgId = 0;
    private short smLength = 0;
    private ShortMessage shortMessage = new ShortMessage(254);
    private TLVShort userMessageReference = new TLVShort(516);
    private TLVShort sourcePort = new TLVShort(522);
    private TLVShort destinationPort = new TLVShort(523);
    private TLVShort sarMsgRefNum = new TLVShort(524);
    private TLVUByte sarTotalSegments = new TLVUByte(526);
    private TLVUByte sarSegmentSeqnum = new TLVUByte(527);
    private TLVByte payloadType = new TLVByte(25);
    private TLVOctets messagePayload = new TLVOctets(1060, 1, 1500);
    private TLVByte privacyIndicator = new TLVByte(513);
    private TLVOctets callbackNum = new TLVOctets(897, 4, 19);
    private TLVOctets sourceSubaddress = new TLVOctets(514, 2, 23);
    private TLVOctets destSubaddress = new TLVOctets(515, 2, 23);
    private TLVByte userResponseCode = new TLVByte(517);
    private TLVByte languageIndicator = new TLVByte(525);
    private TLVShort itsSessionInfo = new TLVShort(4995);
    private TLVOctets networkErrorCode = new TLVOctets(1059, 3, 3);
    private TLVByte messageState = new TLVByte(1063);
    private TLVString receiptedMessageId = new TLVString(30, 1, 65);

    public DeliverSM() {
        super(5);
        this.registerOptional(this.userMessageReference);
        this.registerOptional(this.sourcePort);
        this.registerOptional(this.destinationPort);
        this.registerOptional(this.sarMsgRefNum);
        this.registerOptional(this.sarTotalSegments);
        this.registerOptional(this.sarSegmentSeqnum);
        this.registerOptional(this.payloadType);
        this.registerOptional(this.messagePayload);
        this.registerOptional(this.privacyIndicator);
        this.registerOptional(this.callbackNum);
        this.registerOptional(this.sourceSubaddress);
        this.registerOptional(this.destSubaddress);
        this.registerOptional(this.userResponseCode);
        this.registerOptional(this.languageIndicator);
        this.registerOptional(this.itsSessionInfo);
        this.registerOptional(this.networkErrorCode);
        this.registerOptional(this.messageState);
        this.registerOptional(this.receiptedMessageId);
    }

    protected Response createResponse() {
        return new DeliverSMResp();
    }

    public void setBody(ByteBuffer buffer) throws NotEnoughDataInByteBufferException, TerminatingZeroNotFoundException, PDUException {
        this.setServiceType(buffer.removeCString());
        this.sourceAddr.setData(buffer);
        this.destAddr.setData(buffer);
        this.setEsmClass(buffer.removeByte());
        this.setProtocolId(buffer.removeByte());
        this.setPriorityFlag(buffer.removeByte());
        String dummyStr = buffer.removeCString();
        dummyStr = buffer.removeCString();
        this.setRegisteredDelivery(buffer.removeByte());
        byte dummyByte = buffer.removeByte();
        this.setDataCoding(buffer.removeByte());
        dummyByte = buffer.removeByte();
        this.setSmLength(DeliverSM.decodeUnsigned(buffer.removeByte()));
        this.shortMessage.setData(buffer.removeBuffer(this.getSmLength()));
    }

    public ByteBuffer getBody() {
        ByteBuffer buffer = new ByteBuffer();
        buffer.appendCString(this.getServiceType());
        buffer.appendBuffer(this.getSourceAddr().getData());
        buffer.appendBuffer(this.getDestAddr().getData());
        buffer.appendByte(this.getEsmClass());
        buffer.appendByte(this.getProtocolId());
        buffer.appendByte(this.getPriorityFlag());
        buffer.appendCString(this.getScheduleDeliveryTime());
        buffer.appendCString(this.getValidityPeriod());
        buffer.appendByte(this.getRegisteredDelivery());
        buffer.appendByte(this.getReplaceIfPresentFlag());
        buffer.appendByte(this.getDataCoding());
        buffer.appendByte(this.getSmDefaultMsgId());
        buffer.appendByte(DeliverSM.encodeUnsigned(this.getSmLength()));
        buffer.appendBuffer(this.shortMessage.getData());
        return buffer;
    }

    public void setServiceType(String value) throws WrongLengthOfStringException {
        DeliverSM.checkCString(value, 6);
        this.serviceType = value;
    }

    public void setShortMessage(String value) throws WrongLengthOfStringException {
        this.shortMessage.setMessage(value);
        this.setSmLength((short)this.shortMessage.getLength());
    }

    public void setShortMessage(String value, String encoding) throws WrongLengthOfStringException, UnsupportedEncodingException {
        this.shortMessage.setMessage(value, encoding);
        this.setSmLength((short)this.shortMessage.getLength());
    }

    public void setShortMessageData(ByteBuffer buffer) throws PDUException, NotEnoughDataInByteBufferException, TerminatingZeroNotFoundException {
        this.setSmLength((short)buffer.length());
        this.shortMessage.setData(buffer);
    }

    public void setSourceAddr(Address value) {
        this.sourceAddr = value;
    }

    public void setSourceAddr(String address) throws WrongLengthOfStringException {
        this.setSourceAddr(new Address(address));
    }

    public void setSourceAddr(byte ton, byte npi, String address) throws WrongLengthOfStringException {
        this.setSourceAddr(new Address(ton, npi, address));
    }

    public void setDestAddr(Address value) {
        this.destAddr = value;
    }

    public void setDestAddr(String address) throws WrongLengthOfStringException {
        this.setDestAddr(new Address(address));
    }

    public void setDestAddr(byte ton, byte npi, String address) throws WrongLengthOfStringException {
        this.setDestAddr(new Address(ton, npi, address));
    }

    public void setEsmClass(byte value) {
        this.esmClass = value;
    }

    public void setProtocolId(byte value) {
        this.protocolId = value;
    }

    public void setPriorityFlag(byte value) {
        this.priorityFlag = value;
    }

    public void setRegisteredDelivery(byte value) {
        this.registeredDelivery = value;
    }

    public void setDataCoding(byte value) {
        this.dataCoding = value;
    }

    private void setSmLength(short value) {
        this.smLength = value;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public String getScheduleDeliveryTime() {
        return this.scheduleDeliveryTime;
    }

    public String getValidityPeriod() {
        return this.validityPeriod;
    }

    public String getShortMessage() {
        return this.shortMessage.getMessage();
    }

    public String getShortMessage(String encoding) throws UnsupportedEncodingException {
        return this.shortMessage.getMessage(encoding);
    }

    public ByteBuffer getShortMessageData() {
        return this.shortMessage.getData();
    }

    public Address getSourceAddr() {
        return this.sourceAddr;
    }

    public Address getDestAddr() {
        return this.destAddr;
    }

    public byte getEsmClass() {
        return this.esmClass;
    }

    public byte getProtocolId() {
        return this.protocolId;
    }

    public byte getPriorityFlag() {
        return this.priorityFlag;
    }

    public byte getRegisteredDelivery() {
        return this.registeredDelivery;
    }

    public byte getReplaceIfPresentFlag() {
        return this.replaceIfPresentFlag;
    }

    public byte getDataCoding() {
        return this.dataCoding;
    }

    public byte getSmDefaultMsgId() {
        return this.smDefaultMsgId;
    }

    public short getSmLength() {
        return this.smLength;
    }

    public boolean hasUserMessageReference() {
        return this.userMessageReference.hasValue();
    }

    public boolean hasSourcePort() {
        return this.sourcePort.hasValue();
    }

    public boolean hasDestinationPort() {
        return this.destinationPort.hasValue();
    }

    public boolean hasSarMsgRefNum() {
        return this.sarMsgRefNum.hasValue();
    }

    public boolean hasSarTotalSegments() {
        return this.sarTotalSegments.hasValue();
    }

    public boolean hasSarSegmentSeqnum() {
        return this.sarSegmentSeqnum.hasValue();
    }

    public boolean hasPayloadType() {
        return this.payloadType.hasValue();
    }

    public boolean hasMessagePayload() {
        return this.messagePayload.hasValue();
    }

    public boolean hasPrivacyIndicator() {
        return this.privacyIndicator.hasValue();
    }

    public boolean hasCallbackNum() {
        return this.callbackNum.hasValue();
    }

    public boolean hasSourceSubaddress() {
        return this.sourceSubaddress.hasValue();
    }

    public boolean hasDestSubaddress() {
        return this.destSubaddress.hasValue();
    }

    public boolean hasUserResponseCode() {
        return this.userResponseCode.hasValue();
    }

    public boolean hasLanguageIndicator() {
        return this.languageIndicator.hasValue();
    }

    public boolean hasItsSessionInfo() {
        return this.itsSessionInfo.hasValue();
    }

    public boolean hasNetworkErrorCode() {
        return this.networkErrorCode.hasValue();
    }

    public boolean hasMessageState() {
        return this.messageState.hasValue();
    }

    public boolean hasReceiptedMessageId() {
        return this.receiptedMessageId.hasValue();
    }

    public void setUserMessageReference(short value) {
        this.userMessageReference.setValue(value);
    }

    public void setSourcePort(short value) {
        this.sourcePort.setValue(value);
    }

    public void setDestinationPort(short value) {
        this.destinationPort.setValue(value);
    }

    public void setSarMsgRefNum(short value) {
        this.sarMsgRefNum.setValue(value);
    }

    public void setSarTotalSegments(short value) throws IntegerOutOfRangeException {
        this.sarTotalSegments.setValue(value);
    }

    public void setSarSegmentSeqnum(short value) throws IntegerOutOfRangeException {
        this.sarSegmentSeqnum.setValue(value);
    }

    public void setPayloadType(byte value) {
        this.payloadType.setValue(value);
    }

    public void setMessagePayload(ByteBuffer value) {
        this.messagePayload.setValue(value);
    }

    public void setPrivacyIndicator(byte value) {
        this.privacyIndicator.setValue(value);
    }

    public void setCallbackNum(ByteBuffer value) {
        this.callbackNum.setValue(value);
    }

    public void setSourceSubaddress(ByteBuffer value) {
        this.sourceSubaddress.setValue(value);
    }

    public void setDestSubaddress(ByteBuffer value) {
        this.destSubaddress.setValue(value);
    }

    public void setUserResponseCode(byte value) {
        this.userResponseCode.setValue(value);
    }

    public void setLanguageIndicator(byte value) {
        this.languageIndicator.setValue(value);
    }

    public void setItsSessionInfo(short value) {
        this.itsSessionInfo.setValue(value);
    }

    public void setNetworkErrorCode(ByteBuffer value) {
        this.networkErrorCode.setValue(value);
    }

    public void setMessageState(byte value) {
        this.messageState.setValue(value);
    }

    public void setReceiptedMessageId(String value) throws WrongLengthException {
        this.receiptedMessageId.setValue(value);
    }

    public short getUserMessageReference() throws ValueNotSetException {
        return this.userMessageReference.getValue();
    }

    public short getSourcePort() throws ValueNotSetException {
        return this.sourcePort.getValue();
    }

    public short getDestinationPort() throws ValueNotSetException {
        return this.destinationPort.getValue();
    }

    public short getSarMsgRefNum() throws ValueNotSetException {
        return this.sarMsgRefNum.getValue();
    }

    public short getSarTotalSegments() throws ValueNotSetException {
        return this.sarTotalSegments.getValue();
    }

    public short getSarSegmentSeqnum() throws ValueNotSetException {
        return this.sarSegmentSeqnum.getValue();
    }

    public byte getPayloadType() throws ValueNotSetException {
        return this.payloadType.getValue();
    }

    public ByteBuffer getMessagePayload() throws ValueNotSetException {
        return this.messagePayload.getValue();
    }

    public byte getPrivacyIndicator() throws ValueNotSetException {
        return this.privacyIndicator.getValue();
    }

    public ByteBuffer callbackNum() throws ValueNotSetException {
        return this.callbackNum.getValue();
    }

    public ByteBuffer getSourceSubaddress() throws ValueNotSetException {
        return this.sourceSubaddress.getValue();
    }

    public ByteBuffer getDestSubaddress() throws ValueNotSetException {
        return this.destSubaddress.getValue();
    }

    public byte getUserResponseCode() throws ValueNotSetException {
        return this.userResponseCode.getValue();
    }

    public byte getLanguageIndicator() throws ValueNotSetException {
        return this.languageIndicator.getValue();
    }

    public short getItsSessionInfo() throws ValueNotSetException {
        return this.itsSessionInfo.getValue();
    }

    public ByteBuffer getNetworkErrorCode() throws ValueNotSetException {
        return this.networkErrorCode.getValue();
    }

    public byte getMessageState() throws ValueNotSetException {
        return this.messageState.getValue();
    }

    public String getReceiptedMessageId() throws ValueNotSetException {
        return this.receiptedMessageId.getValue();
    }

    public String debugString() {
        String dbgs = "(deliver: ";
        dbgs = dbgs + super.debugString();
        dbgs = dbgs + this.getSourceAddr().debugString();
        dbgs = dbgs + " ";
        dbgs = dbgs + this.getDestAddr().debugString();
        dbgs = dbgs + " ";
        dbgs = dbgs + this.shortMessage.debugString();
        dbgs = dbgs + " ";
        dbgs = dbgs + this.debugStringOptional();
        dbgs = dbgs + ") ";
        return dbgs;
    }
}

