/*
 * Decompiled with CFR 0.152.
 */
package org.smpp.pdu;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.smpp.pdu.ByteData;
import org.smpp.pdu.HeaderIncompleteException;
import org.smpp.pdu.InvalidPDUException;
import org.smpp.pdu.MessageIncompleteException;
import org.smpp.pdu.PDUException;
import org.smpp.pdu.PDUFactory;
import org.smpp.pdu.PDUHeader;
import org.smpp.pdu.UnexpectedOptionalParameterException;
import org.smpp.pdu.UnknownCommandIdException;
import org.smpp.pdu.ValueNotSetException;
import org.smpp.pdu.tlv.TLV;
import org.smpp.pdu.tlv.TLVException;
import org.smpp.pdu.tlv.TLVOctets;
import org.smpp.util.ByteBuffer;
import org.smpp.util.NotEnoughDataInByteBufferException;
import org.smpp.util.TerminatingZeroNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PDU
extends ByteData {
    public static final byte VALID_NONE = 0;
    public static final byte VALID_HEADER = 1;
    public static final byte VALID_BODY = 2;
    public static final byte VALID_ALL = 3;
    private static int sequenceNumber = 0;
    private boolean sequenceNumberChanged = false;
    private PDUHeader header = null;
    private Vector<TLV> optionalParameters = new Vector(10, 2);
    private Vector<TLV> extraOptionalParameters = new Vector(1, 1);
    private byte valid = (byte)3;
    private Dictionary<Object, Object> applicationSpecificInfo = null;

    public PDU() {
    }

    public PDU(int commandId) {
        this.checkHeader();
        this.setCommandId(commandId);
    }

    public void setBody(ByteBuffer buffer) throws NotEnoughDataInByteBufferException, TerminatingZeroNotFoundException, PDUException {
    }

    public ByteBuffer getBody() throws ValueNotSetException {
        return null;
    }

    public boolean canResponse() {
        return false;
    }

    public abstract boolean isRequest();

    public abstract boolean isResponse();

    public void assignSequenceNumber() {
        this.assignSequenceNumber(false);
    }

    public void assignSequenceNumber(boolean always) {
        if (!this.sequenceNumberChanged || always) {
            this.setSequenceNumber(PDU.nextSequenceNumber());
        }
    }

    private static synchronized int nextSequenceNumber() {
        return ++sequenceNumber & Integer.MAX_VALUE;
    }

    public void resetSequenceNumber() {
        this.setSequenceNumber(0);
        this.sequenceNumberChanged = false;
    }

    @Override
    public void setData(ByteBuffer buffer) throws InvalidPDUException, PDUException {
        int initialBufLen = buffer.length();
        try {
            this.setValid((byte)0);
            if (buffer.length() < 16 && debug.active(5)) {
                debug.write(5, "PDU.setData() not enough data for header in the buffer " + buffer.getHexDump());
            }
            ByteBuffer headerBuf = buffer.removeBytes(16);
            if (debug.active(5)) {
                debug.write(5, "PDU.setData() parsing header " + headerBuf.getHexDump());
            }
            this.setHeader(headerBuf);
            this.setValid((byte)1);
            if (debug.active(5)) {
                if (this.getCommandLength() > 16) {
                    ByteBuffer tempBodyBuf = buffer.readBytes(this.getCommandLength() - 16);
                    debug.write(5, "PDU.setData() parsing body " + tempBodyBuf.getHexDump());
                } else {
                    debug.write(5, "PDU.setData() no data for body");
                }
            }
            this.setBody(buffer);
            this.setValid((byte)2);
            if (initialBufLen - buffer.length() < this.getCommandLength()) {
                int optionalLength = this.getCommandLength() + buffer.length() - initialBufLen;
                try {
                    debug.write(5, "have " + optionalLength + " bytes left.");
                    ByteBuffer optionalBody = buffer.removeBuffer(optionalLength);
                    this.setOptionalBody(optionalBody);
                }
                catch (Exception e) {
                    debug.write(5, "Parsing optional parameters failed: " + e.getMessage());
                }
            }
            this.setValid((byte)3);
        }
        catch (NotEnoughDataInByteBufferException e) {
            throw new InvalidPDUException(this, (Exception)e);
        }
        catch (TerminatingZeroNotFoundException e) {
            throw new InvalidPDUException(this, (Exception)e);
        }
        catch (PDUException e) {
            e.setPDU(this);
            throw e;
        }
        catch (Exception e) {
            throw new InvalidPDUException(this, e);
        }
        if (buffer.length() != initialBufLen - this.getCommandLength()) {
            throw new InvalidPDUException(this, "The parsed size of the message is not equal to command_length.");
        }
    }

    @Override
    public ByteBuffer getData() throws ValueNotSetException {
        ByteBuffer bodyBuf = new ByteBuffer();
        bodyBuf.appendBuffer(this.getBody());
        bodyBuf.appendBuffer(this.getOptionalBody());
        this.setCommandLength(bodyBuf.length() + 16);
        ByteBuffer pduBuf = this.getHeader();
        pduBuf.appendBuffer(bodyBuf);
        if (debug.active(5)) {
            debug.write(5, "PDU.getData() build up data " + pduBuf.getHexDump());
        }
        return pduBuf;
    }

    public void setValid(byte valid) {
        this.valid = valid;
    }

    public byte getValid() {
        return this.valid;
    }

    public boolean isValid() {
        return this.getValid() == 3;
    }

    public boolean isInvalid() {
        return this.getValid() == 0;
    }

    public boolean isHeaderValid() {
        return this.getValid() >= 1;
    }

    private void setHeader(ByteBuffer buffer) throws NotEnoughDataInByteBufferException {
        this.checkHeader();
        this.header.setData(buffer);
        this.sequenceNumberChanged = true;
    }

    private ByteBuffer getHeader() {
        this.checkHeader();
        return this.header.getData();
    }

    private void setOptionalBody(ByteBuffer buffer) throws NotEnoughDataInByteBufferException, UnexpectedOptionalParameterException, TLVException {
        TLV tlv = null;
        while (buffer.length() > 0) {
            ByteBuffer tlvHeader = buffer.readBytes(4);
            short tag = tlvHeader.removeShort();
            tlv = this.findOptional(this.optionalParameters, tag);
            if (tlv == null) {
                tlv = new TLVOctets(tag);
                this.registerExtraOptional(tlv);
            }
            short length = tlvHeader.removeShort();
            ByteBuffer tlvBuf = buffer.removeBuffer(4 + length);
            tlv.setData(tlvBuf);
        }
    }

    private ByteBuffer getOptionalBody() throws ValueNotSetException {
        ByteBuffer optBody = new ByteBuffer();
        optBody.appendBuffer(this.getOptionalBody(this.optionalParameters));
        optBody.appendBuffer(this.getOptionalBody(this.extraOptionalParameters));
        return optBody;
    }

    private ByteBuffer getOptionalBody(Vector<TLV> optionalParameters) throws ValueNotSetException {
        ByteBuffer optBody = new ByteBuffer();
        int size = optionalParameters.size();
        TLV tlv = null;
        for (int i = 0; i < size; ++i) {
            tlv = optionalParameters.get(i);
            if (tlv == null || !tlv.hasValue()) continue;
            optBody.appendBuffer(tlv.getData());
        }
        return optBody;
    }

    protected void registerOptional(TLV tlv) {
        if (tlv != null) {
            this.optionalParameters.add(tlv);
        }
    }

    protected void registerExtraOptional(TLV tlv) {
        if (tlv != null) {
            this.extraOptionalParameters.add(tlv);
        }
    }

    private TLV findOptional(Vector<TLV> optionalParameters, short tag) {
        int size = optionalParameters.size();
        TLV tlv = null;
        for (int i = 0; i < size; ++i) {
            tlv = optionalParameters.get(i);
            if (tlv == null || tlv.getTag() != tag) continue;
            return tlv;
        }
        return null;
    }

    private void replaceExtraOptional(TLV tlv) {
        int size = this.extraOptionalParameters.size();
        TLV existing = null;
        short tlvTag = tlv.getTag();
        for (int i = 0; i < size; ++i) {
            existing = this.extraOptionalParameters.get(i);
            if (existing == null || existing.getTag() != tlvTag) continue;
            this.extraOptionalParameters.set(i, tlv);
            return;
        }
        this.registerExtraOptional(tlv);
    }

    public void setExtraOptional(TLV tlv) {
        this.replaceExtraOptional(tlv);
    }

    public void setExtraOptional(short tag, ByteBuffer data) throws TLVException {
        TLVOctets tlv = new TLVOctets(tag, data);
        this.setExtraOptional(tlv);
    }

    public TLV getExtraOptional(short tag) {
        TLV tlv = this.findOptional(this.extraOptionalParameters, tag);
        return tlv;
    }

    private void checkHeader() {
        if (this.header == null) {
            this.header = new PDUHeader();
        }
    }

    public int getCommandLength() {
        this.checkHeader();
        return this.header.getCommandLength();
    }

    public int getCommandId() {
        this.checkHeader();
        return this.header.getCommandId();
    }

    public int getCommandStatus() {
        this.checkHeader();
        return this.header.getCommandStatus();
    }

    public int getSequenceNumber() {
        this.checkHeader();
        return this.header.getSequenceNumber();
    }

    public void setCommandLength(int cmdLen) {
        this.checkHeader();
        this.header.setCommandLength(cmdLen);
    }

    public void setCommandId(int cmdId) {
        this.checkHeader();
        this.header.setCommandId(cmdId);
    }

    public void setCommandStatus(int cmdStatus) {
        this.checkHeader();
        this.header.setCommandStatus(cmdStatus);
    }

    public void setSequenceNumber(int seqNr) {
        this.checkHeader();
        this.header.setSequenceNumber(seqNr);
        this.sequenceNumberChanged = true;
    }

    public boolean isOk() {
        return this.getCommandStatus() == 0;
    }

    public boolean isGNack() {
        return this.getCommandId() == Integer.MIN_VALUE;
    }

    public static final PDU createPDU(ByteBuffer buffer) throws HeaderIncompleteException, MessageIncompleteException, UnknownCommandIdException, InvalidPDUException, TLVException, PDUException {
        ByteBuffer headerBuf = null;
        try {
            headerBuf = buffer.readBytes(16);
        }
        catch (NotEnoughDataInByteBufferException e) {
            throw new HeaderIncompleteException();
        }
        PDUHeader header = new PDUHeader();
        try {
            header.setData(headerBuf);
        }
        catch (NotEnoughDataInByteBufferException notEnoughDataInByteBufferException) {
            // empty catch block
        }
        if (buffer.length() < header.getCommandLength()) {
            throw new MessageIncompleteException();
        }
        PDU pdu = PDU.createPDU(header.getCommandId());
        if (pdu != null) {
            ByteBuffer thisMessageBuffer = null;
            try {
                thisMessageBuffer = buffer.removeBuffer(header.getCommandLength());
            }
            catch (NotEnoughDataInByteBufferException notEnoughDataInByteBufferException) {
                // empty catch block
            }
            pdu.setData(thisMessageBuffer);
            return pdu;
        }
        throw new UnknownCommandIdException(header);
    }

    public static final PDU createPDU(int commandId) {
        return PDUFactory.createPDU(commandId);
    }

    @Override
    public String debugString() {
        String dbgs = "(pdu: ";
        dbgs = dbgs + super.debugString();
        dbgs = dbgs + Integer.toString(this.getCommandLength());
        dbgs = dbgs + " ";
        dbgs = dbgs + Integer.toHexString(this.getCommandId());
        dbgs = dbgs + " ";
        dbgs = dbgs + Integer.toHexString(this.getCommandStatus());
        dbgs = dbgs + " ";
        dbgs = this.sequenceNumberChanged ? dbgs + Integer.toString(this.getSequenceNumber()) : dbgs + "[" + (sequenceNumber + 1) + "]";
        dbgs = dbgs + ") ";
        return dbgs;
    }

    protected String debugStringOptional(String label, Vector<TLV> optionalParameters) {
        String dbgs = "";
        int size = optionalParameters.size();
        if (size > 0) {
            dbgs = dbgs + "(" + label + ": ";
            TLV tlv = null;
            for (int i = 0; i < size; ++i) {
                tlv = optionalParameters.get(i);
                if (tlv == null || !tlv.hasValue()) continue;
                dbgs = dbgs + tlv.debugString();
                dbgs = dbgs + " ";
            }
            dbgs = dbgs + ") ";
        }
        return dbgs;
    }

    protected String debugStringOptional() {
        String dbgs = "";
        dbgs = dbgs + this.debugStringOptional("opt", this.optionalParameters);
        dbgs = dbgs + this.debugStringOptional("extraopt", this.extraOptionalParameters);
        return dbgs;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof PDU) {
            PDU pdu = (PDU)object;
            return pdu.getSequenceNumber() == this.getSequenceNumber() && pdu.getCommandId() == this.getCommandId();
        }
        return false;
    }

    public void setApplicationSpecificInfo(Object key, Object value) {
        if (this.applicationSpecificInfo == null) {
            this.applicationSpecificInfo = new Hashtable<Object, Object>();
        }
        debug.write(5, "setting app spec info key=\"" + key + "\" value=\"" + (value == null ? "null" : value) + "\"");
        this.applicationSpecificInfo.put(key, value);
    }

    public void setApplicationSpecificInfo(Dictionary<Object, Object> applicationSpecificInfo) {
        this.applicationSpecificInfo = this.cloneApplicationSpecificInfo(applicationSpecificInfo);
    }

    public Object getApplicationSpecificInfo(Object key) {
        Object value = null;
        if (this.applicationSpecificInfo != null) {
            value = this.applicationSpecificInfo.get(key);
        }
        debug.write(5, "getting app spec info key=\"" + key + "\" value=\"" + (value == null ? "null" : value) + "\"");
        return value;
    }

    public Dictionary<Object, Object> getApplicationSpecificInfo() {
        return this.cloneApplicationSpecificInfo(this.applicationSpecificInfo);
    }

    public void removeApplicationSpecificInfo(Object key) {
        if (this.applicationSpecificInfo != null) {
            this.applicationSpecificInfo.remove(key);
        }
    }

    private Dictionary<Object, Object> cloneApplicationSpecificInfo(Dictionary<Object, Object> info) {
        Hashtable<Object, Object> newInfo = null;
        if (info != null) {
            newInfo = new Hashtable<Object, Object>();
            Enumeration<Object> keys = info.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                Object value = info.get(key);
                ((Dictionary)newInfo).put(key, value);
            }
        }
        return newInfo;
    }
}

