/*
 * Decompiled with CFR 0.152.
 */
package org.smpp.pdu;

import java.util.Vector;
import org.smpp.pdu.AlertNotification;
import org.smpp.pdu.BindReceiver;
import org.smpp.pdu.BindReceiverResp;
import org.smpp.pdu.BindTransciever;
import org.smpp.pdu.BindTranscieverResp;
import org.smpp.pdu.BindTransmitter;
import org.smpp.pdu.BindTransmitterResp;
import org.smpp.pdu.CancelSM;
import org.smpp.pdu.CancelSMResp;
import org.smpp.pdu.DataSM;
import org.smpp.pdu.DataSMResp;
import org.smpp.pdu.DeliverSM;
import org.smpp.pdu.DeliverSMResp;
import org.smpp.pdu.EnquireLink;
import org.smpp.pdu.EnquireLinkResp;
import org.smpp.pdu.GenericNack;
import org.smpp.pdu.Outbind;
import org.smpp.pdu.PDU;
import org.smpp.pdu.QuerySM;
import org.smpp.pdu.QuerySMResp;
import org.smpp.pdu.ReplaceSM;
import org.smpp.pdu.ReplaceSMResp;
import org.smpp.pdu.SubmitMultiSM;
import org.smpp.pdu.SubmitMultiSMResp;
import org.smpp.pdu.SubmitSM;
import org.smpp.pdu.SubmitSMResp;
import org.smpp.pdu.Unbind;
import org.smpp.pdu.UnbindResp;

public class PDUFactory {
    private static final Vector<PDU> pduList = new Vector(30, 4);

    public static final PDU createPDU(int commandId) {
        int size = pduList.size();
        PDU pdu = null;
        PDU newInstance = null;
        for (int i = 0; i < size; ++i) {
            pdu = pduList.get(i);
            if (pdu == null || pdu.getCommandId() != commandId) continue;
            try {
                newInstance = (PDU)pdu.getClass().newInstance();
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
            return newInstance;
        }
        return null;
    }

    static {
        pduList.add(new BindTransmitter());
        pduList.add(new BindTransmitterResp());
        pduList.add(new BindReceiver());
        pduList.add(new BindReceiverResp());
        pduList.add(new BindTransciever());
        pduList.add(new BindTranscieverResp());
        pduList.add(new Unbind());
        pduList.add(new UnbindResp());
        pduList.add(new Outbind());
        pduList.add(new SubmitSM());
        pduList.add(new SubmitSMResp());
        pduList.add(new SubmitMultiSM());
        pduList.add(new SubmitMultiSMResp());
        pduList.add(new DeliverSM());
        pduList.add(new DeliverSMResp());
        pduList.add(new DataSM());
        pduList.add(new DataSMResp());
        pduList.add(new QuerySM());
        pduList.add(new QuerySMResp());
        pduList.add(new CancelSM());
        pduList.add(new CancelSMResp());
        pduList.add(new ReplaceSM());
        pduList.add(new ReplaceSMResp());
        pduList.add(new EnquireLink());
        pduList.add(new EnquireLinkResp());
        pduList.add(new AlertNotification());
        pduList.add(new GenericNack());
    }
}

