/*
 * Decompiled with CFR 0.152.
 */
package org.smpp.pdu;

import java.io.UnsupportedEncodingException;
import org.smpp.pdu.Address;
import org.smpp.pdu.ByteData;
import org.smpp.pdu.ByteDataList;
import org.smpp.pdu.DestinationAddress;
import org.smpp.pdu.IntegerOutOfRangeException;
import org.smpp.pdu.PDUException;
import org.smpp.pdu.Request;
import org.smpp.pdu.Response;
import org.smpp.pdu.ShortMessage;
import org.smpp.pdu.SubmitMultiSMResp;
import org.smpp.pdu.TooManyValuesException;
import org.smpp.pdu.ValueNotSetException;
import org.smpp.pdu.WrongDateFormatException;
import org.smpp.pdu.WrongLengthOfStringException;
import org.smpp.pdu.tlv.TLVByte;
import org.smpp.pdu.tlv.TLVEmpty;
import org.smpp.pdu.tlv.TLVOctets;
import org.smpp.pdu.tlv.TLVShort;
import org.smpp.pdu.tlv.TLVUByte;
import org.smpp.util.ByteBuffer;
import org.smpp.util.NotEnoughDataInByteBufferException;
import org.smpp.util.TerminatingZeroNotFoundException;

public class SubmitMultiSM
extends Request {
    private String serviceType = "";
    private Address sourceAddr = new Address();
    private DestAddressList destAddresses = new DestAddressList();
    private byte esmClass = 0;
    private byte protocolId = 0;
    private byte priorityFlag = 0;
    private String scheduleDeliveryTime = "";
    private String validityPeriod = "";
    private byte registeredDelivery = 0;
    private byte replaceIfPresentFlag = 0;
    private byte dataCoding = 0;
    private byte smDefaultMsgId = 0;
    private short smLength = 0;
    private ShortMessage shortMessage = new ShortMessage(254);
    private TLVShort userMessageReference = new TLVShort(516);
    private TLVShort sourcePort = new TLVShort(522);
    private TLVByte sourceAddrSubunit = new TLVByte(13);
    private TLVShort destinationPort = new TLVShort(523);
    private TLVByte destAddrSubunit = new TLVByte(5);
    private TLVShort sarMsgRefNum = new TLVShort(524);
    private TLVUByte sarTotalSegments = new TLVUByte(526);
    private TLVUByte sarSegmentSeqnum = new TLVUByte(527);
    private TLVByte payloadType = new TLVByte(25);
    private TLVOctets messagePayload = new TLVOctets(1060, 1, 1500);
    private TLVByte privacyIndicator = new TLVByte(513);
    private TLVOctets callbackNum = new TLVOctets(897, 4, 19);
    private TLVByte callbackNumPresInd = new TLVByte(770);
    private TLVOctets callbackNumAtag = new TLVOctets(771, 1, 65);
    private TLVOctets sourceSubaddress = new TLVOctets(514, 2, 23);
    private TLVOctets destSubaddress = new TLVOctets(515, 2, 23);
    private TLVByte displayTime = new TLVByte(4609);
    private TLVShort smsSignal = new TLVShort(4611);
    private TLVByte msValidity = new TLVByte(4612);
    private TLVByte msMsgWaitFacilities = new TLVByte(2);
    private TLVEmpty alertOnMsgDelivery = new TLVEmpty(4876);
    private TLVByte languageIndicator = new TLVByte(525);

    public SubmitMultiSM() {
        super(33);
        this.registerOptional(this.userMessageReference);
        this.registerOptional(this.sourcePort);
        this.registerOptional(this.sourceAddrSubunit);
        this.registerOptional(this.destinationPort);
        this.registerOptional(this.destAddrSubunit);
        this.registerOptional(this.sarMsgRefNum);
        this.registerOptional(this.sarTotalSegments);
        this.registerOptional(this.sarSegmentSeqnum);
        this.registerOptional(this.payloadType);
        this.registerOptional(this.messagePayload);
        this.registerOptional(this.privacyIndicator);
        this.registerOptional(this.callbackNum);
        this.registerOptional(this.callbackNumPresInd);
        this.registerOptional(this.callbackNumAtag);
        this.registerOptional(this.sourceSubaddress);
        this.registerOptional(this.destSubaddress);
        this.registerOptional(this.displayTime);
        this.registerOptional(this.smsSignal);
        this.registerOptional(this.msValidity);
        this.registerOptional(this.msMsgWaitFacilities);
        this.registerOptional(this.alertOnMsgDelivery);
        this.registerOptional(this.languageIndicator);
    }

    protected Response createResponse() {
        return new SubmitMultiSMResp();
    }

    public void setBody(ByteBuffer buffer) throws NotEnoughDataInByteBufferException, TerminatingZeroNotFoundException, PDUException {
        this.setServiceType(buffer.removeCString());
        this.sourceAddr.setData(buffer);
        this.destAddresses.setData(buffer);
        this.setEsmClass(buffer.removeByte());
        this.setProtocolId(buffer.removeByte());
        this.setPriorityFlag(buffer.removeByte());
        this.setScheduleDeliveryTime(buffer.removeCString());
        this.setValidityPeriod(buffer.removeCString());
        this.setRegisteredDelivery(buffer.removeByte());
        this.setReplaceIfPresentFlag(buffer.removeByte());
        this.setDataCoding(buffer.removeByte());
        this.setSmDefaultMsgId(buffer.removeByte());
        this.setSmLength(SubmitMultiSM.decodeUnsigned(buffer.removeByte()));
        this.shortMessage.setData(buffer.removeBuffer(this.getSmLength()));
    }

    public ByteBuffer getBody() throws ValueNotSetException {
        ByteBuffer buffer = new ByteBuffer();
        buffer.appendCString(this.getServiceType());
        buffer.appendBuffer(this.getSourceAddr().getData());
        buffer.appendBuffer(this.destAddresses.getData());
        buffer.appendByte(this.getEsmClass());
        buffer.appendByte(this.getProtocolId());
        buffer.appendByte(this.getPriorityFlag());
        buffer.appendCString(this.getScheduleDeliveryTime());
        buffer.appendCString(this.getValidityPeriod());
        buffer.appendByte(this.getRegisteredDelivery());
        buffer.appendByte(this.getReplaceIfPresentFlag());
        buffer.appendByte(this.getDataCoding());
        buffer.appendByte(this.getSmDefaultMsgId());
        buffer.appendByte(SubmitMultiSM.encodeUnsigned(this.getSmLength()));
        buffer.appendBuffer(this.shortMessage.getData());
        return buffer;
    }

    public void setServiceType(String value) throws WrongLengthOfStringException {
        try {
            SubmitMultiSM.checkCString(value, 6);
        }
        catch (WrongLengthOfStringException e) {
            e.setErrorCode(21);
            throw e;
        }
        this.serviceType = value;
    }

    public void setScheduleDeliveryTime(String value) throws WrongDateFormatException {
        try {
            SubmitMultiSM.checkDate(value);
        }
        catch (WrongDateFormatException e) {
            e.setErrorCode(97);
            throw e;
        }
        this.scheduleDeliveryTime = value;
    }

    public void setValidityPeriod(String value) throws WrongDateFormatException {
        try {
            SubmitMultiSM.checkDate(value);
        }
        catch (WrongDateFormatException e) {
            e.setErrorCode(98);
            throw e;
        }
        this.validityPeriod = value;
    }

    public void setShortMessageData(ByteBuffer value) throws PDUException, NotEnoughDataInByteBufferException, TerminatingZeroNotFoundException {
        this.shortMessage.setData(value);
        this.setSmLength((short)this.shortMessage.getLength());
    }

    public void setShortMessage(String value) throws WrongLengthOfStringException {
        this.shortMessage.setMessage(value);
        this.setSmLength((short)this.shortMessage.getLength());
    }

    public void setShortMessage(String value, String encoding) throws WrongLengthOfStringException, UnsupportedEncodingException {
        this.shortMessage.setMessage(value, encoding);
        this.setSmLength((short)this.shortMessage.getLength());
    }

    public void setSourceAddr(Address value) {
        this.sourceAddr = value;
    }

    public void setSourceAddr(String address) throws WrongLengthOfStringException {
        this.setSourceAddr(new Address(address));
    }

    public void setSourceAddr(byte ton, byte npi, String address) throws WrongLengthOfStringException {
        this.setSourceAddr(new Address(ton, npi, address));
    }

    public void addDestAddress(DestinationAddress destAddr) throws TooManyValuesException {
        this.destAddresses.addValue(destAddr);
    }

    public void setEsmClass(byte value) {
        this.esmClass = value;
    }

    public void setProtocolId(byte value) {
        this.protocolId = value;
    }

    public void setPriorityFlag(byte value) {
        this.priorityFlag = value;
    }

    public void setRegisteredDelivery(byte value) {
        this.registeredDelivery = value;
    }

    public void setReplaceIfPresentFlag(byte value) {
        this.replaceIfPresentFlag = value;
    }

    public void setDataCoding(byte value) {
        this.dataCoding = value;
    }

    public void setSmDefaultMsgId(byte value) {
        this.smDefaultMsgId = value;
    }

    private void setSmLength(short value) {
        this.smLength = value;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public String getScheduleDeliveryTime() {
        return this.scheduleDeliveryTime;
    }

    public String getValidityPeriod() {
        return this.validityPeriod;
    }

    public String getShortMessage() {
        return this.shortMessage.getMessage();
    }

    public String getShortMessage(String encoding) throws UnsupportedEncodingException {
        return this.shortMessage.getMessage(encoding);
    }

    public ByteBuffer getShortMessageData() {
        return this.shortMessage.getData();
    }

    public Address getSourceAddr() {
        return this.sourceAddr;
    }

    public short getNumberOfDests() {
        return (short)this.destAddresses.getCount();
    }

    public DestinationAddress getDestAddress(int i) {
        return (DestinationAddress)this.destAddresses.getValue(i);
    }

    public byte getEsmClass() {
        return this.esmClass;
    }

    public byte getProtocolId() {
        return this.protocolId;
    }

    public byte getPriorityFlag() {
        return this.priorityFlag;
    }

    public byte getRegisteredDelivery() {
        return this.registeredDelivery;
    }

    public byte getReplaceIfPresentFlag() {
        return this.replaceIfPresentFlag;
    }

    public byte getDataCoding() {
        return this.dataCoding;
    }

    public byte getSmDefaultMsgId() {
        return this.smDefaultMsgId;
    }

    public short getSmLength() {
        return this.smLength;
    }

    public boolean hasUserMessageReference() {
        return this.userMessageReference.hasValue();
    }

    public boolean hasSourcePort() {
        return this.sourcePort.hasValue();
    }

    public boolean hasSourceAddrSubunit() {
        return this.sourceAddrSubunit.hasValue();
    }

    public boolean hasDestinationPort() {
        return this.destinationPort.hasValue();
    }

    public boolean hasDestAddrSubunit() {
        return this.destAddrSubunit.hasValue();
    }

    public boolean hasSarMsgRefNum() {
        return this.sarMsgRefNum.hasValue();
    }

    public boolean hasSarTotalSegments() {
        return this.sarTotalSegments.hasValue();
    }

    public boolean hasSarSegmentSeqnum() {
        return this.sarSegmentSeqnum.hasValue();
    }

    public boolean hasPayloadType() {
        return this.payloadType.hasValue();
    }

    public boolean hasMessagePayload() {
        return this.messagePayload.hasValue();
    }

    public boolean hasPrivacyIndicator() {
        return this.privacyIndicator.hasValue();
    }

    public boolean hasCallbackNum() {
        return this.callbackNum.hasValue();
    }

    public boolean hasCallbackNumPresInd() {
        return this.callbackNumPresInd.hasValue();
    }

    public boolean hasCallbackNumAtag() {
        return this.callbackNumAtag.hasValue();
    }

    public boolean hasSourceSubaddress() {
        return this.sourceSubaddress.hasValue();
    }

    public boolean hasDestSubaddress() {
        return this.destSubaddress.hasValue();
    }

    public boolean hasDisplayTime() {
        return this.displayTime.hasValue();
    }

    public boolean hasSmsSignal() {
        return this.smsSignal.hasValue();
    }

    public boolean hasMsValidity() {
        return this.msValidity.hasValue();
    }

    public boolean hasMsMsgWaitFacilities() {
        return this.msMsgWaitFacilities.hasValue();
    }

    public boolean hasAlertOnMsgDelivery() {
        return this.alertOnMsgDelivery.hasValue();
    }

    public boolean hasLanguageIndicator() {
        return this.languageIndicator.hasValue();
    }

    public void setUserMessageReference(short value) {
        this.userMessageReference.setValue(value);
    }

    public void setSourcePort(short value) {
        this.sourcePort.setValue(value);
    }

    public void setSourceAddrSubunit(byte value) {
        this.sourceAddrSubunit.setValue(value);
    }

    public void setDestinationPort(short value) {
        this.destinationPort.setValue(value);
    }

    public void setDestAddrSubunit(byte value) {
        this.destAddrSubunit.setValue(value);
    }

    public void setSarMsgRefNum(short value) {
        this.sarMsgRefNum.setValue(value);
    }

    public void setSarTotalSegments(short value) throws IntegerOutOfRangeException {
        this.sarTotalSegments.setValue(value);
    }

    public void setSarSegmentSeqnum(short value) throws IntegerOutOfRangeException {
        this.sarSegmentSeqnum.setValue(value);
    }

    public void setPayloadType(byte value) {
        this.payloadType.setValue(value);
    }

    public void setMessagePayload(ByteBuffer value) {
        this.messagePayload.setValue(value);
    }

    public void setPrivacyIndicator(byte value) {
        this.privacyIndicator.setValue(value);
    }

    public void setCallbackNum(ByteBuffer value) {
        this.callbackNum.setValue(value);
    }

    public void setCallbackNumPresInd(byte value) {
        this.callbackNumPresInd.setValue(value);
    }

    public void setCallbackNumAtag(ByteBuffer value) {
        this.callbackNumAtag.setValue(value);
    }

    public void setSourceSubaddress(ByteBuffer value) {
        this.sourceSubaddress.setValue(value);
    }

    public void setDestSubaddress(ByteBuffer value) {
        this.destSubaddress.setValue(value);
    }

    public void setDisplayTime(byte value) {
        this.displayTime.setValue(value);
    }

    public void setSmsSignal(short value) {
        this.smsSignal.setValue(value);
    }

    public void setMsValidity(byte value) {
        this.msValidity.setValue(value);
    }

    public void setMsMsgWaitFacilities(byte value) {
        this.msMsgWaitFacilities.setValue(value);
    }

    public void setAlertOnMsgDelivery(boolean value) {
        this.alertOnMsgDelivery.setValue(value);
    }

    public void setLanguageIndicator(byte value) {
        this.languageIndicator.setValue(value);
    }

    public short getUserMessageReference() throws ValueNotSetException {
        return this.userMessageReference.getValue();
    }

    public short getSourcePort() throws ValueNotSetException {
        return this.sourcePort.getValue();
    }

    public byte getSourceAddrSubunit() throws ValueNotSetException {
        return this.sourceAddrSubunit.getValue();
    }

    public short getDestinationPort() throws ValueNotSetException {
        return this.destinationPort.getValue();
    }

    public byte getDestAddrSubunit() throws ValueNotSetException {
        return this.destAddrSubunit.getValue();
    }

    public short getSarMsgRefNum() throws ValueNotSetException {
        return this.sarMsgRefNum.getValue();
    }

    public short getSarTotalSegments() throws ValueNotSetException {
        return this.sarTotalSegments.getValue();
    }

    public short getSarSegmentSeqnum() throws ValueNotSetException {
        return this.sarSegmentSeqnum.getValue();
    }

    public byte getPayloadType() throws ValueNotSetException {
        return this.payloadType.getValue();
    }

    public ByteBuffer getMessagePayload() throws ValueNotSetException {
        return this.messagePayload.getValue();
    }

    public byte getPrivacyIndicator() throws ValueNotSetException {
        return this.privacyIndicator.getValue();
    }

    public ByteBuffer callbackNum() throws ValueNotSetException {
        return this.callbackNum.getValue();
    }

    public byte getCallbackNumPresInd() throws ValueNotSetException {
        return this.callbackNumPresInd.getValue();
    }

    public ByteBuffer getCallbackNumAtag() throws ValueNotSetException {
        return this.callbackNumAtag.getValue();
    }

    public ByteBuffer getSourceSubaddress() throws ValueNotSetException {
        return this.sourceSubaddress.getValue();
    }

    public ByteBuffer getDestSubaddress() throws ValueNotSetException {
        return this.destSubaddress.getValue();
    }

    public byte getDisplayTime() throws ValueNotSetException {
        return this.displayTime.getValue();
    }

    public short getSmsSignal() throws ValueNotSetException {
        return this.smsSignal.getValue();
    }

    public byte getMsValidity() throws ValueNotSetException {
        return this.msValidity.getValue();
    }

    public byte getMsMsgWaitFacilities() throws ValueNotSetException {
        return this.msMsgWaitFacilities.getValue();
    }

    public boolean getAlertOnMsgDelivery() throws ValueNotSetException {
        return this.alertOnMsgDelivery.getValue();
    }

    public byte getLanguageIndicator() throws ValueNotSetException {
        return this.languageIndicator.getValue();
    }

    public String debugString() {
        String dbgs = "(submitmulti: ";
        dbgs = dbgs + super.debugString();
        dbgs = dbgs + this.getSourceAddr().debugString();
        dbgs = dbgs + this.destAddresses.debugString();
        dbgs = dbgs + " ";
        dbgs = dbgs + this.shortMessage.debugString();
        dbgs = dbgs + " ";
        dbgs = dbgs + this.debugStringOptional();
        dbgs = dbgs + ") ";
        return dbgs;
    }

    private class DestAddressList
    extends ByteDataList {
        public DestAddressList() {
            super(254, 1);
        }

        public ByteData createValue() {
            return new DestinationAddress();
        }

        public String debugString() {
            return "(dest_addr_list: " + super.debugString() + ")";
        }
    }
}

