/*
 * Decompiled with CFR 0.152.
 */
package org.smpp.pdu;

import org.smpp.pdu.InvalidPDUException;
import org.smpp.pdu.Response;
import org.smpp.pdu.WrongLengthOfStringException;
import org.smpp.util.ByteBuffer;
import org.smpp.util.NotEnoughDataInByteBufferException;
import org.smpp.util.TerminatingZeroNotFoundException;

public class SubmitSMResp
extends Response {
    private String messageId = "";

    public SubmitSMResp() {
        super(-2147483644);
    }

    public void setBody(ByteBuffer buffer) throws NotEnoughDataInByteBufferException, TerminatingZeroNotFoundException, WrongLengthOfStringException, InvalidPDUException {
        if (this.getCommandStatus() == 0) {
            this.setMessageId(buffer.removeCString());
            return;
        }
        if (buffer.length() > 0) {
            debug.enter(this, "setBody");
            debug.write("invalid SubmitSMResp: command_status non-zero, but body was present (ignoring body)");
            debug.exit(this);
            event.write("invalid SubmitSMResp sequenceNumber [" + this.getSequenceNumber() + "]: command_status non-zero, but body was present (ignoring body)");
            buffer.removeBytes(buffer.length());
        }
    }

    public ByteBuffer getBody() {
        ByteBuffer buffer = new ByteBuffer();
        if (this.getCommandStatus() == 0) {
            buffer.appendCString(this.messageId);
        }
        return buffer;
    }

    public void setMessageId(String value) throws WrongLengthOfStringException {
        SubmitSMResp.checkString(value, 64);
        this.messageId = value;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String debugString() {
        String dbgs = "(submit_resp: ";
        dbgs = dbgs + super.debugString();
        dbgs = dbgs + this.getMessageId();
        dbgs = dbgs + " ";
        dbgs = dbgs + this.debugStringOptional();
        dbgs = dbgs + ") ";
        return dbgs;
    }
}

