/*
 * Decompiled with CFR 0.152.
 */
package org.smpp.test;

import org.smpp.pdu.BindReceiver;
import org.smpp.pdu.BindTransciever;

public class PDUInitDeadlockTest {
    private static int TYPE_RECEIVER = 1;
    private static int TYPE_TRANSCEIVER = 2;

    private PDUInitDeadlockTest() {
        int i;
        int numThreads = 2;
        System.out.println("Creating PDU creator threads");
        PDUCreatorThread[] threads = new PDUCreatorThread[numThreads];
        boolean makeReceiver = false;
        for (i = 0; i < numThreads; ++i) {
            threads[i] = makeReceiver ? new PDUCreatorThread(TYPE_RECEIVER, "Receiver" + i) : new PDUCreatorThread(TYPE_TRANSCEIVER, "Transceiver" + i);
            makeReceiver = !makeReceiver;
        }
        for (i = 0; i < numThreads; ++i) {
            threads[i].start();
        }
        try {
            int i2;
            Thread.sleep(500L);
            System.out.println("PDU creator threads started - please wait...");
            Thread.sleep(5000L);
            boolean threadsAlive = false;
            for (i2 = 0; i2 < numThreads; ++i2) {
                if (!threads[i2].isAlive()) continue;
                threadsAlive = true;
                System.out.println("Thread " + threads[i2].getName() + " is alive. Here is its stack trace: ");
                System.out.println("(stacktrace - TODO)");
            }
            if (threadsAlive) {
                Thread.sleep(200L);
                System.out.println("Some threads are still alive (after 5 seconds) - likely deadlock!");
                System.out.println("   - interrupting all living threads...");
                for (i2 = 0; i2 < numThreads; ++i2) {
                    if (!threads[i2].isAlive()) continue;
                    threads[i2].interrupt();
                }
                Thread.sleep(1000L);
            } else {
                System.out.println("All threads have exited correctly.");
            }
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
        }
        System.out.println("Exiting");
        System.exit(0);
    }

    public static void main(String[] args) {
        new PDUInitDeadlockTest();
    }

    class PDUCreatorThread
    extends Thread {
        int type;

        public PDUCreatorThread(int type, String name) {
            this.type = type;
            this.setName(name);
        }

        public void run() {
            System.out.println(this.getName() + ": starting");
            if (this.type == TYPE_RECEIVER) {
                new BindReceiver();
            } else if (this.type == TYPE_TRANSCEIVER) {
                new BindTransciever();
            }
            System.out.println(this.getName() + ": done");
        }
    }
}

