/*
 * Decompiled with CFR 0.152.
 */
package org.smpp.util;

import java.io.UnsupportedEncodingException;
import org.smpp.SmppObject;
import org.smpp.util.NotEnoughDataInByteBufferException;
import org.smpp.util.TerminatingZeroNotFoundException;

public class ByteBuffer
extends SmppObject {
    private byte[] buffer;
    private static final byte SZ_BYTE = 1;
    private static final byte SZ_SHORT = 2;
    private static final byte SZ_INT = 4;
    private static byte[] zero = new byte[1];

    public ByteBuffer() {
        this.buffer = null;
    }

    public ByteBuffer(byte[] buffer) {
        this.buffer = buffer;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public void setBuffer(byte[] buffer) {
        this.buffer = buffer;
    }

    public int length() {
        if (this.buffer == null) {
            return 0;
        }
        return this.buffer.length;
    }

    public void appendByte(byte data) {
        byte[] byteBuf = new byte[]{data};
        this.appendBytes0(byteBuf, 1);
    }

    public void appendShort(short data) {
        byte[] shortBuf = new byte[2];
        shortBuf[1] = (byte)(data & 0xFF);
        shortBuf[0] = (byte)(data >>> 8 & 0xFF);
        this.appendBytes0(shortBuf, 2);
    }

    public void appendInt(int data) {
        byte[] intBuf = new byte[4];
        intBuf[3] = (byte)(data & 0xFF);
        intBuf[2] = (byte)(data >>> 8 & 0xFF);
        intBuf[1] = (byte)(data >>> 16 & 0xFF);
        intBuf[0] = (byte)(data >>> 24 & 0xFF);
        this.appendBytes0(intBuf, 4);
    }

    public void appendCString(String string) {
        try {
            this.appendString0(string, true, "ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void appendCString(String string, String encoding) throws UnsupportedEncodingException {
        this.appendString0(string, true, encoding);
    }

    public void appendString(String string) {
        try {
            this.appendString(string, "ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void appendString(String string, String encoding) throws UnsupportedEncodingException {
        this.appendString0(string, false, encoding);
    }

    public void appendString(String string, int count) {
        try {
            this.appendString(string, count, "ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void appendString(String string, int count, String encoding) throws UnsupportedEncodingException {
        String subStr = string.substring(0, count);
        this.appendString0(subStr, false, encoding);
    }

    private void appendString0(String string, boolean isCString, String encoding) throws UnsupportedEncodingException {
        if (string != null && string.length() > 0) {
            byte[] stringBuf = null;
            stringBuf = encoding != null ? string.getBytes(encoding) : string.getBytes();
            if (stringBuf != null && stringBuf.length > 0) {
                this.appendBytes0(stringBuf, stringBuf.length);
            }
        }
        if (isCString) {
            this.appendBytes0(zero, 1);
        }
    }

    public void appendBuffer(ByteBuffer buf) {
        if (buf != null) {
            try {
                this.appendBytes(buf, buf.length());
            }
            catch (NotEnoughDataInByteBufferException notEnoughDataInByteBufferException) {
                // empty catch block
            }
        }
    }

    public void appendBytes(ByteBuffer bytes, int count) throws NotEnoughDataInByteBufferException {
        if (count > 0) {
            if (bytes == null) {
                throw new NotEnoughDataInByteBufferException(0, count);
            }
            if (bytes.length() < count) {
                throw new NotEnoughDataInByteBufferException(bytes.length(), count);
            }
            this.appendBytes0(bytes.getBuffer(), count);
        }
    }

    public void appendBytes(byte[] bytes, int count) {
        if (bytes != null) {
            if (count > bytes.length) {
                count = bytes.length;
            }
            this.appendBytes0(bytes, count);
        }
    }

    public void appendBytes(byte[] bytes) {
        if (bytes != null) {
            this.appendBytes0(bytes, bytes.length);
        }
    }

    public byte removeByte() throws NotEnoughDataInByteBufferException {
        byte result = 0;
        byte[] resBuff = this.removeBytes(1).getBuffer();
        result = resBuff[0];
        return result;
    }

    public short removeUnsignedByte() throws NotEnoughDataInByteBufferException {
        short result = 0;
        byte[] resBuff = this.removeBytes(1).getBuffer();
        result = (short)(resBuff[0] & 0xFF);
        return result;
    }

    public short removeShort() throws NotEnoughDataInByteBufferException {
        short result = 0;
        byte[] resBuff = this.removeBytes(2).getBuffer();
        result = (short)(result | resBuff[0] & 0xFF);
        result = (short)(result << 8);
        result = (short)(result | resBuff[1] & 0xFF);
        return result;
    }

    public int removeInt() throws NotEnoughDataInByteBufferException {
        int result = this.readInt();
        this.removeBytes0(4);
        return result;
    }

    public int readInt() throws NotEnoughDataInByteBufferException {
        int result = 0;
        int len = this.length();
        if (len >= 4) {
            result |= this.buffer[0] & 0xFF;
            result <<= 8;
            result |= this.buffer[1] & 0xFF;
            result <<= 8;
            result |= this.buffer[2] & 0xFF;
            result <<= 8;
            return result |= this.buffer[3] & 0xFF;
        }
        throw new NotEnoughDataInByteBufferException(len, 4);
    }

    public String removeCString() throws NotEnoughDataInByteBufferException, TerminatingZeroNotFoundException {
        try {
            return this.removeCString("ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public String removeCString(String encoding) throws NotEnoughDataInByteBufferException, TerminatingZeroNotFoundException, UnsupportedEncodingException {
        int zeroPos;
        int len = this.length();
        if (len == 0) {
            throw new NotEnoughDataInByteBufferException(0, 1);
        }
        for (zeroPos = 0; zeroPos < len && this.buffer[zeroPos] != 0; ++zeroPos) {
        }
        if (zeroPos < len) {
            String result;
            UnsupportedEncodingException encodingException;
            block9: {
                encodingException = null;
                result = null;
                if (zeroPos > 0) {
                    try {
                        if (encoding != null) {
                            result = new String(this.buffer, 0, zeroPos, encoding);
                            break block9;
                        }
                        result = new String(this.buffer, 0, zeroPos, "ASCII");
                    }
                    catch (UnsupportedEncodingException e) {
                        debug.write("Unsupported encoding exception " + e);
                        event.write(e, null);
                        encodingException = e;
                    }
                } else {
                    result = new String("");
                }
            }
            this.removeBytes0(zeroPos + 1);
            if (encodingException != null) {
                throw encodingException;
            }
            return result;
        }
        throw new TerminatingZeroNotFoundException();
    }

    public String removeString(int size, String encoding) throws NotEnoughDataInByteBufferException, UnsupportedEncodingException {
        int len = this.length();
        if (len < size) {
            throw new NotEnoughDataInByteBufferException(len, size);
        }
        UnsupportedEncodingException encodingException = null;
        String result = null;
        if (len > 0) {
            try {
                result = encoding != null ? new String(this.buffer, 0, size, encoding) : new String(this.buffer, 0, size);
            }
            catch (UnsupportedEncodingException e) {
                debug.write("Unsupported encoding exception " + e);
                event.write(e, null);
                encodingException = e;
            }
            this.removeBytes0(size);
        } else {
            result = new String("");
        }
        if (encodingException != null) {
            throw encodingException;
        }
        return result;
    }

    public ByteBuffer removeBuffer(int count) throws NotEnoughDataInByteBufferException {
        return this.removeBytes(count);
    }

    public ByteBuffer removeBytes(int count) throws NotEnoughDataInByteBufferException {
        ByteBuffer result = this.readBytes(count);
        this.removeBytes0(count);
        return result;
    }

    public void removeBytes0(int count) throws NotEnoughDataInByteBufferException {
        int len;
        int lefts;
        if (count < 0) {
            count = Integer.MAX_VALUE;
        }
        if ((lefts = (len = this.length()) - count) > 0) {
            byte[] newBuf = new byte[lefts];
            System.arraycopy(this.buffer, count, newBuf, 0, lefts);
            this.setBuffer(newBuf);
        } else {
            this.setBuffer(null);
        }
    }

    public ByteBuffer readBytes(int count) throws NotEnoughDataInByteBufferException {
        int len = this.length();
        ByteBuffer result = null;
        if (count > 0) {
            if (len >= count) {
                byte[] resBuf = new byte[count];
                System.arraycopy(this.buffer, 0, resBuf, 0, count);
                result = new ByteBuffer(resBuf);
                return result;
            }
            throw new NotEnoughDataInByteBufferException(len, count);
        }
        return result;
    }

    private void appendBytes0(byte[] bytes, int count) {
        int len = this.length();
        byte[] newBuf = new byte[len + count];
        if (len > 0) {
            System.arraycopy(this.buffer, 0, newBuf, 0, len);
        }
        System.arraycopy(bytes, 0, newBuf, len, count);
        this.setBuffer(newBuf);
    }

    public String getHexDump() {
        StringBuffer dump = new StringBuffer();
        try {
            int dataLen = this.length();
            byte[] buffer = this.getBuffer();
            for (int i = 0; i < dataLen; ++i) {
                dump.append(Character.forDigit(buffer[i] >> 4 & 0xF, 16));
                dump.append(Character.forDigit(buffer[i] & 0xF, 16));
            }
        }
        catch (Throwable t) {
            dump = new StringBuffer("Throwable caught when dumping = ").append(t);
        }
        return dump.toString();
    }

    static {
        ByteBuffer.zero[0] = 0;
    }
}

