/*
 * Decompiled with CFR 0.152.
 */
package org.smpp.util;

import java.util.LinkedList;
import java.util.ListIterator;
import org.smpp.SmppObject;

public class Queue
extends SmppObject {
    private int maxQueueSize = 0;
    private LinkedList<Object> queueData = new LinkedList();
    private Object mutex;

    public Queue() {
        this.mutex = this;
    }

    public Queue(int maxSize) {
        this.maxQueueSize = maxSize;
        this.mutex = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.mutex;
        synchronized (object) {
            return this.queueData.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.mutex;
        synchronized (object) {
            return this.queueData.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object dequeue() {
        Object object = this.mutex;
        synchronized (object) {
            Object first = null;
            if (this.size() > 0) {
                first = this.queueData.removeFirst();
            }
            return first;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object dequeue(Object obj) {
        Object found = null;
        Object object = this.mutex;
        synchronized (object) {
            found = this.find(obj);
            if (found != null) {
                this.queueData.remove(found);
            }
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(Object obj) throws IndexOutOfBoundsException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.maxQueueSize > 0 && this.size() >= this.maxQueueSize) {
                throw new IndexOutOfBoundsException("Queue is full. Element not added.");
            }
            this.queueData.add(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object find(Object obj) {
        Object object = this.mutex;
        synchronized (object) {
            ListIterator<Object> iter = this.queueData.listIterator(0);
            while (iter.hasNext()) {
                Object current = iter.next();
                if (!current.equals(obj)) continue;
                return current;
            }
        }
        return null;
    }
}

