/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.ifc.step.deserializer;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.bimserver.plugins.deserializers.DeserializeException;
import org.bimserver.plugins.serializers.SerializerException;
import org.eclipse.emf.common.util.Enumerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IfcParserWriterUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(IfcParserWriterUtils.class);
    private static final boolean USE_ISO_8859_1 = false;

    public static Object convertSimpleValue(Class<?> instanceClass, String value, int lineNumber) throws DeserializeException {
        if (!value.equals("")) {
            if (instanceClass == Integer.class || instanceClass == Integer.TYPE) {
                return Integer.parseInt(value);
            }
            if (instanceClass == Long.class || instanceClass == Long.TYPE) {
                return Long.parseLong(value);
            }
            if (instanceClass == Boolean.class || instanceClass == Boolean.TYPE) {
                return Boolean.parseBoolean(value);
            }
            if (instanceClass == Double.class || instanceClass == Double.TYPE) {
                try {
                    return Double.parseDouble(value);
                }
                catch (NumberFormatException e) {
                    throw new DeserializeException(lineNumber, "Incorrect double floating point value: " + value, (Exception)e);
                }
            }
            if (instanceClass == String.class) {
                if (value.startsWith("'") && value.endsWith("'")) {
                    return IfcParserWriterUtils.readString(value, lineNumber);
                }
                return value;
            }
            if (instanceClass == byte[].class) {
                if (value.startsWith("\"") && value.endsWith("\"")) {
                    try {
                        String substring = value.substring(2, value.length() - 1);
                        byte[] decoded = Hex.decodeHex((char[])substring.toCharArray());
                        return decoded;
                    }
                    catch (DecoderException e) {
                        throw new DeserializeException((Exception)((Object)e));
                    }
                }
                throw new DeserializeException("Byte[] not starting/ending with \"");
            }
            throw new DeserializeException("Unimplemented " + instanceClass);
        }
        return null;
    }

    public static String readString(String value, int lineNumber) throws DeserializeException {
        ByteBuffer buffer;
        int indexOfEnd;
        CharBuffer decode;
        ByteBuffer b;
        int index;
        String result = value.substring(1, value.length() - 1);
        while (result.contains("''")) {
            index = result.indexOf("''");
            result = result.substring(0, index) + "'" + result.substring(index + 2);
        }
        while (result.contains("\\S\\")) {
            index = result.indexOf("\\S\\");
            char x = result.charAt(index + 3);
            b = ByteBuffer.wrap(new byte[]{(byte)(x + 128)});
            decode = Charsets.ISO_8859_1.decode(b);
            result = result.substring(0, index) + decode.get() + result.substring(index + 4);
        }
        while (result.contains("\\X\\")) {
            index = result.indexOf("\\X\\");
            int code = Integer.parseInt(result.substring(index + 3, index + 5), 16);
            b = ByteBuffer.wrap(new byte[]{(byte)code});
            decode = Charsets.ISO_8859_1.decode(b);
            result = result.substring(0, index) + decode.get() + result.substring(index + 5);
        }
        while (result.contains("\\X2\\")) {
            index = result.indexOf("\\X2\\");
            indexOfEnd = result.indexOf("\\X0\\");
            if (indexOfEnd == -1) {
                throw new DeserializeException(lineNumber, "\\X2\\ not closed with \\X0\\");
            }
            if ((indexOfEnd - index) % 4 != 0) {
                throw new DeserializeException(lineNumber, "Number of hex chars in \\X2\\ definition not divisible by 4");
            }
            try {
                buffer = ByteBuffer.wrap(Hex.decodeHex((char[])result.substring(index + 4, indexOfEnd).toCharArray()));
                decode = Charsets.UTF_16BE.decode(buffer);
                result = result.substring(0, index) + decode.toString() + result.substring(indexOfEnd + 4);
            }
            catch (DecoderException e) {
                throw new DeserializeException(lineNumber, (Exception)((Object)e));
            }
        }
        while (result.contains("\\X4\\")) {
            index = result.indexOf("\\X4\\");
            indexOfEnd = result.indexOf("\\X0\\");
            if (indexOfEnd == -1) {
                throw new DeserializeException(lineNumber, "\\X4\\ not closed with \\X0\\");
            }
            if ((indexOfEnd - index) % 8 != 0) {
                throw new DeserializeException(lineNumber, "Number of hex chars in \\X4\\ definition not divisible by 8");
            }
            try {
                buffer = ByteBuffer.wrap(Hex.decodeHex((char[])result.substring(index + 4, indexOfEnd).toCharArray()));
                decode = Charset.forName("UTF-32").decode(buffer);
                result = result.substring(0, index) + decode.toString() + result.substring(indexOfEnd + 4);
            }
            catch (DecoderException e) {
                throw new DeserializeException(lineNumber, (Exception)((Object)e));
            }
            catch (UnsupportedCharsetException e) {
                throw new DeserializeException(lineNumber, "UTF-32 is not supported on your system", (Exception)e);
            }
        }
        while (result.contains("\\\\")) {
            index = result.indexOf("\\\\");
            result = result.substring(0, index) + "\\" + result.substring(index + 2);
        }
        return result;
    }

    public static void writePrimitive(Object val, OutputStream outputStream) throws SerializerException, IOException {
        if (val.getClass().getSimpleName().equals("Tristate")) {
            if (val.toString().equals("TRUE")) {
                outputStream.write(".T.".getBytes(Charsets.UTF_8));
            } else if (val.toString().equals("FALSE")) {
                outputStream.write(".F.".getBytes(Charsets.UTF_8));
            } else if (val.toString().equals("UNDEFINED")) {
                outputStream.write(".U.".getBytes(Charsets.UTF_8));
            }
        } else if (val instanceof Double) {
            if (((Double)val).isInfinite() || ((Double)val).isNaN()) {
                LOGGER.info("Serializing infinite or NaN double as 0.0");
                outputStream.write("0.0".getBytes(Charsets.UTF_8));
            } else {
                String string = val.toString();
                if (string.endsWith(".0")) {
                    outputStream.write(string.substring(0, string.length() - 1).getBytes(Charsets.UTF_8));
                } else {
                    outputStream.write(string.getBytes(Charsets.UTF_8));
                }
            }
        } else if (val instanceof Boolean) {
            Boolean bool = (Boolean)val;
            if (bool.booleanValue()) {
                outputStream.write(".T.".getBytes(Charsets.UTF_8));
            } else {
                outputStream.write(".F.".getBytes(Charsets.UTF_8));
            }
        } else if (val instanceof String) {
            outputStream.write("'".getBytes(Charsets.UTF_8));
            String stringVal = (String)val;
            for (int i = 0; i < stringVal.length(); ++i) {
                char c = stringVal.charAt(i);
                if (c == '\'') {
                    outputStream.write("''".getBytes(Charsets.UTF_8));
                    continue;
                }
                if (c == '\\') {
                    outputStream.write("\\\\".getBytes(Charsets.UTF_8));
                    continue;
                }
                if (c >= ' ' && c <= '~') {
                    outputStream.write(("" + c).getBytes(Charsets.UTF_8));
                    continue;
                }
                if (c < '\u00ff') {
                    outputStream.write(("\\X\\" + new String(Hex.encodeHex((byte[])Charsets.ISO_8859_1.encode(CharBuffer.wrap(new char[]{c})).array())).toUpperCase()).getBytes(Charsets.UTF_8));
                    continue;
                }
                if (Character.isLowSurrogate(c)) {
                    throw new SerializerException("Unexpected low surrogate range char");
                }
                if (Character.isHighSurrogate(c)) {
                    if (i + 1 < stringVal.length()) {
                        char low = stringVal.charAt(i + 1);
                        if (!Character.isLowSurrogate(low)) {
                            throw new SerializerException("High surrogate char should be followed by char in low surrogate range");
                        }
                        try {
                            outputStream.write(("\\X4\\" + new String(Hex.encodeHex((byte[])Charset.forName("UTF-32").encode(new String(new char[]{c, low})).array())).toUpperCase() + "\\X0\\").getBytes(Charsets.UTF_8));
                        }
                        catch (UnsupportedCharsetException e) {
                            throw new SerializerException((Throwable)e);
                        }
                        ++i;
                        continue;
                    }
                    throw new SerializerException("High surrogate char should be followed by char in low surrogate range, but end of string reached");
                }
                outputStream.write(("\\X2\\" + new String(Hex.encodeHex((byte[])Charsets.UTF_16BE.encode(CharBuffer.wrap(new char[]{c})).array())).toUpperCase() + "\\X0\\").getBytes(Charsets.UTF_8));
            }
            outputStream.write("'".getBytes(Charsets.UTF_8));
        } else if (val instanceof Enumerator) {
            outputStream.write(("." + val + ".").getBytes(Charsets.UTF_8));
        } else if (val instanceof byte[]) {
            outputStream.write(("\"0" + Hex.encodeHexString((byte[])((byte[])val)) + "\"").getBytes(Charsets.UTF_8));
        } else {
            outputStream.write((val == null ? "$" : val.toString()).getBytes(Charsets.UTF_8));
        }
    }
}

