/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.ifc.step.deserializer;

import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import nl.tue.buildingsmart.schema.Attribute;
import nl.tue.buildingsmart.schema.EntityDefinition;
import nl.tue.buildingsmart.schema.ExplicitAttribute;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.MetricCollector;
import org.bimserver.emf.MetaDataException;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.emf.Schema;
import org.bimserver.ifc.step.deserializer.IfcParserWriterUtils;
import org.bimserver.models.store.IfcHeader;
import org.bimserver.models.store.StoreFactory;
import org.bimserver.plugins.deserializers.ByteProgressReporter;
import org.bimserver.plugins.deserializers.DatabaseInterface;
import org.bimserver.plugins.deserializers.DeserializeException;
import org.bimserver.plugins.deserializers.StreamingDeserializer;
import org.bimserver.shared.ByteBufferVirtualObject;
import org.bimserver.shared.ByteBufferWrappedVirtualObject;
import org.bimserver.shared.ListWaitingVirtualObject;
import org.bimserver.shared.QueryContext;
import org.bimserver.shared.SingleWaitingVirtualObject;
import org.bimserver.shared.VirtualObject;
import org.bimserver.shared.WaitingListVirtualObject;
import org.bimserver.shared.WaitingVirtualObject;
import org.bimserver.shared.WrappedVirtualObject;
import org.bimserver.shared.exceptions.BimServerClientException;
import org.bimserver.utils.FakeClosingInputStream;
import org.bimserver.utils.StringUtils;
import org.bimserver.utils.TokenizeException;
import org.bimserver.utils.Tokenizer;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EClassImpl;
import org.eclipse.emf.ecore.impl.EEnumImpl;

public abstract class IfcStepStreamingDeserializer
implements StreamingDeserializer {
    private ByteProgressReporter byteProgressReporter;
    private PackageMetaData packageMetaData;
    private static final String WRAPPED_VALUE = "wrappedValue";
    private final WaitingListVirtualObject<Integer> waitingList = new WaitingListVirtualObject();
    private Mode mode = Mode.HEADER;
    private int lineNumber;
    private Schema schema;
    private final Map<Integer, Long> mappedObjects = new HashMap<Integer, Long>();
    private QueryContext reusable;
    private IfcHeader ifcHeader;
    private static MetricCollector metricCollector = new MetricCollector();
    private final Map<EClass, AtomicInteger> summaryMap = new TreeMap<EClass, AtomicInteger>(new Comparator<EClass>(){

        @Override
        public int compare(EClass o1, EClass o2) {
            return o1.getName().compareTo(o2.getName());
        }
    });

    public void init(PackageMetaData packageMetaData) {
        this.packageMetaData = packageMetaData;
        this.schema = packageMetaData.getSchema();
    }

    public Map<EClass, Integer> getSummaryMap() {
        HashMap<EClass, Integer> newMap = new HashMap<EClass, Integer>();
        for (EClass key : this.summaryMap.keySet()) {
            newMap.put(key, this.summaryMap.get(key).get());
        }
        return newMap;
    }

    public void setProgressReporter(ByteProgressReporter byteProgressReporter) {
        this.byteProgressReporter = byteProgressReporter;
    }

    public PackageMetaData getPackageMetaData() {
        return this.packageMetaData;
    }

    public long read(InputStream in, String filename, long fileSize, QueryContext reusable) throws DeserializeException {
        this.reusable = reusable;
        this.mode = Mode.HEADER;
        if (filename != null && (filename.toUpperCase().endsWith(".ZIP") || filename.toUpperCase().endsWith(".IFCZIP"))) {
            ZipInputStream zipInputStream = new ZipInputStream(in);
            try {
                ZipEntry nextEntry = zipInputStream.getNextEntry();
                if (nextEntry == null) {
                    throw new DeserializeException("Zip files must contain exactly one IFC-file, this zip-file looks empty");
                }
                if (nextEntry.getName().toUpperCase().endsWith(".IFC")) {
                    FakeClosingInputStream fakeClosingInputStream = new FakeClosingInputStream((InputStream)zipInputStream);
                    this.read((InputStream)fakeClosingInputStream, fileSize);
                    if (zipInputStream.getNextEntry() != null) {
                        zipInputStream.close();
                        throw new DeserializeException("Zip files may only contain one IFC-file, this zip-file contains more files");
                    }
                } else {
                    throw new DeserializeException("Zip files must contain exactly one IFC-file, this zip-file seems to have one or more non-IFC files");
                }
                zipInputStream.close();
            }
            catch (IOException e) {
                throw new DeserializeException((Exception)e);
            }
        } else {
            return this.read(in, fileSize);
        }
        return -1L;
    }

    private void filterComments(Tokenizer tokenizer) throws TokenizeException {
        if (tokenizer.startsWith("/*")) {
            tokenizer.zoomIn("/*", "*/");
            tokenizer.readAll();
            tokenizer.zoomOut();
        }
    }

    private long read(InputStream inputStream, long fileSize) throws DeserializeException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, Charsets.UTF_8));
        long bytesRead = 0L;
        this.lineNumber = 0;
        try {
            String line = reader.readLine();
            if (line == null) {
                throw new DeserializeException("Unexpected end of stream reading first line");
            }
            MessageDigest md = MessageDigest.getInstance("MD5");
            while (line != null) {
                byte[] bytes = line.getBytes(Charsets.UTF_8);
                md.update(bytes, 0, bytes.length);
                try {
                    String readLine;
                    while (!this.processLine(line.trim()) && (readLine = reader.readLine()) != null) {
                        line = line + readLine;
                        ++this.lineNumber;
                    }
                }
                catch (Exception e) {
                    if (e instanceof DeserializeException) {
                        throw (DeserializeException)e;
                    }
                    throw new DeserializeException(this.lineNumber, " (" + e.getMessage() + ") " + line, e);
                }
                bytesRead += (long)bytes.length;
                if (this.byteProgressReporter != null) {
                    this.byteProgressReporter.progress(bytesRead);
                }
                line = reader.readLine();
                ++this.lineNumber;
            }
            if (this.mode == Mode.HEADER) {
                throw new DeserializeException(this.lineNumber, "No valid IFC header found");
            }
            return this.lineNumber;
        }
        catch (FileNotFoundException e) {
            throw new DeserializeException(this.lineNumber, (Exception)e);
        }
        catch (IOException e) {
            throw new DeserializeException(this.lineNumber, (Exception)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new DeserializeException(this.lineNumber, (Exception)e);
        }
    }

    private boolean processLine(String line) throws DeserializeException, MetaDataException, BimserverDatabaseException {
        switch (this.mode) {
            case HEADER: {
                if (line.length() > 0) {
                    if (line.endsWith(";")) {
                        this.processHeader(line);
                    } else {
                        return false;
                    }
                }
                if (!line.equals("DATA;")) break;
                this.mode = Mode.DATA;
                break;
            }
            case DATA: {
                if (line.equals("ENDSEC;")) {
                    this.mode = Mode.FOOTER;
                    try {
                        this.waitingList.dumpIfNotEmpty();
                    }
                    catch (BimServerClientException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                if (line.length() <= 0 || line.charAt(0) != '#') break;
                while (line.endsWith("*/")) {
                    line = line.substring(0, line.lastIndexOf("/*")).trim();
                }
                if (line.endsWith(";")) {
                    this.processRecord(line);
                    break;
                }
                return false;
            }
            case FOOTER: {
                if (!line.equals("ENDSEC;")) break;
                this.mode = Mode.DONE;
                break;
            }
        }
        return true;
    }

    public IfcHeader getIfcHeader() {
        return this.ifcHeader;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processHeader(String line) throws DeserializeException {
        try {
            if (this.ifcHeader == null) {
                this.ifcHeader = StoreFactory.eINSTANCE.createIfcHeader();
            }
            if (line.startsWith("FILE_DESCRIPTION")) {
                Tokenizer tokenizer = new Tokenizer(line.substring(line.indexOf("(")));
                tokenizer.zoomIn("(", ")");
                tokenizer.zoomIn("(", ")");
                this.filterComments(tokenizer);
                while (!tokenizer.isEmpty()) {
                    this.ifcHeader.getDescription().add((Object)tokenizer.readSingleQuoted());
                    if (!tokenizer.nextIsAComma()) continue;
                    tokenizer.readComma();
                }
                tokenizer.zoomOut();
                tokenizer.readComma();
                this.filterComments(tokenizer);
                this.ifcHeader.setImplementationLevel(tokenizer.readSingleQuoted());
                tokenizer.zoomOut();
                tokenizer.shouldBeFinished();
                return;
            }
            if (line.startsWith("FILE_NAME")) {
                Tokenizer tokenizer = new Tokenizer(line.substring(line.indexOf("(")));
                tokenizer.zoomIn("(", ")");
                this.filterComments(tokenizer);
                this.ifcHeader.setFilename(tokenizer.readSingleQuoted());
                SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'kk:mm:ss");
                tokenizer.readComma();
                this.filterComments(tokenizer);
                this.ifcHeader.setTimeStamp(dateFormatter.parse(tokenizer.readSingleQuoted()));
                tokenizer.readComma();
                this.filterComments(tokenizer);
                tokenizer.zoomIn("(", ")");
                while (!tokenizer.isEmpty()) {
                    this.ifcHeader.getAuthor().add((Object)tokenizer.readSingleQuoted());
                    if (!tokenizer.nextIsAComma()) continue;
                    tokenizer.readComma();
                }
                tokenizer.zoomOut();
                tokenizer.readComma();
                this.filterComments(tokenizer);
                tokenizer.zoomIn("(", ")");
                while (!tokenizer.isEmpty()) {
                    this.ifcHeader.getOrganization().add((Object)tokenizer.readSingleQuoted());
                    if (!tokenizer.nextIsAComma()) continue;
                    tokenizer.readComma();
                }
                tokenizer.zoomOut();
                tokenizer.readComma();
                this.filterComments(tokenizer);
                this.ifcHeader.setPreProcessorVersion(tokenizer.readSingleQuoted());
                tokenizer.readComma();
                this.filterComments(tokenizer);
                this.ifcHeader.setOriginatingSystem(tokenizer.readSingleQuoted());
                tokenizer.readComma();
                this.filterComments(tokenizer);
                if (tokenizer.nextIsDollar()) {
                    tokenizer.readDollar();
                } else {
                    this.ifcHeader.setAuthorization(tokenizer.readSingleQuoted());
                }
                tokenizer.zoomOut();
                tokenizer.shouldBeFinished();
                return;
            }
            if (line.startsWith("FILE_SCHEMA")) {
                Tokenizer tokenizer = new Tokenizer(line.substring(line.indexOf("(")));
                String ifcSchemaVersion = tokenizer.zoomIn("(", ")").zoomIn("(", ")").readSingleQuoted();
                if (!ifcSchemaVersion.toLowerCase().equalsIgnoreCase(this.schema.getHeaderName().toLowerCase())) {
                    throw new DeserializeException(this.lineNumber, ifcSchemaVersion + " is not supported by this deserializer (" + this.schema.getHeaderName() + " is)");
                }
                this.ifcHeader.setIfcSchemaVersion(ifcSchemaVersion);
                return;
            }
            if (!line.startsWith("ENDSEC;")) return;
        }
        catch (TokenizeException e) {
            throw new DeserializeException(this.lineNumber, (Exception)((Object)e));
        }
        catch (ParseException e) {
            throw new DeserializeException(this.lineNumber, (Exception)e);
        }
    }

    private VirtualObject newVirtualObject(EClass eClass, int lineLength) {
        return new ByteBufferVirtualObject(this.reusable, eClass, metricCollector.estimateRequiredBytes(lineLength));
    }

    private WrappedVirtualObject newWrappedVirtualObject(EClass eClass) {
        return new ByteBufferWrappedVirtualObject(this.reusable, eClass);
    }

    public void processRecord(String line) throws DeserializeException, MetaDataException, BimserverDatabaseException {
        int equalSignLocation = line.indexOf("=");
        int lastIndexOfSemiColon = line.lastIndexOf(";");
        if (lastIndexOfSemiColon == -1) {
            throw new DeserializeException(this.lineNumber, "No semicolon found in line");
        }
        int indexOfFirstParen = line.indexOf("(", equalSignLocation);
        if (indexOfFirstParen == -1) {
            throw new DeserializeException(this.lineNumber, "No left parenthesis found in line");
        }
        int indexOfLastParen = line.lastIndexOf(")", lastIndexOfSemiColon);
        if (indexOfLastParen == -1) {
            throw new DeserializeException(this.lineNumber, "No right parenthesis found in line");
        }
        int recordNumber = Integer.parseInt(line.substring(1, equalSignLocation).trim());
        String name = line.substring(equalSignLocation + 1, indexOfFirstParen).trim();
        EClass eClass = (EClass)this.getPackageMetaData().getEClassifierCaseInsensitive(name);
        VirtualObject object = this.newVirtualObject(eClass, line.length());
        AtomicInteger atomicInteger = this.summaryMap.get(eClass);
        if (atomicInteger == null) {
            this.summaryMap.put(eClass, new AtomicInteger(1));
        } else {
            atomicInteger.incrementAndGet();
        }
        this.mappedObjects.put(recordNumber, object.getOid());
        boolean openReferences = false;
        if (eClass != null) {
            String realData = line.substring(indexOfFirstParen + 1, indexOfLastParen);
            int lastIndex = 0;
            EntityDefinition entityBN = this.getPackageMetaData().getSchemaDefinition().getEntityBN(name);
            if (entityBN == null) {
                throw new DeserializeException(this.lineNumber, "Unknown entity " + name);
            }
            for (EStructuralFeature eStructuralFeature : eClass.getEAllStructuralFeatures()) {
                if (this.getPackageMetaData().useForSerialization(eClass, eStructuralFeature)) {
                    int nextIndex;
                    if (this.getPackageMetaData().useForDatabaseStorage(eClass, eStructuralFeature)) {
                        EStructuralFeature doubleStringFeature;
                        nextIndex = StringUtils.nextString((String)realData, (int)lastIndex);
                        String val = null;
                        try {
                            val = realData.substring(lastIndex, nextIndex - 1).trim();
                        }
                        catch (Exception e) {
                            int expected = 0;
                            for (Attribute attribute2 : entityBN.getAttributesCached(true)) {
                                if (!(attribute2 instanceof ExplicitAttribute)) continue;
                                ++expected;
                            }
                            throw new DeserializeException(this.lineNumber, eClass.getName() + " expects " + expected + " fields, but less found (" + e.getMessage() + ")");
                        }
                        lastIndex = nextIndex;
                        char firstChar = val.charAt(0);
                        if (firstChar == '$') {
                            object.eUnset(eStructuralFeature);
                            if (eStructuralFeature.getEType() != EcorePackage.eINSTANCE.getEDouble()) continue;
                            doubleStringFeature = eClass.getEStructuralFeature(eStructuralFeature.getName() + "AsString");
                            object.eUnset(doubleStringFeature);
                            continue;
                        }
                        if (firstChar == '#') {
                            if (this.readReference(val, object, eStructuralFeature)) continue;
                            openReferences = true;
                            continue;
                        }
                        if (firstChar == '.') {
                            this.readEnum(val, object, eStructuralFeature);
                            continue;
                        }
                        if (firstChar == '(') {
                            if (this.readList(val, object, eStructuralFeature)) continue;
                            openReferences = true;
                            continue;
                        }
                        if (firstChar == '*') {
                            object.eUnset(eStructuralFeature);
                            continue;
                        }
                        if (eStructuralFeature.isMany()) continue;
                        object.setAttribute(eStructuralFeature, this.convert(eStructuralFeature.getEType(), val));
                        if (eStructuralFeature.getEType() != EcorePackage.eINSTANCE.getEDouble()) continue;
                        doubleStringFeature = eClass.getEStructuralFeature(eStructuralFeature.getName() + "AsString");
                        object.setAttribute(doubleStringFeature, (Object)val);
                        continue;
                    }
                    lastIndex = nextIndex = StringUtils.nextString((String)realData, (int)lastIndex);
                    continue;
                }
                if (!this.getPackageMetaData().useForDatabaseStorage(eClass, eStructuralFeature)) continue;
                if (eStructuralFeature instanceof EReference && this.getPackageMetaData().isInverse((EReference)eStructuralFeature)) {
                    object.eUnset(eStructuralFeature);
                    continue;
                }
                if (eStructuralFeature.getEAnnotation("asstring") != null) continue;
                object.eUnset(eStructuralFeature);
            }
            if (this.waitingList.containsKey((Object)recordNumber)) {
                this.waitingList.updateNode((Object)recordNumber, eClass, object);
            }
            if (!openReferences) {
                int nrBytes = this.getDatabaseInterface().save(object);
                metricCollector.collect(line.length(), nrBytes);
            }
        } else {
            throw new DeserializeException(this.lineNumber, name + " is not a known entity");
        }
    }

    private DatabaseInterface getDatabaseInterface() {
        return this.reusable.getDatabaseInterface();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean readList(String val, VirtualObject object, EStructuralFeature structuralFeature) throws DeserializeException, MetaDataException, BimserverDatabaseException {
        int index = 0;
        if (!structuralFeature.isMany()) {
            throw new DeserializeException(this.lineNumber, "Field " + structuralFeature.getName() + " of " + structuralFeature.getEContainingClass().getName() + " is no aggregation");
        }
        boolean isDouble = structuralFeature.getEType() == EcorePackage.eINSTANCE.getEDouble();
        EStructuralFeature doubleStringFeature = null;
        if (isDouble && (doubleStringFeature = structuralFeature.getEContainingClass().getEStructuralFeature(structuralFeature.getName() + "AsString")) == null) {
            throw new DeserializeException(this.lineNumber, "Field not found: " + structuralFeature.getName() + "AsString");
        }
        String realData = val.substring(1, val.length() - 1);
        int lastIndex = 0;
        object.startList(structuralFeature);
        ArrayList<String> doubles = new ArrayList<String>();
        boolean complete = true;
        while (lastIndex != realData.length() + 1) {
            int nextIndex = StringUtils.nextString((String)realData, (int)lastIndex);
            String stringValue = realData.substring(lastIndex, nextIndex - 1).trim();
            lastIndex = nextIndex;
            if (stringValue.length() > 0) {
                if (stringValue.charAt(0) == '#') {
                    Integer referenceId = Integer.parseInt(stringValue.substring(1));
                    if (this.mappedObjects.containsKey(referenceId)) {
                        Long referencedOid = this.mappedObjects.get(referenceId);
                        if (referencedOid != null) {
                            EClass referenceEClass = this.getDatabaseInterface().getEClassForOid(referencedOid.longValue());
                            if (!((EClass)structuralFeature.getEType()).isSuperTypeOf(referenceEClass)) throw new DeserializeException(this.lineNumber, referenceEClass.getName() + " cannot be stored in " + structuralFeature.getName());
                            object.setListItemReference(structuralFeature, index, referenceEClass, referencedOid, -1);
                        }
                    } else {
                        int pos = object.reserveSpaceForListReference();
                        this.waitingList.add((Object)referenceId, (WaitingVirtualObject)new ListWaitingVirtualObject(this.lineNumber, object, structuralFeature, index, pos));
                        complete = false;
                    }
                } else if (stringValue.charAt(0) == '(') {
                    VirtualObject newObject = this.newVirtualObject((EClass)structuralFeature.getEType(), stringValue.length());
                    this.readList(stringValue, newObject, newObject.eClass().getEStructuralFeature("List"));
                    object.setListItemReference(structuralFeature, index, newObject.eClass(), Long.valueOf(newObject.getOid()), -1);
                } else {
                    Object convert = this.convert(structuralFeature.getEType(), stringValue);
                    if (convert != null) {
                        object.setListItem(structuralFeature, index, convert);
                        if (isDouble) {
                            doubles.add(stringValue);
                        }
                    }
                }
            }
            ++index;
        }
        object.endList();
        if (!isDouble) return complete;
        object.startList(doubleStringFeature);
        int i = 0;
        for (String d : doubles) {
            object.setListItem(doubleStringFeature, i++, (Object)d);
        }
        object.endList();
        return complete;
    }

    private Object convert(EClassifier classifier, String value) throws DeserializeException, MetaDataException, BimserverDatabaseException {
        if (classifier != null) {
            if (classifier instanceof EClassImpl) {
                if (null != ((EClassImpl)classifier).getEStructuralFeature(WRAPPED_VALUE)) {
                    WrappedVirtualObject newObject = this.newWrappedVirtualObject((EClass)classifier);
                    Class instanceClass = newObject.eClass().getEStructuralFeature(WRAPPED_VALUE).getEType().getInstanceClass();
                    if (!value.equals("")) {
                        if (instanceClass == Integer.class || instanceClass == Integer.TYPE) {
                            try {
                                newObject.setAttribute(newObject.eClass().getEStructuralFeature(WRAPPED_VALUE), (Object)Integer.parseInt(value));
                            }
                            catch (NumberFormatException e) {
                                throw new DeserializeException(this.lineNumber, value + " is not a valid integer value");
                            }
                        }
                        if (instanceClass == Long.class || instanceClass == Long.TYPE) {
                            newObject.setAttribute(newObject.eClass().getEStructuralFeature(WRAPPED_VALUE), (Object)Long.parseLong(value));
                        } else if (instanceClass == Boolean.class || instanceClass == Boolean.TYPE) {
                            newObject.setAttribute(newObject.eClass().getEStructuralFeature(WRAPPED_VALUE), (Object)value.equals(".T."));
                        } else if (instanceClass == Double.class || instanceClass == Double.TYPE) {
                            try {
                                newObject.setAttribute(newObject.eClass().getEStructuralFeature(WRAPPED_VALUE), (Object)Double.parseDouble(value));
                            }
                            catch (NumberFormatException e) {
                                throw new DeserializeException(this.lineNumber, value + " is not a valid double floating point number");
                            }
                            newObject.setAttribute(newObject.eClass().getEStructuralFeature("wrappedValueAsString"), (Object)value);
                        } else if (instanceClass == String.class) {
                            newObject.setAttribute(newObject.eClass().getEStructuralFeature(WRAPPED_VALUE), (Object)IfcParserWriterUtils.readString(value, this.lineNumber));
                        } else if (instanceClass.getSimpleName().equals("Tristate")) {
                            EEnumLiteral tristate = null;
                            if (value.equals(".T.")) {
                                tristate = this.getPackageMetaData().getEEnumLiteral("Tristate", "TRUE");
                            } else if (value.equals(".F.")) {
                                tristate = this.getPackageMetaData().getEEnumLiteral("Tristate", "FALSE");
                            } else if (value.equals(".U.")) {
                                tristate = this.getPackageMetaData().getEEnumLiteral("Tristate", "UNDEFINED");
                            }
                            newObject.setAttribute(newObject.eClass().getEStructuralFeature(WRAPPED_VALUE), (Object)tristate);
                        }
                    }
                    return newObject;
                }
                return this.processInline(classifier, value);
            }
            if (classifier instanceof EDataType) {
                return IfcParserWriterUtils.convertSimpleValue(classifier.getInstanceClass(), value, this.lineNumber);
            }
        }
        return null;
    }

    private Object processInline(EClassifier classifier, String value) throws DeserializeException, MetaDataException, BimserverDatabaseException {
        if (value.indexOf("(") != -1) {
            String typeName = value.substring(0, value.indexOf("(")).trim();
            String v = value.substring(value.indexOf("(") + 1, value.length() - 1);
            EClassifier eClassifier = this.getPackageMetaData().getEClassifierCaseInsensitive(typeName);
            if (eClassifier instanceof EClass) {
                return this.convert(eClassifier, v);
            }
            throw new DeserializeException(this.lineNumber, typeName + " is not an existing IFC entity");
        }
        return IfcParserWriterUtils.convertSimpleValue(classifier.getInstanceClass(), value, this.lineNumber);
    }

    private void readEnum(String val, VirtualObject object, EStructuralFeature structuralFeature) throws DeserializeException, MetaDataException, BimserverDatabaseException {
        if (val.equals(".T.")) {
            if (structuralFeature.getEType().getName().equals("Tristate")) {
                object.setAttribute(structuralFeature, (Object)this.getPackageMetaData().getEEnumLiteral("Tristate", "TRUE").getInstance());
            } else if (structuralFeature.getEType().getName().equals("IfcBoolean")) {
                EClass eClass = this.getPackageMetaData().getEClass("IfcBoolean");
                VirtualObject createIfcBoolean = this.newVirtualObject(eClass, val.length());
                createIfcBoolean.setAttribute(eClass.getEStructuralFeature("WrappedValue"), (Object)this.getPackageMetaData().getEEnumLiteral("Tristate", "TRUE").getInstance());
                object.setAttribute(structuralFeature, (Object)createIfcBoolean);
            } else if (structuralFeature.getEType() == EcorePackage.eINSTANCE.getEBoolean()) {
                object.setAttribute(structuralFeature, (Object)true);
            } else {
                EClass eClass = this.getPackageMetaData().getEClass("IfcLogical");
                VirtualObject createIfcBoolean = this.newVirtualObject(eClass, val.length());
                createIfcBoolean.setAttribute(eClass.getEStructuralFeature("WrappedValue"), (Object)this.getPackageMetaData().getEEnumLiteral("Tristate", "TRUE").getInstance());
                object.setAttribute(structuralFeature, (Object)createIfcBoolean);
            }
        } else if (val.equals(".F.")) {
            if (structuralFeature.getEType().getName().equals("Tristate")) {
                object.setAttribute(structuralFeature, (Object)this.getPackageMetaData().getEEnumLiteral("Tristate", "FALSE").getInstance());
            } else if (structuralFeature.getEType().getName().equals("IfcBoolean")) {
                EClass eClass = this.getPackageMetaData().getEClass("IfcBoolean");
                VirtualObject createIfcBoolean = this.newVirtualObject(eClass, val.length());
                createIfcBoolean.setAttribute(eClass.getEStructuralFeature("WrappedValue"), (Object)this.getPackageMetaData().getEEnumLiteral("Tristate", "FALSE").getInstance());
                object.setAttribute(structuralFeature, (Object)createIfcBoolean);
            } else if (structuralFeature.getEType() == EcorePackage.eINSTANCE.getEBoolean()) {
                object.setAttribute(structuralFeature, (Object)false);
            } else {
                EClass eClass = this.getPackageMetaData().getEClass("IfcLogical");
                VirtualObject createIfcBoolean = this.newVirtualObject(eClass, val.length());
                createIfcBoolean.setAttribute(eClass.getEStructuralFeature("WrappedValue"), (Object)this.getPackageMetaData().getEEnumLiteral("Tristate", "FALSE").getInstance());
                object.setAttribute(structuralFeature, (Object)createIfcBoolean);
            }
        } else if (val.equals(".U.")) {
            if (structuralFeature.getEType().getName().equals("Tristate")) {
                object.setAttribute(structuralFeature, (Object)this.getPackageMetaData().getEEnumLiteral("Tristate", "UNDEFINED").getInstance());
            } else if (structuralFeature.getEType() == EcorePackage.eINSTANCE.getEBoolean()) {
                object.eUnset(structuralFeature);
            } else {
                EClass eClass = this.getPackageMetaData().getEClass("IfcLogical");
                VirtualObject createIfcBoolean = this.newVirtualObject(eClass, val.length());
                createIfcBoolean.setAttribute(eClass.getEStructuralFeature("WrappedValue"), (Object)this.getPackageMetaData().getEEnumLiteral("Tristate", "UNDEFINED").getInstance());
                object.setAttribute(structuralFeature, (Object)createIfcBoolean);
            }
        } else if (structuralFeature.getEType() instanceof EEnumImpl) {
            String realEnumValue = val.substring(1, val.length() - 1);
            EEnumLiteral enumValue = ((EEnumImpl)structuralFeature.getEType()).getEEnumLiteral(realEnumValue);
            if (enumValue == null) {
                throw new DeserializeException(this.lineNumber, "Enum type " + structuralFeature.getEType().getName() + " has no literal value '" + realEnumValue + "'");
            }
            object.setAttribute(structuralFeature, (Object)enumValue.getInstance());
        } else {
            throw new DeserializeException(this.lineNumber, "Value " + val + " indicates enum type but " + structuralFeature.getEType().getName() + " expected");
        }
    }

    private boolean readReference(String val, VirtualObject object, EStructuralFeature structuralFeature) throws DeserializeException, BimserverDatabaseException {
        try {
            int referenceId = Integer.parseInt(val.substring(1));
            if (this.mappedObjects.containsKey(referenceId)) {
                object.setReference(structuralFeature, this.mappedObjects.get(referenceId).longValue(), -1);
                return true;
            }
            int pos = object.reserveSpaceForReference(structuralFeature);
            this.waitingList.add((Object)referenceId, (WaitingVirtualObject)new SingleWaitingVirtualObject(this.lineNumber, object, structuralFeature, pos));
            return false;
        }
        catch (NumberFormatException e) {
            throw new DeserializeException(this.lineNumber, "'" + val + "' is not a valid reference");
        }
    }

    public static enum Mode {
        HEADER,
        DATA,
        FOOTER,
        DONE;

    }
}

