/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.ifc.step.serializer;

import org.bimserver.models.store.ObjectDefinition;
import org.bimserver.models.store.ParameterDefinition;
import org.bimserver.models.store.PrimitiveDefinition;
import org.bimserver.models.store.PrimitiveEnum;
import org.bimserver.models.store.StoreFactory;
import org.bimserver.models.store.StringType;
import org.bimserver.models.store.Type;
import org.bimserver.models.store.TypeDefinition;
import org.bimserver.plugins.PluginManagerInterface;
import org.bimserver.plugins.serializers.StreamingSerializerPlugin;
import org.bimserver.shared.exceptions.PluginException;

public abstract class IfcStepStreamingSerializerPlugin
implements StreamingSerializerPlugin {
    private boolean initialized = false;

    public String getDescription() {
        return "IfcStepSerializer";
    }

    public String getVersion() {
        return "1.0";
    }

    public boolean needsGeometry() {
        return false;
    }

    public void init(PluginManagerInterface pluginManager) throws PluginException {
        this.initialized = true;
    }

    public String getDefaultContentType() {
        return "application/ifc";
    }

    public String getDefaultExtension() {
        return "ifc";
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public ObjectDefinition getSettingsDefinition() {
        ObjectDefinition objectDefinition = StoreFactory.eINSTANCE.createObjectDefinition();
        ParameterDefinition extensionParameter = StoreFactory.eINSTANCE.createParameterDefinition();
        extensionParameter.setName("Extension");
        extensionParameter.setDescription("Extension of the downloaded file");
        PrimitiveDefinition stringType = StoreFactory.eINSTANCE.createPrimitiveDefinition();
        stringType.setType(PrimitiveEnum.STRING);
        extensionParameter.setType((TypeDefinition)stringType);
        StringType defaultExtensionValue = StoreFactory.eINSTANCE.createStringType();
        defaultExtensionValue.setValue(this.getDefaultExtension());
        extensionParameter.setDefaultValue((Type)defaultExtensionValue);
        objectDefinition.getParameters().add((Object)extensionParameter);
        ParameterDefinition contentTypeParameter = StoreFactory.eINSTANCE.createParameterDefinition();
        contentTypeParameter.setName("ContentType");
        contentTypeParameter.setDescription("Content-Type in the HTTP header of the downloaded file");
        contentTypeParameter.setType((TypeDefinition)stringType);
        StringType defaultContentTypeValue = StoreFactory.eINSTANCE.createStringType();
        defaultContentTypeValue.setValue(this.getDefaultContentType());
        contentTypeParameter.setDefaultValue((Type)defaultContentTypeValue);
        objectDefinition.getParameters().add((Object)contentTypeParameter);
        PrimitiveDefinition stringDefinition = StoreFactory.eINSTANCE.createPrimitiveDefinition();
        stringDefinition.setType(PrimitiveEnum.STRING);
        ParameterDefinition organizationParameter = StoreFactory.eINSTANCE.createParameterDefinition();
        organizationParameter.setName("organization");
        organizationParameter.setDescription("Organization name to put in the header");
        StringType defaultValue = StoreFactory.eINSTANCE.createStringType();
        defaultValue.setValue("BIMserver.org");
        organizationParameter.setDefaultValue((Type)defaultValue);
        organizationParameter.setType((TypeDefinition)stringDefinition);
        objectDefinition.getParameters().add((Object)organizationParameter);
        ParameterDefinition zipExtension = StoreFactory.eINSTANCE.createParameterDefinition();
        zipExtension.setName("ZipExtension");
        zipExtension.setDescription("Extension of the downloaded file when using zip compression");
        zipExtension.setType((TypeDefinition)stringDefinition);
        StringType defaultZipExtensionValue = StoreFactory.eINSTANCE.createStringType();
        defaultZipExtensionValue.setValue("ifczip");
        zipExtension.setDefaultValue((Type)defaultZipExtensionValue);
        objectDefinition.getParameters().add((Object)zipExtension);
        return objectDefinition;
    }
}

