/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.ifc.xml.deserializer;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.IfcModelInterfaceException;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.ifc.BasicIfcModel;
import org.bimserver.ifc.IfcModel;
import org.bimserver.models.ifc2x3tc1.Ifc2x3tc1Factory;
import org.bimserver.models.ifc2x3tc1.Ifc2x3tc1Package;
import org.bimserver.plugins.deserializers.ByteProgressReporter;
import org.bimserver.plugins.deserializers.DeserializeException;
import org.bimserver.plugins.deserializers.EmfDeserializer;
import org.bimserver.utils.FakeClosingInputStream;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;

public abstract class IfcXmlDeserializer
extends EmfDeserializer {
    private IfcModel model;

    public void init(PackageMetaData packageMetaData) {
        super.init(packageMetaData);
        this.model = new BasicIfcModel(packageMetaData, null);
    }

    public IfcModelInterface read(InputStream inputStream, String filename, long fileSize, ByteProgressReporter byteProgressReporter) throws DeserializeException {
        if (filename != null && (filename.toUpperCase().endsWith(".ZIP") || filename.toUpperCase().endsWith(".IFCZIP") || filename.toUpperCase().endsWith(".IFCXMLZIP"))) {
            ZipInputStream zipInputStream = new ZipInputStream(inputStream);
            try {
                ZipEntry nextEntry = zipInputStream.getNextEntry();
                if (nextEntry == null) {
                    throw new DeserializeException("Zip files must contain exactly one IFC-file, this zip-file looks empty");
                }
                if (nextEntry.getName().toUpperCase().endsWith(".IFCXML")) {
                    IfcModel model = null;
                    FakeClosingInputStream fakeClosingInputStream = new FakeClosingInputStream((InputStream)zipInputStream);
                    model = this.read((InputStream)fakeClosingInputStream);
                    if (model.size() == 0L) {
                        throw new DeserializeException("Uploaded file does not seem to be a correct IFC file");
                    }
                    if (zipInputStream.getNextEntry() != null) {
                        zipInputStream.close();
                        throw new DeserializeException("Zip files may only contain one IFC-file, this zip-file contains more files");
                    }
                    zipInputStream.close();
                    return model;
                }
                throw new DeserializeException("Zip files must contain exactly one IFC-file, this zip-file seems to have one or more non-IFC files");
            }
            catch (IOException e) {
                throw new DeserializeException((Exception)e);
            }
        }
        return this.read(inputStream);
    }

    private IfcModel read(InputStream inputStream) throws DeserializeException {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        try {
            XMLStreamReader reader = inputFactory.createXMLStreamReader(inputStream, "UTF-8");
            this.parseDocument(reader);
            return this.model;
        }
        catch (XMLStreamException e) {
            new DeserializeException((Exception)e);
            return null;
        }
    }

    private void parseDocument(XMLStreamReader reader) throws DeserializeException {
        try {
            while (reader.hasNext()) {
                reader.next();
                if (reader.getEventType() != 1 || !reader.getLocalName().equalsIgnoreCase("iso_10303_28")) continue;
                this.parseIso_10303_28(reader);
            }
        }
        catch (XMLStreamException e) {
            throw new DeserializeException((Exception)e);
        }
    }

    private void parseIso_10303_28(XMLStreamReader reader) throws DeserializeException {
        try {
            while (reader.hasNext()) {
                reader.next();
                if (reader.getEventType() == 1) {
                    if (!reader.getLocalName().equalsIgnoreCase("uos")) continue;
                    this.parseUos(reader);
                    continue;
                }
                if (reader.getEventType() != 2 || !reader.getLocalName().equals("iso_10303_28")) continue;
                return;
            }
        }
        catch (XMLStreamException e) {
            throw new DeserializeException((Exception)e);
        }
    }

    private void parseUos(XMLStreamReader reader) throws DeserializeException {
        try {
            while (reader.hasNext()) {
                reader.next();
                if (reader.getEventType() == 1) {
                    this.parseObject(reader);
                    continue;
                }
                if (reader.getEventType() != 2 || !reader.getLocalName().equalsIgnoreCase("uos")) continue;
                return;
            }
        }
        catch (XMLStreamException e) {
            throw new DeserializeException((Exception)e);
        }
    }

    private IdEObject parseObject(XMLStreamReader reader) throws DeserializeException {
        IdEObject object;
        String className = reader.getLocalName();
        EClassifier eClassifier = Ifc2x3tc1Package.eINSTANCE.getEClassifier(className);
        if (eClassifier == null || !(eClassifier instanceof EClass)) {
            throw new DeserializeException("No class with name " + className + " was found");
        }
        String id = reader.getAttributeValue("", "id");
        if (id == null) {
            throw new DeserializeException("No id attribute found on " + className);
        }
        if (!id.startsWith("i")) {
            throw new DeserializeException("Id " + id + " is not starting with the letter 'i'");
        }
        EClass eClass = (EClass)eClassifier;
        long oid = Long.parseLong(id.substring(1));
        if (this.model.contains(oid)) {
            object = this.model.get(oid);
        } else {
            object = (IdEObject)Ifc2x3tc1Factory.eINSTANCE.create(eClass);
            try {
                this.model.add(oid, object);
            }
            catch (IfcModelInterfaceException e) {
                throw new DeserializeException((Exception)((Object)e));
            }
        }
        try {
            while (reader.hasNext()) {
                reader.next();
                if (reader.getEventType() == 1) {
                    this.parseField(object, reader);
                    continue;
                }
                if (reader.getEventType() != 2 || !reader.getLocalName().equalsIgnoreCase(className)) continue;
                return object;
            }
        }
        catch (XMLStreamException e) {
            throw new DeserializeException((Exception)e);
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private void parseField(IdEObject object, XMLStreamReader reader) throws DeserializeException {
        String fieldName = reader.getLocalName();
        EStructuralFeature eStructuralFeature = object.eClass().getEStructuralFeature(fieldName);
        if (eStructuralFeature == null) {
            throw new DeserializeException("Field " + fieldName + " not found on class " + object.eClass().getName());
        }
        EClassifier realType = null;
        try {
            block5: while (reader.hasNext()) {
                int n;
                List list;
                String[] split;
                Object list2;
                reader.next();
                if (reader.getEventType() == 1) {
                    if (reader.getAttributeValue("", "id") != null) {
                        IdEObject reference = this.parseObject(reader);
                        if (eStructuralFeature.isMany()) {
                            ((List)object.eGet(eStructuralFeature)).add(reference);
                            continue;
                        }
                        object.eSet(eStructuralFeature, (Object)reference);
                        continue;
                    }
                    if (reader.getAttributeValue("", "ref") != null) {
                        String ref = reader.getAttributeValue("", "ref");
                        if (!ref.startsWith("i")) {
                            throw new DeserializeException("Reference id " + ref + " should start with an 'i'");
                        }
                        Long refId = Long.parseLong(ref.substring(1));
                        IdEObject reference = null;
                        if (!this.model.contains(refId.longValue())) {
                            String referenceType = reader.getLocalName();
                            reference = (IdEObject)Ifc2x3tc1Factory.eINSTANCE.create((EClass)Ifc2x3tc1Package.eINSTANCE.getEClassifier(referenceType));
                            try {
                                this.model.add(refId.longValue(), reference);
                            }
                            catch (IfcModelInterfaceException e) {
                                throw new DeserializeException((Exception)((Object)e));
                            }
                        } else {
                            reference = this.model.get(refId.longValue());
                        }
                        if (eStructuralFeature.isMany()) {
                            list2 = (List)object.eGet(eStructuralFeature);
                            String posString = reader.getAttributeValue("urn:iso.org:standard:10303:part(28):version(2):xmlschema:common", "pos");
                            if (posString == null) {
                                list2.add(reference);
                                continue;
                            }
                            int pos = Integer.parseInt(posString);
                            if (list2.size() > pos) {
                                list2.set(pos, reference);
                                continue;
                            }
                            for (int i = list2.size() - 1; i < pos - 1; ++i) {
                                list2.add(reference.eClass().getEPackage().getEFactoryInstance().create(reference.eClass()));
                            }
                            list2.add(reference);
                            continue;
                        }
                        object.eSet(eStructuralFeature, (Object)reference);
                        continue;
                    }
                    String realTypeString = reader.getLocalName();
                    realType = Ifc2x3tc1Package.eINSTANCE.getEClassifier(realTypeString);
                    continue;
                }
                if (reader.getEventType() == 2) {
                    if (reader.getLocalName().equalsIgnoreCase(fieldName)) {
                        return;
                    }
                    if (realType == null || !reader.getLocalName().equalsIgnoreCase(realType.getName())) continue;
                    realType = null;
                    continue;
                }
                if (reader.getEventType() != 4 || reader.isWhiteSpace()) continue;
                String text = reader.getText();
                if (eStructuralFeature.getEType() instanceof EDataType) {
                    if (eStructuralFeature.isMany()) {
                        split = text.split(" ");
                        list = (List)object.eGet(eStructuralFeature);
                        list2 = split;
                        int posString = ((String[])list2).length;
                        n = 0;
                        while (true) {
                            if (n >= posString) continue block5;
                            String s = list2[n];
                            list.add(this.parsePrimitive(eStructuralFeature.getEType(), s));
                            ++n;
                        }
                    }
                    object.eSet(eStructuralFeature, this.parsePrimitive(eStructuralFeature.getEType(), text));
                    continue;
                }
                if (realType == null) {
                    realType = eStructuralFeature.getEType();
                }
                if (realType instanceof EClass) {
                    EClass eClass = (EClass)realType;
                    if (eClass.getEAnnotation("wrapped") == null) continue;
                    IdEObject wrappedObject = (IdEObject)Ifc2x3tc1Factory.eINSTANCE.create(eClass);
                    EStructuralFeature wrappedValueFeature = eClass.getEStructuralFeature("wrappedValue");
                    wrappedObject.eSet(wrappedValueFeature, this.parsePrimitive(wrappedValueFeature.getEType(), text));
                    if (wrappedValueFeature.getEType() == EcorePackage.eINSTANCE.getEDouble()) {
                        EStructuralFeature doubleStringFeature = eClass.getEStructuralFeature("wrappedValueAsString");
                        wrappedObject.eSet(doubleStringFeature, (Object)text);
                    }
                    List list3 = (List)object.eGet(eStructuralFeature);
                    if (eStructuralFeature.isMany()) {
                        list3.add(wrappedObject);
                        continue;
                    }
                    object.eSet(eStructuralFeature, (Object)wrappedObject);
                    continue;
                }
                if (eStructuralFeature.isMany()) {
                    split = text.split(" ");
                    list = (List)object.eGet(eStructuralFeature);
                    String[] stringArray = split;
                    int n2 = stringArray.length;
                    n = 0;
                    while (true) {
                        if (n >= n2) continue block5;
                        String s = stringArray[n];
                        list.add(this.parsePrimitive(realType, s));
                        ++n;
                    }
                }
                object.eSet(eStructuralFeature, this.parsePrimitive(realType, text));
            }
            return;
        }
        catch (NumberFormatException e) {
            throw new DeserializeException((Exception)e);
        }
        catch (XMLStreamException e) {
            throw new DeserializeException((Exception)e);
        }
    }

    private Object parsePrimitive(EClassifier eType, String text) throws DeserializeException {
        if (eType == EcorePackage.eINSTANCE.getEString()) {
            return text;
        }
        if (eType == EcorePackage.eINSTANCE.getEInt()) {
            return Integer.parseInt(text);
        }
        if (eType == EcorePackage.eINSTANCE.getEDouble()) {
            return Double.parseDouble(text);
        }
        if (eType == EcorePackage.eINSTANCE.getEBoolean()) {
            return Boolean.parseBoolean(text);
        }
        if (eType instanceof EEnum) {
            EEnumLiteral eEnumLiteral = ((EEnum)eType).getEEnumLiteral(text.toUpperCase());
            if (eEnumLiteral == null) {
                if (text.equals("unknown")) {
                    return null;
                }
                throw new DeserializeException("Unknown enum literal " + text + " in enum " + ((EEnum)eType).getName());
            }
            return eEnumLiteral.getInstance();
        }
        throw new DeserializeException("Unimplemented primitive type: " + eType.getName());
    }
}

