/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.ifc.xml.serializer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import nl.tue.buildingsmart.schema.Attribute;
import nl.tue.buildingsmart.schema.BaseType;
import nl.tue.buildingsmart.schema.DefinedType;
import nl.tue.buildingsmart.schema.EntityDefinition;
import nl.tue.buildingsmart.schema.ExplicitAttribute;
import nl.tue.buildingsmart.schema.IntegerType;
import nl.tue.buildingsmart.schema.ListType;
import nl.tue.buildingsmart.schema.RealType;
import nl.tue.buildingsmart.schema.SetType;
import org.apache.commons.lang.StringEscapeUtils;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.ifc.IfcSerializer;
import org.bimserver.models.ifc2x3tc1.Tristate;
import org.bimserver.models.store.StringType;
import org.bimserver.plugins.PluginManagerInterface;
import org.bimserver.plugins.serializers.EmfSerializer;
import org.bimserver.plugins.serializers.ProgressReporter;
import org.bimserver.plugins.serializers.ProjectInfo;
import org.bimserver.plugins.serializers.SerializerException;
import org.bimserver.utils.UTF8PrintWriter;
import org.eclipse.emf.common.util.AbstractEList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;

public abstract class IfcXmlSerializer
extends IfcSerializer {
    private PrintWriter out;
    private Map<EObject, Long> objectToOidMap;
    private int tabs;

    public void init(IfcModelInterface model, ProjectInfo projectInfo, PluginManagerInterface pluginManager, PackageMetaData packageMetaData, boolean normalizeOids) throws SerializerException {
        super.init(model, projectInfo, pluginManager, packageMetaData, normalizeOids);
        this.objectToOidMap = new HashMap<EObject, Long>((int)model.size());
        for (Long key : model.keySet()) {
            this.objectToOidMap.put((EObject)model.get(key.longValue()), key);
        }
    }

    public void reset() {
        this.setMode(EmfSerializer.Mode.BODY);
    }

    public boolean write(OutputStream out, ProgressReporter progressReporter) throws SerializerException {
        if (this.getMode() == EmfSerializer.Mode.BODY) {
            this.out = new UTF8PrintWriter(out);
            this.printLineTabbed("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            this.tabs = 0;
            this.printLineTabbed("<iso_10303_28 version=\"2.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xmlns=\"urn:iso.org:standard:10303:part(28):version(2):xmlschema:common\" xsi:schemaLocation=\"urn:iso.org:standard:10303:part(28):version(2):xmlschema:common  http://www.iai-tech.org/ifcXML/IFC2x3/FINAL/ex.xsd\">");
            ++this.tabs;
            this.printLineTabbed("<uos id=\"uos_1\" description=\"\" configuration=\"i-ifc2x3\" edo=\"\" xmlns=\"http://www.iai-tech.org/ifcXML/IFC2x3/FINAL\" xmlns:ex=\"urn:iso.org:standard:10303:part(28):version(2):xmlschema:common\" xsi:schemaLocation=\"http://www.iai-tech.org/ifcXML/IFC2x3/FINAL http://www.iai-tech.org/ifcXML/IFC2x3/FINAL/IFC2X3.xsd\">");
            ++this.tabs;
            Set keySet = this.model.getObjects().keySet();
            int progress = 0;
            for (Long key : keySet) {
                EObject object = (EObject)this.model.getObjects().get((Object)key);
                if (object.eClass().getEStructuralFeature("wrappedValue") == null) {
                    this.store(key, object);
                }
                if (progressReporter == null) continue;
                progressReporter.update((long)progress++, (long)keySet.size());
            }
            --this.tabs;
            this.printLineTabbed("</uos>");
            --this.tabs;
            this.printLineTabbed("</iso_10303_28>");
            this.out.flush();
            this.setMode(EmfSerializer.Mode.FINISHED);
            return true;
        }
        if (this.getMode() == EmfSerializer.Mode.FINISHED) {
            return false;
        }
        return false;
    }

    public void write(File file, ProgressReporter progressReporter) throws FileNotFoundException, SerializerException {
        this.write(new FileOutputStream(file), progressReporter);
    }

    private void store(Long key, EObject object) throws SerializerException {
        if (object.eClass().getEAnnotation("hidden") != null) {
            return;
        }
        this.printLineTabbed("<" + object.eClass().getName() + " id=\"i" + key + "\">");
        ++this.tabs;
        for (EStructuralFeature structuralFeature : object.eClass().getEAllStructuralFeatures()) {
            String type;
            Object value;
            if (structuralFeature.getEAnnotation("hidden") != null) continue;
            EntityDefinition entityBN = this.getPackageMetaData().getSchemaDefinition().getEntityBN(object.eClass().getName().toUpperCase());
            Attribute attributeBN = entityBN != null ? entityBN.getAttributeBNWithSuper(structuralFeature.getName()) : null;
            boolean derived = entityBN.isDerived(structuralFeature.getName());
            EReference eReference = (EReference)structuralFeature;
            if (this.getPackageMetaData().isInverse(eReference) || structuralFeature.isDerived() || derived || structuralFeature.getEAnnotation("hidden") != null || (value = object.eGet(structuralFeature)) == null) continue;
            EClassifier classifier = structuralFeature.getEType();
            if (!structuralFeature.isMany()) {
                if (classifier instanceof EClass) {
                    EObject eObject = (EObject)value;
                    type = eObject.eClass();
                    this.printTabbed("<" + structuralFeature.getName() + ">");
                    if (type.getEAnnotation("wrapped") != null) {
                        boolean showTag;
                        boolean bl = showTag = structuralFeature instanceof EReference && !structuralFeature.getName().equals("GlobalId");
                        if (showTag) {
                            this.print("<" + type.getName() + ">");
                        }
                        EStructuralFeature wrappedFeature = type.getEStructuralFeature("wrappedValue");
                        Object get = ((EObject)value).eGet(wrappedFeature);
                        if (wrappedFeature.getEType() == EcorePackage.eINSTANCE.getEString()) {
                            this.printEscaped((String)get);
                        } else if (!type.getName().equals("IfcLogical") && !type.getName().equals("IfcBoolean")) {
                            this.print(get.toString());
                        } else {
                            this.writeValue(get);
                        }
                        if (showTag) {
                            this.print("</" + type.getName() + ">");
                        }
                    } else {
                        String ref = "i" + this.objectToOidMap.get(value);
                        this.print("<" + type.getName() + " xsi:nil=\"true\" ref=\"" + ref + "\"/>");
                    }
                    this.printLine("</" + structuralFeature.getName() + ">");
                    continue;
                }
                if (classifier instanceof EEnum) {
                    Enumerator enumerator = (Enumerator)value;
                    if (enumerator.getName().equals("NULL")) continue;
                    this.printTabbed("<" + structuralFeature.getName() + ">");
                    this.writeValue(value);
                    this.printLine("</" + structuralFeature.getName() + ">");
                    continue;
                }
                if (!(classifier instanceof EDataType)) continue;
                this.printTabbed("<" + structuralFeature.getName() + ">");
                this.print(value.toString());
                this.printLine("</" + structuralFeature.getName() + ">");
                continue;
            }
            AbstractEList list = (AbstractEList)value;
            type = "set";
            if (attributeBN instanceof ExplicitAttribute) {
                ExplicitAttribute explicitAttribute = (ExplicitAttribute)attributeBN;
                if (list.isEmpty() && explicitAttribute.isOptional()) continue;
                BaseType domain = explicitAttribute.getDomain(true);
                if (domain == null && (domain = explicitAttribute.getDomain()) instanceof DefinedType && ((DefinedType)domain).getName().equals("IfcCompoundPlaneAngleMeasure")) {
                    type = "list";
                }
                if (domain instanceof SetType) {
                    type = "set";
                } else if (domain instanceof ListType) {
                    type = "list";
                    if (structuralFeature.getName().equals("Polygon")) {
                        type = "list-unique";
                    }
                }
            }
            this.printLineTabbed("<" + structuralFeature.getName() + " ex:cType=\"" + type + "\" >");
            ++this.tabs;
            int i = 0;
            for (Object o : list) {
                if (o instanceof EObject) {
                    EObject eObject = (EObject)o;
                    EStructuralFeature wrappedFeature = eObject.eClass().getEStructuralFeature("wrappedValue");
                    if (wrappedFeature != null) {
                        Object val = eObject.eGet(wrappedFeature);
                        this.printLineTabbed("<" + eObject.eClass().getName() + " pos=\"" + i + "\">" + val + "</" + eObject.eClass().getName() + ">");
                    } else {
                        String ref = "i" + this.objectToOidMap.get(eObject);
                        this.printLineTabbed("<" + eObject.eClass().getName() + " pos=\"" + i + "\" xsi:nil=\"true\" ref=\"" + ref + "\" />");
                    }
                    ++i;
                    continue;
                }
                if (!(attributeBN instanceof ExplicitAttribute)) continue;
                BaseType domain = ((ExplicitAttribute)attributeBN).getDomain(true);
                if (attributeBN.getName().equals("RefLatitude") || attributeBN.getName().equals("RefLongitude")) {
                    this.printLineTabbed("<ex:long-wrapper>" + o + "</ex:long-wrapper>");
                    continue;
                }
                if (!(domain instanceof ListType)) continue;
                BaseType elementType = ((ListType)domain).getElement_type();
                if (elementType instanceof DefinedType) {
                    DefinedType def = (DefinedType)elementType;
                    this.printLineTabbed("<" + def.getName() + ">" + o + "</" + def.getName() + ">");
                    continue;
                }
                if (elementType instanceof RealType) {
                    this.printLineTabbed("<ex:double-wrapper>" + o + "</ex:double-wrapper>");
                    continue;
                }
                if (elementType instanceof IntegerType) {
                    this.printLineTabbed("<ex:long-wrapper>" + o + "</ex:long-wrapper>");
                    continue;
                }
                if (!(elementType instanceof StringType)) continue;
                this.printLineTabbed("<string-wrapper>" + o + "</string-wrapper>");
            }
            --this.tabs;
            this.printLineTabbed("</" + structuralFeature.getName() + ">");
        }
        --this.tabs;
        this.printLineTabbed("</" + object.eClass().getName() + ">");
    }

    private void writeValue(Object value) {
        if (value instanceof Tristate && value == Tristate.UNDEFINED) {
            this.print("unknown");
        } else {
            this.print(value.toString().toLowerCase());
        }
    }

    private void printEscaped(String value) {
        this.out.print(StringEscapeUtils.escapeXml((String)value));
    }

    private void writeTabs(int tabs) {
        for (int i = 0; i < tabs; ++i) {
            this.out.print("\t");
        }
    }

    private void printTabbed(String str) {
        this.writeTabs(this.tabs);
        this.out.print(str);
    }

    private void printLineTabbed(String str) {
        this.writeTabs(this.tabs);
        this.out.println(str);
    }

    private void print(String str) {
        this.out.print(str);
    }

    private void printLine(String str) {
        this.out.println(str);
    }
}

